/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.assimp.AIAABB;
import org.lwjgl.assimp.AIColor4D;
import org.lwjgl.assimp.AIFace;
import org.lwjgl.assimp.AIString;
import org.lwjgl.assimp.AIVector3D;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiMesh")
public class AIMesh
extends Struct<AIMesh>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MPRIMITIVETYPES;
    public static final int MNUMVERTICES;
    public static final int MNUMFACES;
    public static final int MVERTICES;
    public static final int MNORMALS;
    public static final int MTANGENTS;
    public static final int MBITANGENTS;
    public static final int MCOLORS;
    public static final int MTEXTURECOORDS;
    public static final int MNUMUVCOMPONENTS;
    public static final int MFACES;
    public static final int MNUMBONES;
    public static final int MBONES;
    public static final int MMATERIALINDEX;
    public static final int MNAME;
    public static final int MNUMANIMMESHES;
    public static final int MANIMMESHES;
    public static final int MMETHOD;
    public static final int MAABB;
    public static final int MTEXTURECOORDSNAMES;

    protected AIMesh(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected AIMesh create(long address, @Nullable ByteBuffer container) {
        return new AIMesh(address, container);
    }

    public AIMesh(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AIMesh.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int mPrimitiveTypes() {
        return AIMesh.nmPrimitiveTypes(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumVertices() {
        return AIMesh.nmNumVertices(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumFaces() {
        return AIMesh.nmNumFaces(this.address());
    }

    @NativeType(value="struct aiVector3D *")
    public AIVector3D.Buffer mVertices() {
        return AIMesh.nmVertices(this.address());
    }

    @NativeType(value="struct aiVector3D *")
    public @Nullable AIVector3D.Buffer mNormals() {
        return AIMesh.nmNormals(this.address());
    }

    @NativeType(value="struct aiVector3D *")
    public @Nullable AIVector3D.Buffer mTangents() {
        return AIMesh.nmTangents(this.address());
    }

    @NativeType(value="struct aiVector3D *")
    public @Nullable AIVector3D.Buffer mBitangents() {
        return AIMesh.nmBitangents(this.address());
    }

    @NativeType(value="struct aiColor4D *[AI_MAX_NUMBER_OF_COLOR_SETS]")
    public PointerBuffer mColors() {
        return AIMesh.nmColors(this.address());
    }

    @NativeType(value="struct aiColor4D *")
    public @Nullable AIColor4D.Buffer mColors(int index) {
        return AIMesh.nmColors(this.address(), index);
    }

    @NativeType(value="struct aiVector3D *[AI_MAX_NUMBER_OF_TEXTURECOORDS]")
    public PointerBuffer mTextureCoords() {
        return AIMesh.nmTextureCoords(this.address());
    }

    @NativeType(value="struct aiVector3D *")
    public @Nullable AIVector3D.Buffer mTextureCoords(int index) {
        return AIMesh.nmTextureCoords(this.address(), index);
    }

    @NativeType(value="unsigned int[AI_MAX_NUMBER_OF_TEXTURECOORDS]")
    public IntBuffer mNumUVComponents() {
        return AIMesh.nmNumUVComponents(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumUVComponents(int index) {
        return AIMesh.nmNumUVComponents(this.address(), index);
    }

    @NativeType(value="struct aiFace *")
    public AIFace.Buffer mFaces() {
        return AIMesh.nmFaces(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumBones() {
        return AIMesh.nmNumBones(this.address());
    }

    @NativeType(value="struct aiBone **")
    public @Nullable PointerBuffer mBones() {
        return AIMesh.nmBones(this.address());
    }

    @NativeType(value="unsigned int")
    public int mMaterialIndex() {
        return AIMesh.nmMaterialIndex(this.address());
    }

    @NativeType(value="struct aiString")
    public AIString mName() {
        return AIMesh.nmName(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumAnimMeshes() {
        return AIMesh.nmNumAnimMeshes(this.address());
    }

    @NativeType(value="struct aiAnimMesh **")
    public @Nullable PointerBuffer mAnimMeshes() {
        return AIMesh.nmAnimMeshes(this.address());
    }

    @NativeType(value="aiMorphingMethod")
    public int mMethod() {
        return AIMesh.nmMethod(this.address());
    }

    @NativeType(value="struct aiAABB")
    public AIAABB mAABB() {
        return AIMesh.nmAABB(this.address());
    }

    @NativeType(value="struct aiString **")
    public @Nullable PointerBuffer mTextureCoordsNames() {
        return AIMesh.nmTextureCoordsNames(this.address());
    }

    public AIMesh mPrimitiveTypes(@NativeType(value="unsigned int") int value) {
        AIMesh.nmPrimitiveTypes(this.address(), value);
        return this;
    }

    public AIMesh mNumVertices(@NativeType(value="unsigned int") int value) {
        AIMesh.nmNumVertices(this.address(), value);
        return this;
    }

    public AIMesh mVertices(@NativeType(value="struct aiVector3D *") AIVector3D.Buffer value) {
        AIMesh.nmVertices(this.address(), value);
        return this;
    }

    public AIMesh mNormals(@NativeType(value="struct aiVector3D *") @Nullable AIVector3D.Buffer value) {
        AIMesh.nmNormals(this.address(), value);
        return this;
    }

    public AIMesh mTangents(@NativeType(value="struct aiVector3D *") @Nullable AIVector3D.Buffer value) {
        AIMesh.nmTangents(this.address(), value);
        return this;
    }

    public AIMesh mBitangents(@NativeType(value="struct aiVector3D *") @Nullable AIVector3D.Buffer value) {
        AIMesh.nmBitangents(this.address(), value);
        return this;
    }

    public AIMesh mColors(@NativeType(value="struct aiColor4D *[AI_MAX_NUMBER_OF_COLOR_SETS]") PointerBuffer value) {
        AIMesh.nmColors(this.address(), value);
        return this;
    }

    public AIMesh mColors(int index, @NativeType(value="struct aiColor4D *") @Nullable AIColor4D.Buffer value) {
        AIMesh.nmColors(this.address(), index, value);
        return this;
    }

    public AIMesh mColors(int index, Consumer<@Nullable AIColor4D.Buffer> consumer) {
        consumer.accept(this.mColors(index));
        return this;
    }

    public AIMesh mTextureCoords(@NativeType(value="struct aiVector3D *[AI_MAX_NUMBER_OF_TEXTURECOORDS]") PointerBuffer value) {
        AIMesh.nmTextureCoords(this.address(), value);
        return this;
    }

    public AIMesh mTextureCoords(int index, @NativeType(value="struct aiVector3D *") @Nullable AIVector3D.Buffer value) {
        AIMesh.nmTextureCoords(this.address(), index, value);
        return this;
    }

    public AIMesh mTextureCoords(int index, Consumer<@Nullable AIVector3D.Buffer> consumer) {
        consumer.accept(this.mTextureCoords(index));
        return this;
    }

    public AIMesh mNumUVComponents(@NativeType(value="unsigned int[AI_MAX_NUMBER_OF_TEXTURECOORDS]") IntBuffer value) {
        AIMesh.nmNumUVComponents(this.address(), value);
        return this;
    }

    public AIMesh mNumUVComponents(int index, @NativeType(value="unsigned int") int value) {
        AIMesh.nmNumUVComponents(this.address(), index, value);
        return this;
    }

    public AIMesh mFaces(@NativeType(value="struct aiFace *") AIFace.Buffer value) {
        AIMesh.nmFaces(this.address(), value);
        return this;
    }

    public AIMesh mBones(@NativeType(value="struct aiBone **") @Nullable PointerBuffer value) {
        AIMesh.nmBones(this.address(), value);
        return this;
    }

    public AIMesh mMaterialIndex(@NativeType(value="unsigned int") int value) {
        AIMesh.nmMaterialIndex(this.address(), value);
        return this;
    }

    public AIMesh mName(@NativeType(value="struct aiString") AIString value) {
        AIMesh.nmName(this.address(), value);
        return this;
    }

    public AIMesh mName(Consumer<AIString> consumer) {
        consumer.accept(this.mName());
        return this;
    }

    public AIMesh mAnimMeshes(@NativeType(value="struct aiAnimMesh **") @Nullable PointerBuffer value) {
        AIMesh.nmAnimMeshes(this.address(), value);
        return this;
    }

    public AIMesh mMethod(@NativeType(value="aiMorphingMethod") int value) {
        AIMesh.nmMethod(this.address(), value);
        return this;
    }

    public AIMesh mAABB(@NativeType(value="struct aiAABB") AIAABB value) {
        AIMesh.nmAABB(this.address(), value);
        return this;
    }

    public AIMesh mAABB(Consumer<AIAABB> consumer) {
        consumer.accept(this.mAABB());
        return this;
    }

    public AIMesh mTextureCoordsNames(@NativeType(value="struct aiString **") @Nullable PointerBuffer value) {
        AIMesh.nmTextureCoordsNames(this.address(), value);
        return this;
    }

    public AIMesh set(int mPrimitiveTypes, int mNumVertices, AIVector3D.Buffer mVertices, @Nullable AIVector3D.Buffer mNormals, @Nullable AIVector3D.Buffer mTangents, @Nullable AIVector3D.Buffer mBitangents, PointerBuffer mColors, PointerBuffer mTextureCoords, IntBuffer mNumUVComponents, AIFace.Buffer mFaces, @Nullable PointerBuffer mBones, int mMaterialIndex, AIString mName, @Nullable PointerBuffer mAnimMeshes, int mMethod, AIAABB mAABB, @Nullable PointerBuffer mTextureCoordsNames) {
        this.mPrimitiveTypes(mPrimitiveTypes);
        this.mNumVertices(mNumVertices);
        this.mVertices(mVertices);
        this.mNormals(mNormals);
        this.mTangents(mTangents);
        this.mBitangents(mBitangents);
        this.mColors(mColors);
        this.mTextureCoords(mTextureCoords);
        this.mNumUVComponents(mNumUVComponents);
        this.mFaces(mFaces);
        this.mBones(mBones);
        this.mMaterialIndex(mMaterialIndex);
        this.mName(mName);
        this.mAnimMeshes(mAnimMeshes);
        this.mMethod(mMethod);
        this.mAABB(mAABB);
        this.mTextureCoordsNames(mTextureCoordsNames);
        return this;
    }

    public AIMesh set(AIMesh src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static AIMesh malloc() {
        return new AIMesh(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static AIMesh calloc() {
        return new AIMesh(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static AIMesh create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new AIMesh(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static AIMesh create(long address) {
        return new AIMesh(address, null);
    }

    public static @Nullable AIMesh createSafe(long address) {
        return address == 0L ? null : new AIMesh(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)AIMesh.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIMesh.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static AIMesh mallocStack() {
        return AIMesh.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIMesh callocStack() {
        return AIMesh.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIMesh mallocStack(MemoryStack stack) {
        return AIMesh.malloc(stack);
    }

    @Deprecated
    public static AIMesh callocStack(MemoryStack stack) {
        return AIMesh.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AIMesh.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AIMesh.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIMesh.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIMesh.calloc(capacity, stack);
    }

    public static AIMesh malloc(MemoryStack stack) {
        return new AIMesh(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static AIMesh calloc(MemoryStack stack) {
        return new AIMesh(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nmPrimitiveTypes(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MPRIMITIVETYPES));
    }

    public static int nmNumVertices(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MNUMVERTICES));
    }

    public static int nmNumFaces(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MNUMFACES));
    }

    public static AIVector3D.Buffer nmVertices(long struct) {
        return AIVector3D.create(MemoryUtil.memGetAddress((long)(struct + (long)MVERTICES)), AIMesh.nmNumVertices(struct));
    }

    public static @Nullable AIVector3D.Buffer nmNormals(long struct) {
        return AIVector3D.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)MNORMALS)), AIMesh.nmNumVertices(struct));
    }

    public static @Nullable AIVector3D.Buffer nmTangents(long struct) {
        return AIVector3D.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)MTANGENTS)), AIMesh.nmNumVertices(struct));
    }

    public static @Nullable AIVector3D.Buffer nmBitangents(long struct) {
        return AIVector3D.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)MBITANGENTS)), AIMesh.nmNumVertices(struct));
    }

    public static PointerBuffer nmColors(long struct) {
        return MemoryUtil.memPointerBuffer((long)(struct + (long)MCOLORS), (int)8);
    }

    public static @Nullable AIColor4D.Buffer nmColors(long struct, int index) {
        return AIColor4D.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)MCOLORS + Checks.check((int)index, (int)8) * (long)POINTER_SIZE)), AIMesh.nmNumVertices(struct));
    }

    public static PointerBuffer nmTextureCoords(long struct) {
        return MemoryUtil.memPointerBuffer((long)(struct + (long)MTEXTURECOORDS), (int)8);
    }

    public static @Nullable AIVector3D.Buffer nmTextureCoords(long struct, int index) {
        return AIVector3D.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)MTEXTURECOORDS + Checks.check((int)index, (int)8) * (long)POINTER_SIZE)), AIMesh.nmNumVertices(struct));
    }

    public static IntBuffer nmNumUVComponents(long struct) {
        return MemoryUtil.memIntBuffer((long)(struct + (long)MNUMUVCOMPONENTS), (int)8);
    }

    public static int nmNumUVComponents(long struct, int index) {
        return MemoryUtil.memGetInt((long)(struct + (long)MNUMUVCOMPONENTS + Checks.check((int)index, (int)8) * 4L));
    }

    public static AIFace.Buffer nmFaces(long struct) {
        return AIFace.create(MemoryUtil.memGetAddress((long)(struct + (long)MFACES)), AIMesh.nmNumFaces(struct));
    }

    public static int nmNumBones(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MNUMBONES));
    }

    public static @Nullable PointerBuffer nmBones(long struct) {
        return MemoryUtil.memPointerBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)MBONES)), (int)AIMesh.nmNumBones(struct));
    }

    public static int nmMaterialIndex(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MMATERIALINDEX));
    }

    public static AIString nmName(long struct) {
        return AIString.create(struct + (long)MNAME);
    }

    public static int nmNumAnimMeshes(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MNUMANIMMESHES));
    }

    public static @Nullable PointerBuffer nmAnimMeshes(long struct) {
        return MemoryUtil.memPointerBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)MANIMMESHES)), (int)AIMesh.nmNumAnimMeshes(struct));
    }

    public static int nmMethod(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MMETHOD));
    }

    public static AIAABB nmAABB(long struct) {
        return AIAABB.create(struct + (long)MAABB);
    }

    public static @Nullable PointerBuffer nmTextureCoordsNames(long struct) {
        return MemoryUtil.memPointerBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)MTEXTURECOORDSNAMES)), (int)8);
    }

    public static void nmPrimitiveTypes(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MPRIMITIVETYPES), (int)value);
    }

    public static void nmNumVertices(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MNUMVERTICES), (int)value);
    }

    public static void nmNumFaces(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MNUMFACES), (int)value);
    }

    public static void nmVertices(long struct, AIVector3D.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MVERTICES), (long)value.address());
    }

    public static void nmNormals(long struct, @Nullable AIVector3D.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MNORMALS), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nmTangents(long struct, @Nullable AIVector3D.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MTANGENTS), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nmBitangents(long struct, @Nullable AIVector3D.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MBITANGENTS), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nmColors(long struct, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((CustomBuffer)value, (int)8);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((CustomBuffer)value), (long)(struct + (long)MCOLORS), (long)(value.remaining() * POINTER_SIZE));
    }

    public static void nmColors(long struct, int index, @Nullable AIColor4D.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MCOLORS + Checks.check((int)index, (int)8) * (long)POINTER_SIZE), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nmTextureCoords(long struct, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((CustomBuffer)value, (int)8);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((CustomBuffer)value), (long)(struct + (long)MTEXTURECOORDS), (long)(value.remaining() * POINTER_SIZE));
    }

    public static void nmTextureCoords(long struct, int index, @Nullable AIVector3D.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MTEXTURECOORDS + Checks.check((int)index, (int)8) * (long)POINTER_SIZE), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nmNumUVComponents(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)8);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((IntBuffer)value), (long)(struct + (long)MNUMUVCOMPONENTS), (long)(value.remaining() * 4));
    }

    public static void nmNumUVComponents(long struct, int index, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MNUMUVCOMPONENTS + Checks.check((int)index, (int)8) * 4L), (int)value);
    }

    public static void nmFaces(long struct, AIFace.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MFACES), (long)value.address());
        AIMesh.nmNumFaces(struct, value.remaining());
    }

    public static void nmNumBones(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MNUMBONES), (int)value);
    }

    public static void nmBones(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MBONES), (long)MemoryUtil.memAddressSafe((Pointer)value));
        AIMesh.nmNumBones(struct, value == null ? 0 : value.remaining());
    }

    public static void nmMaterialIndex(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MMATERIALINDEX), (int)value);
    }

    public static void nmName(long struct, AIString value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MNAME), (long)AIString.SIZEOF);
    }

    public static void nmNumAnimMeshes(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MNUMANIMMESHES), (int)value);
    }

    public static void nmAnimMeshes(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MANIMMESHES), (long)MemoryUtil.memAddressSafe((Pointer)value));
        AIMesh.nmNumAnimMeshes(struct, value == null ? 0 : value.remaining());
    }

    public static void nmMethod(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MMETHOD), (int)value);
    }

    public static void nmAABB(long struct, AIAABB value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MAABB), (long)AIAABB.SIZEOF);
    }

    public static void nmTextureCoordsNames(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MTEXTURECOORDSNAMES), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void validate(long struct) {
        int mNumFaces = AIMesh.nmNumFaces(struct);
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MVERTICES)));
        long mFaces = MemoryUtil.memGetAddress((long)(struct + (long)MFACES));
        Checks.check((long)mFaces);
        AIMesh.validate((long)mFaces, (int)mNumFaces, (int)AIFace.SIZEOF, AIFace::validate);
        if (AIMesh.nmNumBones(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MBONES)));
        }
        if (AIMesh.nmNumAnimMeshes(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MANIMMESHES)));
        }
    }

    static {
        Struct.Layout layout = AIMesh.__struct((Struct.Member[])new Struct.Member[]{AIMesh.__member((int)4), AIMesh.__member((int)4), AIMesh.__member((int)4), AIMesh.__member((int)POINTER_SIZE), AIMesh.__member((int)POINTER_SIZE), AIMesh.__member((int)POINTER_SIZE), AIMesh.__member((int)POINTER_SIZE), AIMesh.__array((int)POINTER_SIZE, (int)8), AIMesh.__array((int)POINTER_SIZE, (int)8), AIMesh.__array((int)4, (int)8), AIMesh.__member((int)POINTER_SIZE), AIMesh.__member((int)4), AIMesh.__member((int)POINTER_SIZE), AIMesh.__member((int)4), AIMesh.__member((int)AIString.SIZEOF, (int)AIString.ALIGNOF), AIMesh.__member((int)4), AIMesh.__member((int)POINTER_SIZE), AIMesh.__member((int)4), AIMesh.__member((int)AIAABB.SIZEOF, (int)AIAABB.ALIGNOF), AIMesh.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MPRIMITIVETYPES = layout.offsetof(0);
        MNUMVERTICES = layout.offsetof(1);
        MNUMFACES = layout.offsetof(2);
        MVERTICES = layout.offsetof(3);
        MNORMALS = layout.offsetof(4);
        MTANGENTS = layout.offsetof(5);
        MBITANGENTS = layout.offsetof(6);
        MCOLORS = layout.offsetof(7);
        MTEXTURECOORDS = layout.offsetof(8);
        MNUMUVCOMPONENTS = layout.offsetof(9);
        MFACES = layout.offsetof(10);
        MNUMBONES = layout.offsetof(11);
        MBONES = layout.offsetof(12);
        MMATERIALINDEX = layout.offsetof(13);
        MNAME = layout.offsetof(14);
        MNUMANIMMESHES = layout.offsetof(15);
        MANIMMESHES = layout.offsetof(16);
        MMETHOD = layout.offsetof(17);
        MAABB = layout.offsetof(18);
        MTEXTURECOORDSNAMES = layout.offsetof(19);
    }

    public static class Buffer
    extends StructBuffer<AIMesh, Buffer>
    implements NativeResource {
        private static final AIMesh ELEMENT_FACTORY = AIMesh.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected AIMesh getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int mPrimitiveTypes() {
            return AIMesh.nmPrimitiveTypes(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumVertices() {
            return AIMesh.nmNumVertices(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumFaces() {
            return AIMesh.nmNumFaces(this.address());
        }

        @NativeType(value="struct aiVector3D *")
        public AIVector3D.Buffer mVertices() {
            return AIMesh.nmVertices(this.address());
        }

        @NativeType(value="struct aiVector3D *")
        public @Nullable AIVector3D.Buffer mNormals() {
            return AIMesh.nmNormals(this.address());
        }

        @NativeType(value="struct aiVector3D *")
        public @Nullable AIVector3D.Buffer mTangents() {
            return AIMesh.nmTangents(this.address());
        }

        @NativeType(value="struct aiVector3D *")
        public @Nullable AIVector3D.Buffer mBitangents() {
            return AIMesh.nmBitangents(this.address());
        }

        @NativeType(value="struct aiColor4D *[AI_MAX_NUMBER_OF_COLOR_SETS]")
        public PointerBuffer mColors() {
            return AIMesh.nmColors(this.address());
        }

        @NativeType(value="struct aiColor4D *")
        public @Nullable AIColor4D.Buffer mColors(int index) {
            return AIMesh.nmColors(this.address(), index);
        }

        @NativeType(value="struct aiVector3D *[AI_MAX_NUMBER_OF_TEXTURECOORDS]")
        public PointerBuffer mTextureCoords() {
            return AIMesh.nmTextureCoords(this.address());
        }

        @NativeType(value="struct aiVector3D *")
        public @Nullable AIVector3D.Buffer mTextureCoords(int index) {
            return AIMesh.nmTextureCoords(this.address(), index);
        }

        @NativeType(value="unsigned int[AI_MAX_NUMBER_OF_TEXTURECOORDS]")
        public IntBuffer mNumUVComponents() {
            return AIMesh.nmNumUVComponents(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumUVComponents(int index) {
            return AIMesh.nmNumUVComponents(this.address(), index);
        }

        @NativeType(value="struct aiFace *")
        public AIFace.Buffer mFaces() {
            return AIMesh.nmFaces(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumBones() {
            return AIMesh.nmNumBones(this.address());
        }

        @NativeType(value="struct aiBone **")
        public @Nullable PointerBuffer mBones() {
            return AIMesh.nmBones(this.address());
        }

        @NativeType(value="unsigned int")
        public int mMaterialIndex() {
            return AIMesh.nmMaterialIndex(this.address());
        }

        @NativeType(value="struct aiString")
        public AIString mName() {
            return AIMesh.nmName(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumAnimMeshes() {
            return AIMesh.nmNumAnimMeshes(this.address());
        }

        @NativeType(value="struct aiAnimMesh **")
        public @Nullable PointerBuffer mAnimMeshes() {
            return AIMesh.nmAnimMeshes(this.address());
        }

        @NativeType(value="aiMorphingMethod")
        public int mMethod() {
            return AIMesh.nmMethod(this.address());
        }

        @NativeType(value="struct aiAABB")
        public AIAABB mAABB() {
            return AIMesh.nmAABB(this.address());
        }

        @NativeType(value="struct aiString **")
        public @Nullable PointerBuffer mTextureCoordsNames() {
            return AIMesh.nmTextureCoordsNames(this.address());
        }

        public Buffer mPrimitiveTypes(@NativeType(value="unsigned int") int value) {
            AIMesh.nmPrimitiveTypes(this.address(), value);
            return this;
        }

        public Buffer mNumVertices(@NativeType(value="unsigned int") int value) {
            AIMesh.nmNumVertices(this.address(), value);
            return this;
        }

        public Buffer mVertices(@NativeType(value="struct aiVector3D *") AIVector3D.Buffer value) {
            AIMesh.nmVertices(this.address(), value);
            return this;
        }

        public Buffer mNormals(@NativeType(value="struct aiVector3D *") @Nullable AIVector3D.Buffer value) {
            AIMesh.nmNormals(this.address(), value);
            return this;
        }

        public Buffer mTangents(@NativeType(value="struct aiVector3D *") @Nullable AIVector3D.Buffer value) {
            AIMesh.nmTangents(this.address(), value);
            return this;
        }

        public Buffer mBitangents(@NativeType(value="struct aiVector3D *") @Nullable AIVector3D.Buffer value) {
            AIMesh.nmBitangents(this.address(), value);
            return this;
        }

        public Buffer mColors(@NativeType(value="struct aiColor4D *[AI_MAX_NUMBER_OF_COLOR_SETS]") PointerBuffer value) {
            AIMesh.nmColors(this.address(), value);
            return this;
        }

        public Buffer mColors(int index, @NativeType(value="struct aiColor4D *") @Nullable AIColor4D.Buffer value) {
            AIMesh.nmColors(this.address(), index, value);
            return this;
        }

        public Buffer mColors(int index, Consumer<@Nullable AIColor4D.Buffer> consumer) {
            consumer.accept(this.mColors(index));
            return this;
        }

        public Buffer mTextureCoords(@NativeType(value="struct aiVector3D *[AI_MAX_NUMBER_OF_TEXTURECOORDS]") PointerBuffer value) {
            AIMesh.nmTextureCoords(this.address(), value);
            return this;
        }

        public Buffer mTextureCoords(int index, @NativeType(value="struct aiVector3D *") @Nullable AIVector3D.Buffer value) {
            AIMesh.nmTextureCoords(this.address(), index, value);
            return this;
        }

        public Buffer mTextureCoords(int index, Consumer<@Nullable AIVector3D.Buffer> consumer) {
            consumer.accept(this.mTextureCoords(index));
            return this;
        }

        public Buffer mNumUVComponents(@NativeType(value="unsigned int[AI_MAX_NUMBER_OF_TEXTURECOORDS]") IntBuffer value) {
            AIMesh.nmNumUVComponents(this.address(), value);
            return this;
        }

        public Buffer mNumUVComponents(int index, @NativeType(value="unsigned int") int value) {
            AIMesh.nmNumUVComponents(this.address(), index, value);
            return this;
        }

        public Buffer mFaces(@NativeType(value="struct aiFace *") AIFace.Buffer value) {
            AIMesh.nmFaces(this.address(), value);
            return this;
        }

        public Buffer mBones(@NativeType(value="struct aiBone **") @Nullable PointerBuffer value) {
            AIMesh.nmBones(this.address(), value);
            return this;
        }

        public Buffer mMaterialIndex(@NativeType(value="unsigned int") int value) {
            AIMesh.nmMaterialIndex(this.address(), value);
            return this;
        }

        public Buffer mName(@NativeType(value="struct aiString") AIString value) {
            AIMesh.nmName(this.address(), value);
            return this;
        }

        public Buffer mName(Consumer<AIString> consumer) {
            consumer.accept(this.mName());
            return this;
        }

        public Buffer mAnimMeshes(@NativeType(value="struct aiAnimMesh **") @Nullable PointerBuffer value) {
            AIMesh.nmAnimMeshes(this.address(), value);
            return this;
        }

        public Buffer mMethod(@NativeType(value="aiMorphingMethod") int value) {
            AIMesh.nmMethod(this.address(), value);
            return this;
        }

        public Buffer mAABB(@NativeType(value="struct aiAABB") AIAABB value) {
            AIMesh.nmAABB(this.address(), value);
            return this;
        }

        public Buffer mAABB(Consumer<AIAABB> consumer) {
            consumer.accept(this.mAABB());
            return this;
        }

        public Buffer mTextureCoordsNames(@NativeType(value="struct aiString **") @Nullable PointerBuffer value) {
            AIMesh.nmTextureCoordsNames(this.address(), value);
            return this;
        }
    }
}

