/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AIMatrix4x4;
import org.lwjgl.assimp.AIMesh;
import org.lwjgl.assimp.AINode;
import org.lwjgl.assimp.AIVertexWeight;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiSkeletonBone")
public class AISkeletonBone
extends Struct<AISkeletonBone>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MPARENT;
    public static final int MARMATURE;
    public static final int MNODE;
    public static final int MNUMNWEIGHTS;
    public static final int MMESHID;
    public static final int MWEIGHTS;
    public static final int MOFFSETMATRIX;
    public static final int MLOCALMATRIX;

    protected AISkeletonBone(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected AISkeletonBone create(long address, @Nullable ByteBuffer container) {
        return new AISkeletonBone(address, container);
    }

    public AISkeletonBone(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AISkeletonBone.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int mParent() {
        return AISkeletonBone.nmParent(this.address());
    }

    @NativeType(value="struct aiNode *")
    public @Nullable AINode mArmature() {
        return AISkeletonBone.nmArmature(this.address());
    }

    @NativeType(value="struct aiNode *")
    public @Nullable AINode mNode() {
        return AISkeletonBone.nmNode(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumnWeights() {
        return AISkeletonBone.nmNumnWeights(this.address());
    }

    @NativeType(value="struct aiMesh *")
    public AIMesh.Buffer mMeshId() {
        return AISkeletonBone.nmMeshId(this.address());
    }

    @NativeType(value="struct aiVertexWeight *")
    public AIVertexWeight.Buffer mWeights() {
        return AISkeletonBone.nmWeights(this.address());
    }

    @NativeType(value="struct aiMatrix4x4")
    public AIMatrix4x4 mOffsetMatrix() {
        return AISkeletonBone.nmOffsetMatrix(this.address());
    }

    @NativeType(value="struct aiMatrix4x4")
    public AIMatrix4x4 mLocalMatrix() {
        return AISkeletonBone.nmLocalMatrix(this.address());
    }

    public AISkeletonBone mParent(int value) {
        AISkeletonBone.nmParent(this.address(), value);
        return this;
    }

    public AISkeletonBone mArmature(@NativeType(value="struct aiNode *") @Nullable AINode value) {
        AISkeletonBone.nmArmature(this.address(), value);
        return this;
    }

    public AISkeletonBone mNode(@NativeType(value="struct aiNode *") @Nullable AINode value) {
        AISkeletonBone.nmNode(this.address(), value);
        return this;
    }

    public AISkeletonBone mNumnWeights(@NativeType(value="unsigned int") int value) {
        AISkeletonBone.nmNumnWeights(this.address(), value);
        return this;
    }

    public AISkeletonBone mMeshId(@NativeType(value="struct aiMesh *") AIMesh.Buffer value) {
        AISkeletonBone.nmMeshId(this.address(), value);
        return this;
    }

    public AISkeletonBone mWeights(@NativeType(value="struct aiVertexWeight *") AIVertexWeight.Buffer value) {
        AISkeletonBone.nmWeights(this.address(), value);
        return this;
    }

    public AISkeletonBone mOffsetMatrix(@NativeType(value="struct aiMatrix4x4") AIMatrix4x4 value) {
        AISkeletonBone.nmOffsetMatrix(this.address(), value);
        return this;
    }

    public AISkeletonBone mOffsetMatrix(Consumer<AIMatrix4x4> consumer) {
        consumer.accept(this.mOffsetMatrix());
        return this;
    }

    public AISkeletonBone mLocalMatrix(@NativeType(value="struct aiMatrix4x4") AIMatrix4x4 value) {
        AISkeletonBone.nmLocalMatrix(this.address(), value);
        return this;
    }

    public AISkeletonBone mLocalMatrix(Consumer<AIMatrix4x4> consumer) {
        consumer.accept(this.mLocalMatrix());
        return this;
    }

    public AISkeletonBone set(int mParent, @Nullable AINode mArmature, @Nullable AINode mNode, int mNumnWeights, AIMesh.Buffer mMeshId, AIVertexWeight.Buffer mWeights, AIMatrix4x4 mOffsetMatrix, AIMatrix4x4 mLocalMatrix) {
        this.mParent(mParent);
        this.mArmature(mArmature);
        this.mNode(mNode);
        this.mNumnWeights(mNumnWeights);
        this.mMeshId(mMeshId);
        this.mWeights(mWeights);
        this.mOffsetMatrix(mOffsetMatrix);
        this.mLocalMatrix(mLocalMatrix);
        return this;
    }

    public AISkeletonBone set(AISkeletonBone src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static AISkeletonBone malloc() {
        return new AISkeletonBone(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static AISkeletonBone calloc() {
        return new AISkeletonBone(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static AISkeletonBone create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new AISkeletonBone(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static AISkeletonBone create(long address) {
        return new AISkeletonBone(address, null);
    }

    public static @Nullable AISkeletonBone createSafe(long address) {
        return address == 0L ? null : new AISkeletonBone(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)AISkeletonBone.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AISkeletonBone.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static AISkeletonBone malloc(MemoryStack stack) {
        return new AISkeletonBone(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static AISkeletonBone calloc(MemoryStack stack) {
        return new AISkeletonBone(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nmParent(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MPARENT));
    }

    public static @Nullable AINode nmArmature(long struct) {
        return AINode.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)MARMATURE)));
    }

    public static @Nullable AINode nmNode(long struct) {
        return AINode.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)MNODE)));
    }

    public static int nmNumnWeights(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MNUMNWEIGHTS));
    }

    public static AIMesh.Buffer nmMeshId(long struct) {
        return AIMesh.create(MemoryUtil.memGetAddress((long)(struct + (long)MMESHID)), AISkeletonBone.nmNumnWeights(struct));
    }

    public static AIVertexWeight.Buffer nmWeights(long struct) {
        return AIVertexWeight.create(MemoryUtil.memGetAddress((long)(struct + (long)MWEIGHTS)), AISkeletonBone.nmNumnWeights(struct));
    }

    public static AIMatrix4x4 nmOffsetMatrix(long struct) {
        return AIMatrix4x4.create(struct + (long)MOFFSETMATRIX);
    }

    public static AIMatrix4x4 nmLocalMatrix(long struct) {
        return AIMatrix4x4.create(struct + (long)MLOCALMATRIX);
    }

    public static void nmParent(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MPARENT), (int)value);
    }

    public static void nmArmature(long struct, @Nullable AINode value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MARMATURE), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nmNode(long struct, @Nullable AINode value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MNODE), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nmNumnWeights(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MNUMNWEIGHTS), (int)value);
    }

    public static void nmMeshId(long struct, AIMesh.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MMESHID), (long)value.address());
    }

    public static void nmWeights(long struct, AIVertexWeight.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MWEIGHTS), (long)value.address());
    }

    public static void nmOffsetMatrix(long struct, AIMatrix4x4 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MOFFSETMATRIX), (long)AIMatrix4x4.SIZEOF);
    }

    public static void nmLocalMatrix(long struct, AIMatrix4x4 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MLOCALMATRIX), (long)AIMatrix4x4.SIZEOF);
    }

    public static void validate(long struct) {
        long mNode;
        long mArmature = MemoryUtil.memGetAddress((long)(struct + (long)MARMATURE));
        if (mArmature != 0L) {
            AINode.validate(mArmature);
        }
        if ((mNode = MemoryUtil.memGetAddress((long)(struct + (long)MNODE))) != 0L) {
            AINode.validate(mNode);
        }
        int mNumnWeights = AISkeletonBone.nmNumnWeights(struct);
        long mMeshId = MemoryUtil.memGetAddress((long)(struct + (long)MMESHID));
        Checks.check((long)mMeshId);
        AISkeletonBone.validate((long)mMeshId, (int)mNumnWeights, (int)AIMesh.SIZEOF, AIMesh::validate);
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MWEIGHTS)));
    }

    static {
        Struct.Layout layout = AISkeletonBone.__struct((Struct.Member[])new Struct.Member[]{AISkeletonBone.__member((int)4), AISkeletonBone.__member((int)POINTER_SIZE), AISkeletonBone.__member((int)POINTER_SIZE), AISkeletonBone.__member((int)4), AISkeletonBone.__member((int)POINTER_SIZE), AISkeletonBone.__member((int)POINTER_SIZE), AISkeletonBone.__member((int)AIMatrix4x4.SIZEOF, (int)AIMatrix4x4.ALIGNOF), AISkeletonBone.__member((int)AIMatrix4x4.SIZEOF, (int)AIMatrix4x4.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MPARENT = layout.offsetof(0);
        MARMATURE = layout.offsetof(1);
        MNODE = layout.offsetof(2);
        MNUMNWEIGHTS = layout.offsetof(3);
        MMESHID = layout.offsetof(4);
        MWEIGHTS = layout.offsetof(5);
        MOFFSETMATRIX = layout.offsetof(6);
        MLOCALMATRIX = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<AISkeletonBone, Buffer>
    implements NativeResource {
        private static final AISkeletonBone ELEMENT_FACTORY = AISkeletonBone.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected AISkeletonBone getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int mParent() {
            return AISkeletonBone.nmParent(this.address());
        }

        @NativeType(value="struct aiNode *")
        public @Nullable AINode mArmature() {
            return AISkeletonBone.nmArmature(this.address());
        }

        @NativeType(value="struct aiNode *")
        public @Nullable AINode mNode() {
            return AISkeletonBone.nmNode(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumnWeights() {
            return AISkeletonBone.nmNumnWeights(this.address());
        }

        @NativeType(value="struct aiMesh *")
        public AIMesh.Buffer mMeshId() {
            return AISkeletonBone.nmMeshId(this.address());
        }

        @NativeType(value="struct aiVertexWeight *")
        public AIVertexWeight.Buffer mWeights() {
            return AISkeletonBone.nmWeights(this.address());
        }

        @NativeType(value="struct aiMatrix4x4")
        public AIMatrix4x4 mOffsetMatrix() {
            return AISkeletonBone.nmOffsetMatrix(this.address());
        }

        @NativeType(value="struct aiMatrix4x4")
        public AIMatrix4x4 mLocalMatrix() {
            return AISkeletonBone.nmLocalMatrix(this.address());
        }

        public Buffer mParent(int value) {
            AISkeletonBone.nmParent(this.address(), value);
            return this;
        }

        public Buffer mArmature(@NativeType(value="struct aiNode *") @Nullable AINode value) {
            AISkeletonBone.nmArmature(this.address(), value);
            return this;
        }

        public Buffer mNode(@NativeType(value="struct aiNode *") @Nullable AINode value) {
            AISkeletonBone.nmNode(this.address(), value);
            return this;
        }

        public Buffer mNumnWeights(@NativeType(value="unsigned int") int value) {
            AISkeletonBone.nmNumnWeights(this.address(), value);
            return this;
        }

        public Buffer mMeshId(@NativeType(value="struct aiMesh *") AIMesh.Buffer value) {
            AISkeletonBone.nmMeshId(this.address(), value);
            return this;
        }

        public Buffer mWeights(@NativeType(value="struct aiVertexWeight *") AIVertexWeight.Buffer value) {
            AISkeletonBone.nmWeights(this.address(), value);
            return this;
        }

        public Buffer mOffsetMatrix(@NativeType(value="struct aiMatrix4x4") AIMatrix4x4 value) {
            AISkeletonBone.nmOffsetMatrix(this.address(), value);
            return this;
        }

        public Buffer mOffsetMatrix(Consumer<AIMatrix4x4> consumer) {
            consumer.accept(this.mOffsetMatrix());
            return this;
        }

        public Buffer mLocalMatrix(@NativeType(value="struct aiMatrix4x4") AIMatrix4x4 value) {
            AISkeletonBone.nmLocalMatrix(this.address(), value);
            return this;
        }

        public Buffer mLocalMatrix(Consumer<AIMatrix4x4> consumer) {
            consumer.accept(this.mLocalMatrix());
            return this;
        }
    }
}

