/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.bgfx.BGFXReallocCallback;
import org.lwjgl.bgfx.BGFXReallocCallbackI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_allocator_vtbl_t")
public class BGFXAllocatorVtbl
extends Struct<BGFXAllocatorVtbl>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int REALLOC;

    protected BGFXAllocatorVtbl(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected BGFXAllocatorVtbl create(long address, @Nullable ByteBuffer container) {
        return new BGFXAllocatorVtbl(address, container);
    }

    public BGFXAllocatorVtbl(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), BGFXAllocatorVtbl.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void * (*) (bgfx_allocator_interface_t *, void *, size_t, size_t, char *, uint32_t)")
    public BGFXReallocCallback realloc() {
        return BGFXAllocatorVtbl.nrealloc(this.address());
    }

    public BGFXAllocatorVtbl realloc(@NativeType(value="void * (*) (bgfx_allocator_interface_t *, void *, size_t, size_t, char *, uint32_t)") BGFXReallocCallbackI value) {
        BGFXAllocatorVtbl.nrealloc(this.address(), value);
        return this;
    }

    public BGFXAllocatorVtbl set(BGFXAllocatorVtbl src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static BGFXAllocatorVtbl malloc() {
        return new BGFXAllocatorVtbl(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static BGFXAllocatorVtbl calloc() {
        return new BGFXAllocatorVtbl(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static BGFXAllocatorVtbl create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new BGFXAllocatorVtbl(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static BGFXAllocatorVtbl create(long address) {
        return new BGFXAllocatorVtbl(address, null);
    }

    public static @Nullable BGFXAllocatorVtbl createSafe(long address) {
        return address == 0L ? null : new BGFXAllocatorVtbl(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)BGFXAllocatorVtbl.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = BGFXAllocatorVtbl.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static BGFXAllocatorVtbl mallocStack() {
        return BGFXAllocatorVtbl.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXAllocatorVtbl callocStack() {
        return BGFXAllocatorVtbl.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXAllocatorVtbl mallocStack(MemoryStack stack) {
        return BGFXAllocatorVtbl.malloc(stack);
    }

    @Deprecated
    public static BGFXAllocatorVtbl callocStack(MemoryStack stack) {
        return BGFXAllocatorVtbl.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return BGFXAllocatorVtbl.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return BGFXAllocatorVtbl.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return BGFXAllocatorVtbl.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return BGFXAllocatorVtbl.calloc(capacity, stack);
    }

    public static BGFXAllocatorVtbl malloc(MemoryStack stack) {
        return new BGFXAllocatorVtbl(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static BGFXAllocatorVtbl calloc(MemoryStack stack) {
        return new BGFXAllocatorVtbl(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static BGFXReallocCallback nrealloc(long struct) {
        return BGFXReallocCallback.create(MemoryUtil.memGetAddress((long)(struct + (long)REALLOC)));
    }

    public static void nrealloc(long struct, BGFXReallocCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)REALLOC), (long)value.address());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)REALLOC)));
    }

    static {
        Struct.Layout layout = BGFXAllocatorVtbl.__struct((Struct.Member[])new Struct.Member[]{BGFXAllocatorVtbl.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        REALLOC = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<BGFXAllocatorVtbl, Buffer>
    implements NativeResource {
        private static final BGFXAllocatorVtbl ELEMENT_FACTORY = BGFXAllocatorVtbl.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected BGFXAllocatorVtbl getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void * (*) (bgfx_allocator_interface_t *, void *, size_t, size_t, char *, uint32_t)")
        public BGFXReallocCallback realloc() {
            return BGFXAllocatorVtbl.nrealloc(this.address());
        }

        public Buffer realloc(@NativeType(value="void * (*) (bgfx_allocator_interface_t *, void *, size_t, size_t, char *, uint32_t)") BGFXReallocCallbackI value) {
            BGFXAllocatorVtbl.nrealloc(this.address(), value);
            return this;
        }
    }
}

