/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.bgfx.BGFXCallbackVtbl;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;

@NativeType(value="struct bgfx_callback_interface_t")
public class BGFXCallbackInterface
extends Struct<BGFXCallbackInterface>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VTBL;

    protected BGFXCallbackInterface(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected BGFXCallbackInterface create(long address, @Nullable ByteBuffer container) {
        return new BGFXCallbackInterface(address, container);
    }

    public BGFXCallbackInterface(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), BGFXCallbackInterface.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="bgfx_callback_vtbl_t const *")
    public BGFXCallbackVtbl vtbl() {
        return BGFXCallbackInterface.nvtbl(this.address());
    }

    public BGFXCallbackInterface vtbl(@NativeType(value="bgfx_callback_vtbl_t const *") BGFXCallbackVtbl value) {
        BGFXCallbackInterface.nvtbl(this.address(), value);
        return this;
    }

    public BGFXCallbackInterface set(BGFXCallbackInterface src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static BGFXCallbackInterface malloc() {
        return new BGFXCallbackInterface(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static BGFXCallbackInterface calloc() {
        return new BGFXCallbackInterface(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static BGFXCallbackInterface create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new BGFXCallbackInterface(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static BGFXCallbackInterface create(long address) {
        return new BGFXCallbackInterface(address, null);
    }

    public static @Nullable BGFXCallbackInterface createSafe(long address) {
        return address == 0L ? null : new BGFXCallbackInterface(address, null);
    }

    @Deprecated
    public static BGFXCallbackInterface mallocStack() {
        return BGFXCallbackInterface.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXCallbackInterface callocStack() {
        return BGFXCallbackInterface.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXCallbackInterface mallocStack(MemoryStack stack) {
        return BGFXCallbackInterface.malloc(stack);
    }

    @Deprecated
    public static BGFXCallbackInterface callocStack(MemoryStack stack) {
        return BGFXCallbackInterface.calloc(stack);
    }

    public static BGFXCallbackInterface malloc(MemoryStack stack) {
        return new BGFXCallbackInterface(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static BGFXCallbackInterface calloc(MemoryStack stack) {
        return new BGFXCallbackInterface(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static BGFXCallbackVtbl nvtbl(long struct) {
        return BGFXCallbackVtbl.create(MemoryUtil.memGetAddress((long)(struct + (long)VTBL)));
    }

    public static void nvtbl(long struct, BGFXCallbackVtbl value) {
        MemoryUtil.memPutAddress((long)(struct + (long)VTBL), (long)value.address());
    }

    public static void validate(long struct) {
        long vtbl = MemoryUtil.memGetAddress((long)(struct + (long)VTBL));
        Checks.check((long)vtbl);
        BGFXCallbackVtbl.validate(vtbl);
    }

    static {
        Struct.Layout layout = BGFXCallbackInterface.__struct((Struct.Member[])new Struct.Member[]{BGFXCallbackInterface.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VTBL = layout.offsetof(0);
    }
}

