/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.bgfx.BGFXAllocatorInterface;
import org.lwjgl.bgfx.BGFXCallbackInterface;
import org.lwjgl.bgfx.BGFXInitLimits;
import org.lwjgl.bgfx.BGFXPlatformData;
import org.lwjgl.bgfx.BGFXResolution;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;

@NativeType(value="struct bgfx_init_t")
public class BGFXInit
extends Struct<BGFXInit>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int VENDORID;
    public static final int DEVICEID;
    public static final int CAPABILITIES;
    public static final int DEBUG;
    public static final int PROFILE;
    public static final int PLATFORMDATA;
    public static final int RESOLUTION;
    public static final int LIMITS;
    public static final int CALLBACK;
    public static final int ALLOCATOR;

    protected BGFXInit(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected BGFXInit create(long address, @Nullable ByteBuffer container) {
        return new BGFXInit(address, container);
    }

    public BGFXInit(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), BGFXInit.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="bgfx_renderer_type_t")
    public int type() {
        return BGFXInit.ntype(this.address());
    }

    @NativeType(value="uint16_t")
    public short vendorId() {
        return BGFXInit.nvendorId(this.address());
    }

    @NativeType(value="uint16_t")
    public short deviceId() {
        return BGFXInit.ndeviceId(this.address());
    }

    @NativeType(value="uint64_t")
    public long capabilities() {
        return BGFXInit.ncapabilities(this.address());
    }

    @NativeType(value="bool")
    public boolean debug() {
        return BGFXInit.ndebug(this.address());
    }

    @NativeType(value="bool")
    public boolean profile() {
        return BGFXInit.nprofile(this.address());
    }

    @NativeType(value="bgfx_platform_data_t")
    public BGFXPlatformData platformData() {
        return BGFXInit.nplatformData(this.address());
    }

    @NativeType(value="bgfx_resolution_t")
    public BGFXResolution resolution() {
        return BGFXInit.nresolution(this.address());
    }

    @NativeType(value="bgfx_init_limits_t")
    public BGFXInitLimits limits() {
        return BGFXInit.nlimits(this.address());
    }

    @NativeType(value="bgfx_callback_interface_t *")
    public @Nullable BGFXCallbackInterface callback() {
        return BGFXInit.ncallback(this.address());
    }

    @NativeType(value="bgfx_allocator_interface_t *")
    public @Nullable BGFXAllocatorInterface allocator() {
        return BGFXInit.nallocator(this.address());
    }

    public BGFXInit type(@NativeType(value="bgfx_renderer_type_t") int value) {
        BGFXInit.ntype(this.address(), value);
        return this;
    }

    public BGFXInit vendorId(@NativeType(value="uint16_t") short value) {
        BGFXInit.nvendorId(this.address(), value);
        return this;
    }

    public BGFXInit deviceId(@NativeType(value="uint16_t") short value) {
        BGFXInit.ndeviceId(this.address(), value);
        return this;
    }

    public BGFXInit capabilities(@NativeType(value="uint64_t") long value) {
        BGFXInit.ncapabilities(this.address(), value);
        return this;
    }

    public BGFXInit debug(@NativeType(value="bool") boolean value) {
        BGFXInit.ndebug(this.address(), value);
        return this;
    }

    public BGFXInit profile(@NativeType(value="bool") boolean value) {
        BGFXInit.nprofile(this.address(), value);
        return this;
    }

    public BGFXInit platformData(@NativeType(value="bgfx_platform_data_t") BGFXPlatformData value) {
        BGFXInit.nplatformData(this.address(), value);
        return this;
    }

    public BGFXInit platformData(Consumer<BGFXPlatformData> consumer) {
        consumer.accept(this.platformData());
        return this;
    }

    public BGFXInit resolution(@NativeType(value="bgfx_resolution_t") BGFXResolution value) {
        BGFXInit.nresolution(this.address(), value);
        return this;
    }

    public BGFXInit resolution(Consumer<BGFXResolution> consumer) {
        consumer.accept(this.resolution());
        return this;
    }

    public BGFXInit limits(@NativeType(value="bgfx_init_limits_t") BGFXInitLimits value) {
        BGFXInit.nlimits(this.address(), value);
        return this;
    }

    public BGFXInit limits(Consumer<BGFXInitLimits> consumer) {
        consumer.accept(this.limits());
        return this;
    }

    public BGFXInit callback(@NativeType(value="bgfx_callback_interface_t *") @Nullable BGFXCallbackInterface value) {
        BGFXInit.ncallback(this.address(), value);
        return this;
    }

    public BGFXInit allocator(@NativeType(value="bgfx_allocator_interface_t *") @Nullable BGFXAllocatorInterface value) {
        BGFXInit.nallocator(this.address(), value);
        return this;
    }

    public BGFXInit set(int type, short vendorId, short deviceId, long capabilities, boolean debug, boolean profile, BGFXPlatformData platformData, BGFXResolution resolution, BGFXInitLimits limits, @Nullable BGFXCallbackInterface callback, @Nullable BGFXAllocatorInterface allocator) {
        this.type(type);
        this.vendorId(vendorId);
        this.deviceId(deviceId);
        this.capabilities(capabilities);
        this.debug(debug);
        this.profile(profile);
        this.platformData(platformData);
        this.resolution(resolution);
        this.limits(limits);
        this.callback(callback);
        this.allocator(allocator);
        return this;
    }

    public BGFXInit set(BGFXInit src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static BGFXInit malloc() {
        return new BGFXInit(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static BGFXInit calloc() {
        return new BGFXInit(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static BGFXInit create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new BGFXInit(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static BGFXInit create(long address) {
        return new BGFXInit(address, null);
    }

    public static @Nullable BGFXInit createSafe(long address) {
        return address == 0L ? null : new BGFXInit(address, null);
    }

    @Deprecated
    public static BGFXInit mallocStack() {
        return BGFXInit.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXInit callocStack() {
        return BGFXInit.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXInit mallocStack(MemoryStack stack) {
        return BGFXInit.malloc(stack);
    }

    @Deprecated
    public static BGFXInit callocStack(MemoryStack stack) {
        return BGFXInit.calloc(stack);
    }

    public static BGFXInit malloc(MemoryStack stack) {
        return new BGFXInit(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static BGFXInit calloc(MemoryStack stack) {
        return new BGFXInit(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static short nvendorId(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)VENDORID));
    }

    public static short ndeviceId(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)DEVICEID));
    }

    public static long ncapabilities(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)CAPABILITIES));
    }

    public static boolean ndebug(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)DEBUG)) != 0;
    }

    public static boolean nprofile(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)PROFILE)) != 0;
    }

    public static BGFXPlatformData nplatformData(long struct) {
        return BGFXPlatformData.create(struct + (long)PLATFORMDATA);
    }

    public static BGFXResolution nresolution(long struct) {
        return BGFXResolution.create(struct + (long)RESOLUTION);
    }

    public static BGFXInitLimits nlimits(long struct) {
        return BGFXInitLimits.create(struct + (long)LIMITS);
    }

    public static @Nullable BGFXCallbackInterface ncallback(long struct) {
        return BGFXCallbackInterface.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)CALLBACK)));
    }

    public static @Nullable BGFXAllocatorInterface nallocator(long struct) {
        return BGFXAllocatorInterface.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)ALLOCATOR)));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nvendorId(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)VENDORID), (short)value);
    }

    public static void ndeviceId(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)DEVICEID), (short)value);
    }

    public static void ncapabilities(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)CAPABILITIES), (long)value);
    }

    public static void ndebug(long struct, boolean value) {
        MemoryUtil.memPutByte((long)(struct + (long)DEBUG), (byte)(value ? (byte)1 : 0));
    }

    public static void nprofile(long struct, boolean value) {
        MemoryUtil.memPutByte((long)(struct + (long)PROFILE), (byte)(value ? (byte)1 : 0));
    }

    public static void nplatformData(long struct, BGFXPlatformData value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PLATFORMDATA), (long)BGFXPlatformData.SIZEOF);
    }

    public static void nresolution(long struct, BGFXResolution value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)RESOLUTION), (long)BGFXResolution.SIZEOF);
    }

    public static void nlimits(long struct, BGFXInitLimits value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)LIMITS), (long)BGFXInitLimits.SIZEOF);
    }

    public static void ncallback(long struct, @Nullable BGFXCallbackInterface value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CALLBACK), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nallocator(long struct, @Nullable BGFXAllocatorInterface value) {
        MemoryUtil.memPutAddress((long)(struct + (long)ALLOCATOR), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void validate(long struct) {
        long allocator;
        long callback = MemoryUtil.memGetAddress((long)(struct + (long)CALLBACK));
        if (callback != 0L) {
            BGFXCallbackInterface.validate(callback);
        }
        if ((allocator = MemoryUtil.memGetAddress((long)(struct + (long)ALLOCATOR))) != 0L) {
            BGFXAllocatorInterface.validate(allocator);
        }
    }

    static {
        Struct.Layout layout = BGFXInit.__struct((Struct.Member[])new Struct.Member[]{BGFXInit.__member((int)4), BGFXInit.__member((int)2), BGFXInit.__member((int)2), BGFXInit.__member((int)8), BGFXInit.__member((int)1), BGFXInit.__member((int)1), BGFXInit.__member((int)BGFXPlatformData.SIZEOF, (int)BGFXPlatformData.ALIGNOF), BGFXInit.__member((int)BGFXResolution.SIZEOF, (int)BGFXResolution.ALIGNOF), BGFXInit.__member((int)BGFXInitLimits.SIZEOF, (int)BGFXInitLimits.ALIGNOF), BGFXInit.__member((int)POINTER_SIZE), BGFXInit.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        VENDORID = layout.offsetof(1);
        DEVICEID = layout.offsetof(2);
        CAPABILITIES = layout.offsetof(3);
        DEBUG = layout.offsetof(4);
        PROFILE = layout.offsetof(5);
        PLATFORMDATA = layout.offsetof(6);
        RESOLUTION = layout.offsetof(7);
        LIMITS = layout.offsetof(8);
        CALLBACK = layout.offsetof(9);
        ALLOCATOR = layout.offsetof(10);
    }
}

