/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_memory_t")
public class BGFXMemory
extends Struct<BGFXMemory>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DATA;
    public static final int SIZE;

    protected BGFXMemory(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected BGFXMemory create(long address, @Nullable ByteBuffer container) {
        return new BGFXMemory(address, container);
    }

    public BGFXMemory(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), BGFXMemory.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint8_t *")
    public ByteBuffer data() {
        return BGFXMemory.ndata(this.address());
    }

    @NativeType(value="uint32_t")
    public int size() {
        return BGFXMemory.nsize(this.address());
    }

    public BGFXMemory data(@NativeType(value="uint8_t *") ByteBuffer value) {
        BGFXMemory.ndata(this.address(), value);
        return this;
    }

    public BGFXMemory set(BGFXMemory src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static BGFXMemory malloc() {
        return new BGFXMemory(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static BGFXMemory calloc() {
        return new BGFXMemory(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static BGFXMemory create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new BGFXMemory(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static BGFXMemory create(long address) {
        return new BGFXMemory(address, null);
    }

    public static @Nullable BGFXMemory createSafe(long address) {
        return address == 0L ? null : new BGFXMemory(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)BGFXMemory.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = BGFXMemory.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static BGFXMemory mallocStack() {
        return BGFXMemory.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXMemory callocStack() {
        return BGFXMemory.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXMemory mallocStack(MemoryStack stack) {
        return BGFXMemory.malloc(stack);
    }

    @Deprecated
    public static BGFXMemory callocStack(MemoryStack stack) {
        return BGFXMemory.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return BGFXMemory.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return BGFXMemory.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return BGFXMemory.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return BGFXMemory.calloc(capacity, stack);
    }

    public static BGFXMemory malloc(MemoryStack stack) {
        return new BGFXMemory(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static BGFXMemory calloc(MemoryStack stack) {
        return new BGFXMemory(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer ndata(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)DATA)), (int)BGFXMemory.nsize(struct));
    }

    public static int nsize(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SIZE));
    }

    public static void ndata(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DATA), (long)MemoryUtil.memAddress((ByteBuffer)value));
        BGFXMemory.nsize(struct, value.remaining());
    }

    public static void nsize(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SIZE), (int)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)DATA)));
    }

    static {
        Struct.Layout layout = BGFXMemory.__struct((Struct.Member[])new Struct.Member[]{BGFXMemory.__member((int)POINTER_SIZE), BGFXMemory.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DATA = layout.offsetof(0);
        SIZE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<BGFXMemory, Buffer>
    implements NativeResource {
        private static final BGFXMemory ELEMENT_FACTORY = BGFXMemory.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected BGFXMemory getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint8_t *")
        public ByteBuffer data() {
            return BGFXMemory.ndata(this.address());
        }

        @NativeType(value="uint32_t")
        public int size() {
            return BGFXMemory.nsize(this.address());
        }

        public Buffer data(@NativeType(value="uint8_t *") ByteBuffer value) {
            BGFXMemory.ndata(this.address(), value);
            return this;
        }
    }
}

