/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;

@NativeType(value="struct bgfx_platform_data_t")
public class BGFXPlatformData
extends Struct<BGFXPlatformData>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NDT;
    public static final int NWH;
    public static final int CONTEXT;
    public static final int BACKBUFFER;
    public static final int BACKBUFFERDS;
    public static final int TYPE;

    protected BGFXPlatformData(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected BGFXPlatformData create(long address, @Nullable ByteBuffer container) {
        return new BGFXPlatformData(address, container);
    }

    public BGFXPlatformData(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), BGFXPlatformData.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public long ndt() {
        return BGFXPlatformData.nndt(this.address());
    }

    @NativeType(value="void *")
    public long nwh() {
        return BGFXPlatformData.nnwh(this.address());
    }

    @NativeType(value="void *")
    public long context() {
        return BGFXPlatformData.ncontext(this.address());
    }

    @NativeType(value="void *")
    public long backBuffer() {
        return BGFXPlatformData.nbackBuffer(this.address());
    }

    @NativeType(value="void *")
    public long backBufferDS() {
        return BGFXPlatformData.nbackBufferDS(this.address());
    }

    @NativeType(value="bgfx_native_window_handle_type_t")
    public int type() {
        return BGFXPlatformData.ntype(this.address());
    }

    public BGFXPlatformData ndt(@NativeType(value="void *") long value) {
        BGFXPlatformData.nndt(this.address(), value);
        return this;
    }

    public BGFXPlatformData nwh(@NativeType(value="void *") long value) {
        BGFXPlatformData.nnwh(this.address(), value);
        return this;
    }

    public BGFXPlatformData context(@NativeType(value="void *") long value) {
        BGFXPlatformData.ncontext(this.address(), value);
        return this;
    }

    public BGFXPlatformData backBuffer(@NativeType(value="void *") long value) {
        BGFXPlatformData.nbackBuffer(this.address(), value);
        return this;
    }

    public BGFXPlatformData backBufferDS(@NativeType(value="void *") long value) {
        BGFXPlatformData.nbackBufferDS(this.address(), value);
        return this;
    }

    public BGFXPlatformData type(@NativeType(value="bgfx_native_window_handle_type_t") int value) {
        BGFXPlatformData.ntype(this.address(), value);
        return this;
    }

    public BGFXPlatformData set(long ndt, long nwh, long context, long backBuffer, long backBufferDS, int type) {
        this.ndt(ndt);
        this.nwh(nwh);
        this.context(context);
        this.backBuffer(backBuffer);
        this.backBufferDS(backBufferDS);
        this.type(type);
        return this;
    }

    public BGFXPlatformData set(BGFXPlatformData src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static BGFXPlatformData malloc() {
        return new BGFXPlatformData(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static BGFXPlatformData calloc() {
        return new BGFXPlatformData(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static BGFXPlatformData create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new BGFXPlatformData(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static BGFXPlatformData create(long address) {
        return new BGFXPlatformData(address, null);
    }

    public static @Nullable BGFXPlatformData createSafe(long address) {
        return address == 0L ? null : new BGFXPlatformData(address, null);
    }

    @Deprecated
    public static BGFXPlatformData mallocStack() {
        return BGFXPlatformData.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXPlatformData callocStack() {
        return BGFXPlatformData.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXPlatformData mallocStack(MemoryStack stack) {
        return BGFXPlatformData.malloc(stack);
    }

    @Deprecated
    public static BGFXPlatformData callocStack(MemoryStack stack) {
        return BGFXPlatformData.calloc(stack);
    }

    public static BGFXPlatformData malloc(MemoryStack stack) {
        return new BGFXPlatformData(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static BGFXPlatformData calloc(MemoryStack stack) {
        return new BGFXPlatformData(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static long nndt(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NDT));
    }

    public static long nnwh(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NWH));
    }

    public static long ncontext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)CONTEXT));
    }

    public static long nbackBuffer(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)BACKBUFFER));
    }

    public static long nbackBufferDS(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)BACKBUFFERDS));
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static void nndt(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NDT), (long)value);
    }

    public static void nnwh(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NWH), (long)value);
    }

    public static void ncontext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CONTEXT), (long)value);
    }

    public static void nbackBuffer(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)BACKBUFFER), (long)value);
    }

    public static void nbackBufferDS(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)BACKBUFFERDS), (long)value);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    static {
        Struct.Layout layout = BGFXPlatformData.__struct((Struct.Member[])new Struct.Member[]{BGFXPlatformData.__member((int)POINTER_SIZE), BGFXPlatformData.__member((int)POINTER_SIZE), BGFXPlatformData.__member((int)POINTER_SIZE), BGFXPlatformData.__member((int)POINTER_SIZE), BGFXPlatformData.__member((int)POINTER_SIZE), BGFXPlatformData.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NDT = layout.offsetof(0);
        NWH = layout.offsetof(1);
        CONTEXT = layout.offsetof(2);
        BACKBUFFER = layout.offsetof(3);
        BACKBUFFERDS = layout.offsetof(4);
        TYPE = layout.offsetof(5);
    }
}

