/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;

@NativeType(value="struct bgfx_resolution_t")
public class BGFXResolution
extends Struct<BGFXResolution>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FORMAT;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int RESET;
    public static final int NUMBACKBUFFERS;
    public static final int MAXFRAMELATENCY;
    public static final int DEBUGTEXTSCALE;

    protected BGFXResolution(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected BGFXResolution create(long address, @Nullable ByteBuffer container) {
        return new BGFXResolution(address, container);
    }

    public BGFXResolution(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), BGFXResolution.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="bgfx_texture_format_t")
    public int format() {
        return BGFXResolution.nformat(this.address());
    }

    @NativeType(value="uint32_t")
    public int width() {
        return BGFXResolution.nwidth(this.address());
    }

    @NativeType(value="uint32_t")
    public int height() {
        return BGFXResolution.nheight(this.address());
    }

    @NativeType(value="uint32_t")
    public int reset() {
        return BGFXResolution.nreset(this.address());
    }

    @NativeType(value="uint8_t")
    public byte numBackBuffers() {
        return BGFXResolution.nnumBackBuffers(this.address());
    }

    @NativeType(value="uint8_t")
    public byte maxFrameLatency() {
        return BGFXResolution.nmaxFrameLatency(this.address());
    }

    @NativeType(value="uint8_t")
    public byte debugTextScale() {
        return BGFXResolution.ndebugTextScale(this.address());
    }

    public BGFXResolution format(@NativeType(value="bgfx_texture_format_t") int value) {
        BGFXResolution.nformat(this.address(), value);
        return this;
    }

    public BGFXResolution width(@NativeType(value="uint32_t") int value) {
        BGFXResolution.nwidth(this.address(), value);
        return this;
    }

    public BGFXResolution height(@NativeType(value="uint32_t") int value) {
        BGFXResolution.nheight(this.address(), value);
        return this;
    }

    public BGFXResolution reset(@NativeType(value="uint32_t") int value) {
        BGFXResolution.nreset(this.address(), value);
        return this;
    }

    public BGFXResolution numBackBuffers(@NativeType(value="uint8_t") byte value) {
        BGFXResolution.nnumBackBuffers(this.address(), value);
        return this;
    }

    public BGFXResolution maxFrameLatency(@NativeType(value="uint8_t") byte value) {
        BGFXResolution.nmaxFrameLatency(this.address(), value);
        return this;
    }

    public BGFXResolution debugTextScale(@NativeType(value="uint8_t") byte value) {
        BGFXResolution.ndebugTextScale(this.address(), value);
        return this;
    }

    public BGFXResolution set(int format, int width, int height, int reset, byte numBackBuffers, byte maxFrameLatency, byte debugTextScale) {
        this.format(format);
        this.width(width);
        this.height(height);
        this.reset(reset);
        this.numBackBuffers(numBackBuffers);
        this.maxFrameLatency(maxFrameLatency);
        this.debugTextScale(debugTextScale);
        return this;
    }

    public BGFXResolution set(BGFXResolution src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static BGFXResolution malloc() {
        return new BGFXResolution(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static BGFXResolution calloc() {
        return new BGFXResolution(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static BGFXResolution create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new BGFXResolution(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static BGFXResolution create(long address) {
        return new BGFXResolution(address, null);
    }

    public static @Nullable BGFXResolution createSafe(long address) {
        return address == 0L ? null : new BGFXResolution(address, null);
    }

    @Deprecated
    public static BGFXResolution mallocStack() {
        return BGFXResolution.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXResolution callocStack() {
        return BGFXResolution.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXResolution mallocStack(MemoryStack stack) {
        return BGFXResolution.malloc(stack);
    }

    @Deprecated
    public static BGFXResolution callocStack(MemoryStack stack) {
        return BGFXResolution.calloc(stack);
    }

    public static BGFXResolution malloc(MemoryStack stack) {
        return new BGFXResolution(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static BGFXResolution calloc(MemoryStack stack) {
        return new BGFXResolution(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static int nformat(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FORMAT));
    }

    public static int nwidth(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)WIDTH));
    }

    public static int nheight(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)HEIGHT));
    }

    public static int nreset(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)RESET));
    }

    public static byte nnumBackBuffers(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)NUMBACKBUFFERS));
    }

    public static byte nmaxFrameLatency(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)MAXFRAMELATENCY));
    }

    public static byte ndebugTextScale(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)DEBUGTEXTSCALE));
    }

    public static void nformat(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FORMAT), (int)value);
    }

    public static void nwidth(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)WIDTH), (int)value);
    }

    public static void nheight(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)HEIGHT), (int)value);
    }

    public static void nreset(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)RESET), (int)value);
    }

    public static void nnumBackBuffers(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)NUMBACKBUFFERS), (byte)value);
    }

    public static void nmaxFrameLatency(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)MAXFRAMELATENCY), (byte)value);
    }

    public static void ndebugTextScale(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)DEBUGTEXTSCALE), (byte)value);
    }

    static {
        Struct.Layout layout = BGFXResolution.__struct((Struct.Member[])new Struct.Member[]{BGFXResolution.__member((int)4), BGFXResolution.__member((int)4), BGFXResolution.__member((int)4), BGFXResolution.__member((int)4), BGFXResolution.__member((int)1), BGFXResolution.__member((int)1), BGFXResolution.__member((int)1)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FORMAT = layout.offsetof(0);
        WIDTH = layout.offsetof(1);
        HEIGHT = layout.offsetof(2);
        RESET = layout.offsetof(3);
        NUMBACKBUFFERS = layout.offsetof(4);
        MAXFRAMELATENCY = layout.offsetof(5);
        DEBUGTEXTSCALE = layout.offsetof(6);
    }
}

