/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUDA_ARRAY_MEMORY_REQUIREMENTS
extends Struct<CUDA_ARRAY_MEMORY_REQUIREMENTS>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SIZE;
    public static final int ALIGNMENT;
    public static final int RESERVED;

    protected CUDA_ARRAY_MEMORY_REQUIREMENTS(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CUDA_ARRAY_MEMORY_REQUIREMENTS create(long address, @Nullable ByteBuffer container) {
        return new CUDA_ARRAY_MEMORY_REQUIREMENTS(address, container);
    }

    public CUDA_ARRAY_MEMORY_REQUIREMENTS(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUDA_ARRAY_MEMORY_REQUIREMENTS.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="size_t")
    public long size() {
        return CUDA_ARRAY_MEMORY_REQUIREMENTS.nsize(this.address());
    }

    @NativeType(value="size_t")
    public long alignment() {
        return CUDA_ARRAY_MEMORY_REQUIREMENTS.nalignment(this.address());
    }

    @NativeType(value="unsigned int[4]")
    public IntBuffer reserved() {
        return CUDA_ARRAY_MEMORY_REQUIREMENTS.nreserved(this.address());
    }

    @NativeType(value="unsigned int")
    public int reserved(int index) {
        return CUDA_ARRAY_MEMORY_REQUIREMENTS.nreserved(this.address(), index);
    }

    public static CUDA_ARRAY_MEMORY_REQUIREMENTS malloc() {
        return new CUDA_ARRAY_MEMORY_REQUIREMENTS(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CUDA_ARRAY_MEMORY_REQUIREMENTS calloc() {
        return new CUDA_ARRAY_MEMORY_REQUIREMENTS(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CUDA_ARRAY_MEMORY_REQUIREMENTS create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CUDA_ARRAY_MEMORY_REQUIREMENTS(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CUDA_ARRAY_MEMORY_REQUIREMENTS create(long address) {
        return new CUDA_ARRAY_MEMORY_REQUIREMENTS(address, null);
    }

    public static @Nullable CUDA_ARRAY_MEMORY_REQUIREMENTS createSafe(long address) {
        return address == 0L ? null : new CUDA_ARRAY_MEMORY_REQUIREMENTS(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CUDA_ARRAY_MEMORY_REQUIREMENTS.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUDA_ARRAY_MEMORY_REQUIREMENTS.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUDA_ARRAY_MEMORY_REQUIREMENTS malloc(MemoryStack stack) {
        return new CUDA_ARRAY_MEMORY_REQUIREMENTS(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUDA_ARRAY_MEMORY_REQUIREMENTS calloc(MemoryStack stack) {
        return new CUDA_ARRAY_MEMORY_REQUIREMENTS(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SIZE));
    }

    public static long nalignment(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)ALIGNMENT));
    }

    public static IntBuffer nreserved(long struct) {
        return MemoryUtil.memIntBuffer((long)(struct + (long)RESERVED), (int)4);
    }

    public static int nreserved(long struct, int index) {
        return MemoryUtil.memGetInt((long)(struct + (long)RESERVED + Checks.check((int)index, (int)4) * 4L));
    }

    static {
        Struct.Layout layout = CUDA_ARRAY_MEMORY_REQUIREMENTS.__struct((Struct.Member[])new Struct.Member[]{CUDA_ARRAY_MEMORY_REQUIREMENTS.__member((int)POINTER_SIZE), CUDA_ARRAY_MEMORY_REQUIREMENTS.__member((int)POINTER_SIZE), CUDA_ARRAY_MEMORY_REQUIREMENTS.__array((int)4, (int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SIZE = layout.offsetof(0);
        ALIGNMENT = layout.offsetof(1);
        RESERVED = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<CUDA_ARRAY_MEMORY_REQUIREMENTS, Buffer>
    implements NativeResource {
        private static final CUDA_ARRAY_MEMORY_REQUIREMENTS ELEMENT_FACTORY = CUDA_ARRAY_MEMORY_REQUIREMENTS.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected CUDA_ARRAY_MEMORY_REQUIREMENTS getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="size_t")
        public long size() {
            return CUDA_ARRAY_MEMORY_REQUIREMENTS.nsize(this.address());
        }

        @NativeType(value="size_t")
        public long alignment() {
            return CUDA_ARRAY_MEMORY_REQUIREMENTS.nalignment(this.address());
        }

        @NativeType(value="unsigned int[4]")
        public IntBuffer reserved() {
            return CUDA_ARRAY_MEMORY_REQUIREMENTS.nreserved(this.address());
        }

        @NativeType(value="unsigned int")
        public int reserved(int index) {
            return CUDA_ARRAY_MEMORY_REQUIREMENTS.nreserved(this.address(), index);
        }
    }
}

