/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUDA_ARRAY_SPARSE_PROPERTIES
extends Struct<CUDA_ARRAY_SPARSE_PROPERTIES>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TILEEXTENT;
    public static final int TILEEXTENT_WIDTH;
    public static final int TILEEXTENT_HEIGHT;
    public static final int TILEEXTENT_DEPTH;
    public static final int MIPTAILFIRSTLEVEL;
    public static final int MIPTAILSIZE;
    public static final int FLAGS;
    public static final int RESERVED;

    protected CUDA_ARRAY_SPARSE_PROPERTIES(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CUDA_ARRAY_SPARSE_PROPERTIES create(long address, @Nullable ByteBuffer container) {
        return new CUDA_ARRAY_SPARSE_PROPERTIES(address, container);
    }

    public CUDA_ARRAY_SPARSE_PROPERTIES(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUDA_ARRAY_SPARSE_PROPERTIES.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int tileExtent_width() {
        return CUDA_ARRAY_SPARSE_PROPERTIES.ntileExtent_width(this.address());
    }

    @NativeType(value="unsigned int")
    public int tileExtent_height() {
        return CUDA_ARRAY_SPARSE_PROPERTIES.ntileExtent_height(this.address());
    }

    @NativeType(value="unsigned int")
    public int tileExtent_depth() {
        return CUDA_ARRAY_SPARSE_PROPERTIES.ntileExtent_depth(this.address());
    }

    @NativeType(value="unsigned int")
    public int miptailFirstLevel() {
        return CUDA_ARRAY_SPARSE_PROPERTIES.nmiptailFirstLevel(this.address());
    }

    @NativeType(value="unsigned long long")
    public long miptailSize() {
        return CUDA_ARRAY_SPARSE_PROPERTIES.nmiptailSize(this.address());
    }

    @NativeType(value="unsigned int")
    public int flags() {
        return CUDA_ARRAY_SPARSE_PROPERTIES.nflags(this.address());
    }

    @NativeType(value="unsigned int[4]")
    public IntBuffer reserved() {
        return CUDA_ARRAY_SPARSE_PROPERTIES.nreserved(this.address());
    }

    @NativeType(value="unsigned int")
    public int reserved(int index) {
        return CUDA_ARRAY_SPARSE_PROPERTIES.nreserved(this.address(), index);
    }

    public CUDA_ARRAY_SPARSE_PROPERTIES tileExtent_width(@NativeType(value="unsigned int") int value) {
        CUDA_ARRAY_SPARSE_PROPERTIES.ntileExtent_width(this.address(), value);
        return this;
    }

    public CUDA_ARRAY_SPARSE_PROPERTIES tileExtent_height(@NativeType(value="unsigned int") int value) {
        CUDA_ARRAY_SPARSE_PROPERTIES.ntileExtent_height(this.address(), value);
        return this;
    }

    public CUDA_ARRAY_SPARSE_PROPERTIES tileExtent_depth(@NativeType(value="unsigned int") int value) {
        CUDA_ARRAY_SPARSE_PROPERTIES.ntileExtent_depth(this.address(), value);
        return this;
    }

    public CUDA_ARRAY_SPARSE_PROPERTIES miptailFirstLevel(@NativeType(value="unsigned int") int value) {
        CUDA_ARRAY_SPARSE_PROPERTIES.nmiptailFirstLevel(this.address(), value);
        return this;
    }

    public CUDA_ARRAY_SPARSE_PROPERTIES miptailSize(@NativeType(value="unsigned long long") long value) {
        CUDA_ARRAY_SPARSE_PROPERTIES.nmiptailSize(this.address(), value);
        return this;
    }

    public CUDA_ARRAY_SPARSE_PROPERTIES flags(@NativeType(value="unsigned int") int value) {
        CUDA_ARRAY_SPARSE_PROPERTIES.nflags(this.address(), value);
        return this;
    }

    public CUDA_ARRAY_SPARSE_PROPERTIES reserved(@NativeType(value="unsigned int[4]") IntBuffer value) {
        CUDA_ARRAY_SPARSE_PROPERTIES.nreserved(this.address(), value);
        return this;
    }

    public CUDA_ARRAY_SPARSE_PROPERTIES reserved(int index, @NativeType(value="unsigned int") int value) {
        CUDA_ARRAY_SPARSE_PROPERTIES.nreserved(this.address(), index, value);
        return this;
    }

    public CUDA_ARRAY_SPARSE_PROPERTIES set(int tileExtent_width, int tileExtent_height, int tileExtent_depth, int miptailFirstLevel, long miptailSize, int flags, IntBuffer reserved) {
        this.tileExtent_width(tileExtent_width);
        this.tileExtent_height(tileExtent_height);
        this.tileExtent_depth(tileExtent_depth);
        this.miptailFirstLevel(miptailFirstLevel);
        this.miptailSize(miptailSize);
        this.flags(flags);
        this.reserved(reserved);
        return this;
    }

    public CUDA_ARRAY_SPARSE_PROPERTIES set(CUDA_ARRAY_SPARSE_PROPERTIES src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUDA_ARRAY_SPARSE_PROPERTIES malloc() {
        return new CUDA_ARRAY_SPARSE_PROPERTIES(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CUDA_ARRAY_SPARSE_PROPERTIES calloc() {
        return new CUDA_ARRAY_SPARSE_PROPERTIES(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CUDA_ARRAY_SPARSE_PROPERTIES create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CUDA_ARRAY_SPARSE_PROPERTIES(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CUDA_ARRAY_SPARSE_PROPERTIES create(long address) {
        return new CUDA_ARRAY_SPARSE_PROPERTIES(address, null);
    }

    public static @Nullable CUDA_ARRAY_SPARSE_PROPERTIES createSafe(long address) {
        return address == 0L ? null : new CUDA_ARRAY_SPARSE_PROPERTIES(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CUDA_ARRAY_SPARSE_PROPERTIES.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUDA_ARRAY_SPARSE_PROPERTIES.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUDA_ARRAY_SPARSE_PROPERTIES malloc(MemoryStack stack) {
        return new CUDA_ARRAY_SPARSE_PROPERTIES(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUDA_ARRAY_SPARSE_PROPERTIES calloc(MemoryStack stack) {
        return new CUDA_ARRAY_SPARSE_PROPERTIES(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntileExtent_width(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TILEEXTENT_WIDTH));
    }

    public static int ntileExtent_height(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TILEEXTENT_HEIGHT));
    }

    public static int ntileExtent_depth(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TILEEXTENT_DEPTH));
    }

    public static int nmiptailFirstLevel(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MIPTAILFIRSTLEVEL));
    }

    public static long nmiptailSize(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)MIPTAILSIZE));
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FLAGS));
    }

    public static IntBuffer nreserved(long struct) {
        return MemoryUtil.memIntBuffer((long)(struct + (long)RESERVED), (int)4);
    }

    public static int nreserved(long struct, int index) {
        return MemoryUtil.memGetInt((long)(struct + (long)RESERVED + Checks.check((int)index, (int)4) * 4L));
    }

    public static void ntileExtent_width(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TILEEXTENT_WIDTH), (int)value);
    }

    public static void ntileExtent_height(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TILEEXTENT_HEIGHT), (int)value);
    }

    public static void ntileExtent_depth(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TILEEXTENT_DEPTH), (int)value);
    }

    public static void nmiptailFirstLevel(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MIPTAILFIRSTLEVEL), (int)value);
    }

    public static void nmiptailSize(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)MIPTAILSIZE), (long)value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FLAGS), (int)value);
    }

    public static void nreserved(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)4);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((IntBuffer)value), (long)(struct + (long)RESERVED), (long)(value.remaining() * 4));
    }

    public static void nreserved(long struct, int index, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)RESERVED + Checks.check((int)index, (int)4) * 4L), (int)value);
    }

    static {
        Struct.Layout layout = CUDA_ARRAY_SPARSE_PROPERTIES.__struct((Struct.Member[])new Struct.Member[]{CUDA_ARRAY_SPARSE_PROPERTIES.__struct((Struct.Member[])new Struct.Member[]{CUDA_ARRAY_SPARSE_PROPERTIES.__member((int)4), CUDA_ARRAY_SPARSE_PROPERTIES.__member((int)4), CUDA_ARRAY_SPARSE_PROPERTIES.__member((int)4)}), CUDA_ARRAY_SPARSE_PROPERTIES.__member((int)4), CUDA_ARRAY_SPARSE_PROPERTIES.__member((int)8), CUDA_ARRAY_SPARSE_PROPERTIES.__member((int)4), CUDA_ARRAY_SPARSE_PROPERTIES.__array((int)4, (int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TILEEXTENT = layout.offsetof(0);
        TILEEXTENT_WIDTH = layout.offsetof(1);
        TILEEXTENT_HEIGHT = layout.offsetof(2);
        TILEEXTENT_DEPTH = layout.offsetof(3);
        MIPTAILFIRSTLEVEL = layout.offsetof(4);
        MIPTAILSIZE = layout.offsetof(5);
        FLAGS = layout.offsetof(6);
        RESERVED = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<CUDA_ARRAY_SPARSE_PROPERTIES, Buffer>
    implements NativeResource {
        private static final CUDA_ARRAY_SPARSE_PROPERTIES ELEMENT_FACTORY = CUDA_ARRAY_SPARSE_PROPERTIES.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected CUDA_ARRAY_SPARSE_PROPERTIES getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int tileExtent_width() {
            return CUDA_ARRAY_SPARSE_PROPERTIES.ntileExtent_width(this.address());
        }

        @NativeType(value="unsigned int")
        public int tileExtent_height() {
            return CUDA_ARRAY_SPARSE_PROPERTIES.ntileExtent_height(this.address());
        }

        @NativeType(value="unsigned int")
        public int tileExtent_depth() {
            return CUDA_ARRAY_SPARSE_PROPERTIES.ntileExtent_depth(this.address());
        }

        @NativeType(value="unsigned int")
        public int miptailFirstLevel() {
            return CUDA_ARRAY_SPARSE_PROPERTIES.nmiptailFirstLevel(this.address());
        }

        @NativeType(value="unsigned long long")
        public long miptailSize() {
            return CUDA_ARRAY_SPARSE_PROPERTIES.nmiptailSize(this.address());
        }

        @NativeType(value="unsigned int")
        public int flags() {
            return CUDA_ARRAY_SPARSE_PROPERTIES.nflags(this.address());
        }

        @NativeType(value="unsigned int[4]")
        public IntBuffer reserved() {
            return CUDA_ARRAY_SPARSE_PROPERTIES.nreserved(this.address());
        }

        @NativeType(value="unsigned int")
        public int reserved(int index) {
            return CUDA_ARRAY_SPARSE_PROPERTIES.nreserved(this.address(), index);
        }

        public Buffer tileExtent_width(@NativeType(value="unsigned int") int value) {
            CUDA_ARRAY_SPARSE_PROPERTIES.ntileExtent_width(this.address(), value);
            return this;
        }

        public Buffer tileExtent_height(@NativeType(value="unsigned int") int value) {
            CUDA_ARRAY_SPARSE_PROPERTIES.ntileExtent_height(this.address(), value);
            return this;
        }

        public Buffer tileExtent_depth(@NativeType(value="unsigned int") int value) {
            CUDA_ARRAY_SPARSE_PROPERTIES.ntileExtent_depth(this.address(), value);
            return this;
        }

        public Buffer miptailFirstLevel(@NativeType(value="unsigned int") int value) {
            CUDA_ARRAY_SPARSE_PROPERTIES.nmiptailFirstLevel(this.address(), value);
            return this;
        }

        public Buffer miptailSize(@NativeType(value="unsigned long long") long value) {
            CUDA_ARRAY_SPARSE_PROPERTIES.nmiptailSize(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="unsigned int") int value) {
            CUDA_ARRAY_SPARSE_PROPERTIES.nflags(this.address(), value);
            return this;
        }

        public Buffer reserved(@NativeType(value="unsigned int[4]") IntBuffer value) {
            CUDA_ARRAY_SPARSE_PROPERTIES.nreserved(this.address(), value);
            return this;
        }

        public Buffer reserved(int index, @NativeType(value="unsigned int") int value) {
            CUDA_ARRAY_SPARSE_PROPERTIES.nreserved(this.address(), index, value);
            return this;
        }
    }
}

