/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.cuda.CUstreamBatchMemOpParams;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUDA_BATCH_MEM_OP_NODE_PARAMS
extends Struct<CUDA_BATCH_MEM_OP_NODE_PARAMS>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CTX;
    public static final int COUNT;
    public static final int PARAMARRAY;
    public static final int FLAGS;

    protected CUDA_BATCH_MEM_OP_NODE_PARAMS(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CUDA_BATCH_MEM_OP_NODE_PARAMS create(long address, @Nullable ByteBuffer container) {
        return new CUDA_BATCH_MEM_OP_NODE_PARAMS(address, container);
    }

    public CUDA_BATCH_MEM_OP_NODE_PARAMS(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUDA_BATCH_MEM_OP_NODE_PARAMS.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CUcontext")
    public long ctx() {
        return CUDA_BATCH_MEM_OP_NODE_PARAMS.nctx(this.address());
    }

    @NativeType(value="unsigned int")
    public int count() {
        return CUDA_BATCH_MEM_OP_NODE_PARAMS.ncount(this.address());
    }

    @NativeType(value="CUstreamBatchMemOpParams *")
    public @Nullable CUstreamBatchMemOpParams.Buffer paramArray() {
        return CUDA_BATCH_MEM_OP_NODE_PARAMS.nparamArray(this.address());
    }

    @NativeType(value="unsigned int")
    public int flags() {
        return CUDA_BATCH_MEM_OP_NODE_PARAMS.nflags(this.address());
    }

    public CUDA_BATCH_MEM_OP_NODE_PARAMS ctx(@NativeType(value="CUcontext") long value) {
        CUDA_BATCH_MEM_OP_NODE_PARAMS.nctx(this.address(), value);
        return this;
    }

    public CUDA_BATCH_MEM_OP_NODE_PARAMS count(@NativeType(value="unsigned int") int value) {
        CUDA_BATCH_MEM_OP_NODE_PARAMS.ncount(this.address(), value);
        return this;
    }

    public CUDA_BATCH_MEM_OP_NODE_PARAMS paramArray(@NativeType(value="CUstreamBatchMemOpParams *") @Nullable CUstreamBatchMemOpParams.Buffer value) {
        CUDA_BATCH_MEM_OP_NODE_PARAMS.nparamArray(this.address(), value);
        return this;
    }

    public CUDA_BATCH_MEM_OP_NODE_PARAMS flags(@NativeType(value="unsigned int") int value) {
        CUDA_BATCH_MEM_OP_NODE_PARAMS.nflags(this.address(), value);
        return this;
    }

    public CUDA_BATCH_MEM_OP_NODE_PARAMS set(long ctx, int count, @Nullable CUstreamBatchMemOpParams.Buffer paramArray, int flags) {
        this.ctx(ctx);
        this.count(count);
        this.paramArray(paramArray);
        this.flags(flags);
        return this;
    }

    public CUDA_BATCH_MEM_OP_NODE_PARAMS set(CUDA_BATCH_MEM_OP_NODE_PARAMS src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUDA_BATCH_MEM_OP_NODE_PARAMS malloc() {
        return new CUDA_BATCH_MEM_OP_NODE_PARAMS(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CUDA_BATCH_MEM_OP_NODE_PARAMS calloc() {
        return new CUDA_BATCH_MEM_OP_NODE_PARAMS(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CUDA_BATCH_MEM_OP_NODE_PARAMS create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CUDA_BATCH_MEM_OP_NODE_PARAMS(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CUDA_BATCH_MEM_OP_NODE_PARAMS create(long address) {
        return new CUDA_BATCH_MEM_OP_NODE_PARAMS(address, null);
    }

    public static @Nullable CUDA_BATCH_MEM_OP_NODE_PARAMS createSafe(long address) {
        return address == 0L ? null : new CUDA_BATCH_MEM_OP_NODE_PARAMS(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CUDA_BATCH_MEM_OP_NODE_PARAMS.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUDA_BATCH_MEM_OP_NODE_PARAMS.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUDA_BATCH_MEM_OP_NODE_PARAMS malloc(MemoryStack stack) {
        return new CUDA_BATCH_MEM_OP_NODE_PARAMS(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUDA_BATCH_MEM_OP_NODE_PARAMS calloc(MemoryStack stack) {
        return new CUDA_BATCH_MEM_OP_NODE_PARAMS(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nctx(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)CTX));
    }

    public static int ncount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)COUNT));
    }

    public static @Nullable CUstreamBatchMemOpParams.Buffer nparamArray(long struct) {
        return CUstreamBatchMemOpParams.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PARAMARRAY)), CUDA_BATCH_MEM_OP_NODE_PARAMS.ncount(struct));
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FLAGS));
    }

    public static void nctx(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CTX), (long)Checks.check((long)value));
    }

    public static void ncount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)COUNT), (int)value);
    }

    public static void nparamArray(long struct, @Nullable CUstreamBatchMemOpParams.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PARAMARRAY), (long)MemoryUtil.memAddressSafe((Pointer)value));
        CUDA_BATCH_MEM_OP_NODE_PARAMS.ncount(struct, value == null ? 0 : value.remaining());
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FLAGS), (int)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)CTX)));
    }

    static {
        Struct.Layout layout = CUDA_BATCH_MEM_OP_NODE_PARAMS.__struct((Struct.Member[])new Struct.Member[]{CUDA_BATCH_MEM_OP_NODE_PARAMS.__member((int)POINTER_SIZE), CUDA_BATCH_MEM_OP_NODE_PARAMS.__member((int)4), CUDA_BATCH_MEM_OP_NODE_PARAMS.__member((int)POINTER_SIZE), CUDA_BATCH_MEM_OP_NODE_PARAMS.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CTX = layout.offsetof(0);
        COUNT = layout.offsetof(1);
        PARAMARRAY = layout.offsetof(2);
        FLAGS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<CUDA_BATCH_MEM_OP_NODE_PARAMS, Buffer>
    implements NativeResource {
        private static final CUDA_BATCH_MEM_OP_NODE_PARAMS ELEMENT_FACTORY = CUDA_BATCH_MEM_OP_NODE_PARAMS.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected CUDA_BATCH_MEM_OP_NODE_PARAMS getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CUcontext")
        public long ctx() {
            return CUDA_BATCH_MEM_OP_NODE_PARAMS.nctx(this.address());
        }

        @NativeType(value="unsigned int")
        public int count() {
            return CUDA_BATCH_MEM_OP_NODE_PARAMS.ncount(this.address());
        }

        @NativeType(value="CUstreamBatchMemOpParams *")
        public @Nullable CUstreamBatchMemOpParams.Buffer paramArray() {
            return CUDA_BATCH_MEM_OP_NODE_PARAMS.nparamArray(this.address());
        }

        @NativeType(value="unsigned int")
        public int flags() {
            return CUDA_BATCH_MEM_OP_NODE_PARAMS.nflags(this.address());
        }

        public Buffer ctx(@NativeType(value="CUcontext") long value) {
            CUDA_BATCH_MEM_OP_NODE_PARAMS.nctx(this.address(), value);
            return this;
        }

        public Buffer count(@NativeType(value="unsigned int") int value) {
            CUDA_BATCH_MEM_OP_NODE_PARAMS.ncount(this.address(), value);
            return this;
        }

        public Buffer paramArray(@NativeType(value="CUstreamBatchMemOpParams *") @Nullable CUstreamBatchMemOpParams.Buffer value) {
            CUDA_BATCH_MEM_OP_NODE_PARAMS.nparamArray(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="unsigned int") int value) {
            CUDA_BATCH_MEM_OP_NODE_PARAMS.nflags(this.address(), value);
            return this;
        }
    }
}

