/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUDA_CONDITIONAL_NODE_PARAMS
extends Struct<CUDA_CONDITIONAL_NODE_PARAMS>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HANDLE;
    public static final int TYPE;
    public static final int SIZE;
    public static final int PHGRAPH_OUT;
    public static final int CTX;

    protected CUDA_CONDITIONAL_NODE_PARAMS(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CUDA_CONDITIONAL_NODE_PARAMS create(long address, @Nullable ByteBuffer container) {
        return new CUDA_CONDITIONAL_NODE_PARAMS(address, container);
    }

    public CUDA_CONDITIONAL_NODE_PARAMS(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUDA_CONDITIONAL_NODE_PARAMS.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CUgraphConditionalHandle")
    public long handle() {
        return CUDA_CONDITIONAL_NODE_PARAMS.nhandle(this.address());
    }

    @NativeType(value="CUgraphConditionalNodeType")
    public int type() {
        return CUDA_CONDITIONAL_NODE_PARAMS.ntype(this.address());
    }

    @NativeType(value="unsigned int")
    public int size() {
        return CUDA_CONDITIONAL_NODE_PARAMS.nsize(this.address());
    }

    @NativeType(value="CUgraph *")
    public PointerBuffer phGraph_out() {
        return CUDA_CONDITIONAL_NODE_PARAMS.nphGraph_out(this.address());
    }

    @NativeType(value="CUcontext")
    public long ctx() {
        return CUDA_CONDITIONAL_NODE_PARAMS.nctx(this.address());
    }

    public CUDA_CONDITIONAL_NODE_PARAMS handle(@NativeType(value="CUgraphConditionalHandle") long value) {
        CUDA_CONDITIONAL_NODE_PARAMS.nhandle(this.address(), value);
        return this;
    }

    public CUDA_CONDITIONAL_NODE_PARAMS type(@NativeType(value="CUgraphConditionalNodeType") int value) {
        CUDA_CONDITIONAL_NODE_PARAMS.ntype(this.address(), value);
        return this;
    }

    public CUDA_CONDITIONAL_NODE_PARAMS size(@NativeType(value="unsigned int") int value) {
        CUDA_CONDITIONAL_NODE_PARAMS.nsize(this.address(), value);
        return this;
    }

    public CUDA_CONDITIONAL_NODE_PARAMS phGraph_out(@NativeType(value="CUgraph *") PointerBuffer value) {
        CUDA_CONDITIONAL_NODE_PARAMS.nphGraph_out(this.address(), value);
        return this;
    }

    public CUDA_CONDITIONAL_NODE_PARAMS ctx(@NativeType(value="CUcontext") long value) {
        CUDA_CONDITIONAL_NODE_PARAMS.nctx(this.address(), value);
        return this;
    }

    public CUDA_CONDITIONAL_NODE_PARAMS set(long handle, int type, int size, PointerBuffer phGraph_out, long ctx) {
        this.handle(handle);
        this.type(type);
        this.size(size);
        this.phGraph_out(phGraph_out);
        this.ctx(ctx);
        return this;
    }

    public CUDA_CONDITIONAL_NODE_PARAMS set(CUDA_CONDITIONAL_NODE_PARAMS src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUDA_CONDITIONAL_NODE_PARAMS malloc() {
        return new CUDA_CONDITIONAL_NODE_PARAMS(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CUDA_CONDITIONAL_NODE_PARAMS calloc() {
        return new CUDA_CONDITIONAL_NODE_PARAMS(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CUDA_CONDITIONAL_NODE_PARAMS create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CUDA_CONDITIONAL_NODE_PARAMS(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CUDA_CONDITIONAL_NODE_PARAMS create(long address) {
        return new CUDA_CONDITIONAL_NODE_PARAMS(address, null);
    }

    public static @Nullable CUDA_CONDITIONAL_NODE_PARAMS createSafe(long address) {
        return address == 0L ? null : new CUDA_CONDITIONAL_NODE_PARAMS(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CUDA_CONDITIONAL_NODE_PARAMS.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUDA_CONDITIONAL_NODE_PARAMS.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUDA_CONDITIONAL_NODE_PARAMS malloc(MemoryStack stack) {
        return new CUDA_CONDITIONAL_NODE_PARAMS(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUDA_CONDITIONAL_NODE_PARAMS calloc(MemoryStack stack) {
        return new CUDA_CONDITIONAL_NODE_PARAMS(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nhandle(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)HANDLE));
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static int nsize(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SIZE));
    }

    public static PointerBuffer nphGraph_out(long struct) {
        return MemoryUtil.memPointerBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PHGRAPH_OUT)), (int)1);
    }

    public static long nctx(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)CTX));
    }

    public static void nhandle(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)HANDLE), (long)value);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nsize(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SIZE), (int)value);
    }

    public static void nphGraph_out(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PHGRAPH_OUT), (long)MemoryUtil.memAddress((CustomBuffer)value));
    }

    public static void nctx(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CTX), (long)Checks.check((long)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PHGRAPH_OUT)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)CTX)));
    }

    static {
        Struct.Layout layout = CUDA_CONDITIONAL_NODE_PARAMS.__struct((Struct.Member[])new Struct.Member[]{CUDA_CONDITIONAL_NODE_PARAMS.__member((int)8), CUDA_CONDITIONAL_NODE_PARAMS.__member((int)4), CUDA_CONDITIONAL_NODE_PARAMS.__member((int)4), CUDA_CONDITIONAL_NODE_PARAMS.__member((int)POINTER_SIZE), CUDA_CONDITIONAL_NODE_PARAMS.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HANDLE = layout.offsetof(0);
        TYPE = layout.offsetof(1);
        SIZE = layout.offsetof(2);
        PHGRAPH_OUT = layout.offsetof(3);
        CTX = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<CUDA_CONDITIONAL_NODE_PARAMS, Buffer>
    implements NativeResource {
        private static final CUDA_CONDITIONAL_NODE_PARAMS ELEMENT_FACTORY = CUDA_CONDITIONAL_NODE_PARAMS.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected CUDA_CONDITIONAL_NODE_PARAMS getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CUgraphConditionalHandle")
        public long handle() {
            return CUDA_CONDITIONAL_NODE_PARAMS.nhandle(this.address());
        }

        @NativeType(value="CUgraphConditionalNodeType")
        public int type() {
            return CUDA_CONDITIONAL_NODE_PARAMS.ntype(this.address());
        }

        @NativeType(value="unsigned int")
        public int size() {
            return CUDA_CONDITIONAL_NODE_PARAMS.nsize(this.address());
        }

        @NativeType(value="CUgraph *")
        public PointerBuffer phGraph_out() {
            return CUDA_CONDITIONAL_NODE_PARAMS.nphGraph_out(this.address());
        }

        @NativeType(value="CUcontext")
        public long ctx() {
            return CUDA_CONDITIONAL_NODE_PARAMS.nctx(this.address());
        }

        public Buffer handle(@NativeType(value="CUgraphConditionalHandle") long value) {
            CUDA_CONDITIONAL_NODE_PARAMS.nhandle(this.address(), value);
            return this;
        }

        public Buffer type(@NativeType(value="CUgraphConditionalNodeType") int value) {
            CUDA_CONDITIONAL_NODE_PARAMS.ntype(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="unsigned int") int value) {
            CUDA_CONDITIONAL_NODE_PARAMS.nsize(this.address(), value);
            return this;
        }

        public Buffer phGraph_out(@NativeType(value="CUgraph *") PointerBuffer value) {
            CUDA_CONDITIONAL_NODE_PARAMS.nphGraph_out(this.address(), value);
            return this;
        }

        public Buffer ctx(@NativeType(value="CUcontext") long value) {
            CUDA_CONDITIONAL_NODE_PARAMS.nctx(this.address(), value);
            return this;
        }
    }
}

