/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.cuda.CUhostFn;
import org.lwjgl.cuda.CUhostFnI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUDA_HOST_NODE_PARAMS_v2
extends Struct<CUDA_HOST_NODE_PARAMS_v2>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FN;
    public static final int USERDATA;

    protected CUDA_HOST_NODE_PARAMS_v2(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CUDA_HOST_NODE_PARAMS_v2 create(long address, @Nullable ByteBuffer container) {
        return new CUDA_HOST_NODE_PARAMS_v2(address, container);
    }

    public CUDA_HOST_NODE_PARAMS_v2(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUDA_HOST_NODE_PARAMS_v2.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void (*) (void *)")
    public CUhostFn fn() {
        return CUDA_HOST_NODE_PARAMS_v2.nfn(this.address());
    }

    @NativeType(value="void *")
    public long userData() {
        return CUDA_HOST_NODE_PARAMS_v2.nuserData(this.address());
    }

    public CUDA_HOST_NODE_PARAMS_v2 fn(@NativeType(value="void (*) (void *)") CUhostFnI value) {
        CUDA_HOST_NODE_PARAMS_v2.nfn(this.address(), value);
        return this;
    }

    public CUDA_HOST_NODE_PARAMS_v2 userData(@NativeType(value="void *") long value) {
        CUDA_HOST_NODE_PARAMS_v2.nuserData(this.address(), value);
        return this;
    }

    public CUDA_HOST_NODE_PARAMS_v2 set(CUhostFnI fn, long userData) {
        this.fn(fn);
        this.userData(userData);
        return this;
    }

    public CUDA_HOST_NODE_PARAMS_v2 set(CUDA_HOST_NODE_PARAMS_v2 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUDA_HOST_NODE_PARAMS_v2 malloc() {
        return new CUDA_HOST_NODE_PARAMS_v2(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CUDA_HOST_NODE_PARAMS_v2 calloc() {
        return new CUDA_HOST_NODE_PARAMS_v2(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CUDA_HOST_NODE_PARAMS_v2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CUDA_HOST_NODE_PARAMS_v2(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CUDA_HOST_NODE_PARAMS_v2 create(long address) {
        return new CUDA_HOST_NODE_PARAMS_v2(address, null);
    }

    public static @Nullable CUDA_HOST_NODE_PARAMS_v2 createSafe(long address) {
        return address == 0L ? null : new CUDA_HOST_NODE_PARAMS_v2(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CUDA_HOST_NODE_PARAMS_v2.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUDA_HOST_NODE_PARAMS_v2.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUDA_HOST_NODE_PARAMS_v2 malloc(MemoryStack stack) {
        return new CUDA_HOST_NODE_PARAMS_v2(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUDA_HOST_NODE_PARAMS_v2 calloc(MemoryStack stack) {
        return new CUDA_HOST_NODE_PARAMS_v2(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static CUhostFn nfn(long struct) {
        return CUhostFn.create(MemoryUtil.memGetAddress((long)(struct + (long)FN)));
    }

    public static long nuserData(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)USERDATA));
    }

    public static void nfn(long struct, CUhostFnI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)FN), (long)value.address());
    }

    public static void nuserData(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)USERDATA), (long)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)FN)));
    }

    static {
        Struct.Layout layout = CUDA_HOST_NODE_PARAMS_v2.__struct((Struct.Member[])new Struct.Member[]{CUDA_HOST_NODE_PARAMS_v2.__member((int)POINTER_SIZE), CUDA_HOST_NODE_PARAMS_v2.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FN = layout.offsetof(0);
        USERDATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CUDA_HOST_NODE_PARAMS_v2, Buffer>
    implements NativeResource {
        private static final CUDA_HOST_NODE_PARAMS_v2 ELEMENT_FACTORY = CUDA_HOST_NODE_PARAMS_v2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected CUDA_HOST_NODE_PARAMS_v2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void (*) (void *)")
        public CUhostFn fn() {
            return CUDA_HOST_NODE_PARAMS_v2.nfn(this.address());
        }

        @NativeType(value="void *")
        public long userData() {
            return CUDA_HOST_NODE_PARAMS_v2.nuserData(this.address());
        }

        public Buffer fn(@NativeType(value="void (*) (void *)") CUhostFnI value) {
            CUDA_HOST_NODE_PARAMS_v2.nfn(this.address(), value);
            return this;
        }

        public Buffer userData(@NativeType(value="void *") long value) {
            CUDA_HOST_NODE_PARAMS_v2.nuserData(this.address(), value);
            return this;
        }
    }
}

