/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.cuda.CUDA_MEMCPY3D;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUDA_MEMCPY_NODE_PARAMS
extends Struct<CUDA_MEMCPY_NODE_PARAMS>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int RESERVED;
    public static final int COPYCTX;
    public static final int COPYPARAMS;

    protected CUDA_MEMCPY_NODE_PARAMS(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CUDA_MEMCPY_NODE_PARAMS create(long address, @Nullable ByteBuffer container) {
        return new CUDA_MEMCPY_NODE_PARAMS(address, container);
    }

    public CUDA_MEMCPY_NODE_PARAMS(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUDA_MEMCPY_NODE_PARAMS.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int flags() {
        return CUDA_MEMCPY_NODE_PARAMS.nflags(this.address());
    }

    public int reserved() {
        return CUDA_MEMCPY_NODE_PARAMS.nreserved(this.address());
    }

    @NativeType(value="CUcontext")
    public long copyCtx() {
        return CUDA_MEMCPY_NODE_PARAMS.ncopyCtx(this.address());
    }

    public CUDA_MEMCPY3D copyParams() {
        return CUDA_MEMCPY_NODE_PARAMS.ncopyParams(this.address());
    }

    public CUDA_MEMCPY_NODE_PARAMS flags(int value) {
        CUDA_MEMCPY_NODE_PARAMS.nflags(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY_NODE_PARAMS reserved(int value) {
        CUDA_MEMCPY_NODE_PARAMS.nreserved(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY_NODE_PARAMS copyCtx(@NativeType(value="CUcontext") long value) {
        CUDA_MEMCPY_NODE_PARAMS.ncopyCtx(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY_NODE_PARAMS copyParams(CUDA_MEMCPY3D value) {
        CUDA_MEMCPY_NODE_PARAMS.ncopyParams(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY_NODE_PARAMS copyParams(Consumer<CUDA_MEMCPY3D> consumer) {
        consumer.accept(this.copyParams());
        return this;
    }

    public CUDA_MEMCPY_NODE_PARAMS set(int flags, int reserved, long copyCtx, CUDA_MEMCPY3D copyParams) {
        this.flags(flags);
        this.reserved(reserved);
        this.copyCtx(copyCtx);
        this.copyParams(copyParams);
        return this;
    }

    public CUDA_MEMCPY_NODE_PARAMS set(CUDA_MEMCPY_NODE_PARAMS src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUDA_MEMCPY_NODE_PARAMS malloc() {
        return new CUDA_MEMCPY_NODE_PARAMS(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CUDA_MEMCPY_NODE_PARAMS calloc() {
        return new CUDA_MEMCPY_NODE_PARAMS(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CUDA_MEMCPY_NODE_PARAMS create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CUDA_MEMCPY_NODE_PARAMS(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CUDA_MEMCPY_NODE_PARAMS create(long address) {
        return new CUDA_MEMCPY_NODE_PARAMS(address, null);
    }

    public static @Nullable CUDA_MEMCPY_NODE_PARAMS createSafe(long address) {
        return address == 0L ? null : new CUDA_MEMCPY_NODE_PARAMS(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CUDA_MEMCPY_NODE_PARAMS.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUDA_MEMCPY_NODE_PARAMS.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUDA_MEMCPY_NODE_PARAMS malloc(MemoryStack stack) {
        return new CUDA_MEMCPY_NODE_PARAMS(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUDA_MEMCPY_NODE_PARAMS calloc(MemoryStack stack) {
        return new CUDA_MEMCPY_NODE_PARAMS(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FLAGS));
    }

    public static int nreserved(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)RESERVED));
    }

    public static long ncopyCtx(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)COPYCTX));
    }

    public static CUDA_MEMCPY3D ncopyParams(long struct) {
        return CUDA_MEMCPY3D.create(struct + (long)COPYPARAMS);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FLAGS), (int)value);
    }

    public static void nreserved(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)RESERVED), (int)value);
    }

    public static void ncopyCtx(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)COPYCTX), (long)Checks.check((long)value));
    }

    public static void ncopyParams(long struct, CUDA_MEMCPY3D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)COPYPARAMS), (long)CUDA_MEMCPY3D.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)COPYCTX)));
    }

    static {
        Struct.Layout layout = CUDA_MEMCPY_NODE_PARAMS.__struct((Struct.Member[])new Struct.Member[]{CUDA_MEMCPY_NODE_PARAMS.__member((int)4), CUDA_MEMCPY_NODE_PARAMS.__member((int)4), CUDA_MEMCPY_NODE_PARAMS.__member((int)POINTER_SIZE), CUDA_MEMCPY_NODE_PARAMS.__member((int)CUDA_MEMCPY3D.SIZEOF, (int)CUDA_MEMCPY3D.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        RESERVED = layout.offsetof(1);
        COPYCTX = layout.offsetof(2);
        COPYPARAMS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<CUDA_MEMCPY_NODE_PARAMS, Buffer>
    implements NativeResource {
        private static final CUDA_MEMCPY_NODE_PARAMS ELEMENT_FACTORY = CUDA_MEMCPY_NODE_PARAMS.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected CUDA_MEMCPY_NODE_PARAMS getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int flags() {
            return CUDA_MEMCPY_NODE_PARAMS.nflags(this.address());
        }

        public int reserved() {
            return CUDA_MEMCPY_NODE_PARAMS.nreserved(this.address());
        }

        @NativeType(value="CUcontext")
        public long copyCtx() {
            return CUDA_MEMCPY_NODE_PARAMS.ncopyCtx(this.address());
        }

        public CUDA_MEMCPY3D copyParams() {
            return CUDA_MEMCPY_NODE_PARAMS.ncopyParams(this.address());
        }

        public Buffer flags(int value) {
            CUDA_MEMCPY_NODE_PARAMS.nflags(this.address(), value);
            return this;
        }

        public Buffer reserved(int value) {
            CUDA_MEMCPY_NODE_PARAMS.nreserved(this.address(), value);
            return this;
        }

        public Buffer copyCtx(@NativeType(value="CUcontext") long value) {
            CUDA_MEMCPY_NODE_PARAMS.ncopyCtx(this.address(), value);
            return this;
        }

        public Buffer copyParams(CUDA_MEMCPY3D value) {
            CUDA_MEMCPY_NODE_PARAMS.ncopyParams(this.address(), value);
            return this;
        }

        public Buffer copyParams(Consumer<CUDA_MEMCPY3D> consumer) {
            consumer.accept(this.copyParams());
            return this;
        }
    }
}

