/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.cuda.CUdevSmResource;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUdevResource
extends Struct<CUdevResource>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int _INTERNAL_PADDING;
    public static final int RESOURCE;
    public static final int RESOURCE_SM;
    public static final int RESOURCE__OVERSIZE;

    protected CUdevResource(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CUdevResource create(long address, @Nullable ByteBuffer container) {
        return new CUdevResource(address, container);
    }

    public CUdevResource(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUdevResource.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CUdevResourceType")
    public int type() {
        return CUdevResource.ntype(this.address());
    }

    public CUdevSmResource resource_sm() {
        return CUdevResource.nresource_sm(this.address());
    }

    @NativeType(value="unsigned char[48]")
    public ByteBuffer resource__oversize() {
        return CUdevResource.nresource__oversize(this.address());
    }

    @NativeType(value="unsigned char")
    public byte resource__oversize(int index) {
        return CUdevResource.nresource__oversize(this.address(), index);
    }

    public static CUdevResource malloc() {
        return new CUdevResource(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CUdevResource calloc() {
        return new CUdevResource(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CUdevResource create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CUdevResource(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CUdevResource create(long address) {
        return new CUdevResource(address, null);
    }

    public static @Nullable CUdevResource createSafe(long address) {
        return address == 0L ? null : new CUdevResource(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CUdevResource.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUdevResource.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUdevResource malloc(MemoryStack stack) {
        return new CUdevResource(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUdevResource calloc(MemoryStack stack) {
        return new CUdevResource(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static ByteBuffer n_internal_padding(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)_INTERNAL_PADDING), (int)92);
    }

    public static byte n_internal_padding(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)_INTERNAL_PADDING + Checks.check((int)index, (int)92) * 1L));
    }

    public static CUdevSmResource nresource_sm(long struct) {
        return CUdevSmResource.create(struct + (long)RESOURCE_SM);
    }

    public static ByteBuffer nresource__oversize(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)RESOURCE__OVERSIZE), (int)48);
    }

    public static byte nresource__oversize(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)RESOURCE__OVERSIZE + Checks.check((int)index, (int)48) * 1L));
    }

    static {
        Struct.Layout layout = CUdevResource.__struct((Struct.Member[])new Struct.Member[]{CUdevResource.__member((int)4), CUdevResource.__array((int)1, (int)92), CUdevResource.__union((Struct.Member[])new Struct.Member[]{CUdevResource.__member((int)CUdevSmResource.SIZEOF, (int)CUdevSmResource.ALIGNOF), CUdevResource.__array((int)1, (int)48)})});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        _INTERNAL_PADDING = layout.offsetof(1);
        RESOURCE = layout.offsetof(2);
        RESOURCE_SM = layout.offsetof(3);
        RESOURCE__OVERSIZE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<CUdevResource, Buffer>
    implements NativeResource {
        private static final CUdevResource ELEMENT_FACTORY = CUdevResource.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected CUdevResource getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CUdevResourceType")
        public int type() {
            return CUdevResource.ntype(this.address());
        }

        public CUdevSmResource resource_sm() {
            return CUdevResource.nresource_sm(this.address());
        }

        @NativeType(value="unsigned char[48]")
        public ByteBuffer resource__oversize() {
            return CUdevResource.nresource__oversize(this.address());
        }

        @NativeType(value="unsigned char")
        public byte resource__oversize(int index) {
            return CUdevResource.nresource__oversize(this.address(), index);
        }
    }
}

