/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.cuda.CUaccessPolicyWindow;
import org.lwjgl.cuda.CUlaunchMemSyncDomainMap;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUlaunchAttributeValue
extends Struct<CUlaunchAttributeValue>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PAD;
    public static final int ACCESSPOLICYWINDOW;
    public static final int COOPERATIVE;
    public static final int SYNCPOLICY;
    public static final int CLUSTERDIM;
    public static final int CLUSTERDIM_X;
    public static final int CLUSTERDIM_Y;
    public static final int CLUSTERDIM_Z;
    public static final int CLUSTERSCHEDULINGPOLICYPREFERENCE;
    public static final int PROGRAMMATICSTREAMSERIALIZATIONALLOWED;
    public static final int PROGRAMMATICEVENT;
    public static final int PROGRAMMATICEVENT_EVENT;
    public static final int PROGRAMMATICEVENT_FLAGS;
    public static final int PROGRAMMATICEVENT_TRIGGERATBLOCKSTART;
    public static final int PRIORITY;
    public static final int MEMSYNCDOMAINMAP;
    public static final int MEMSYNCDOMAIN;

    protected CUlaunchAttributeValue(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CUlaunchAttributeValue create(long address, @Nullable ByteBuffer container) {
        return new CUlaunchAttributeValue(address, container);
    }

    public CUlaunchAttributeValue(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUlaunchAttributeValue.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[64]")
    public ByteBuffer pad() {
        return CUlaunchAttributeValue.npad(this.address());
    }

    @NativeType(value="char")
    public byte pad(int index) {
        return CUlaunchAttributeValue.npad(this.address(), index);
    }

    public CUaccessPolicyWindow accessPolicyWindow() {
        return CUlaunchAttributeValue.naccessPolicyWindow(this.address());
    }

    public int cooperative() {
        return CUlaunchAttributeValue.ncooperative(this.address());
    }

    @NativeType(value="CUsynchronizationPolicy")
    public int syncPolicy() {
        return CUlaunchAttributeValue.nsyncPolicy(this.address());
    }

    @NativeType(value="unsigned int")
    public int clusterDim_x() {
        return CUlaunchAttributeValue.nclusterDim_x(this.address());
    }

    @NativeType(value="unsigned int")
    public int clusterDim_y() {
        return CUlaunchAttributeValue.nclusterDim_y(this.address());
    }

    @NativeType(value="unsigned int")
    public int clusterDim_z() {
        return CUlaunchAttributeValue.nclusterDim_z(this.address());
    }

    @NativeType(value="CUclusterSchedulingPolicy")
    public int clusterSchedulingPolicyPreference() {
        return CUlaunchAttributeValue.nclusterSchedulingPolicyPreference(this.address());
    }

    public int programmaticStreamSerializationAllowed() {
        return CUlaunchAttributeValue.nprogrammaticStreamSerializationAllowed(this.address());
    }

    @NativeType(value="CUevent")
    public long programmaticEvent_event() {
        return CUlaunchAttributeValue.nprogrammaticEvent_event(this.address());
    }

    public int programmaticEvent_flags() {
        return CUlaunchAttributeValue.nprogrammaticEvent_flags(this.address());
    }

    public int programmaticEvent_triggerAtBlockStart() {
        return CUlaunchAttributeValue.nprogrammaticEvent_triggerAtBlockStart(this.address());
    }

    public int priority() {
        return CUlaunchAttributeValue.npriority(this.address());
    }

    public CUlaunchMemSyncDomainMap memSyncDomainMap() {
        return CUlaunchAttributeValue.nmemSyncDomainMap(this.address());
    }

    @NativeType(value="CUlaunchMemSyncDomain")
    public int memSyncDomain() {
        return CUlaunchAttributeValue.nmemSyncDomain(this.address());
    }

    public CUlaunchAttributeValue pad(@NativeType(value="char[64]") ByteBuffer value) {
        CUlaunchAttributeValue.npad(this.address(), value);
        return this;
    }

    public CUlaunchAttributeValue pad(int index, @NativeType(value="char") byte value) {
        CUlaunchAttributeValue.npad(this.address(), index, value);
        return this;
    }

    public CUlaunchAttributeValue accessPolicyWindow(CUaccessPolicyWindow value) {
        CUlaunchAttributeValue.naccessPolicyWindow(this.address(), value);
        return this;
    }

    public CUlaunchAttributeValue accessPolicyWindow(Consumer<CUaccessPolicyWindow> consumer) {
        consumer.accept(this.accessPolicyWindow());
        return this;
    }

    public CUlaunchAttributeValue cooperative(int value) {
        CUlaunchAttributeValue.ncooperative(this.address(), value);
        return this;
    }

    public CUlaunchAttributeValue syncPolicy(@NativeType(value="CUsynchronizationPolicy") int value) {
        CUlaunchAttributeValue.nsyncPolicy(this.address(), value);
        return this;
    }

    public CUlaunchAttributeValue clusterDim_x(@NativeType(value="unsigned int") int value) {
        CUlaunchAttributeValue.nclusterDim_x(this.address(), value);
        return this;
    }

    public CUlaunchAttributeValue clusterDim_y(@NativeType(value="unsigned int") int value) {
        CUlaunchAttributeValue.nclusterDim_y(this.address(), value);
        return this;
    }

    public CUlaunchAttributeValue clusterDim_z(@NativeType(value="unsigned int") int value) {
        CUlaunchAttributeValue.nclusterDim_z(this.address(), value);
        return this;
    }

    public CUlaunchAttributeValue clusterSchedulingPolicyPreference(@NativeType(value="CUclusterSchedulingPolicy") int value) {
        CUlaunchAttributeValue.nclusterSchedulingPolicyPreference(this.address(), value);
        return this;
    }

    public CUlaunchAttributeValue programmaticStreamSerializationAllowed(int value) {
        CUlaunchAttributeValue.nprogrammaticStreamSerializationAllowed(this.address(), value);
        return this;
    }

    public CUlaunchAttributeValue programmaticEvent_event(@NativeType(value="CUevent") long value) {
        CUlaunchAttributeValue.nprogrammaticEvent_event(this.address(), value);
        return this;
    }

    public CUlaunchAttributeValue programmaticEvent_flags(int value) {
        CUlaunchAttributeValue.nprogrammaticEvent_flags(this.address(), value);
        return this;
    }

    public CUlaunchAttributeValue programmaticEvent_triggerAtBlockStart(int value) {
        CUlaunchAttributeValue.nprogrammaticEvent_triggerAtBlockStart(this.address(), value);
        return this;
    }

    public CUlaunchAttributeValue priority(int value) {
        CUlaunchAttributeValue.npriority(this.address(), value);
        return this;
    }

    public CUlaunchAttributeValue memSyncDomainMap(CUlaunchMemSyncDomainMap value) {
        CUlaunchAttributeValue.nmemSyncDomainMap(this.address(), value);
        return this;
    }

    public CUlaunchAttributeValue memSyncDomainMap(Consumer<CUlaunchMemSyncDomainMap> consumer) {
        consumer.accept(this.memSyncDomainMap());
        return this;
    }

    public CUlaunchAttributeValue memSyncDomain(@NativeType(value="CUlaunchMemSyncDomain") int value) {
        CUlaunchAttributeValue.nmemSyncDomain(this.address(), value);
        return this;
    }

    public CUlaunchAttributeValue set(CUlaunchAttributeValue src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUlaunchAttributeValue malloc() {
        return new CUlaunchAttributeValue(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CUlaunchAttributeValue calloc() {
        return new CUlaunchAttributeValue(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CUlaunchAttributeValue create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CUlaunchAttributeValue(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CUlaunchAttributeValue create(long address) {
        return new CUlaunchAttributeValue(address, null);
    }

    public static @Nullable CUlaunchAttributeValue createSafe(long address) {
        return address == 0L ? null : new CUlaunchAttributeValue(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CUlaunchAttributeValue.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUlaunchAttributeValue.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUlaunchAttributeValue malloc(MemoryStack stack) {
        return new CUlaunchAttributeValue(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUlaunchAttributeValue calloc(MemoryStack stack) {
        return new CUlaunchAttributeValue(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer npad(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)PAD), (int)64);
    }

    public static byte npad(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)PAD + Checks.check((int)index, (int)64) * 1L));
    }

    public static CUaccessPolicyWindow naccessPolicyWindow(long struct) {
        return CUaccessPolicyWindow.create(struct + (long)ACCESSPOLICYWINDOW);
    }

    public static int ncooperative(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)COOPERATIVE));
    }

    public static int nsyncPolicy(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SYNCPOLICY));
    }

    public static int nclusterDim_x(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)CLUSTERDIM_X));
    }

    public static int nclusterDim_y(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)CLUSTERDIM_Y));
    }

    public static int nclusterDim_z(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)CLUSTERDIM_Z));
    }

    public static int nclusterSchedulingPolicyPreference(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)CLUSTERSCHEDULINGPOLICYPREFERENCE));
    }

    public static int nprogrammaticStreamSerializationAllowed(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PROGRAMMATICSTREAMSERIALIZATIONALLOWED));
    }

    public static long nprogrammaticEvent_event(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PROGRAMMATICEVENT_EVENT));
    }

    public static int nprogrammaticEvent_flags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PROGRAMMATICEVENT_FLAGS));
    }

    public static int nprogrammaticEvent_triggerAtBlockStart(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PROGRAMMATICEVENT_TRIGGERATBLOCKSTART));
    }

    public static int npriority(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PRIORITY));
    }

    public static CUlaunchMemSyncDomainMap nmemSyncDomainMap(long struct) {
        return CUlaunchMemSyncDomainMap.create(struct + (long)MEMSYNCDOMAINMAP);
    }

    public static int nmemSyncDomain(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MEMSYNCDOMAIN));
    }

    public static void npad(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)64);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)PAD), (long)(value.remaining() * 1));
    }

    public static void npad(long struct, int index, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)PAD + Checks.check((int)index, (int)64) * 1L), (byte)value);
    }

    public static void naccessPolicyWindow(long struct, CUaccessPolicyWindow value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)ACCESSPOLICYWINDOW), (long)CUaccessPolicyWindow.SIZEOF);
    }

    public static void ncooperative(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)COOPERATIVE), (int)value);
    }

    public static void nsyncPolicy(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SYNCPOLICY), (int)value);
    }

    public static void nclusterDim_x(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)CLUSTERDIM_X), (int)value);
    }

    public static void nclusterDim_y(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)CLUSTERDIM_Y), (int)value);
    }

    public static void nclusterDim_z(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)CLUSTERDIM_Z), (int)value);
    }

    public static void nclusterSchedulingPolicyPreference(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)CLUSTERSCHEDULINGPOLICYPREFERENCE), (int)value);
    }

    public static void nprogrammaticStreamSerializationAllowed(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)PROGRAMMATICSTREAMSERIALIZATIONALLOWED), (int)value);
    }

    public static void nprogrammaticEvent_event(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PROGRAMMATICEVENT_EVENT), (long)Checks.check((long)value));
    }

    public static void nprogrammaticEvent_flags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)PROGRAMMATICEVENT_FLAGS), (int)value);
    }

    public static void nprogrammaticEvent_triggerAtBlockStart(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)PROGRAMMATICEVENT_TRIGGERATBLOCKSTART), (int)value);
    }

    public static void npriority(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)PRIORITY), (int)value);
    }

    public static void nmemSyncDomainMap(long struct, CUlaunchMemSyncDomainMap value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MEMSYNCDOMAINMAP), (long)CUlaunchMemSyncDomainMap.SIZEOF);
    }

    public static void nmemSyncDomain(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MEMSYNCDOMAIN), (int)value);
    }

    static {
        Struct.Layout layout = CUlaunchAttributeValue.__union((Struct.Member[])new Struct.Member[]{CUlaunchAttributeValue.__array((int)1, (int)64), CUlaunchAttributeValue.__member((int)CUaccessPolicyWindow.SIZEOF, (int)CUaccessPolicyWindow.ALIGNOF), CUlaunchAttributeValue.__member((int)4), CUlaunchAttributeValue.__member((int)4), CUlaunchAttributeValue.__struct((Struct.Member[])new Struct.Member[]{CUlaunchAttributeValue.__member((int)4), CUlaunchAttributeValue.__member((int)4), CUlaunchAttributeValue.__member((int)4)}), CUlaunchAttributeValue.__member((int)4), CUlaunchAttributeValue.__member((int)4), CUlaunchAttributeValue.__struct((Struct.Member[])new Struct.Member[]{CUlaunchAttributeValue.__member((int)POINTER_SIZE), CUlaunchAttributeValue.__member((int)4), CUlaunchAttributeValue.__member((int)4)}), CUlaunchAttributeValue.__member((int)4), CUlaunchAttributeValue.__member((int)CUlaunchMemSyncDomainMap.SIZEOF, (int)CUlaunchMemSyncDomainMap.ALIGNOF), CUlaunchAttributeValue.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PAD = layout.offsetof(0);
        ACCESSPOLICYWINDOW = layout.offsetof(1);
        COOPERATIVE = layout.offsetof(2);
        SYNCPOLICY = layout.offsetof(3);
        CLUSTERDIM = layout.offsetof(4);
        CLUSTERDIM_X = layout.offsetof(5);
        CLUSTERDIM_Y = layout.offsetof(6);
        CLUSTERDIM_Z = layout.offsetof(7);
        CLUSTERSCHEDULINGPOLICYPREFERENCE = layout.offsetof(8);
        PROGRAMMATICSTREAMSERIALIZATIONALLOWED = layout.offsetof(9);
        PROGRAMMATICEVENT = layout.offsetof(10);
        PROGRAMMATICEVENT_EVENT = layout.offsetof(11);
        PROGRAMMATICEVENT_FLAGS = layout.offsetof(12);
        PROGRAMMATICEVENT_TRIGGERATBLOCKSTART = layout.offsetof(13);
        PRIORITY = layout.offsetof(14);
        MEMSYNCDOMAINMAP = layout.offsetof(15);
        MEMSYNCDOMAIN = layout.offsetof(16);
    }

    public static class Buffer
    extends StructBuffer<CUlaunchAttributeValue, Buffer>
    implements NativeResource {
        private static final CUlaunchAttributeValue ELEMENT_FACTORY = CUlaunchAttributeValue.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected CUlaunchAttributeValue getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char[64]")
        public ByteBuffer pad() {
            return CUlaunchAttributeValue.npad(this.address());
        }

        @NativeType(value="char")
        public byte pad(int index) {
            return CUlaunchAttributeValue.npad(this.address(), index);
        }

        public CUaccessPolicyWindow accessPolicyWindow() {
            return CUlaunchAttributeValue.naccessPolicyWindow(this.address());
        }

        public int cooperative() {
            return CUlaunchAttributeValue.ncooperative(this.address());
        }

        @NativeType(value="CUsynchronizationPolicy")
        public int syncPolicy() {
            return CUlaunchAttributeValue.nsyncPolicy(this.address());
        }

        @NativeType(value="unsigned int")
        public int clusterDim_x() {
            return CUlaunchAttributeValue.nclusterDim_x(this.address());
        }

        @NativeType(value="unsigned int")
        public int clusterDim_y() {
            return CUlaunchAttributeValue.nclusterDim_y(this.address());
        }

        @NativeType(value="unsigned int")
        public int clusterDim_z() {
            return CUlaunchAttributeValue.nclusterDim_z(this.address());
        }

        @NativeType(value="CUclusterSchedulingPolicy")
        public int clusterSchedulingPolicyPreference() {
            return CUlaunchAttributeValue.nclusterSchedulingPolicyPreference(this.address());
        }

        public int programmaticStreamSerializationAllowed() {
            return CUlaunchAttributeValue.nprogrammaticStreamSerializationAllowed(this.address());
        }

        @NativeType(value="CUevent")
        public long programmaticEvent_event() {
            return CUlaunchAttributeValue.nprogrammaticEvent_event(this.address());
        }

        public int programmaticEvent_flags() {
            return CUlaunchAttributeValue.nprogrammaticEvent_flags(this.address());
        }

        public int programmaticEvent_triggerAtBlockStart() {
            return CUlaunchAttributeValue.nprogrammaticEvent_triggerAtBlockStart(this.address());
        }

        public int priority() {
            return CUlaunchAttributeValue.npriority(this.address());
        }

        public CUlaunchMemSyncDomainMap memSyncDomainMap() {
            return CUlaunchAttributeValue.nmemSyncDomainMap(this.address());
        }

        @NativeType(value="CUlaunchMemSyncDomain")
        public int memSyncDomain() {
            return CUlaunchAttributeValue.nmemSyncDomain(this.address());
        }

        public Buffer pad(@NativeType(value="char[64]") ByteBuffer value) {
            CUlaunchAttributeValue.npad(this.address(), value);
            return this;
        }

        public Buffer pad(int index, @NativeType(value="char") byte value) {
            CUlaunchAttributeValue.npad(this.address(), index, value);
            return this;
        }

        public Buffer accessPolicyWindow(CUaccessPolicyWindow value) {
            CUlaunchAttributeValue.naccessPolicyWindow(this.address(), value);
            return this;
        }

        public Buffer accessPolicyWindow(Consumer<CUaccessPolicyWindow> consumer) {
            consumer.accept(this.accessPolicyWindow());
            return this;
        }

        public Buffer cooperative(int value) {
            CUlaunchAttributeValue.ncooperative(this.address(), value);
            return this;
        }

        public Buffer syncPolicy(@NativeType(value="CUsynchronizationPolicy") int value) {
            CUlaunchAttributeValue.nsyncPolicy(this.address(), value);
            return this;
        }

        public Buffer clusterDim_x(@NativeType(value="unsigned int") int value) {
            CUlaunchAttributeValue.nclusterDim_x(this.address(), value);
            return this;
        }

        public Buffer clusterDim_y(@NativeType(value="unsigned int") int value) {
            CUlaunchAttributeValue.nclusterDim_y(this.address(), value);
            return this;
        }

        public Buffer clusterDim_z(@NativeType(value="unsigned int") int value) {
            CUlaunchAttributeValue.nclusterDim_z(this.address(), value);
            return this;
        }

        public Buffer clusterSchedulingPolicyPreference(@NativeType(value="CUclusterSchedulingPolicy") int value) {
            CUlaunchAttributeValue.nclusterSchedulingPolicyPreference(this.address(), value);
            return this;
        }

        public Buffer programmaticStreamSerializationAllowed(int value) {
            CUlaunchAttributeValue.nprogrammaticStreamSerializationAllowed(this.address(), value);
            return this;
        }

        public Buffer programmaticEvent_event(@NativeType(value="CUevent") long value) {
            CUlaunchAttributeValue.nprogrammaticEvent_event(this.address(), value);
            return this;
        }

        public Buffer programmaticEvent_flags(int value) {
            CUlaunchAttributeValue.nprogrammaticEvent_flags(this.address(), value);
            return this;
        }

        public Buffer programmaticEvent_triggerAtBlockStart(int value) {
            CUlaunchAttributeValue.nprogrammaticEvent_triggerAtBlockStart(this.address(), value);
            return this;
        }

        public Buffer priority(int value) {
            CUlaunchAttributeValue.npriority(this.address(), value);
            return this;
        }

        public Buffer memSyncDomainMap(CUlaunchMemSyncDomainMap value) {
            CUlaunchAttributeValue.nmemSyncDomainMap(this.address(), value);
            return this;
        }

        public Buffer memSyncDomainMap(Consumer<CUlaunchMemSyncDomainMap> consumer) {
            consumer.accept(this.memSyncDomainMap());
            return this;
        }

        public Buffer memSyncDomain(@NativeType(value="CUlaunchMemSyncDomain") int value) {
            CUlaunchAttributeValue.nmemSyncDomain(this.address(), value);
            return this;
        }
    }
}

