/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.cuda.CUlaunchAttribute;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUlaunchConfig
extends Struct<CUlaunchConfig>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int GRIDDIMX;
    public static final int GRIDDIMY;
    public static final int GRIDDIMZ;
    public static final int BLOCKDIMX;
    public static final int BLOCKDIMY;
    public static final int BLOCKDIMZ;
    public static final int SHAREDMEMBYTES;
    public static final int HSTREAM;
    public static final int ATTRS;
    public static final int NUMATTRS;

    protected CUlaunchConfig(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CUlaunchConfig create(long address, @Nullable ByteBuffer container) {
        return new CUlaunchConfig(address, container);
    }

    public CUlaunchConfig(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUlaunchConfig.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int gridDimX() {
        return CUlaunchConfig.ngridDimX(this.address());
    }

    @NativeType(value="unsigned int")
    public int gridDimY() {
        return CUlaunchConfig.ngridDimY(this.address());
    }

    @NativeType(value="unsigned int")
    public int gridDimZ() {
        return CUlaunchConfig.ngridDimZ(this.address());
    }

    @NativeType(value="unsigned int")
    public int blockDimX() {
        return CUlaunchConfig.nblockDimX(this.address());
    }

    @NativeType(value="unsigned int")
    public int blockDimY() {
        return CUlaunchConfig.nblockDimY(this.address());
    }

    @NativeType(value="unsigned int")
    public int blockDimZ() {
        return CUlaunchConfig.nblockDimZ(this.address());
    }

    @NativeType(value="unsigned int")
    public int sharedMemBytes() {
        return CUlaunchConfig.nsharedMemBytes(this.address());
    }

    @NativeType(value="CUstream")
    public long hStream() {
        return CUlaunchConfig.nhStream(this.address());
    }

    @NativeType(value="CUlaunchAttribute *")
    public @Nullable CUlaunchAttribute.Buffer attrs() {
        return CUlaunchConfig.nattrs(this.address());
    }

    @NativeType(value="unsigned int")
    public int numAttrs() {
        return CUlaunchConfig.nnumAttrs(this.address());
    }

    public CUlaunchConfig gridDimX(@NativeType(value="unsigned int") int value) {
        CUlaunchConfig.ngridDimX(this.address(), value);
        return this;
    }

    public CUlaunchConfig gridDimY(@NativeType(value="unsigned int") int value) {
        CUlaunchConfig.ngridDimY(this.address(), value);
        return this;
    }

    public CUlaunchConfig gridDimZ(@NativeType(value="unsigned int") int value) {
        CUlaunchConfig.ngridDimZ(this.address(), value);
        return this;
    }

    public CUlaunchConfig blockDimX(@NativeType(value="unsigned int") int value) {
        CUlaunchConfig.nblockDimX(this.address(), value);
        return this;
    }

    public CUlaunchConfig blockDimY(@NativeType(value="unsigned int") int value) {
        CUlaunchConfig.nblockDimY(this.address(), value);
        return this;
    }

    public CUlaunchConfig blockDimZ(@NativeType(value="unsigned int") int value) {
        CUlaunchConfig.nblockDimZ(this.address(), value);
        return this;
    }

    public CUlaunchConfig sharedMemBytes(@NativeType(value="unsigned int") int value) {
        CUlaunchConfig.nsharedMemBytes(this.address(), value);
        return this;
    }

    public CUlaunchConfig hStream(@NativeType(value="CUstream") long value) {
        CUlaunchConfig.nhStream(this.address(), value);
        return this;
    }

    public CUlaunchConfig attrs(@NativeType(value="CUlaunchAttribute *") @Nullable CUlaunchAttribute.Buffer value) {
        CUlaunchConfig.nattrs(this.address(), value);
        return this;
    }

    public CUlaunchConfig numAttrs(@NativeType(value="unsigned int") int value) {
        CUlaunchConfig.nnumAttrs(this.address(), value);
        return this;
    }

    public CUlaunchConfig set(int gridDimX, int gridDimY, int gridDimZ, int blockDimX, int blockDimY, int blockDimZ, int sharedMemBytes, long hStream, @Nullable CUlaunchAttribute.Buffer attrs, int numAttrs) {
        this.gridDimX(gridDimX);
        this.gridDimY(gridDimY);
        this.gridDimZ(gridDimZ);
        this.blockDimX(blockDimX);
        this.blockDimY(blockDimY);
        this.blockDimZ(blockDimZ);
        this.sharedMemBytes(sharedMemBytes);
        this.hStream(hStream);
        this.attrs(attrs);
        this.numAttrs(numAttrs);
        return this;
    }

    public CUlaunchConfig set(CUlaunchConfig src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUlaunchConfig malloc() {
        return new CUlaunchConfig(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CUlaunchConfig calloc() {
        return new CUlaunchConfig(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CUlaunchConfig create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CUlaunchConfig(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CUlaunchConfig create(long address) {
        return new CUlaunchConfig(address, null);
    }

    public static @Nullable CUlaunchConfig createSafe(long address) {
        return address == 0L ? null : new CUlaunchConfig(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CUlaunchConfig.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUlaunchConfig.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUlaunchConfig malloc(MemoryStack stack) {
        return new CUlaunchConfig(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUlaunchConfig calloc(MemoryStack stack) {
        return new CUlaunchConfig(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ngridDimX(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)GRIDDIMX));
    }

    public static int ngridDimY(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)GRIDDIMY));
    }

    public static int ngridDimZ(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)GRIDDIMZ));
    }

    public static int nblockDimX(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BLOCKDIMX));
    }

    public static int nblockDimY(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BLOCKDIMY));
    }

    public static int nblockDimZ(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BLOCKDIMZ));
    }

    public static int nsharedMemBytes(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SHAREDMEMBYTES));
    }

    public static long nhStream(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)HSTREAM));
    }

    public static @Nullable CUlaunchAttribute.Buffer nattrs(long struct) {
        return CUlaunchAttribute.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)ATTRS)), CUlaunchConfig.nnumAttrs(struct));
    }

    public static int nnumAttrs(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)NUMATTRS));
    }

    public static void ngridDimX(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)GRIDDIMX), (int)value);
    }

    public static void ngridDimY(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)GRIDDIMY), (int)value);
    }

    public static void ngridDimZ(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)GRIDDIMZ), (int)value);
    }

    public static void nblockDimX(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)BLOCKDIMX), (int)value);
    }

    public static void nblockDimY(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)BLOCKDIMY), (int)value);
    }

    public static void nblockDimZ(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)BLOCKDIMZ), (int)value);
    }

    public static void nsharedMemBytes(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SHAREDMEMBYTES), (int)value);
    }

    public static void nhStream(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)HSTREAM), (long)value);
    }

    public static void nattrs(long struct, @Nullable CUlaunchAttribute.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)ATTRS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        CUlaunchConfig.nnumAttrs(struct, value == null ? 0 : value.remaining());
    }

    public static void nnumAttrs(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)NUMATTRS), (int)value);
    }

    static {
        Struct.Layout layout = CUlaunchConfig.__struct((Struct.Member[])new Struct.Member[]{CUlaunchConfig.__member((int)4), CUlaunchConfig.__member((int)4), CUlaunchConfig.__member((int)4), CUlaunchConfig.__member((int)4), CUlaunchConfig.__member((int)4), CUlaunchConfig.__member((int)4), CUlaunchConfig.__member((int)4), CUlaunchConfig.__member((int)POINTER_SIZE), CUlaunchConfig.__member((int)POINTER_SIZE), CUlaunchConfig.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        GRIDDIMX = layout.offsetof(0);
        GRIDDIMY = layout.offsetof(1);
        GRIDDIMZ = layout.offsetof(2);
        BLOCKDIMX = layout.offsetof(3);
        BLOCKDIMY = layout.offsetof(4);
        BLOCKDIMZ = layout.offsetof(5);
        SHAREDMEMBYTES = layout.offsetof(6);
        HSTREAM = layout.offsetof(7);
        ATTRS = layout.offsetof(8);
        NUMATTRS = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<CUlaunchConfig, Buffer>
    implements NativeResource {
        private static final CUlaunchConfig ELEMENT_FACTORY = CUlaunchConfig.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected CUlaunchConfig getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int gridDimX() {
            return CUlaunchConfig.ngridDimX(this.address());
        }

        @NativeType(value="unsigned int")
        public int gridDimY() {
            return CUlaunchConfig.ngridDimY(this.address());
        }

        @NativeType(value="unsigned int")
        public int gridDimZ() {
            return CUlaunchConfig.ngridDimZ(this.address());
        }

        @NativeType(value="unsigned int")
        public int blockDimX() {
            return CUlaunchConfig.nblockDimX(this.address());
        }

        @NativeType(value="unsigned int")
        public int blockDimY() {
            return CUlaunchConfig.nblockDimY(this.address());
        }

        @NativeType(value="unsigned int")
        public int blockDimZ() {
            return CUlaunchConfig.nblockDimZ(this.address());
        }

        @NativeType(value="unsigned int")
        public int sharedMemBytes() {
            return CUlaunchConfig.nsharedMemBytes(this.address());
        }

        @NativeType(value="CUstream")
        public long hStream() {
            return CUlaunchConfig.nhStream(this.address());
        }

        @NativeType(value="CUlaunchAttribute *")
        public @Nullable CUlaunchAttribute.Buffer attrs() {
            return CUlaunchConfig.nattrs(this.address());
        }

        @NativeType(value="unsigned int")
        public int numAttrs() {
            return CUlaunchConfig.nnumAttrs(this.address());
        }

        public Buffer gridDimX(@NativeType(value="unsigned int") int value) {
            CUlaunchConfig.ngridDimX(this.address(), value);
            return this;
        }

        public Buffer gridDimY(@NativeType(value="unsigned int") int value) {
            CUlaunchConfig.ngridDimY(this.address(), value);
            return this;
        }

        public Buffer gridDimZ(@NativeType(value="unsigned int") int value) {
            CUlaunchConfig.ngridDimZ(this.address(), value);
            return this;
        }

        public Buffer blockDimX(@NativeType(value="unsigned int") int value) {
            CUlaunchConfig.nblockDimX(this.address(), value);
            return this;
        }

        public Buffer blockDimY(@NativeType(value="unsigned int") int value) {
            CUlaunchConfig.nblockDimY(this.address(), value);
            return this;
        }

        public Buffer blockDimZ(@NativeType(value="unsigned int") int value) {
            CUlaunchConfig.nblockDimZ(this.address(), value);
            return this;
        }

        public Buffer sharedMemBytes(@NativeType(value="unsigned int") int value) {
            CUlaunchConfig.nsharedMemBytes(this.address(), value);
            return this;
        }

        public Buffer hStream(@NativeType(value="CUstream") long value) {
            CUlaunchConfig.nhStream(this.address(), value);
            return this;
        }

        public Buffer attrs(@NativeType(value="CUlaunchAttribute *") @Nullable CUlaunchAttribute.Buffer value) {
            CUlaunchConfig.nattrs(this.address(), value);
            return this;
        }

        public Buffer numAttrs(@NativeType(value="unsigned int") int value) {
            CUlaunchConfig.nnumAttrs(this.address(), value);
            return this;
        }
    }
}

