/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct EGLClientPixmapHI")
public class EGLClientPixmapHI
extends Struct<EGLClientPixmapHI>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PDATA;
    public static final int IWIDTH;
    public static final int IHEIGHT;
    public static final int ISTRIDE;

    protected EGLClientPixmapHI(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected EGLClientPixmapHI create(long address, @Nullable ByteBuffer container) {
        return new EGLClientPixmapHI(address, container);
    }

    public EGLClientPixmapHI(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), EGLClientPixmapHI.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public ByteBuffer pData(int capacity) {
        return EGLClientPixmapHI.npData(this.address(), capacity);
    }

    @NativeType(value="EGLint")
    public int iWidth() {
        return EGLClientPixmapHI.niWidth(this.address());
    }

    @NativeType(value="EGLint")
    public int iHeight() {
        return EGLClientPixmapHI.niHeight(this.address());
    }

    @NativeType(value="EGLint")
    public int iStride() {
        return EGLClientPixmapHI.niStride(this.address());
    }

    public EGLClientPixmapHI pData(@NativeType(value="void *") ByteBuffer value) {
        EGLClientPixmapHI.npData(this.address(), value);
        return this;
    }

    public EGLClientPixmapHI iWidth(@NativeType(value="EGLint") int value) {
        EGLClientPixmapHI.niWidth(this.address(), value);
        return this;
    }

    public EGLClientPixmapHI iHeight(@NativeType(value="EGLint") int value) {
        EGLClientPixmapHI.niHeight(this.address(), value);
        return this;
    }

    public EGLClientPixmapHI iStride(@NativeType(value="EGLint") int value) {
        EGLClientPixmapHI.niStride(this.address(), value);
        return this;
    }

    public EGLClientPixmapHI set(ByteBuffer pData, int iWidth, int iHeight, int iStride) {
        this.pData(pData);
        this.iWidth(iWidth);
        this.iHeight(iHeight);
        this.iStride(iStride);
        return this;
    }

    public EGLClientPixmapHI set(EGLClientPixmapHI src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static EGLClientPixmapHI malloc() {
        return new EGLClientPixmapHI(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static EGLClientPixmapHI calloc() {
        return new EGLClientPixmapHI(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static EGLClientPixmapHI create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new EGLClientPixmapHI(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static EGLClientPixmapHI create(long address) {
        return new EGLClientPixmapHI(address, null);
    }

    public static @Nullable EGLClientPixmapHI createSafe(long address) {
        return address == 0L ? null : new EGLClientPixmapHI(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)EGLClientPixmapHI.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = EGLClientPixmapHI.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static EGLClientPixmapHI mallocStack() {
        return EGLClientPixmapHI.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static EGLClientPixmapHI callocStack() {
        return EGLClientPixmapHI.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static EGLClientPixmapHI mallocStack(MemoryStack stack) {
        return EGLClientPixmapHI.malloc(stack);
    }

    @Deprecated
    public static EGLClientPixmapHI callocStack(MemoryStack stack) {
        return EGLClientPixmapHI.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return EGLClientPixmapHI.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return EGLClientPixmapHI.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return EGLClientPixmapHI.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return EGLClientPixmapHI.calloc(capacity, stack);
    }

    public static EGLClientPixmapHI malloc(MemoryStack stack) {
        return new EGLClientPixmapHI(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static EGLClientPixmapHI calloc(MemoryStack stack) {
        return new EGLClientPixmapHI(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer npData(long struct, int capacity) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PDATA)), (int)capacity);
    }

    public static int niWidth(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)IWIDTH));
    }

    public static int niHeight(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)IHEIGHT));
    }

    public static int niStride(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)ISTRIDE));
    }

    public static void npData(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PDATA), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void niWidth(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)IWIDTH), (int)value);
    }

    public static void niHeight(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)IHEIGHT), (int)value);
    }

    public static void niStride(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)ISTRIDE), (int)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PDATA)));
    }

    static {
        Struct.Layout layout = EGLClientPixmapHI.__struct((Struct.Member[])new Struct.Member[]{EGLClientPixmapHI.__member((int)POINTER_SIZE), EGLClientPixmapHI.__member((int)4), EGLClientPixmapHI.__member((int)4), EGLClientPixmapHI.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PDATA = layout.offsetof(0);
        IWIDTH = layout.offsetof(1);
        IHEIGHT = layout.offsetof(2);
        ISTRIDE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<EGLClientPixmapHI, Buffer>
    implements NativeResource {
        private static final EGLClientPixmapHI ELEMENT_FACTORY = EGLClientPixmapHI.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected EGLClientPixmapHI getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public ByteBuffer pData(int capacity) {
            return EGLClientPixmapHI.npData(this.address(), capacity);
        }

        @NativeType(value="EGLint")
        public int iWidth() {
            return EGLClientPixmapHI.niWidth(this.address());
        }

        @NativeType(value="EGLint")
        public int iHeight() {
            return EGLClientPixmapHI.niHeight(this.address());
        }

        @NativeType(value="EGLint")
        public int iStride() {
            return EGLClientPixmapHI.niStride(this.address());
        }

        public Buffer pData(@NativeType(value="void *") ByteBuffer value) {
            EGLClientPixmapHI.npData(this.address(), value);
            return this;
        }

        public Buffer iWidth(@NativeType(value="EGLint") int value) {
            EGLClientPixmapHI.niWidth(this.address(), value);
            return this;
        }

        public Buffer iHeight(@NativeType(value="EGLint") int value) {
            EGLClientPixmapHI.niHeight(this.address(), value);
            return this;
        }

        public Buffer iStride(@NativeType(value="EGLint") int value) {
            EGLClientPixmapHI.niStride(this.address(), value);
            return this;
        }
    }
}

