/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.egl.EGL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class KHRImageBase {
    public static final int EGL_IMAGE_PRESERVED_KHR = 12498;
    public static final long EGL_NO_IMAGE_KHR = 0L;

    protected KHRImageBase() {
        throw new UnsupportedOperationException();
    }

    public static long neglCreateImageKHR(long dpy, long ctx, int target, long buffer, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateImageKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)dpy);
            Checks.check((long)ctx);
            Checks.check((long)buffer);
        }
        return JNI.callPPPPP((long)dpy, (long)ctx, (int)target, (long)buffer, (long)attrib_list, (long)__functionAddress);
    }

    @NativeType(value="EGLImageKHR")
    public static long eglCreateImageKHR(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLContext") long ctx, @NativeType(value="EGLenum") int target, @NativeType(value="EGLClientBuffer") long buffer, @NativeType(value="EGLint const *") @Nullable IntBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((IntBuffer)attrib_list, (int)12344);
        }
        return KHRImageBase.neglCreateImageKHR(dpy, ctx, target, buffer, MemoryUtil.memAddressSafe((IntBuffer)attrib_list));
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglDestroyImageKHR(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLImageKHR") long image) {
        long __functionAddress = EGL.getCapabilities().eglDestroyImageKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)dpy);
            Checks.check((long)image);
        }
        return JNI.callPPI((long)dpy, (long)image, (long)__functionAddress) != 0;
    }

    @NativeType(value="EGLImageKHR")
    public static long eglCreateImageKHR(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLContext") long ctx, @NativeType(value="EGLenum") int target, @NativeType(value="EGLClientBuffer") long buffer, @NativeType(value="EGLint const *") int @Nullable [] attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateImageKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)dpy);
            Checks.check((long)ctx);
            Checks.check((long)buffer);
            Checks.checkNTSafe((int[])attrib_list, (int)12344);
        }
        return JNI.callPPPPP((long)dpy, (long)ctx, (int)target, (long)buffer, (int[])attrib_list, (long)__functionAddress);
    }
}

