/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.fmod;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.fmod.FMOD_CODEC_STATE_FUNCTIONS;
import org.lwjgl.fmod.FMOD_CODEC_WAVEFORMAT;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct FMOD_CODEC_STATE")
public class FMOD_CODEC_STATE
extends Struct<FMOD_CODEC_STATE>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PLUGINDATA;
    public static final int WAVEFORMAT;
    public static final int FUNCTIONS;
    public static final int NUMSUBSOUNDS;

    protected FMOD_CODEC_STATE(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected FMOD_CODEC_STATE create(long address, @Nullable ByteBuffer container) {
        return new FMOD_CODEC_STATE(address, container);
    }

    public FMOD_CODEC_STATE(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), FMOD_CODEC_STATE.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public ByteBuffer plugindata(int capacity) {
        return FMOD_CODEC_STATE.nplugindata(this.address(), capacity);
    }

    @NativeType(value="struct FMOD_CODEC_WAVEFORMAT *")
    public FMOD_CODEC_WAVEFORMAT waveformat() {
        return FMOD_CODEC_STATE.nwaveformat(this.address());
    }

    @NativeType(value="FMOD_CODEC_STATE_FUNCTIONS *")
    public FMOD_CODEC_STATE_FUNCTIONS functions() {
        return FMOD_CODEC_STATE.nfunctions(this.address());
    }

    public int numsubsounds() {
        return FMOD_CODEC_STATE.nnumsubsounds(this.address());
    }

    public FMOD_CODEC_STATE plugindata(@NativeType(value="void *") ByteBuffer value) {
        FMOD_CODEC_STATE.nplugindata(this.address(), value);
        return this;
    }

    public FMOD_CODEC_STATE waveformat(@NativeType(value="struct FMOD_CODEC_WAVEFORMAT *") FMOD_CODEC_WAVEFORMAT value) {
        FMOD_CODEC_STATE.nwaveformat(this.address(), value);
        return this;
    }

    public FMOD_CODEC_STATE functions(@NativeType(value="FMOD_CODEC_STATE_FUNCTIONS *") FMOD_CODEC_STATE_FUNCTIONS value) {
        FMOD_CODEC_STATE.nfunctions(this.address(), value);
        return this;
    }

    public FMOD_CODEC_STATE numsubsounds(int value) {
        FMOD_CODEC_STATE.nnumsubsounds(this.address(), value);
        return this;
    }

    public FMOD_CODEC_STATE set(ByteBuffer plugindata, FMOD_CODEC_WAVEFORMAT waveformat, FMOD_CODEC_STATE_FUNCTIONS functions, int numsubsounds) {
        this.plugindata(plugindata);
        this.waveformat(waveformat);
        this.functions(functions);
        this.numsubsounds(numsubsounds);
        return this;
    }

    public FMOD_CODEC_STATE set(FMOD_CODEC_STATE src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static FMOD_CODEC_STATE malloc() {
        return new FMOD_CODEC_STATE(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static FMOD_CODEC_STATE calloc() {
        return new FMOD_CODEC_STATE(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static FMOD_CODEC_STATE create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new FMOD_CODEC_STATE(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static FMOD_CODEC_STATE create(long address) {
        return new FMOD_CODEC_STATE(address, null);
    }

    public static @Nullable FMOD_CODEC_STATE createSafe(long address) {
        return address == 0L ? null : new FMOD_CODEC_STATE(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)FMOD_CODEC_STATE.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = FMOD_CODEC_STATE.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static FMOD_CODEC_STATE malloc(MemoryStack stack) {
        return new FMOD_CODEC_STATE(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static FMOD_CODEC_STATE calloc(MemoryStack stack) {
        return new FMOD_CODEC_STATE(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nplugindata(long struct, int capacity) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PLUGINDATA)), (int)capacity);
    }

    public static FMOD_CODEC_WAVEFORMAT nwaveformat(long struct) {
        return FMOD_CODEC_WAVEFORMAT.create(MemoryUtil.memGetAddress((long)(struct + (long)WAVEFORMAT)));
    }

    public static FMOD_CODEC_STATE_FUNCTIONS nfunctions(long struct) {
        return FMOD_CODEC_STATE_FUNCTIONS.create(MemoryUtil.memGetAddress((long)(struct + (long)FUNCTIONS)));
    }

    public static int nnumsubsounds(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)NUMSUBSOUNDS));
    }

    public static void nplugindata(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PLUGINDATA), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void nwaveformat(long struct, FMOD_CODEC_WAVEFORMAT value) {
        MemoryUtil.memPutAddress((long)(struct + (long)WAVEFORMAT), (long)value.address());
    }

    public static void nfunctions(long struct, FMOD_CODEC_STATE_FUNCTIONS value) {
        MemoryUtil.memPutAddress((long)(struct + (long)FUNCTIONS), (long)value.address());
    }

    public static void nnumsubsounds(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)NUMSUBSOUNDS), (int)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PLUGINDATA)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)WAVEFORMAT)));
        long functions = MemoryUtil.memGetAddress((long)(struct + (long)FUNCTIONS));
        Checks.check((long)functions);
        FMOD_CODEC_STATE_FUNCTIONS.validate(functions);
    }

    static {
        Struct.Layout layout = FMOD_CODEC_STATE.__struct((Struct.Member[])new Struct.Member[]{FMOD_CODEC_STATE.__member((int)POINTER_SIZE), FMOD_CODEC_STATE.__member((int)POINTER_SIZE), FMOD_CODEC_STATE.__member((int)POINTER_SIZE), FMOD_CODEC_STATE.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PLUGINDATA = layout.offsetof(0);
        WAVEFORMAT = layout.offsetof(1);
        FUNCTIONS = layout.offsetof(2);
        NUMSUBSOUNDS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<FMOD_CODEC_STATE, Buffer>
    implements NativeResource {
        private static final FMOD_CODEC_STATE ELEMENT_FACTORY = FMOD_CODEC_STATE.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected FMOD_CODEC_STATE getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public ByteBuffer plugindata(int capacity) {
            return FMOD_CODEC_STATE.nplugindata(this.address(), capacity);
        }

        @NativeType(value="struct FMOD_CODEC_WAVEFORMAT *")
        public FMOD_CODEC_WAVEFORMAT waveformat() {
            return FMOD_CODEC_STATE.nwaveformat(this.address());
        }

        @NativeType(value="FMOD_CODEC_STATE_FUNCTIONS *")
        public FMOD_CODEC_STATE_FUNCTIONS functions() {
            return FMOD_CODEC_STATE.nfunctions(this.address());
        }

        public int numsubsounds() {
            return FMOD_CODEC_STATE.nnumsubsounds(this.address());
        }

        public Buffer plugindata(@NativeType(value="void *") ByteBuffer value) {
            FMOD_CODEC_STATE.nplugindata(this.address(), value);
            return this;
        }

        public Buffer waveformat(@NativeType(value="struct FMOD_CODEC_WAVEFORMAT *") FMOD_CODEC_WAVEFORMAT value) {
            FMOD_CODEC_STATE.nwaveformat(this.address(), value);
            return this;
        }

        public Buffer functions(@NativeType(value="FMOD_CODEC_STATE_FUNCTIONS *") FMOD_CODEC_STATE_FUNCTIONS value) {
            FMOD_CODEC_STATE.nfunctions(this.address(), value);
            return this;
        }

        public Buffer numsubsounds(int value) {
            FMOD_CODEC_STATE.nnumsubsounds(this.address(), value);
            return this;
        }
    }
}

