/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.fmod;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct FMOD_COMPLEX")
public class FMOD_COMPLEX
extends Struct<FMOD_COMPLEX>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int REAL;
    public static final int IMAG;

    protected FMOD_COMPLEX(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected FMOD_COMPLEX create(long address, @Nullable ByteBuffer container) {
        return new FMOD_COMPLEX(address, container);
    }

    public FMOD_COMPLEX(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), FMOD_COMPLEX.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float real() {
        return FMOD_COMPLEX.nreal(this.address());
    }

    public float imag() {
        return FMOD_COMPLEX.nimag(this.address());
    }

    public FMOD_COMPLEX real(float value) {
        FMOD_COMPLEX.nreal(this.address(), value);
        return this;
    }

    public FMOD_COMPLEX imag(float value) {
        FMOD_COMPLEX.nimag(this.address(), value);
        return this;
    }

    public FMOD_COMPLEX set(float real, float imag) {
        this.real(real);
        this.imag(imag);
        return this;
    }

    public FMOD_COMPLEX set(FMOD_COMPLEX src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static FMOD_COMPLEX malloc() {
        return new FMOD_COMPLEX(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static FMOD_COMPLEX calloc() {
        return new FMOD_COMPLEX(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static FMOD_COMPLEX create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new FMOD_COMPLEX(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static FMOD_COMPLEX create(long address) {
        return new FMOD_COMPLEX(address, null);
    }

    public static @Nullable FMOD_COMPLEX createSafe(long address) {
        return address == 0L ? null : new FMOD_COMPLEX(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)FMOD_COMPLEX.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = FMOD_COMPLEX.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static FMOD_COMPLEX malloc(MemoryStack stack) {
        return new FMOD_COMPLEX(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static FMOD_COMPLEX calloc(MemoryStack stack) {
        return new FMOD_COMPLEX(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nreal(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)REAL));
    }

    public static float nimag(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)IMAG));
    }

    public static void nreal(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)REAL), (float)value);
    }

    public static void nimag(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)IMAG), (float)value);
    }

    static {
        Struct.Layout layout = FMOD_COMPLEX.__struct((Struct.Member[])new Struct.Member[]{FMOD_COMPLEX.__member((int)4), FMOD_COMPLEX.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        REAL = layout.offsetof(0);
        IMAG = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<FMOD_COMPLEX, Buffer>
    implements NativeResource {
        private static final FMOD_COMPLEX ELEMENT_FACTORY = FMOD_COMPLEX.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected FMOD_COMPLEX getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float real() {
            return FMOD_COMPLEX.nreal(this.address());
        }

        public float imag() {
            return FMOD_COMPLEX.nimag(this.address());
        }

        public Buffer real(float value) {
            FMOD_COMPLEX.nreal(this.address(), value);
            return this;
        }

        public Buffer imag(float value) {
            FMOD_COMPLEX.nimag(this.address(), value);
            return this;
        }
    }
}

