/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.fmod;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class FMOD_DSP_PARAMETER_FFT
extends Struct<FMOD_DSP_PARAMETER_FFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LENGTH;
    public static final int NUMCHANNELS;
    public static final int SPECTRUM;

    protected FMOD_DSP_PARAMETER_FFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected FMOD_DSP_PARAMETER_FFT create(long address, @Nullable ByteBuffer container) {
        return new FMOD_DSP_PARAMETER_FFT(address, container);
    }

    public FMOD_DSP_PARAMETER_FFT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), FMOD_DSP_PARAMETER_FFT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int length() {
        return FMOD_DSP_PARAMETER_FFT.nlength(this.address());
    }

    public int numchannels() {
        return FMOD_DSP_PARAMETER_FFT.nnumchannels(this.address());
    }

    @NativeType(value="float *[32]")
    public PointerBuffer spectrum() {
        return FMOD_DSP_PARAMETER_FFT.nspectrum(this.address());
    }

    @NativeType(value="float *")
    public long spectrum(int index) {
        return FMOD_DSP_PARAMETER_FFT.nspectrum(this.address(), index);
    }

    public FMOD_DSP_PARAMETER_FFT length(int value) {
        FMOD_DSP_PARAMETER_FFT.nlength(this.address(), value);
        return this;
    }

    public FMOD_DSP_PARAMETER_FFT numchannels(int value) {
        FMOD_DSP_PARAMETER_FFT.nnumchannels(this.address(), value);
        return this;
    }

    public FMOD_DSP_PARAMETER_FFT spectrum(@NativeType(value="float *[32]") PointerBuffer value) {
        FMOD_DSP_PARAMETER_FFT.nspectrum(this.address(), value);
        return this;
    }

    public FMOD_DSP_PARAMETER_FFT spectrum(int index, @NativeType(value="float *") FloatBuffer value) {
        FMOD_DSP_PARAMETER_FFT.nspectrum(this.address(), index, MemoryUtil.memAddressSafe((FloatBuffer)value));
        return this;
    }

    public FMOD_DSP_PARAMETER_FFT set(int length, int numchannels, PointerBuffer spectrum) {
        this.length(length);
        this.numchannels(numchannels);
        this.spectrum(spectrum);
        return this;
    }

    public FMOD_DSP_PARAMETER_FFT set(FMOD_DSP_PARAMETER_FFT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static FMOD_DSP_PARAMETER_FFT malloc() {
        return new FMOD_DSP_PARAMETER_FFT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static FMOD_DSP_PARAMETER_FFT calloc() {
        return new FMOD_DSP_PARAMETER_FFT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static FMOD_DSP_PARAMETER_FFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new FMOD_DSP_PARAMETER_FFT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static FMOD_DSP_PARAMETER_FFT create(long address) {
        return new FMOD_DSP_PARAMETER_FFT(address, null);
    }

    public static @Nullable FMOD_DSP_PARAMETER_FFT createSafe(long address) {
        return address == 0L ? null : new FMOD_DSP_PARAMETER_FFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)FMOD_DSP_PARAMETER_FFT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = FMOD_DSP_PARAMETER_FFT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static FMOD_DSP_PARAMETER_FFT malloc(MemoryStack stack) {
        return new FMOD_DSP_PARAMETER_FFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static FMOD_DSP_PARAMETER_FFT calloc(MemoryStack stack) {
        return new FMOD_DSP_PARAMETER_FFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nlength(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)LENGTH));
    }

    public static int nnumchannels(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)NUMCHANNELS));
    }

    public static PointerBuffer nspectrum(long struct) {
        return MemoryUtil.memPointerBuffer((long)(struct + (long)SPECTRUM), (int)32);
    }

    public static long nspectrum(long struct, int index) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SPECTRUM + Checks.check((int)index, (int)32) * (long)POINTER_SIZE));
    }

    public static void nlength(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)LENGTH), (int)value);
    }

    public static void nnumchannels(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)NUMCHANNELS), (int)value);
    }

    public static void nspectrum(long struct, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((CustomBuffer)value, (int)32);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((CustomBuffer)value), (long)(struct + (long)SPECTRUM), (long)(value.remaining() * POINTER_SIZE));
    }

    public static void nspectrum(long struct, int index, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SPECTRUM + Checks.check((int)index, (int)32) * (long)POINTER_SIZE), (long)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SPECTRUM)));
    }

    static {
        Struct.Layout layout = FMOD_DSP_PARAMETER_FFT.__struct((Struct.Member[])new Struct.Member[]{FMOD_DSP_PARAMETER_FFT.__member((int)4), FMOD_DSP_PARAMETER_FFT.__member((int)4), FMOD_DSP_PARAMETER_FFT.__array((int)POINTER_SIZE, (int)32)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LENGTH = layout.offsetof(0);
        NUMCHANNELS = layout.offsetof(1);
        SPECTRUM = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<FMOD_DSP_PARAMETER_FFT, Buffer>
    implements NativeResource {
        private static final FMOD_DSP_PARAMETER_FFT ELEMENT_FACTORY = FMOD_DSP_PARAMETER_FFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected FMOD_DSP_PARAMETER_FFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int length() {
            return FMOD_DSP_PARAMETER_FFT.nlength(this.address());
        }

        public int numchannels() {
            return FMOD_DSP_PARAMETER_FFT.nnumchannels(this.address());
        }

        @NativeType(value="float *[32]")
        public PointerBuffer spectrum() {
            return FMOD_DSP_PARAMETER_FFT.nspectrum(this.address());
        }

        @NativeType(value="float *")
        public long spectrum(int index) {
            return FMOD_DSP_PARAMETER_FFT.nspectrum(this.address(), index);
        }

        public Buffer length(int value) {
            FMOD_DSP_PARAMETER_FFT.nlength(this.address(), value);
            return this;
        }

        public Buffer numchannels(int value) {
            FMOD_DSP_PARAMETER_FFT.nnumchannels(this.address(), value);
            return this;
        }

        public Buffer spectrum(@NativeType(value="float *[32]") PointerBuffer value) {
            FMOD_DSP_PARAMETER_FFT.nspectrum(this.address(), value);
            return this;
        }

        public Buffer spectrum(int index, @NativeType(value="float *") FloatBuffer value) {
            FMOD_DSP_PARAMETER_FFT.nspectrum(this.address(), index, MemoryUtil.memAddressSafe((FloatBuffer)value));
            return this;
        }
    }
}

