/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.fmod;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.fmod.FMOD_VECTOR;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct FMOD_OUTPUT_OBJECT3DINFO")
public class FMOD_OUTPUT_OBJECT3DINFO
extends Struct<FMOD_OUTPUT_OBJECT3DINFO>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUFFER;
    public static final int BUFFERLENGTH;
    public static final int POSITION;
    public static final int GAIN;
    public static final int SPREAD;
    public static final int PRIORITY;

    protected FMOD_OUTPUT_OBJECT3DINFO(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected FMOD_OUTPUT_OBJECT3DINFO create(long address, @Nullable ByteBuffer container) {
        return new FMOD_OUTPUT_OBJECT3DINFO(address, container);
    }

    public FMOD_OUTPUT_OBJECT3DINFO(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), FMOD_OUTPUT_OBJECT3DINFO.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float *")
    public FloatBuffer buffer() {
        return FMOD_OUTPUT_OBJECT3DINFO.nbuffer(this.address());
    }

    @NativeType(value="unsigned int")
    public int bufferlength() {
        return FMOD_OUTPUT_OBJECT3DINFO.nbufferlength(this.address());
    }

    public FMOD_VECTOR position$() {
        return FMOD_OUTPUT_OBJECT3DINFO.nposition$(this.address());
    }

    public float gain() {
        return FMOD_OUTPUT_OBJECT3DINFO.ngain(this.address());
    }

    public float spread() {
        return FMOD_OUTPUT_OBJECT3DINFO.nspread(this.address());
    }

    public float priority() {
        return FMOD_OUTPUT_OBJECT3DINFO.npriority(this.address());
    }

    public FMOD_OUTPUT_OBJECT3DINFO buffer(@NativeType(value="float *") FloatBuffer value) {
        FMOD_OUTPUT_OBJECT3DINFO.nbuffer(this.address(), value);
        return this;
    }

    public FMOD_OUTPUT_OBJECT3DINFO position$(FMOD_VECTOR value) {
        FMOD_OUTPUT_OBJECT3DINFO.nposition$(this.address(), value);
        return this;
    }

    public FMOD_OUTPUT_OBJECT3DINFO position$(Consumer<FMOD_VECTOR> consumer) {
        consumer.accept(this.position$());
        return this;
    }

    public FMOD_OUTPUT_OBJECT3DINFO gain(float value) {
        FMOD_OUTPUT_OBJECT3DINFO.ngain(this.address(), value);
        return this;
    }

    public FMOD_OUTPUT_OBJECT3DINFO spread(float value) {
        FMOD_OUTPUT_OBJECT3DINFO.nspread(this.address(), value);
        return this;
    }

    public FMOD_OUTPUT_OBJECT3DINFO priority(float value) {
        FMOD_OUTPUT_OBJECT3DINFO.npriority(this.address(), value);
        return this;
    }

    public FMOD_OUTPUT_OBJECT3DINFO set(FloatBuffer buffer, FMOD_VECTOR position$, float gain, float spread, float priority) {
        this.buffer(buffer);
        this.position$(position$);
        this.gain(gain);
        this.spread(spread);
        this.priority(priority);
        return this;
    }

    public FMOD_OUTPUT_OBJECT3DINFO set(FMOD_OUTPUT_OBJECT3DINFO src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static FMOD_OUTPUT_OBJECT3DINFO malloc() {
        return new FMOD_OUTPUT_OBJECT3DINFO(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static FMOD_OUTPUT_OBJECT3DINFO calloc() {
        return new FMOD_OUTPUT_OBJECT3DINFO(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static FMOD_OUTPUT_OBJECT3DINFO create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new FMOD_OUTPUT_OBJECT3DINFO(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static FMOD_OUTPUT_OBJECT3DINFO create(long address) {
        return new FMOD_OUTPUT_OBJECT3DINFO(address, null);
    }

    public static @Nullable FMOD_OUTPUT_OBJECT3DINFO createSafe(long address) {
        return address == 0L ? null : new FMOD_OUTPUT_OBJECT3DINFO(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)FMOD_OUTPUT_OBJECT3DINFO.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = FMOD_OUTPUT_OBJECT3DINFO.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static FMOD_OUTPUT_OBJECT3DINFO malloc(MemoryStack stack) {
        return new FMOD_OUTPUT_OBJECT3DINFO(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static FMOD_OUTPUT_OBJECT3DINFO calloc(MemoryStack stack) {
        return new FMOD_OUTPUT_OBJECT3DINFO(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static FloatBuffer nbuffer(long struct) {
        return MemoryUtil.memFloatBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)BUFFER)), (int)FMOD_OUTPUT_OBJECT3DINFO.nbufferlength(struct));
    }

    public static int nbufferlength(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BUFFERLENGTH));
    }

    public static FMOD_VECTOR nposition$(long struct) {
        return FMOD_VECTOR.create(struct + (long)POSITION);
    }

    public static float ngain(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)GAIN));
    }

    public static float nspread(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)SPREAD));
    }

    public static float npriority(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)PRIORITY));
    }

    public static void nbuffer(long struct, FloatBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)BUFFER), (long)MemoryUtil.memAddress((FloatBuffer)value));
        FMOD_OUTPUT_OBJECT3DINFO.nbufferlength(struct, value.remaining());
    }

    public static void nbufferlength(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)BUFFERLENGTH), (int)value);
    }

    public static void nposition$(long struct, FMOD_VECTOR value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)POSITION), (long)FMOD_VECTOR.SIZEOF);
    }

    public static void ngain(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)GAIN), (float)value);
    }

    public static void nspread(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)SPREAD), (float)value);
    }

    public static void npriority(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)PRIORITY), (float)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)BUFFER)));
    }

    static {
        Struct.Layout layout = FMOD_OUTPUT_OBJECT3DINFO.__struct((Struct.Member[])new Struct.Member[]{FMOD_OUTPUT_OBJECT3DINFO.__member((int)POINTER_SIZE), FMOD_OUTPUT_OBJECT3DINFO.__member((int)4), FMOD_OUTPUT_OBJECT3DINFO.__member((int)FMOD_VECTOR.SIZEOF, (int)FMOD_VECTOR.ALIGNOF), FMOD_OUTPUT_OBJECT3DINFO.__member((int)4), FMOD_OUTPUT_OBJECT3DINFO.__member((int)4), FMOD_OUTPUT_OBJECT3DINFO.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUFFER = layout.offsetof(0);
        BUFFERLENGTH = layout.offsetof(1);
        POSITION = layout.offsetof(2);
        GAIN = layout.offsetof(3);
        SPREAD = layout.offsetof(4);
        PRIORITY = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<FMOD_OUTPUT_OBJECT3DINFO, Buffer>
    implements NativeResource {
        private static final FMOD_OUTPUT_OBJECT3DINFO ELEMENT_FACTORY = FMOD_OUTPUT_OBJECT3DINFO.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected FMOD_OUTPUT_OBJECT3DINFO getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="float *")
        public FloatBuffer buffer() {
            return FMOD_OUTPUT_OBJECT3DINFO.nbuffer(this.address());
        }

        @NativeType(value="unsigned int")
        public int bufferlength() {
            return FMOD_OUTPUT_OBJECT3DINFO.nbufferlength(this.address());
        }

        public FMOD_VECTOR position$() {
            return FMOD_OUTPUT_OBJECT3DINFO.nposition$(this.address());
        }

        public float gain() {
            return FMOD_OUTPUT_OBJECT3DINFO.ngain(this.address());
        }

        public float spread() {
            return FMOD_OUTPUT_OBJECT3DINFO.nspread(this.address());
        }

        public float priority() {
            return FMOD_OUTPUT_OBJECT3DINFO.npriority(this.address());
        }

        public Buffer buffer(@NativeType(value="float *") FloatBuffer value) {
            FMOD_OUTPUT_OBJECT3DINFO.nbuffer(this.address(), value);
            return this;
        }

        public Buffer position$(FMOD_VECTOR value) {
            FMOD_OUTPUT_OBJECT3DINFO.nposition$(this.address(), value);
            return this;
        }

        public Buffer position$(Consumer<FMOD_VECTOR> consumer) {
            consumer.accept(this.position$());
            return this;
        }

        public Buffer gain(float value) {
            FMOD_OUTPUT_OBJECT3DINFO.ngain(this.address(), value);
            return this;
        }

        public Buffer spread(float value) {
            FMOD_OUTPUT_OBJECT3DINFO.nspread(this.address(), value);
            return this;
        }

        public Buffer priority(float value) {
            FMOD_OUTPUT_OBJECT3DINFO.npriority(this.address(), value);
            return this;
        }
    }
}

