/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.fmod;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class FMOD_STUDIO_BUFFER_INFO
extends Struct<FMOD_STUDIO_BUFFER_INFO>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CURRENTUSAGE;
    public static final int PEAKUSAGE;
    public static final int CAPACITY;
    public static final int STALLCOUNT;
    public static final int STALLTIME;

    protected FMOD_STUDIO_BUFFER_INFO(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected FMOD_STUDIO_BUFFER_INFO create(long address, @Nullable ByteBuffer container) {
        return new FMOD_STUDIO_BUFFER_INFO(address, container);
    }

    public FMOD_STUDIO_BUFFER_INFO(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), FMOD_STUDIO_BUFFER_INFO.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int currentusage() {
        return FMOD_STUDIO_BUFFER_INFO.ncurrentusage(this.address());
    }

    public int peakusage() {
        return FMOD_STUDIO_BUFFER_INFO.npeakusage(this.address());
    }

    public int capacity$() {
        return FMOD_STUDIO_BUFFER_INFO.ncapacity$(this.address());
    }

    public int stallcount() {
        return FMOD_STUDIO_BUFFER_INFO.nstallcount(this.address());
    }

    public float stalltime() {
        return FMOD_STUDIO_BUFFER_INFO.nstalltime(this.address());
    }

    public FMOD_STUDIO_BUFFER_INFO currentusage(int value) {
        FMOD_STUDIO_BUFFER_INFO.ncurrentusage(this.address(), value);
        return this;
    }

    public FMOD_STUDIO_BUFFER_INFO peakusage(int value) {
        FMOD_STUDIO_BUFFER_INFO.npeakusage(this.address(), value);
        return this;
    }

    public FMOD_STUDIO_BUFFER_INFO capacity$(int value) {
        FMOD_STUDIO_BUFFER_INFO.ncapacity$(this.address(), value);
        return this;
    }

    public FMOD_STUDIO_BUFFER_INFO stallcount(int value) {
        FMOD_STUDIO_BUFFER_INFO.nstallcount(this.address(), value);
        return this;
    }

    public FMOD_STUDIO_BUFFER_INFO stalltime(float value) {
        FMOD_STUDIO_BUFFER_INFO.nstalltime(this.address(), value);
        return this;
    }

    public FMOD_STUDIO_BUFFER_INFO set(int currentusage, int peakusage, int capacity$, int stallcount, float stalltime) {
        this.currentusage(currentusage);
        this.peakusage(peakusage);
        this.capacity$(capacity$);
        this.stallcount(stallcount);
        this.stalltime(stalltime);
        return this;
    }

    public FMOD_STUDIO_BUFFER_INFO set(FMOD_STUDIO_BUFFER_INFO src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static FMOD_STUDIO_BUFFER_INFO malloc() {
        return new FMOD_STUDIO_BUFFER_INFO(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static FMOD_STUDIO_BUFFER_INFO calloc() {
        return new FMOD_STUDIO_BUFFER_INFO(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static FMOD_STUDIO_BUFFER_INFO create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new FMOD_STUDIO_BUFFER_INFO(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static FMOD_STUDIO_BUFFER_INFO create(long address) {
        return new FMOD_STUDIO_BUFFER_INFO(address, null);
    }

    public static @Nullable FMOD_STUDIO_BUFFER_INFO createSafe(long address) {
        return address == 0L ? null : new FMOD_STUDIO_BUFFER_INFO(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)FMOD_STUDIO_BUFFER_INFO.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = FMOD_STUDIO_BUFFER_INFO.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static FMOD_STUDIO_BUFFER_INFO malloc(MemoryStack stack) {
        return new FMOD_STUDIO_BUFFER_INFO(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static FMOD_STUDIO_BUFFER_INFO calloc(MemoryStack stack) {
        return new FMOD_STUDIO_BUFFER_INFO(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ncurrentusage(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)CURRENTUSAGE));
    }

    public static int npeakusage(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PEAKUSAGE));
    }

    public static int ncapacity$(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)CAPACITY));
    }

    public static int nstallcount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STALLCOUNT));
    }

    public static float nstalltime(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)STALLTIME));
    }

    public static void ncurrentusage(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)CURRENTUSAGE), (int)value);
    }

    public static void npeakusage(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)PEAKUSAGE), (int)value);
    }

    public static void ncapacity$(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)CAPACITY), (int)value);
    }

    public static void nstallcount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STALLCOUNT), (int)value);
    }

    public static void nstalltime(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)STALLTIME), (float)value);
    }

    static {
        Struct.Layout layout = FMOD_STUDIO_BUFFER_INFO.__struct((Struct.Member[])new Struct.Member[]{FMOD_STUDIO_BUFFER_INFO.__member((int)4), FMOD_STUDIO_BUFFER_INFO.__member((int)4), FMOD_STUDIO_BUFFER_INFO.__member((int)4), FMOD_STUDIO_BUFFER_INFO.__member((int)4), FMOD_STUDIO_BUFFER_INFO.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CURRENTUSAGE = layout.offsetof(0);
        PEAKUSAGE = layout.offsetof(1);
        CAPACITY = layout.offsetof(2);
        STALLCOUNT = layout.offsetof(3);
        STALLTIME = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<FMOD_STUDIO_BUFFER_INFO, Buffer>
    implements NativeResource {
        private static final FMOD_STUDIO_BUFFER_INFO ELEMENT_FACTORY = FMOD_STUDIO_BUFFER_INFO.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected FMOD_STUDIO_BUFFER_INFO getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int currentusage() {
            return FMOD_STUDIO_BUFFER_INFO.ncurrentusage(this.address());
        }

        public int peakusage() {
            return FMOD_STUDIO_BUFFER_INFO.npeakusage(this.address());
        }

        public int capacity$() {
            return FMOD_STUDIO_BUFFER_INFO.ncapacity$(this.address());
        }

        public int stallcount() {
            return FMOD_STUDIO_BUFFER_INFO.nstallcount(this.address());
        }

        public float stalltime() {
            return FMOD_STUDIO_BUFFER_INFO.nstalltime(this.address());
        }

        public Buffer currentusage(int value) {
            FMOD_STUDIO_BUFFER_INFO.ncurrentusage(this.address(), value);
            return this;
        }

        public Buffer peakusage(int value) {
            FMOD_STUDIO_BUFFER_INFO.npeakusage(this.address(), value);
            return this;
        }

        public Buffer capacity$(int value) {
            FMOD_STUDIO_BUFFER_INFO.ncapacity$(this.address(), value);
            return this;
        }

        public Buffer stallcount(int value) {
            FMOD_STUDIO_BUFFER_INFO.nstallcount(this.address(), value);
            return this;
        }

        public Buffer stalltime(float value) {
            FMOD_STUDIO_BUFFER_INFO.nstalltime(this.address(), value);
            return this;
        }
    }
}

