/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.ktx;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ktxOrientation")
public class ktxOrientation
extends Struct<ktxOrientation> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int Z;

    protected ktxOrientation(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected ktxOrientation create(long address, @Nullable ByteBuffer container) {
        return new ktxOrientation(address, container);
    }

    public ktxOrientation(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ktxOrientation.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ktxOrientationX")
    public int x() {
        return ktxOrientation.nx(this.address());
    }

    @NativeType(value="ktxOrientationY")
    public int y() {
        return ktxOrientation.ny(this.address());
    }

    @NativeType(value="ktxOrientationZ")
    public int z() {
        return ktxOrientation.nz(this.address());
    }

    public static ktxOrientation create(long address) {
        return new ktxOrientation(address, null);
    }

    public static @Nullable ktxOrientation createSafe(long address) {
        return address == 0L ? null : new ktxOrientation(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static int nx(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)X));
    }

    public static int ny(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)Y));
    }

    public static int nz(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)Z));
    }

    static {
        Struct.Layout layout = ktxOrientation.__struct((Struct.Member[])new Struct.Member[]{ktxOrientation.__member((int)4), ktxOrientation.__member((int)4), ktxOrientation.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        Z = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<ktxOrientation, Buffer> {
        private static final ktxOrientation ELEMENT_FACTORY = ktxOrientation.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected ktxOrientation getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ktxOrientationX")
        public int x() {
            return ktxOrientation.nx(this.address());
        }

        @NativeType(value="ktxOrientationY")
        public int y() {
            return ktxOrientation.ny(this.address());
        }

        @NativeType(value="ktxOrientationZ")
        public int z() {
            return ktxOrientation.nz(this.address());
        }
    }
}

