/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.ktx;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.ktx.ktxVulkanFunctions;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkCommandBuffer;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkPhysicalDevice;
import org.lwjgl.vulkan.VkPhysicalDeviceMemoryProperties;
import org.lwjgl.vulkan.VkQueue;

public class ktxVulkanDeviceInfo
extends Struct<ktxVulkanDeviceInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int INSTANCE;
    public static final int PHYSICALDEVICE;
    public static final int DEVICE;
    public static final int QUEUE;
    public static final int CMDBUFFER;
    public static final int CMDPOOL;
    public static final int PALLOCATOR;
    public static final int DEVICEMEMORYPROPERTIES;
    public static final int VKFUNCS;

    protected ktxVulkanDeviceInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected ktxVulkanDeviceInfo create(long address, @Nullable ByteBuffer container) {
        return new ktxVulkanDeviceInfo(address, container);
    }

    public ktxVulkanDeviceInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ktxVulkanDeviceInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkInstance")
    public long instance() {
        return ktxVulkanDeviceInfo.ninstance(this.address());
    }

    @NativeType(value="VkPhysicalDevice")
    public long physicalDevice() {
        return ktxVulkanDeviceInfo.nphysicalDevice(this.address());
    }

    @NativeType(value="VkDevice")
    public long device() {
        return ktxVulkanDeviceInfo.ndevice(this.address());
    }

    @NativeType(value="VkQueue")
    public long queue() {
        return ktxVulkanDeviceInfo.nqueue(this.address());
    }

    @NativeType(value="VkCommandBuffer")
    public long cmdBuffer() {
        return ktxVulkanDeviceInfo.ncmdBuffer(this.address());
    }

    @NativeType(value="VkCommandPool")
    public long cmdPool() {
        return ktxVulkanDeviceInfo.ncmdPool(this.address());
    }

    @NativeType(value="VkAllocationCallbacks const *")
    public @Nullable VkAllocationCallbacks pAllocator() {
        return ktxVulkanDeviceInfo.npAllocator(this.address());
    }

    public VkPhysicalDeviceMemoryProperties deviceMemoryProperties() {
        return ktxVulkanDeviceInfo.ndeviceMemoryProperties(this.address());
    }

    public ktxVulkanFunctions vkFuncs() {
        return ktxVulkanDeviceInfo.nvkFuncs(this.address());
    }

    public ktxVulkanDeviceInfo instance(VkInstance value) {
        ktxVulkanDeviceInfo.ninstance(this.address(), value);
        return this;
    }

    public ktxVulkanDeviceInfo physicalDevice(VkPhysicalDevice value) {
        ktxVulkanDeviceInfo.nphysicalDevice(this.address(), value);
        return this;
    }

    public ktxVulkanDeviceInfo device(VkDevice value) {
        ktxVulkanDeviceInfo.ndevice(this.address(), value);
        return this;
    }

    public ktxVulkanDeviceInfo queue(VkQueue value) {
        ktxVulkanDeviceInfo.nqueue(this.address(), value);
        return this;
    }

    public ktxVulkanDeviceInfo cmdBuffer(VkCommandBuffer value) {
        ktxVulkanDeviceInfo.ncmdBuffer(this.address(), value);
        return this;
    }

    public ktxVulkanDeviceInfo cmdPool(@NativeType(value="VkCommandPool") long value) {
        ktxVulkanDeviceInfo.ncmdPool(this.address(), value);
        return this;
    }

    public ktxVulkanDeviceInfo pAllocator(@NativeType(value="VkAllocationCallbacks const *") @Nullable VkAllocationCallbacks value) {
        ktxVulkanDeviceInfo.npAllocator(this.address(), value);
        return this;
    }

    public ktxVulkanDeviceInfo deviceMemoryProperties(VkPhysicalDeviceMemoryProperties value) {
        ktxVulkanDeviceInfo.ndeviceMemoryProperties(this.address(), value);
        return this;
    }

    public ktxVulkanDeviceInfo vkFuncs(ktxVulkanFunctions value) {
        ktxVulkanDeviceInfo.nvkFuncs(this.address(), value);
        return this;
    }

    public ktxVulkanDeviceInfo vkFuncs(Consumer<ktxVulkanFunctions> consumer) {
        consumer.accept(this.vkFuncs());
        return this;
    }

    public ktxVulkanDeviceInfo set(VkInstance instance, VkPhysicalDevice physicalDevice, VkDevice device, VkQueue queue, VkCommandBuffer cmdBuffer, long cmdPool, @Nullable VkAllocationCallbacks pAllocator, VkPhysicalDeviceMemoryProperties deviceMemoryProperties, ktxVulkanFunctions vkFuncs) {
        this.instance(instance);
        this.physicalDevice(physicalDevice);
        this.device(device);
        this.queue(queue);
        this.cmdBuffer(cmdBuffer);
        this.cmdPool(cmdPool);
        this.pAllocator(pAllocator);
        this.deviceMemoryProperties(deviceMemoryProperties);
        this.vkFuncs(vkFuncs);
        return this;
    }

    public ktxVulkanDeviceInfo set(ktxVulkanDeviceInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static ktxVulkanDeviceInfo malloc() {
        return new ktxVulkanDeviceInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static ktxVulkanDeviceInfo calloc() {
        return new ktxVulkanDeviceInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static ktxVulkanDeviceInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new ktxVulkanDeviceInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static ktxVulkanDeviceInfo create(long address) {
        return new ktxVulkanDeviceInfo(address, null);
    }

    public static @Nullable ktxVulkanDeviceInfo createSafe(long address) {
        return address == 0L ? null : new ktxVulkanDeviceInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)ktxVulkanDeviceInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ktxVulkanDeviceInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static ktxVulkanDeviceInfo malloc(MemoryStack stack) {
        return new ktxVulkanDeviceInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static ktxVulkanDeviceInfo calloc(MemoryStack stack) {
        return new ktxVulkanDeviceInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ninstance(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)INSTANCE));
    }

    public static long nphysicalDevice(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PHYSICALDEVICE));
    }

    public static long ndevice(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)DEVICE));
    }

    public static long nqueue(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)QUEUE));
    }

    public static long ncmdBuffer(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)CMDBUFFER));
    }

    public static long ncmdPool(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)CMDPOOL));
    }

    public static @Nullable VkAllocationCallbacks npAllocator(long struct) {
        return VkAllocationCallbacks.createSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PALLOCATOR)));
    }

    public static VkPhysicalDeviceMemoryProperties ndeviceMemoryProperties(long struct) {
        return VkPhysicalDeviceMemoryProperties.create((long)(struct + (long)DEVICEMEMORYPROPERTIES));
    }

    public static ktxVulkanFunctions nvkFuncs(long struct) {
        return ktxVulkanFunctions.create(struct + (long)VKFUNCS);
    }

    public static void ninstance(long struct, VkInstance value) {
        MemoryUtil.memPutAddress((long)(struct + (long)INSTANCE), (long)value.address());
    }

    public static void nphysicalDevice(long struct, VkPhysicalDevice value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PHYSICALDEVICE), (long)value.address());
    }

    public static void ndevice(long struct, VkDevice value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DEVICE), (long)value.address());
    }

    public static void nqueue(long struct, VkQueue value) {
        MemoryUtil.memPutAddress((long)(struct + (long)QUEUE), (long)value.address());
    }

    public static void ncmdBuffer(long struct, VkCommandBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CMDBUFFER), (long)value.address());
    }

    public static void ncmdPool(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)CMDPOOL), (long)value);
    }

    public static void npAllocator(long struct, @Nullable VkAllocationCallbacks value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PALLOCATOR), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void ndeviceMemoryProperties(long struct, VkPhysicalDeviceMemoryProperties value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)DEVICEMEMORYPROPERTIES), (long)VkPhysicalDeviceMemoryProperties.SIZEOF);
    }

    public static void nvkFuncs(long struct, ktxVulkanFunctions value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)VKFUNCS), (long)ktxVulkanFunctions.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)INSTANCE)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PHYSICALDEVICE)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)DEVICE)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)QUEUE)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)CMDBUFFER)));
        ktxVulkanFunctions.validate(struct + (long)VKFUNCS);
    }

    static {
        Struct.Layout layout = ktxVulkanDeviceInfo.__struct((Struct.Member[])new Struct.Member[]{ktxVulkanDeviceInfo.__member((int)POINTER_SIZE), ktxVulkanDeviceInfo.__member((int)POINTER_SIZE), ktxVulkanDeviceInfo.__member((int)POINTER_SIZE), ktxVulkanDeviceInfo.__member((int)POINTER_SIZE), ktxVulkanDeviceInfo.__member((int)POINTER_SIZE), ktxVulkanDeviceInfo.__member((int)8), ktxVulkanDeviceInfo.__member((int)POINTER_SIZE), ktxVulkanDeviceInfo.__member((int)VkPhysicalDeviceMemoryProperties.SIZEOF, (int)VkPhysicalDeviceMemoryProperties.ALIGNOF), ktxVulkanDeviceInfo.__member((int)ktxVulkanFunctions.SIZEOF, (int)ktxVulkanFunctions.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        INSTANCE = layout.offsetof(0);
        PHYSICALDEVICE = layout.offsetof(1);
        DEVICE = layout.offsetof(2);
        QUEUE = layout.offsetof(3);
        CMDBUFFER = layout.offsetof(4);
        CMDPOOL = layout.offsetof(5);
        PALLOCATOR = layout.offsetof(6);
        DEVICEMEMORYPROPERTIES = layout.offsetof(7);
        VKFUNCS = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<ktxVulkanDeviceInfo, Buffer>
    implements NativeResource {
        private static final ktxVulkanDeviceInfo ELEMENT_FACTORY = ktxVulkanDeviceInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected ktxVulkanDeviceInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkInstance")
        public long instance() {
            return ktxVulkanDeviceInfo.ninstance(this.address());
        }

        @NativeType(value="VkPhysicalDevice")
        public long physicalDevice() {
            return ktxVulkanDeviceInfo.nphysicalDevice(this.address());
        }

        @NativeType(value="VkDevice")
        public long device() {
            return ktxVulkanDeviceInfo.ndevice(this.address());
        }

        @NativeType(value="VkQueue")
        public long queue() {
            return ktxVulkanDeviceInfo.nqueue(this.address());
        }

        @NativeType(value="VkCommandBuffer")
        public long cmdBuffer() {
            return ktxVulkanDeviceInfo.ncmdBuffer(this.address());
        }

        @NativeType(value="VkCommandPool")
        public long cmdPool() {
            return ktxVulkanDeviceInfo.ncmdPool(this.address());
        }

        @NativeType(value="VkAllocationCallbacks const *")
        public @Nullable VkAllocationCallbacks pAllocator() {
            return ktxVulkanDeviceInfo.npAllocator(this.address());
        }

        public VkPhysicalDeviceMemoryProperties deviceMemoryProperties() {
            return ktxVulkanDeviceInfo.ndeviceMemoryProperties(this.address());
        }

        public ktxVulkanFunctions vkFuncs() {
            return ktxVulkanDeviceInfo.nvkFuncs(this.address());
        }

        public Buffer instance(VkInstance value) {
            ktxVulkanDeviceInfo.ninstance(this.address(), value);
            return this;
        }

        public Buffer physicalDevice(VkPhysicalDevice value) {
            ktxVulkanDeviceInfo.nphysicalDevice(this.address(), value);
            return this;
        }

        public Buffer device(VkDevice value) {
            ktxVulkanDeviceInfo.ndevice(this.address(), value);
            return this;
        }

        public Buffer queue(VkQueue value) {
            ktxVulkanDeviceInfo.nqueue(this.address(), value);
            return this;
        }

        public Buffer cmdBuffer(VkCommandBuffer value) {
            ktxVulkanDeviceInfo.ncmdBuffer(this.address(), value);
            return this;
        }

        public Buffer cmdPool(@NativeType(value="VkCommandPool") long value) {
            ktxVulkanDeviceInfo.ncmdPool(this.address(), value);
            return this;
        }

        public Buffer pAllocator(@NativeType(value="VkAllocationCallbacks const *") @Nullable VkAllocationCallbacks value) {
            ktxVulkanDeviceInfo.npAllocator(this.address(), value);
            return this;
        }

        public Buffer deviceMemoryProperties(VkPhysicalDeviceMemoryProperties value) {
            ktxVulkanDeviceInfo.ndeviceMemoryProperties(this.address(), value);
            return this;
        }

        public Buffer vkFuncs(ktxVulkanFunctions value) {
            ktxVulkanDeviceInfo.nvkFuncs(this.address(), value);
            return this;
        }

        public Buffer vkFuncs(Consumer<ktxVulkanFunctions> consumer) {
            consumer.accept(this.vkFuncs());
            return this;
        }
    }
}

