/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.libdivide;

import org.lwjgl.system.Library;
import org.lwjgl.system.MathUtil;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Platform;
import org.lwjgl.util.libdivide.LibDivideS16;
import org.lwjgl.util.libdivide.LibDivideS16BranchFree;
import org.lwjgl.util.libdivide.LibDivideS32;
import org.lwjgl.util.libdivide.LibDivideS32BranchFree;
import org.lwjgl.util.libdivide.LibDivideS64;
import org.lwjgl.util.libdivide.LibDivideS64BranchFree;
import org.lwjgl.util.libdivide.LibDivideU16;
import org.lwjgl.util.libdivide.LibDivideU16BranchFree;
import org.lwjgl.util.libdivide.LibDivideU32;
import org.lwjgl.util.libdivide.LibDivideU32BranchFree;
import org.lwjgl.util.libdivide.LibDivideU64;
import org.lwjgl.util.libdivide.LibDivideU64BranchFree;

public class LibDivide {
    public static final int LIBDIVIDE_VERSION_MAJOR = 5;
    public static final int LIBDIVIDE_VERSION_MINOR = 1;
    public static final int LIBDIVIDE_16_SHIFT_MASK = 31;
    public static final int LIBDIVIDE_32_SHIFT_MASK = 31;
    public static final int LIBDIVIDE_64_SHIFT_MASK = 63;
    public static final int LIBDIVIDE_ADD_MARKER = 64;
    public static final int LIBDIVIDE_NEGATIVE_DIVISOR = 128;

    protected LibDivide() {
        throw new UnsupportedOperationException();
    }

    static native void nlibdivide_s16_gen_ref(short var0, long var1);

    @NativeType(value="struct libdivide_s16_t")
    static LibDivideS16 libdivide_s16_gen_ref(@NativeType(value="int16_t") short denom, @NativeType(value="struct libdivide_s16_t") LibDivideS16 __result) {
        LibDivide.nlibdivide_s16_gen_ref(denom, __result.address());
        return __result;
    }

    static native void nlibdivide_u16_gen_ref(short var0, long var1);

    @NativeType(value="struct libdivide_u16_t")
    static LibDivideU16 libdivide_u16_gen_ref(@NativeType(value="uint16_t") short denom, @NativeType(value="struct libdivide_u16_t") LibDivideU16 __result) {
        LibDivide.nlibdivide_u16_gen_ref(denom, __result.address());
        return __result;
    }

    static native void nlibdivide_s32_gen_ref(int var0, long var1);

    @NativeType(value="struct libdivide_s32_t")
    static LibDivideS32 libdivide_s32_gen_ref(@NativeType(value="int32_t") int denom, @NativeType(value="struct libdivide_s32_t") LibDivideS32 __result) {
        LibDivide.nlibdivide_s32_gen_ref(denom, __result.address());
        return __result;
    }

    static native void nlibdivide_u32_gen_ref(int var0, long var1);

    @NativeType(value="struct libdivide_u32_t")
    static LibDivideU32 libdivide_u32_gen_ref(@NativeType(value="uint32_t") int denom, @NativeType(value="struct libdivide_u32_t") LibDivideU32 __result) {
        LibDivide.nlibdivide_u32_gen_ref(denom, __result.address());
        return __result;
    }

    static native void nlibdivide_s64_gen_ref(long var0, long var2);

    @NativeType(value="struct libdivide_s64_t")
    static LibDivideS64 libdivide_s64_gen_ref(@NativeType(value="int64_t") long denom, @NativeType(value="struct libdivide_s64_t") LibDivideS64 __result) {
        LibDivide.nlibdivide_s64_gen_ref(denom, __result.address());
        return __result;
    }

    static native void nlibdivide_u64_gen_ref(long var0, long var2);

    @NativeType(value="struct libdivide_u64_t")
    static LibDivideU64 libdivide_u64_gen_ref(@NativeType(value="uint64_t") long denom, @NativeType(value="struct libdivide_u64_t") LibDivideU64 __result) {
        LibDivide.nlibdivide_u64_gen_ref(denom, __result.address());
        return __result;
    }

    static native void nlibdivide_s16_branchfree_gen_ref(short var0, long var1);

    @NativeType(value="struct libdivide_s16_branchfree_t")
    static LibDivideS16BranchFree libdivide_s16_branchfree_gen_ref(@NativeType(value="int16_t") short denom, @NativeType(value="struct libdivide_s16_branchfree_t") LibDivideS16BranchFree __result) {
        LibDivide.nlibdivide_s16_branchfree_gen_ref(denom, __result.address());
        return __result;
    }

    static native void nlibdivide_u16_branchfree_gen_ref(short var0, long var1);

    @NativeType(value="struct libdivide_u16_branchfree_t")
    static LibDivideU16BranchFree libdivide_u16_branchfree_gen_ref(@NativeType(value="uint16_t") short denom, @NativeType(value="struct libdivide_u16_branchfree_t") LibDivideU16BranchFree __result) {
        LibDivide.nlibdivide_u16_branchfree_gen_ref(denom, __result.address());
        return __result;
    }

    static native void nlibdivide_s32_branchfree_gen_ref(int var0, long var1);

    @NativeType(value="struct libdivide_s32_branchfree_t")
    static LibDivideS32BranchFree libdivide_s32_branchfree_gen_ref(@NativeType(value="int32_t") int denom, @NativeType(value="struct libdivide_s32_branchfree_t") LibDivideS32BranchFree __result) {
        LibDivide.nlibdivide_s32_branchfree_gen_ref(denom, __result.address());
        return __result;
    }

    static native void nlibdivide_u32_branchfree_gen_ref(int var0, long var1);

    @NativeType(value="struct libdivide_u32_branchfree_t")
    static LibDivideU32BranchFree libdivide_u32_branchfree_gen_ref(@NativeType(value="uint32_t") int denom, @NativeType(value="struct libdivide_u32_branchfree_t") LibDivideU32BranchFree __result) {
        LibDivide.nlibdivide_u32_branchfree_gen_ref(denom, __result.address());
        return __result;
    }

    static native void nlibdivide_s64_branchfree_gen_ref(long var0, long var2);

    @NativeType(value="struct libdivide_s64_branchfree_t")
    static LibDivideS64BranchFree libdivide_s64_branchfree_gen_ref(@NativeType(value="int64_t") long denom, @NativeType(value="struct libdivide_s64_branchfree_t") LibDivideS64BranchFree __result) {
        LibDivide.nlibdivide_s64_branchfree_gen_ref(denom, __result.address());
        return __result;
    }

    static native void nlibdivide_u64_branchfree_gen_ref(long var0, long var2);

    @NativeType(value="struct libdivide_u64_branchfree_t")
    static LibDivideU64BranchFree libdivide_u64_branchfree_gen_ref(@NativeType(value="uint64_t") long denom, @NativeType(value="struct libdivide_u64_branchfree_t") LibDivideU64BranchFree __result) {
        LibDivide.nlibdivide_u64_branchfree_gen_ref(denom, __result.address());
        return __result;
    }

    static native short nlibdivide_s16_do_ref(short var0, long var1);

    @NativeType(value="int16_t")
    static short libdivide_s16_do_ref(@NativeType(value="int16_t") short numer, @NativeType(value="struct libdivide_s16_t const *") LibDivideS16 denom) {
        return LibDivide.nlibdivide_s16_do_ref(numer, denom.address());
    }

    static native short nlibdivide_u16_do_ref(short var0, long var1);

    @NativeType(value="uint16_t")
    static short libdivide_u16_do_ref(@NativeType(value="uint16_t") short numer, @NativeType(value="struct libdivide_u16_t const *") LibDivideU16 denom) {
        return LibDivide.nlibdivide_u16_do_ref(numer, denom.address());
    }

    static native int nlibdivide_s32_do_ref(int var0, long var1);

    @NativeType(value="int32_t")
    static int libdivide_s32_do_ref(@NativeType(value="int32_t") int numer, @NativeType(value="struct libdivide_s32_t const *") LibDivideS32 denom) {
        return LibDivide.nlibdivide_s32_do_ref(numer, denom.address());
    }

    static native int nlibdivide_u32_do_ref(int var0, long var1);

    @NativeType(value="uint32_t")
    static int libdivide_u32_do_ref(@NativeType(value="uint32_t") int numer, @NativeType(value="struct libdivide_u32_t const *") LibDivideU32 denom) {
        return LibDivide.nlibdivide_u32_do_ref(numer, denom.address());
    }

    static native long nlibdivide_s64_do_ref(long var0, long var2);

    @NativeType(value="int64_t")
    static long libdivide_s64_do_ref(@NativeType(value="int64_t") long numer, @NativeType(value="struct libdivide_s64_t const *") LibDivideS64 denom) {
        return LibDivide.nlibdivide_s64_do_ref(numer, denom.address());
    }

    static native long nlibdivide_u64_do_ref(long var0, long var2);

    @NativeType(value="uint64_t")
    static long libdivide_u64_do_ref(@NativeType(value="uint64_t") long numer, @NativeType(value="struct libdivide_u64_t const *") LibDivideU64 denom) {
        return LibDivide.nlibdivide_u64_do_ref(numer, denom.address());
    }

    static native short nlibdivide_s16_branchfree_do_ref(short var0, long var1);

    @NativeType(value="int16_t")
    static short libdivide_s16_branchfree_do_ref(@NativeType(value="int16_t") short numer, @NativeType(value="struct libdivide_s16_branchfree_t const *") LibDivideS16BranchFree denom) {
        return LibDivide.nlibdivide_s16_branchfree_do_ref(numer, denom.address());
    }

    static native short nlibdivide_u16_branchfree_do_ref(short var0, long var1);

    @NativeType(value="uint16_t")
    static short libdivide_u16_branchfree_do_ref(@NativeType(value="uint16_t") short numer, @NativeType(value="struct libdivide_u16_branchfree_t const *") LibDivideU16BranchFree denom) {
        return LibDivide.nlibdivide_u16_branchfree_do_ref(numer, denom.address());
    }

    static native int nlibdivide_s32_branchfree_do_ref(int var0, long var1);

    @NativeType(value="int32_t")
    static int libdivide_s32_branchfree_do_ref(@NativeType(value="int32_t") int numer, @NativeType(value="struct libdivide_s32_branchfree_t const *") LibDivideS32BranchFree denom) {
        return LibDivide.nlibdivide_s32_branchfree_do_ref(numer, denom.address());
    }

    static native int nlibdivide_u32_branchfree_do_ref(int var0, long var1);

    @NativeType(value="uint32_t")
    static int libdivide_u32_branchfree_do_ref(@NativeType(value="uint32_t") int numer, @NativeType(value="struct libdivide_u32_branchfree_t const *") LibDivideU32BranchFree denom) {
        return LibDivide.nlibdivide_u32_branchfree_do_ref(numer, denom.address());
    }

    static native long nlibdivide_s64_branchfree_do_ref(long var0, long var2);

    @NativeType(value="int64_t")
    static long libdivide_s64_branchfree_do_ref(@NativeType(value="int64_t") long numer, @NativeType(value="struct libdivide_s64_branchfree_t const *") LibDivideS64BranchFree denom) {
        return LibDivide.nlibdivide_s64_branchfree_do_ref(numer, denom.address());
    }

    static native long nlibdivide_u64_branchfree_do_ref(long var0, long var2);

    @NativeType(value="uint64_t")
    static long libdivide_u64_branchfree_do_ref(@NativeType(value="uint64_t") long numer, @NativeType(value="struct libdivide_u64_branchfree_t const *") LibDivideU64BranchFree denom) {
        return LibDivide.nlibdivide_u64_branchfree_do_ref(numer, denom.address());
    }

    public static native short nlibdivide_s16_recover(long var0);

    @NativeType(value="int16_t")
    public static short libdivide_s16_recover(@NativeType(value="struct libdivide_s16_t const *") LibDivideS16 denom) {
        return LibDivide.nlibdivide_s16_recover(denom.address());
    }

    public static native short nlibdivide_u16_recover(long var0);

    @NativeType(value="uint16_t")
    public static short libdivide_u16_recover(@NativeType(value="struct libdivide_u16_t const *") LibDivideU16 denom) {
        return LibDivide.nlibdivide_u16_recover(denom.address());
    }

    public static native int nlibdivide_s32_recover(long var0);

    @NativeType(value="int32_t")
    public static int libdivide_s32_recover(@NativeType(value="struct libdivide_s32_t const *") LibDivideS32 denom) {
        return LibDivide.nlibdivide_s32_recover(denom.address());
    }

    public static native int nlibdivide_u32_recover(long var0);

    @NativeType(value="uint32_t")
    public static int libdivide_u32_recover(@NativeType(value="struct libdivide_u32_t const *") LibDivideU32 denom) {
        return LibDivide.nlibdivide_u32_recover(denom.address());
    }

    public static native long nlibdivide_s64_recover(long var0);

    @NativeType(value="int64_t")
    public static long libdivide_s64_recover(@NativeType(value="struct libdivide_s64_t const *") LibDivideS64 denom) {
        return LibDivide.nlibdivide_s64_recover(denom.address());
    }

    public static native long nlibdivide_u64_recover(long var0);

    @NativeType(value="uint64_t")
    public static long libdivide_u64_recover(@NativeType(value="struct libdivide_u64_t const *") LibDivideU64 denom) {
        return LibDivide.nlibdivide_u64_recover(denom.address());
    }

    public static native short nlibdivide_s16_branchfree_recover(long var0);

    @NativeType(value="int16_t")
    public static short libdivide_s16_branchfree_recover(@NativeType(value="struct libdivide_s16_branchfree_t const *") LibDivideS16BranchFree denom) {
        return LibDivide.nlibdivide_s16_branchfree_recover(denom.address());
    }

    public static native short nlibdivide_u16_branchfree_recover(long var0);

    @NativeType(value="uint16_t")
    public static short libdivide_u16_branchfree_recover(@NativeType(value="struct libdivide_u16_branchfree_t const *") LibDivideU16BranchFree denom) {
        return LibDivide.nlibdivide_u16_branchfree_recover(denom.address());
    }

    public static native int nlibdivide_s32_branchfree_recover(long var0);

    @NativeType(value="int32_t")
    public static int libdivide_s32_branchfree_recover(@NativeType(value="struct libdivide_s32_branchfree_t const *") LibDivideS32BranchFree denom) {
        return LibDivide.nlibdivide_s32_branchfree_recover(denom.address());
    }

    public static native int nlibdivide_u32_branchfree_recover(long var0);

    @NativeType(value="uint32_t")
    public static int libdivide_u32_branchfree_recover(@NativeType(value="struct libdivide_u32_branchfree_t const *") LibDivideU32BranchFree denom) {
        return LibDivide.nlibdivide_u32_branchfree_recover(denom.address());
    }

    public static native long nlibdivide_s64_branchfree_recover(long var0);

    @NativeType(value="int64_t")
    public static long libdivide_s64_branchfree_recover(@NativeType(value="struct libdivide_s64_branchfree_t const *") LibDivideS64BranchFree denom) {
        return LibDivide.nlibdivide_s64_branchfree_recover(denom.address());
    }

    public static native long nlibdivide_u64_branchfree_recover(long var0);

    @NativeType(value="uint64_t")
    public static long libdivide_u64_branchfree_recover(@NativeType(value="struct libdivide_u64_branchfree_t const *") LibDivideU64BranchFree denom) {
        return LibDivide.nlibdivide_u64_branchfree_recover(denom.address());
    }

    @NativeType(value="struct libdivide_s16_t")
    public static LibDivideS16 libdivide_s16_gen(@NativeType(value="int16_t") short denom, @NativeType(value="struct libdivide_s16_t") LibDivideS16 __result) {
        int more;
        int magic;
        if (denom == 0) {
            throw new IllegalArgumentException("divider must be != 0");
        }
        short absD = denom < 0 ? -denom : denom;
        int floor_log_2_d = 31 - Integer.numberOfLeadingZeros(absD);
        if ((absD & absD - 1) == 0) {
            magic = 0;
            more = floor_log_2_d | (denom < 0 ? 128 : 0);
        } else {
            int l = 1 << 15 + floor_log_2_d;
            magic = l / absD;
            int rem = l % absD;
            if (absD - rem < 1 << floor_log_2_d) {
                more = floor_log_2_d - 1;
            } else {
                more = floor_log_2_d | 0x40;
                magic <<= 1;
            }
            ++magic;
            if (denom < 0) {
                more |= 0x80;
                magic = -magic;
            }
        }
        __result.magic((short)magic);
        __result.more((byte)more);
        return __result;
    }

    @NativeType(value="struct libdivide_u16_t")
    public static LibDivideU16 libdivide_u16_gen(@NativeType(value="uint16_t") short denom, @NativeType(value="struct libdivide_u16_t") LibDivideU16 __result) {
        int more;
        int magic;
        if (denom == 0) {
            throw new IllegalArgumentException("divider must be != 0");
        }
        int d = Short.toUnsignedInt(denom);
        int floor_log_2_d = 31 - Integer.numberOfLeadingZeros(d);
        if ((d & d - 1) == 0) {
            magic = 0;
            more = floor_log_2_d;
        } else {
            int l = 1 << 16 + floor_log_2_d;
            magic = Integer.divideUnsigned(l, d);
            int rem = l - magic * d;
            if (d - rem < 1 << floor_log_2_d) {
                more = floor_log_2_d;
            } else {
                more = floor_log_2_d | 0x40;
                magic <<= 1;
            }
            ++magic;
        }
        __result.magic((short)magic);
        __result.more((byte)more);
        return __result;
    }

    @NativeType(value="struct libdivide_s32_t")
    public static LibDivideS32 libdivide_s32_gen(@NativeType(value="int32_t") int denom, @NativeType(value="struct libdivide_s32_t") LibDivideS32 __result) {
        int more;
        int magic;
        if (denom == 0) {
            throw new IllegalArgumentException("divider must be != 0");
        }
        int absD = denom < 0 ? -denom : denom;
        int floor_log_2_d = 31 - Integer.numberOfLeadingZeros(absD);
        if ((absD & absD - 1) == 0) {
            magic = 0;
            more = floor_log_2_d | (denom < 0 ? 128 : 0);
        } else {
            long l = 1L << 31 + floor_log_2_d;
            magic = (int)(l / (long)absD);
            int rem = (int)(l % (long)absD);
            if (absD - rem < 1 << floor_log_2_d) {
                more = floor_log_2_d - 1;
            } else {
                more = floor_log_2_d | 0x40;
                magic <<= 1;
            }
            ++magic;
            if (denom < 0) {
                more |= 0x80;
                magic = -magic;
            }
        }
        __result.magic(magic);
        __result.more((byte)more);
        return __result;
    }

    @NativeType(value="struct libdivide_u32_t")
    public static LibDivideU32 libdivide_u32_gen(@NativeType(value="uint32_t") int denom, @NativeType(value="struct libdivide_u32_t") LibDivideU32 __result) {
        int more;
        int magic;
        if (denom == 0) {
            throw new IllegalArgumentException("divider must be != 0");
        }
        int floor_log_2_d = 31 - Integer.numberOfLeadingZeros(denom);
        if ((denom & denom - 1) == 0) {
            magic = 0;
            more = floor_log_2_d;
        } else {
            long l = 1L << 32 + floor_log_2_d;
            magic = (int)MathUtil.mathDivideUnsigned((long)l, (long)Integer.toUnsignedLong(denom));
            int rem = (int)(l - (long)magic * Integer.toUnsignedLong(denom));
            if (Integer.compareUnsigned(denom - rem, 1 << floor_log_2_d) < 0) {
                more = floor_log_2_d;
            } else {
                more = floor_log_2_d | 0x40;
                magic <<= 1;
            }
            ++magic;
        }
        __result.magic(magic);
        __result.more((byte)more);
        return __result;
    }

    @NativeType(value="struct libdivide_s64_t")
    public static LibDivideS64 libdivide_s64_gen(@NativeType(value="int64_t") long denom, @NativeType(value="struct libdivide_s64_t") LibDivideS64 __result) {
        int more;
        long magic;
        if (denom == 0L) {
            throw new IllegalArgumentException("divider must be != 0");
        }
        long absD = denom < 0L ? -denom : denom;
        int floor_log_2_d = 63 - Long.numberOfLeadingZeros(absD);
        if ((absD & absD - 1L) == 0L) {
            magic = 0L;
            more = floor_log_2_d | (denom < 0L ? 128 : 0);
        } else {
            magic = LibDivide.libdivide_128_div_64_to_64(1L << floor_log_2_d - 1, 0L, absD, __result.address());
            long rem = __result.magic();
            if (absD - rem < 1L << floor_log_2_d) {
                more = floor_log_2_d - 1;
            } else {
                more = floor_log_2_d | 0x40;
                magic <<= 1;
            }
            ++magic;
            if (denom < 0L) {
                more |= 0x80;
                magic = -magic;
            }
        }
        __result.magic(magic);
        __result.more((byte)more);
        return __result;
    }

    @NativeType(value="struct libdivide_u64_t")
    public static LibDivideU64 libdivide_u64_gen(@NativeType(value="uint64_t") long denom, @NativeType(value="struct libdivide_u64_t") LibDivideU64 __result) {
        int more;
        long magic;
        if (denom == 0L) {
            throw new IllegalArgumentException("divider must be != 0");
        }
        int floor_log_2_d = 63 - Long.numberOfLeadingZeros(denom);
        if ((denom & denom - 1L) == 0L) {
            magic = 0L;
            more = floor_log_2_d;
        } else {
            magic = LibDivide.libdivide_128_div_64_to_64(1L << floor_log_2_d, 0L, denom, __result.address());
            long rem = __result.magic();
            if (Long.compareUnsigned(denom - rem, 1L << floor_log_2_d) < 0) {
                more = floor_log_2_d;
            } else {
                more = floor_log_2_d | 0x40;
                magic <<= 1;
            }
            ++magic;
        }
        __result.magic(magic);
        __result.more((byte)more);
        return __result;
    }

    @NativeType(value="struct libdivide_s16_branchfree_t")
    public static LibDivideS16BranchFree libdivide_s16_branchfree_gen(@NativeType(value="int16_t") short denom, @NativeType(value="struct libdivide_s16_branchfree_t") LibDivideS16BranchFree __result) {
        int more;
        int magic;
        if (denom == 0) {
            throw new IllegalArgumentException("divider must be != 0");
        }
        short absD = denom < 0 ? -denom : denom;
        int floor_log_2_d = 31 - Integer.numberOfLeadingZeros(absD);
        if ((absD & absD - 1) == 0) {
            magic = 0;
            more = floor_log_2_d | (denom < 0 ? 128 : 0);
        } else {
            int l = 1 << 15 + floor_log_2_d;
            magic = l / absD;
            int rem = l % absD;
            magic = (magic << 1) + 1;
            if (absD < rem << 1) {
                ++magic;
            }
            more = floor_log_2_d | 0x40;
            if (denom < 0) {
                more |= 0x80;
            }
        }
        __result.magic((short)magic);
        __result.more((byte)more);
        return __result;
    }

    @NativeType(value="struct libdivide_u16_branchfree_t")
    public static LibDivideU16BranchFree libdivide_u16_branchfree_gen(@NativeType(value="uint16_t") short denom, @NativeType(value="struct libdivide_u16_branchfree_t") LibDivideU16BranchFree __result) {
        int more;
        int magic;
        if (denom == 0) {
            throw new IllegalArgumentException("divider must be != 0");
        }
        if (denom == 1) {
            throw new IllegalArgumentException("branchfree divider must be != 1");
        }
        int d = Short.toUnsignedInt(denom);
        int floor_log_2_d = 31 - Integer.numberOfLeadingZeros(d);
        if ((d & d - 1) == 0) {
            magic = 0;
            more = floor_log_2_d - 1;
        } else {
            int l = 1 << 16 + floor_log_2_d;
            magic = Integer.divideUnsigned(l, d);
            int rem = l - magic * d;
            magic = (magic << 1) + 1;
            if (d < rem << 1) {
                ++magic;
            }
            more = floor_log_2_d | 0x40;
        }
        __result.magic((short)magic);
        __result.more((byte)(more & 0x1F));
        return __result;
    }

    @NativeType(value="struct libdivide_s32_branchfree_t")
    public static LibDivideS32BranchFree libdivide_s32_branchfree_gen(@NativeType(value="int32_t") int denom, @NativeType(value="struct libdivide_s32_branchfree_t") LibDivideS32BranchFree __result) {
        int more;
        int magic;
        if (denom == 0) {
            throw new IllegalArgumentException("divider must be != 0");
        }
        int absD = denom < 0 ? -denom : denom;
        int floor_log_2_d = 31 - Integer.numberOfLeadingZeros(absD);
        if ((absD & absD - 1) == 0) {
            magic = 0;
            more = floor_log_2_d | (denom < 0 ? 128 : 0);
        } else {
            long l = 1L << 31 + floor_log_2_d;
            magic = (int)(l / (long)absD);
            int rem = (int)(l % (long)absD);
            magic = (magic << 1) + 1;
            if (Integer.compareUnsigned(absD, rem << 1) < 0) {
                ++magic;
            }
            more = floor_log_2_d | 0x40;
            if (denom < 0) {
                more |= 0x80;
            }
        }
        __result.magic(magic);
        __result.more((byte)more);
        return __result;
    }

    @NativeType(value="struct libdivide_u32_branchfree_t")
    public static LibDivideU32BranchFree libdivide_u32_branchfree_gen(@NativeType(value="uint32_t") int denom, @NativeType(value="struct libdivide_u32_branchfree_t") LibDivideU32BranchFree __result) {
        int more;
        int magic;
        if (denom == 0) {
            throw new IllegalArgumentException("divider must be != 0");
        }
        if (denom == 1) {
            throw new IllegalArgumentException("branchfree divider must be != 1");
        }
        int floor_log_2_d = 31 - Integer.numberOfLeadingZeros(denom);
        if ((denom & denom - 1) == 0) {
            magic = 0;
            more = floor_log_2_d - 1;
        } else {
            long l = 1L << 32 + floor_log_2_d;
            magic = (int)MathUtil.mathDivideUnsigned((long)l, (long)Integer.toUnsignedLong(denom));
            int rem = (int)(l - (long)magic * Integer.toUnsignedLong(denom));
            magic = (magic << 1) + 1;
            if (Integer.compareUnsigned(denom, rem << 1) < 0 || Integer.compareUnsigned(rem << 1, rem) < 0) {
                ++magic;
            }
            more = floor_log_2_d | 0x40;
        }
        __result.magic(magic);
        __result.more((byte)(more & 0x1F));
        return __result;
    }

    @NativeType(value="struct libdivide_s64_branchfree_t")
    public static LibDivideS64BranchFree libdivide_s64_branchfree_gen(@NativeType(value="int64_t") long denom, @NativeType(value="struct libdivide_s64_branchfree_t") LibDivideS64BranchFree __result) {
        int more;
        long magic;
        if (denom == 0L) {
            throw new IllegalArgumentException("divider must be != 0");
        }
        long absD = denom < 0L ? -denom : denom;
        int floor_log_2_d = 63 - Long.numberOfLeadingZeros(absD);
        if ((absD & absD - 1L) == 0L) {
            magic = 0L;
            more = floor_log_2_d | (denom < 0L ? 128 : 0);
        } else {
            magic = (LibDivide.libdivide_128_div_64_to_64(1L << floor_log_2_d - 1, 0L, absD, __result.address()) << 1) + 1L;
            long rem = __result.magic();
            if (Long.compareUnsigned(absD, rem << 1) < 0) {
                ++magic;
            }
            more = floor_log_2_d | 0x40;
            if (denom < 0L) {
                more |= 0x80;
            }
        }
        __result.magic(magic);
        __result.more((byte)more);
        return __result;
    }

    @NativeType(value="struct libdivide_u64_branchfree_t")
    public static LibDivideU64BranchFree libdivide_u64_branchfree_gen(@NativeType(value="uint64_t") long denom, @NativeType(value="struct libdivide_u64_branchfree_t") LibDivideU64BranchFree __result) {
        int more;
        long magic;
        if (denom == 0L) {
            throw new IllegalArgumentException("divider must be != 0");
        }
        if (denom == 1L) {
            throw new IllegalArgumentException("branchfree divider must be != 1");
        }
        int floor_log_2_d = 63 - Long.numberOfLeadingZeros(denom);
        if ((denom & denom - 1L) == 0L) {
            magic = 0L;
            more = floor_log_2_d - 1;
        } else {
            magic = (LibDivide.libdivide_128_div_64_to_64(1L << floor_log_2_d, 0L, denom, __result.address()) << 1) + 1L;
            long rem = __result.magic();
            if (Long.compareUnsigned(denom, rem << 1) < 0 || Long.compareUnsigned(rem << 1, rem) < 0) {
                ++magic;
            }
            more = floor_log_2_d | 0x40;
        }
        __result.magic(magic);
        __result.more((byte)(more & 0x3F));
        return __result;
    }

    public static short libdivide_s16_do(@NativeType(value="int16_t") short numer, @NativeType(value="struct libdivide_s16_t const *") LibDivideS16 denom) {
        return LibDivide.libdivide_s16_do(numer, denom.magic(), denom.more());
    }

    public static short libdivide_s16_do(@NativeType(value="int16_t") short numer, @NativeType(value="int16_t") short magic, @NativeType(value="uint8_t") byte more) {
        int shift = more & 0x1F;
        if (magic == 0) {
            int sign = more >> 7;
            int mask = (1 << shift) - 1;
            int q = numer + (numer >> 15 & mask);
            q >>= shift;
            q = (q ^ sign) - sign;
            return (short)q;
        }
        int uq = LibDivide.libdivide_mullhi_s16(magic, numer);
        if ((more & 0x40) != 0) {
            int sign = more >> 7;
            uq += (numer ^ sign) - sign;
        }
        int q = uq;
        return (short)(q += (q >>= shift) < 0 ? 1 : 0);
    }

    public static short libdivide_u16_do(@NativeType(value="uint16_t") short numer, @NativeType(value="struct libdivide_u16_t const *") LibDivideU16 denom) {
        return LibDivide.libdivide_u16_do(numer, denom.magic(), denom.more());
    }

    public static short libdivide_u16_do(@NativeType(value="uint16_t") short numer, @NativeType(value="uint16_t") short magic, @NativeType(value="uint8_t") byte more) {
        int n = Short.toUnsignedInt(numer);
        if (magic == 0) {
            return (short)(n >>> more);
        }
        int q = LibDivide.libdivide_mullhi_u16(magic, numer);
        if ((more & 0x40) != 0) {
            int t = (n - q >>> 1) + q;
            return (short)(t >>> (more & 0x1F));
        }
        return (short)(q >>> more);
    }

    public static int libdivide_s32_do(@NativeType(value="int32_t") int numer, @NativeType(value="struct libdivide_s32_t const *") LibDivideS32 denom) {
        return LibDivide.libdivide_s32_do(numer, denom.magic(), denom.more());
    }

    public static int libdivide_s32_do(@NativeType(value="int32_t") int numer, @NativeType(value="int32_t") int magic, @NativeType(value="uint8_t") byte more) {
        int shift = more & 0x1F;
        if (magic == 0) {
            int sign = more >> 7;
            int mask = (1 << shift) - 1;
            int q = numer + (numer >> 31 & mask);
            q >>= shift;
            q = (q ^ sign) - sign;
            return q;
        }
        int uq = LibDivide.libdivide_mullhi_s32(magic, numer);
        if ((more & 0x40) != 0) {
            int sign = more >> 7;
            uq += (numer ^ sign) - sign;
        }
        int q = uq;
        return q += (q >>= shift) < 0 ? 1 : 0;
    }

    public static int libdivide_u32_do(@NativeType(value="uint32_t") int numer, @NativeType(value="struct libdivide_u32_t const *") LibDivideU32 denom) {
        return LibDivide.libdivide_u32_do(numer, denom.magic(), denom.more());
    }

    public static int libdivide_u32_do(@NativeType(value="uint32_t") int numer, @NativeType(value="uint32_t") int magic, @NativeType(value="uint8_t") byte more) {
        if (magic == 0) {
            return numer >>> more;
        }
        int q = LibDivide.libdivide_mullhi_u32(magic, numer);
        if ((more & 0x40) != 0) {
            int t = (numer - q >>> 1) + q;
            return t >>> (more & 0x1F);
        }
        return q >>> more;
    }

    public static long libdivide_s64_do(@NativeType(value="int64_t") long numer, @NativeType(value="struct libdivide_s64_t const *") LibDivideS64 denom) {
        return LibDivide.libdivide_s64_do(numer, denom.magic(), denom.more());
    }

    public static long libdivide_s64_do(@NativeType(value="int64_t") long numer, @NativeType(value="int64_t") long magic, @NativeType(value="uint8_t") byte more) {
        int shift = more & 0x3F;
        if (magic == 0L) {
            long mask = (1L << shift) - 1L;
            long q = numer + (numer >> 63 & mask);
            q >>= shift;
            long sign = more >> 7;
            q = (q ^ sign) - sign;
            return q;
        }
        long uq = MathUtil.mathMultiplyHighS64((long)magic, (long)numer);
        if ((more & 0x40) != 0) {
            long sign = more >> 7;
            uq += (numer ^ sign) - sign;
        }
        long q = uq;
        return q += (long)((q >>= shift) < 0L ? 1 : 0);
    }

    public static long libdivide_u64_do(@NativeType(value="uint64_t") long numer, @NativeType(value="struct libdivide_u64_t const *") LibDivideU64 denom) {
        return LibDivide.libdivide_u64_do(numer, denom.magic(), denom.more());
    }

    public static long libdivide_u64_do(@NativeType(value="uint64_t") long numer, @NativeType(value="uint64_t") long magic, @NativeType(value="uint8_t") byte more) {
        if (magic == 0L) {
            return numer >>> more;
        }
        long q = MathUtil.mathMultiplyHighU64((long)magic, (long)numer);
        if ((more & 0x40) != 0) {
            long t = (numer - q >>> 1) + q;
            return t >>> (more & 0x3F);
        }
        return q >>> more;
    }

    public static short libdivide_s16_branchfree_do(@NativeType(value="int16_t") short numer, @NativeType(value="struct libdivide_s16_branchfree_t const *") LibDivideS16BranchFree denom) {
        return LibDivide.libdivide_s16_branchfree_do(numer, denom.magic(), denom.more());
    }

    public static short libdivide_s16_branchfree_do(@NativeType(value="int16_t") short numer, @NativeType(value="int16_t") short magic, @NativeType(value="uint8_t") byte more) {
        int shift = more & 0x1F;
        int sign = more >> 7;
        int q = LibDivide.libdivide_mullhi_s16(magic, numer);
        int q_sign = (q += numer) >> 15;
        q += q_sign & (1 << shift) - (magic == 0 ? 1 : 0);
        q >>= shift;
        q = (q ^ sign) - sign;
        return (short)q;
    }

    public static short libdivide_u16_branchfree_do(@NativeType(value="uint16_t") short numer, @NativeType(value="struct libdivide_u16_branchfree_t const *") LibDivideU16BranchFree denom) {
        return LibDivide.libdivide_u16_branchfree_do(numer, denom.magic(), denom.more());
    }

    public static short libdivide_u16_branchfree_do(@NativeType(value="uint16_t") short numer, @NativeType(value="uint16_t") short magic, @NativeType(value="uint8_t") byte more) {
        int q = LibDivide.libdivide_mullhi_u16(magic, numer);
        int t = (Short.toUnsignedInt(numer) - q >>> 1) + q;
        return (short)(t >>> more);
    }

    public static int libdivide_s32_branchfree_do(@NativeType(value="int32_t") int numer, @NativeType(value="struct libdivide_s32_branchfree_t const *") LibDivideS32BranchFree denom) {
        return LibDivide.libdivide_s32_branchfree_do(numer, denom.magic(), denom.more());
    }

    public static int libdivide_s32_branchfree_do(@NativeType(value="int32_t") int numer, @NativeType(value="int32_t") int magic, @NativeType(value="uint8_t") byte more) {
        int shift = more & 0x1F;
        int sign = more >> 7;
        int q = LibDivide.libdivide_mullhi_s32(magic, numer);
        int q_sign = (q += numer) >> 31;
        q += q_sign & (1 << shift) - (magic == 0 ? 1 : 0);
        q >>= shift;
        q = (q ^ sign) - sign;
        return q;
    }

    public static int libdivide_u32_branchfree_do(@NativeType(value="uint32_t") int numer, @NativeType(value="struct libdivide_u32_branchfree_t const *") LibDivideU32BranchFree denom) {
        return LibDivide.libdivide_u32_branchfree_do(numer, denom.magic(), denom.more());
    }

    public static int libdivide_u32_branchfree_do(@NativeType(value="uint32_t") int numer, @NativeType(value="uint32_t") int magic, @NativeType(value="uint8_t") byte more) {
        int q = LibDivide.libdivide_mullhi_u32(magic, numer);
        int t = (numer - q >>> 1) + q;
        return t >>> more;
    }

    public static long libdivide_s64_branchfree_do(@NativeType(value="int64_t") long numer, @NativeType(value="struct libdivide_s64_branchfree_t const *") LibDivideS64BranchFree denom) {
        return LibDivide.libdivide_s64_branchfree_do(numer, denom.magic(), denom.more());
    }

    public static long libdivide_s64_branchfree_do(@NativeType(value="int64_t") long numer, @NativeType(value="int64_t") long magic, @NativeType(value="uint8_t") byte more) {
        int shift = more & 0x3F;
        long sign = more >> 7;
        long q = MathUtil.mathMultiplyHighS64((long)magic, (long)numer);
        long q_sign = (q += numer) >> 63;
        q += q_sign & (1L << shift) - (long)(magic == 0L ? 1 : 0);
        q >>= shift;
        q = (q ^ sign) - sign;
        return q;
    }

    public static long libdivide_u64_branchfree_do(@NativeType(value="uint64_t") long numer, @NativeType(value="struct libdivide_u64_branchfree_t const *") LibDivideU64BranchFree denom) {
        return LibDivide.libdivide_u64_branchfree_do(numer, denom.magic(), denom.more());
    }

    public static long libdivide_u64_branchfree_do(@NativeType(value="uint64_t") long numer, @NativeType(value="uint64_t") long magic, @NativeType(value="uint8_t") byte more) {
        long q = MathUtil.mathMultiplyHighU64((long)magic, (long)numer);
        long t = (numer - q >>> 1) + q;
        return t >>> more;
    }

    private static long libdivide_128_div_64_to_64(long u1, long u0, long v, long remainder) {
        long un10;
        long un64;
        long b = 0x100000000L;
        int s = Long.numberOfLeadingZeros(v);
        if (s > 0) {
            v <<= s;
            un64 = u1 << s | u0 >>> 64 - s & (long)(-s >> 31);
            un10 = u0 << s;
        } else {
            un64 = u1 | u0;
            un10 = u0;
        }
        long vn1 = v >>> 32;
        long vn0 = v & 0xFFFFFFFFL;
        long un1 = un10 >>> 32;
        long un0 = un10 & 0xFFFFFFFFL;
        long q1 = MathUtil.mathDivideUnsigned((long)un64, (long)vn1);
        long rhat = un64 - q1 * vn1;
        while (Long.compareUnsigned(b, q1) < 0 || Long.compareUnsigned(b * rhat + un1, q1 * vn0) <= 0) {
            --q1;
            if ((rhat += vn1) < b) continue;
        }
        long un21 = un64 * b + un1 - q1 * v;
        long q0 = MathUtil.mathDivideUnsigned((long)un21, (long)vn1);
        rhat = un21 - q0 * vn1;
        while (Long.compareUnsigned(b, q0) < 0 || Long.compareUnsigned(b * rhat + un0, q0 * vn0) <= 0) {
            --q0;
            if ((rhat += vn1) < b) continue;
        }
        MemoryUtil.memPutLong((long)remainder, (long)(un21 * b + un0 - q0 * v >>> s));
        return q1 * b + q0;
    }

    private static int libdivide_mullhi_s16(short x, short y) {
        return x * y >> 16;
    }

    private static int libdivide_mullhi_u16(short x, short y) {
        return (x & 0xFFFF) * (y & 0xFFFF) >>> 16;
    }

    private static int libdivide_mullhi_s32(int x, int y) {
        return (int)((long)x * (long)y >> 32);
    }

    private static int libdivide_mullhi_u32(int x, int y) {
        return (int)(((long)x & 0xFFFFFFFFL) * ((long)y & 0xFFFFFFFFL) >>> 32);
    }

    static {
        Library.loadSystem(System::load, System::loadLibrary, LibDivide.class, (String)"org.lwjgl.libdivide", (String)Platform.mapLibraryNameBundled((String)"lwjgl_libdivide"));
    }
}

