/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.libdivide;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct libdivide_s16_t")
public class LibDivideS16
extends Struct<LibDivideS16>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MAGIC;
    public static final int MORE;

    protected LibDivideS16(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected LibDivideS16 create(long address, @Nullable ByteBuffer container) {
        return new LibDivideS16(address, container);
    }

    public LibDivideS16(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), LibDivideS16.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="int16_t")
    public short magic() {
        return LibDivideS16.nmagic(this.address());
    }

    @NativeType(value="uint8_t")
    public byte more() {
        return LibDivideS16.nmore(this.address());
    }

    public LibDivideS16 magic(@NativeType(value="int16_t") short value) {
        LibDivideS16.nmagic(this.address(), value);
        return this;
    }

    public LibDivideS16 more(@NativeType(value="uint8_t") byte value) {
        LibDivideS16.nmore(this.address(), value);
        return this;
    }

    public LibDivideS16 set(short magic, byte more) {
        this.magic(magic);
        this.more(more);
        return this;
    }

    public LibDivideS16 set(LibDivideS16 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static LibDivideS16 malloc() {
        return new LibDivideS16(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static LibDivideS16 calloc() {
        return new LibDivideS16(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static LibDivideS16 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new LibDivideS16(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static LibDivideS16 create(long address) {
        return new LibDivideS16(address, null);
    }

    public static @Nullable LibDivideS16 createSafe(long address) {
        return address == 0L ? null : new LibDivideS16(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)LibDivideS16.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LibDivideS16.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static LibDivideS16 malloc(MemoryStack stack) {
        return new LibDivideS16(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static LibDivideS16 calloc(MemoryStack stack) {
        return new LibDivideS16(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static short nmagic(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)MAGIC));
    }

    public static byte nmore(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)MORE));
    }

    public static void nmagic(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)MAGIC), (short)value);
    }

    public static void nmore(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)MORE), (byte)value);
    }

    static {
        Struct.Layout layout = LibDivideS16.__struct((Struct.Member[])new Struct.Member[]{LibDivideS16.__member((int)2), LibDivideS16.__member((int)1)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MAGIC = layout.offsetof(0);
        MORE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LibDivideS16, Buffer>
    implements NativeResource {
        private static final LibDivideS16 ELEMENT_FACTORY = LibDivideS16.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected LibDivideS16 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="int16_t")
        public short magic() {
            return LibDivideS16.nmagic(this.address());
        }

        @NativeType(value="uint8_t")
        public byte more() {
            return LibDivideS16.nmore(this.address());
        }

        public Buffer magic(@NativeType(value="int16_t") short value) {
            LibDivideS16.nmagic(this.address(), value);
            return this;
        }

        public Buffer more(@NativeType(value="uint8_t") byte value) {
            LibDivideS16.nmore(this.address(), value);
            return this;
        }
    }
}

