/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.llvm.CXCursorAndRangeVisit;
import org.lwjgl.llvm.CXCursorAndRangeVisitI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXCursorAndRangeVisitor
extends Struct<CXCursorAndRangeVisitor>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CONTEXT;
    public static final int VISIT;

    protected CXCursorAndRangeVisitor(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CXCursorAndRangeVisitor create(long address, @Nullable ByteBuffer container) {
        return new CXCursorAndRangeVisitor(address, container);
    }

    public CXCursorAndRangeVisitor(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CXCursorAndRangeVisitor.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public long context() {
        return CXCursorAndRangeVisitor.ncontext(this.address());
    }

    @NativeType(value="enum CXVisitorResult (*) (void *, CXCursor, CXSourceRange)")
    public CXCursorAndRangeVisit visit() {
        return CXCursorAndRangeVisitor.nvisit(this.address());
    }

    public CXCursorAndRangeVisitor context(@NativeType(value="void *") long value) {
        CXCursorAndRangeVisitor.ncontext(this.address(), value);
        return this;
    }

    public CXCursorAndRangeVisitor visit(@NativeType(value="enum CXVisitorResult (*) (void *, CXCursor, CXSourceRange)") CXCursorAndRangeVisitI value) {
        CXCursorAndRangeVisitor.nvisit(this.address(), value);
        return this;
    }

    public CXCursorAndRangeVisitor set(long context, CXCursorAndRangeVisitI visit) {
        this.context(context);
        this.visit(visit);
        return this;
    }

    public CXCursorAndRangeVisitor set(CXCursorAndRangeVisitor src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CXCursorAndRangeVisitor malloc() {
        return new CXCursorAndRangeVisitor(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CXCursorAndRangeVisitor calloc() {
        return new CXCursorAndRangeVisitor(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CXCursorAndRangeVisitor create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CXCursorAndRangeVisitor(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CXCursorAndRangeVisitor create(long address) {
        return new CXCursorAndRangeVisitor(address, null);
    }

    public static @Nullable CXCursorAndRangeVisitor createSafe(long address) {
        return address == 0L ? null : new CXCursorAndRangeVisitor(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CXCursorAndRangeVisitor.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXCursorAndRangeVisitor.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static CXCursorAndRangeVisitor mallocStack() {
        return CXCursorAndRangeVisitor.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXCursorAndRangeVisitor callocStack() {
        return CXCursorAndRangeVisitor.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXCursorAndRangeVisitor mallocStack(MemoryStack stack) {
        return CXCursorAndRangeVisitor.malloc(stack);
    }

    @Deprecated
    public static CXCursorAndRangeVisitor callocStack(MemoryStack stack) {
        return CXCursorAndRangeVisitor.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CXCursorAndRangeVisitor.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CXCursorAndRangeVisitor.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CXCursorAndRangeVisitor.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CXCursorAndRangeVisitor.calloc(capacity, stack);
    }

    public static CXCursorAndRangeVisitor malloc(MemoryStack stack) {
        return new CXCursorAndRangeVisitor(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CXCursorAndRangeVisitor calloc(MemoryStack stack) {
        return new CXCursorAndRangeVisitor(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ncontext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)CONTEXT));
    }

    public static CXCursorAndRangeVisit nvisit(long struct) {
        return CXCursorAndRangeVisit.create(MemoryUtil.memGetAddress((long)(struct + (long)VISIT)));
    }

    public static void ncontext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CONTEXT), (long)Checks.check((long)value));
    }

    public static void nvisit(long struct, CXCursorAndRangeVisitI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)VISIT), (long)value.address());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)CONTEXT)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)VISIT)));
    }

    static {
        Struct.Layout layout = CXCursorAndRangeVisitor.__struct((Struct.Member[])new Struct.Member[]{CXCursorAndRangeVisitor.__member((int)POINTER_SIZE), CXCursorAndRangeVisitor.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CONTEXT = layout.offsetof(0);
        VISIT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CXCursorAndRangeVisitor, Buffer>
    implements NativeResource {
        private static final CXCursorAndRangeVisitor ELEMENT_FACTORY = CXCursorAndRangeVisitor.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected CXCursorAndRangeVisitor getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public long context() {
            return CXCursorAndRangeVisitor.ncontext(this.address());
        }

        @NativeType(value="enum CXVisitorResult (*) (void *, CXCursor, CXSourceRange)")
        public CXCursorAndRangeVisit visit() {
            return CXCursorAndRangeVisitor.nvisit(this.address());
        }

        public Buffer context(@NativeType(value="void *") long value) {
            CXCursorAndRangeVisitor.ncontext(this.address(), value);
            return this;
        }

        public Buffer visit(@NativeType(value="enum CXVisitorResult (*) (void *, CXCursor, CXSourceRange)") CXCursorAndRangeVisitI value) {
            CXCursorAndRangeVisitor.nvisit(this.address(), value);
            return this;
        }
    }
}

