/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXIndexOptions
extends Struct<CXIndexOptions>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SIZE;
    public static final int THREADBACKGROUNDPRIORITYFORINDEXING;
    public static final int THREADBACKGROUNDPRIORITYFOREDITING;
    public static final int BITFIELD0;
    public static final int PREAMBLESTORAGEPATH;
    public static final int INVOCATIONEMISSIONPATH;

    protected CXIndexOptions(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CXIndexOptions create(long address, @Nullable ByteBuffer container) {
        return new CXIndexOptions(address, container);
    }

    public CXIndexOptions(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CXIndexOptions.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned")
    public int Size() {
        return CXIndexOptions.nSize(this.address());
    }

    @NativeType(value="unsigned char")
    public byte ThreadBackgroundPriorityForIndexing() {
        return CXIndexOptions.nThreadBackgroundPriorityForIndexing(this.address());
    }

    @NativeType(value="unsigned char")
    public byte ThreadBackgroundPriorityForEditing() {
        return CXIndexOptions.nThreadBackgroundPriorityForEditing(this.address());
    }

    @NativeType(value="unsigned")
    public boolean ExcludeDeclarationsFromPCH() {
        return CXIndexOptions.nExcludeDeclarationsFromPCH(this.address()) != 0;
    }

    @NativeType(value="unsigned")
    public boolean DisplayDiagnostics() {
        return CXIndexOptions.nDisplayDiagnostics(this.address()) != 0;
    }

    @NativeType(value="unsigned")
    public boolean StorePreamblesInMemory() {
        return CXIndexOptions.nStorePreamblesInMemory(this.address()) != 0;
    }

    @NativeType(value="char const *")
    public @Nullable ByteBuffer PreambleStoragePath() {
        return CXIndexOptions.nPreambleStoragePath(this.address());
    }

    @NativeType(value="char const *")
    public @Nullable String PreambleStoragePathString() {
        return CXIndexOptions.nPreambleStoragePathString(this.address());
    }

    @NativeType(value="char const *")
    public @Nullable ByteBuffer InvocationEmissionPath() {
        return CXIndexOptions.nInvocationEmissionPath(this.address());
    }

    @NativeType(value="char const *")
    public @Nullable String InvocationEmissionPathString() {
        return CXIndexOptions.nInvocationEmissionPathString(this.address());
    }

    public CXIndexOptions Size(@NativeType(value="unsigned") int value) {
        CXIndexOptions.nSize(this.address(), value);
        return this;
    }

    public CXIndexOptions Size$Default() {
        return this.Size(SIZEOF);
    }

    public CXIndexOptions ThreadBackgroundPriorityForIndexing(@NativeType(value="unsigned char") byte value) {
        CXIndexOptions.nThreadBackgroundPriorityForIndexing(this.address(), value);
        return this;
    }

    public CXIndexOptions ThreadBackgroundPriorityForEditing(@NativeType(value="unsigned char") byte value) {
        CXIndexOptions.nThreadBackgroundPriorityForEditing(this.address(), value);
        return this;
    }

    public CXIndexOptions ExcludeDeclarationsFromPCH(@NativeType(value="unsigned") boolean value) {
        CXIndexOptions.nExcludeDeclarationsFromPCH(this.address(), value ? 1 : 0);
        return this;
    }

    public CXIndexOptions DisplayDiagnostics(@NativeType(value="unsigned") boolean value) {
        CXIndexOptions.nDisplayDiagnostics(this.address(), value ? 1 : 0);
        return this;
    }

    public CXIndexOptions StorePreamblesInMemory(@NativeType(value="unsigned") boolean value) {
        CXIndexOptions.nStorePreamblesInMemory(this.address(), value ? 1 : 0);
        return this;
    }

    public CXIndexOptions PreambleStoragePath(@NativeType(value="char const *") @Nullable ByteBuffer value) {
        CXIndexOptions.nPreambleStoragePath(this.address(), value);
        return this;
    }

    public CXIndexOptions InvocationEmissionPath(@NativeType(value="char const *") @Nullable ByteBuffer value) {
        CXIndexOptions.nInvocationEmissionPath(this.address(), value);
        return this;
    }

    public CXIndexOptions set(int Size, byte ThreadBackgroundPriorityForIndexing, byte ThreadBackgroundPriorityForEditing, boolean ExcludeDeclarationsFromPCH, boolean DisplayDiagnostics, boolean StorePreamblesInMemory, @Nullable ByteBuffer PreambleStoragePath, @Nullable ByteBuffer InvocationEmissionPath) {
        this.Size(Size);
        this.ThreadBackgroundPriorityForIndexing(ThreadBackgroundPriorityForIndexing);
        this.ThreadBackgroundPriorityForEditing(ThreadBackgroundPriorityForEditing);
        this.ExcludeDeclarationsFromPCH(ExcludeDeclarationsFromPCH);
        this.DisplayDiagnostics(DisplayDiagnostics);
        this.StorePreamblesInMemory(StorePreamblesInMemory);
        this.PreambleStoragePath(PreambleStoragePath);
        this.InvocationEmissionPath(InvocationEmissionPath);
        return this;
    }

    public CXIndexOptions set(CXIndexOptions src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CXIndexOptions malloc() {
        return new CXIndexOptions(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CXIndexOptions calloc() {
        return new CXIndexOptions(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CXIndexOptions create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CXIndexOptions(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CXIndexOptions create(long address) {
        return new CXIndexOptions(address, null);
    }

    public static @Nullable CXIndexOptions createSafe(long address) {
        return address == 0L ? null : new CXIndexOptions(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CXIndexOptions.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXIndexOptions.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CXIndexOptions malloc(MemoryStack stack) {
        return new CXIndexOptions(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CXIndexOptions calloc(MemoryStack stack) {
        return new CXIndexOptions(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nSize(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SIZE));
    }

    public static byte nThreadBackgroundPriorityForIndexing(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)THREADBACKGROUNDPRIORITYFORINDEXING));
    }

    public static byte nThreadBackgroundPriorityForEditing(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)THREADBACKGROUNDPRIORITYFOREDITING));
    }

    public static int nbitfield0(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BITFIELD0));
    }

    public static int nExcludeDeclarationsFromPCH(long struct) {
        return CXIndexOptions.nbitfield0(struct) & 1;
    }

    public static int nDisplayDiagnostics(long struct) {
        return (CXIndexOptions.nbitfield0(struct) & 2) >>> 1;
    }

    public static int nStorePreamblesInMemory(long struct) {
        return (CXIndexOptions.nbitfield0(struct) & 4) >>> 2;
    }

    public static int nReserved(long struct) {
        return (CXIndexOptions.nbitfield0(struct) & 0xFFF8) >>> 3;
    }

    public static @Nullable ByteBuffer nPreambleStoragePath(long struct) {
        return MemoryUtil.memByteBufferNT1Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)PREAMBLESTORAGEPATH)));
    }

    public static @Nullable String nPreambleStoragePathString(long struct) {
        return MemoryUtil.memUTF8Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)PREAMBLESTORAGEPATH)));
    }

    public static @Nullable ByteBuffer nInvocationEmissionPath(long struct) {
        return MemoryUtil.memByteBufferNT1Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)INVOCATIONEMISSIONPATH)));
    }

    public static @Nullable String nInvocationEmissionPathString(long struct) {
        return MemoryUtil.memUTF8Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)INVOCATIONEMISSIONPATH)));
    }

    public static void nSize(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SIZE), (int)value);
    }

    public static void nThreadBackgroundPriorityForIndexing(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)THREADBACKGROUNDPRIORITYFORINDEXING), (byte)value);
    }

    public static void nThreadBackgroundPriorityForEditing(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)THREADBACKGROUNDPRIORITYFOREDITING), (byte)value);
    }

    public static void nbitfield0(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)BITFIELD0), (int)value);
    }

    public static void nExcludeDeclarationsFromPCH(long struct, int value) {
        CXIndexOptions.nbitfield0(struct, CXIndexOptions.nbitfield0(struct) & 0xFFFFFFFE | value & 1);
    }

    public static void nDisplayDiagnostics(long struct, int value) {
        CXIndexOptions.nbitfield0(struct, value << 1 & 2 | CXIndexOptions.nbitfield0(struct) & 0xFFFFFFFD);
    }

    public static void nStorePreamblesInMemory(long struct, int value) {
        CXIndexOptions.nbitfield0(struct, value << 2 & 4 | CXIndexOptions.nbitfield0(struct) & 0xFFFFFFFB);
    }

    public static void nReserved(long struct, int value) {
        CXIndexOptions.nbitfield0(struct, value << 3 & 0xFFF8 | CXIndexOptions.nbitfield0(struct) & 0xFFFF0007);
    }

    public static void nPreambleStoragePath(long struct, @Nullable ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)PREAMBLESTORAGEPATH), (long)MemoryUtil.memAddressSafe((ByteBuffer)value));
    }

    public static void nInvocationEmissionPath(long struct, @Nullable ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)INVOCATIONEMISSIONPATH), (long)MemoryUtil.memAddressSafe((ByteBuffer)value));
    }

    static {
        Struct.Layout layout = CXIndexOptions.__struct((Struct.Member[])new Struct.Member[]{CXIndexOptions.__member((int)4), CXIndexOptions.__member((int)1), CXIndexOptions.__member((int)1), CXIndexOptions.__member((int)4), CXIndexOptions.__member((int)POINTER_SIZE), CXIndexOptions.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SIZE = layout.offsetof(0);
        THREADBACKGROUNDPRIORITYFORINDEXING = layout.offsetof(1);
        THREADBACKGROUNDPRIORITYFOREDITING = layout.offsetof(2);
        BITFIELD0 = layout.offsetof(3);
        PREAMBLESTORAGEPATH = layout.offsetof(4);
        INVOCATIONEMISSIONPATH = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<CXIndexOptions, Buffer>
    implements NativeResource {
        private static final CXIndexOptions ELEMENT_FACTORY = CXIndexOptions.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected CXIndexOptions getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned")
        public int Size() {
            return CXIndexOptions.nSize(this.address());
        }

        @NativeType(value="unsigned char")
        public byte ThreadBackgroundPriorityForIndexing() {
            return CXIndexOptions.nThreadBackgroundPriorityForIndexing(this.address());
        }

        @NativeType(value="unsigned char")
        public byte ThreadBackgroundPriorityForEditing() {
            return CXIndexOptions.nThreadBackgroundPriorityForEditing(this.address());
        }

        @NativeType(value="unsigned")
        public boolean ExcludeDeclarationsFromPCH() {
            return CXIndexOptions.nExcludeDeclarationsFromPCH(this.address()) != 0;
        }

        @NativeType(value="unsigned")
        public boolean DisplayDiagnostics() {
            return CXIndexOptions.nDisplayDiagnostics(this.address()) != 0;
        }

        @NativeType(value="unsigned")
        public boolean StorePreamblesInMemory() {
            return CXIndexOptions.nStorePreamblesInMemory(this.address()) != 0;
        }

        @NativeType(value="char const *")
        public @Nullable ByteBuffer PreambleStoragePath() {
            return CXIndexOptions.nPreambleStoragePath(this.address());
        }

        @NativeType(value="char const *")
        public @Nullable String PreambleStoragePathString() {
            return CXIndexOptions.nPreambleStoragePathString(this.address());
        }

        @NativeType(value="char const *")
        public @Nullable ByteBuffer InvocationEmissionPath() {
            return CXIndexOptions.nInvocationEmissionPath(this.address());
        }

        @NativeType(value="char const *")
        public @Nullable String InvocationEmissionPathString() {
            return CXIndexOptions.nInvocationEmissionPathString(this.address());
        }

        public Buffer Size(@NativeType(value="unsigned") int value) {
            CXIndexOptions.nSize(this.address(), value);
            return this;
        }

        public Buffer Size$Default() {
            return this.Size(SIZEOF);
        }

        public Buffer ThreadBackgroundPriorityForIndexing(@NativeType(value="unsigned char") byte value) {
            CXIndexOptions.nThreadBackgroundPriorityForIndexing(this.address(), value);
            return this;
        }

        public Buffer ThreadBackgroundPriorityForEditing(@NativeType(value="unsigned char") byte value) {
            CXIndexOptions.nThreadBackgroundPriorityForEditing(this.address(), value);
            return this;
        }

        public Buffer ExcludeDeclarationsFromPCH(@NativeType(value="unsigned") boolean value) {
            CXIndexOptions.nExcludeDeclarationsFromPCH(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer DisplayDiagnostics(@NativeType(value="unsigned") boolean value) {
            CXIndexOptions.nDisplayDiagnostics(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer StorePreamblesInMemory(@NativeType(value="unsigned") boolean value) {
            CXIndexOptions.nStorePreamblesInMemory(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer PreambleStoragePath(@NativeType(value="char const *") @Nullable ByteBuffer value) {
            CXIndexOptions.nPreambleStoragePath(this.address(), value);
            return this;
        }

        public Buffer InvocationEmissionPath(@NativeType(value="char const *") @Nullable ByteBuffer value) {
            CXIndexOptions.nInvocationEmissionPath(this.address(), value);
            return this;
        }
    }
}

