/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXType
extends Struct<CXType>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int KIND;
    public static final int DATA;

    protected CXType(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CXType create(long address, @Nullable ByteBuffer container) {
        return new CXType(address, container);
    }

    public CXType(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CXType.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="enum CXTypeKind")
    public int kind() {
        return CXType.nkind(this.address());
    }

    @NativeType(value="void *[2]")
    public PointerBuffer data() {
        return CXType.ndata(this.address());
    }

    @NativeType(value="void *")
    public long data(int index) {
        return CXType.ndata(this.address(), index);
    }

    public static CXType malloc() {
        return new CXType(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CXType calloc() {
        return new CXType(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CXType create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CXType(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CXType create(long address) {
        return new CXType(address, null);
    }

    public static @Nullable CXType createSafe(long address) {
        return address == 0L ? null : new CXType(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CXType.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXType.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static CXType mallocStack() {
        return CXType.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXType callocStack() {
        return CXType.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXType mallocStack(MemoryStack stack) {
        return CXType.malloc(stack);
    }

    @Deprecated
    public static CXType callocStack(MemoryStack stack) {
        return CXType.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CXType.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CXType.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CXType.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CXType.calloc(capacity, stack);
    }

    public static CXType malloc(MemoryStack stack) {
        return new CXType(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CXType calloc(MemoryStack stack) {
        return new CXType(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nkind(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)KIND));
    }

    public static PointerBuffer ndata(long struct) {
        return MemoryUtil.memPointerBuffer((long)(struct + (long)DATA), (int)2);
    }

    public static long ndata(long struct, int index) {
        return MemoryUtil.memGetAddress((long)(struct + (long)DATA + Checks.check((int)index, (int)2) * (long)POINTER_SIZE));
    }

    static {
        Struct.Layout layout = CXType.__struct((Struct.Member[])new Struct.Member[]{CXType.__member((int)4), CXType.__array((int)POINTER_SIZE, (int)2)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        KIND = layout.offsetof(0);
        DATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CXType, Buffer>
    implements NativeResource {
        private static final CXType ELEMENT_FACTORY = CXType.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected CXType getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="enum CXTypeKind")
        public int kind() {
            return CXType.nkind(this.address());
        }

        @NativeType(value="void *[2]")
        public PointerBuffer data() {
            return CXType.ndata(this.address());
        }

        @NativeType(value="void *")
        public long data(int index) {
            return CXType.ndata(this.address(), index);
        }
    }
}

