/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.llvm.LLVMJITSymbolFlags;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class LLVMJITEvaluatedSymbol
extends Struct<LLVMJITEvaluatedSymbol>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ADDRESS;
    public static final int FLAGS;

    protected LLVMJITEvaluatedSymbol(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected LLVMJITEvaluatedSymbol create(long address, @Nullable ByteBuffer container) {
        return new LLVMJITEvaluatedSymbol(address, container);
    }

    public LLVMJITEvaluatedSymbol(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), LLVMJITEvaluatedSymbol.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LLVMOrcExecutorAddress")
    public long Address() {
        return LLVMJITEvaluatedSymbol.nAddress(this.address());
    }

    public LLVMJITSymbolFlags Flags() {
        return LLVMJITEvaluatedSymbol.nFlags(this.address());
    }

    public LLVMJITEvaluatedSymbol Address(@NativeType(value="LLVMOrcExecutorAddress") long value) {
        LLVMJITEvaluatedSymbol.nAddress(this.address(), value);
        return this;
    }

    public LLVMJITEvaluatedSymbol Flags(LLVMJITSymbolFlags value) {
        LLVMJITEvaluatedSymbol.nFlags(this.address(), value);
        return this;
    }

    public LLVMJITEvaluatedSymbol Flags(Consumer<LLVMJITSymbolFlags> consumer) {
        consumer.accept(this.Flags());
        return this;
    }

    public LLVMJITEvaluatedSymbol set(long Address, LLVMJITSymbolFlags Flags) {
        this.Address(Address);
        this.Flags(Flags);
        return this;
    }

    public LLVMJITEvaluatedSymbol set(LLVMJITEvaluatedSymbol src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static LLVMJITEvaluatedSymbol malloc() {
        return new LLVMJITEvaluatedSymbol(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static LLVMJITEvaluatedSymbol calloc() {
        return new LLVMJITEvaluatedSymbol(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static LLVMJITEvaluatedSymbol create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new LLVMJITEvaluatedSymbol(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static LLVMJITEvaluatedSymbol create(long address) {
        return new LLVMJITEvaluatedSymbol(address, null);
    }

    public static @Nullable LLVMJITEvaluatedSymbol createSafe(long address) {
        return address == 0L ? null : new LLVMJITEvaluatedSymbol(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)LLVMJITEvaluatedSymbol.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LLVMJITEvaluatedSymbol.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static LLVMJITEvaluatedSymbol malloc(MemoryStack stack) {
        return new LLVMJITEvaluatedSymbol(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static LLVMJITEvaluatedSymbol calloc(MemoryStack stack) {
        return new LLVMJITEvaluatedSymbol(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nAddress(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)ADDRESS));
    }

    public static LLVMJITSymbolFlags nFlags(long struct) {
        return LLVMJITSymbolFlags.create(struct + (long)FLAGS);
    }

    public static void nAddress(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)ADDRESS), (long)value);
    }

    public static void nFlags(long struct, LLVMJITSymbolFlags value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FLAGS), (long)LLVMJITSymbolFlags.SIZEOF);
    }

    static {
        Struct.Layout layout = LLVMJITEvaluatedSymbol.__struct((Struct.Member[])new Struct.Member[]{LLVMJITEvaluatedSymbol.__member((int)8), LLVMJITEvaluatedSymbol.__member((int)LLVMJITSymbolFlags.SIZEOF, (int)LLVMJITSymbolFlags.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ADDRESS = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LLVMJITEvaluatedSymbol, Buffer>
    implements NativeResource {
        private static final LLVMJITEvaluatedSymbol ELEMENT_FACTORY = LLVMJITEvaluatedSymbol.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected LLVMJITEvaluatedSymbol getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="LLVMOrcExecutorAddress")
        public long Address() {
            return LLVMJITEvaluatedSymbol.nAddress(this.address());
        }

        public LLVMJITSymbolFlags Flags() {
            return LLVMJITEvaluatedSymbol.nFlags(this.address());
        }

        public Buffer Address(@NativeType(value="LLVMOrcExecutorAddress") long value) {
            LLVMJITEvaluatedSymbol.nAddress(this.address(), value);
            return this;
        }

        public Buffer Flags(LLVMJITSymbolFlags value) {
            LLVMJITEvaluatedSymbol.nFlags(this.address(), value);
            return this;
        }

        public Buffer Flags(Consumer<LLVMJITSymbolFlags> consumer) {
            consumer.accept(this.Flags());
            return this;
        }
    }
}

