/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.meshoptimizer;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct meshopt_OverdrawStatistics")
public class MeshoptOverdrawStatistics
extends Struct<MeshoptOverdrawStatistics>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PIXELS_COVERED;
    public static final int PIXELS_SHADED;
    public static final int OVERDRAW;

    protected MeshoptOverdrawStatistics(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected MeshoptOverdrawStatistics create(long address, @Nullable ByteBuffer container) {
        return new MeshoptOverdrawStatistics(address, container);
    }

    public MeshoptOverdrawStatistics(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), MeshoptOverdrawStatistics.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int pixels_covered() {
        return MeshoptOverdrawStatistics.npixels_covered(this.address());
    }

    @NativeType(value="unsigned int")
    public int pixels_shaded() {
        return MeshoptOverdrawStatistics.npixels_shaded(this.address());
    }

    public float overdraw() {
        return MeshoptOverdrawStatistics.noverdraw(this.address());
    }

    public static MeshoptOverdrawStatistics malloc() {
        return new MeshoptOverdrawStatistics(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static MeshoptOverdrawStatistics calloc() {
        return new MeshoptOverdrawStatistics(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static MeshoptOverdrawStatistics create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new MeshoptOverdrawStatistics(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static MeshoptOverdrawStatistics create(long address) {
        return new MeshoptOverdrawStatistics(address, null);
    }

    public static @Nullable MeshoptOverdrawStatistics createSafe(long address) {
        return address == 0L ? null : new MeshoptOverdrawStatistics(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)MeshoptOverdrawStatistics.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = MeshoptOverdrawStatistics.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static MeshoptOverdrawStatistics malloc(MemoryStack stack) {
        return new MeshoptOverdrawStatistics(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static MeshoptOverdrawStatistics calloc(MemoryStack stack) {
        return new MeshoptOverdrawStatistics(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int npixels_covered(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PIXELS_COVERED));
    }

    public static int npixels_shaded(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PIXELS_SHADED));
    }

    public static float noverdraw(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)OVERDRAW));
    }

    static {
        Struct.Layout layout = MeshoptOverdrawStatistics.__struct((Struct.Member[])new Struct.Member[]{MeshoptOverdrawStatistics.__member((int)4), MeshoptOverdrawStatistics.__member((int)4), MeshoptOverdrawStatistics.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PIXELS_COVERED = layout.offsetof(0);
        PIXELS_SHADED = layout.offsetof(1);
        OVERDRAW = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<MeshoptOverdrawStatistics, Buffer>
    implements NativeResource {
        private static final MeshoptOverdrawStatistics ELEMENT_FACTORY = MeshoptOverdrawStatistics.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected MeshoptOverdrawStatistics getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int pixels_covered() {
            return MeshoptOverdrawStatistics.npixels_covered(this.address());
        }

        @NativeType(value="unsigned int")
        public int pixels_shaded() {
            return MeshoptOverdrawStatistics.npixels_shaded(this.address());
        }

        public float overdraw() {
            return MeshoptOverdrawStatistics.noverdraw(this.address());
        }
    }
}

