/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.msdfgen;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.util.msdfgen.LibMsdfGen;
import org.lwjgl.util.msdfgen.MSDFGenFTLoadCallback;
import org.lwjgl.util.msdfgen.MSDFGenFTLoadCallbackI;

public class MSDFGenExt {
    public static final int MSDF_FONT_SCALING_NONE = 0;
    public static final int MSDF_FONT_SCALING_EM_NORMALIZED = 1;
    public static final int MSDF_FONT_SCALING_LEGACY = 2;

    protected MSDFGenExt() {
        throw new UnsupportedOperationException();
    }

    public static native int nmsdf_ft_set_load_callback(long var0);

    public static int msdf_ft_set_load_callback(@NativeType(value="void * (*) (char const *)") MSDFGenFTLoadCallbackI callback) {
        return MSDFGenExt.nmsdf_ft_set_load_callback(callback.address());
    }

    public static native long nmsdf_ft_get_load_callback();

    @NativeType(value="void * (*) (char const *)")
    public static @Nullable MSDFGenFTLoadCallback msdf_ft_get_load_callback() {
        return MSDFGenFTLoadCallback.createSafe(MSDFGenExt.nmsdf_ft_get_load_callback());
    }

    public static native int nmsdf_ft_init(long var0);

    public static int msdf_ft_init(@NativeType(value="msdf_ft_handle *") PointerBuffer handle) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)handle, (int)1);
        }
        return MSDFGenExt.nmsdf_ft_init(MemoryUtil.memAddress((CustomBuffer)handle));
    }

    public static native int nmsdf_ft_load_font(long var0, long var2, long var4);

    public static int msdf_ft_load_font(@NativeType(value="msdf_ft_handle") long handle, @NativeType(value="char const *") ByteBuffer fileName, @NativeType(value="msdf_ft_font_handle *") PointerBuffer font) {
        if (Checks.CHECKS) {
            Checks.check((long)handle);
            Checks.checkNT1((ByteBuffer)fileName);
            Checks.check((CustomBuffer)font, (int)1);
        }
        return MSDFGenExt.nmsdf_ft_load_font(handle, MemoryUtil.memAddress((ByteBuffer)fileName), MemoryUtil.memAddress((CustomBuffer)font));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int msdf_ft_load_font(@NativeType(value="msdf_ft_handle") long handle, @NativeType(value="char const *") CharSequence fileName, @NativeType(value="msdf_ft_font_handle *") PointerBuffer font) {
        if (Checks.CHECKS) {
            Checks.check((long)handle);
            Checks.check((CustomBuffer)font, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(fileName, true);
            long fileNameEncoded = stack.getPointerAddress();
            int n = MSDFGenExt.nmsdf_ft_load_font(handle, fileNameEncoded, MemoryUtil.memAddress((CustomBuffer)font));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nmsdf_ft_adopt_font(long var0, long var2);

    public static int msdf_ft_adopt_font(@NativeType(value="void *") long face, @NativeType(value="msdf_ft_font_handle *") PointerBuffer font) {
        if (Checks.CHECKS) {
            Checks.check((long)face);
            Checks.check((CustomBuffer)font, (int)1);
        }
        return MSDFGenExt.nmsdf_ft_adopt_font(face, MemoryUtil.memAddress((CustomBuffer)font));
    }

    public static native int nmsdf_ft_load_font_data(long var0, long var2, long var4, long var6);

    public static int msdf_ft_load_font_data(@NativeType(value="msdf_ft_handle") long handle, @NativeType(value="void const *") ByteBuffer data, @NativeType(value="msdf_ft_font_handle *") PointerBuffer font) {
        if (Checks.CHECKS) {
            Checks.check((long)handle);
            Checks.check((CustomBuffer)font, (int)1);
        }
        return MSDFGenExt.nmsdf_ft_load_font_data(handle, MemoryUtil.memAddress((ByteBuffer)data), data.remaining(), MemoryUtil.memAddress((CustomBuffer)font));
    }

    public static native int nmsdf_ft_font_load_glyph(long var0, int var2, int var3, long var4);

    public static int msdf_ft_font_load_glyph(@NativeType(value="msdf_ft_font_handle") long font, @NativeType(value="unsigned") int cp, int coordinateScaling, @NativeType(value="msdf_shape_handle *") PointerBuffer shape) {
        if (Checks.CHECKS) {
            Checks.check((long)font);
            Checks.check((CustomBuffer)shape, (int)1);
        }
        return MSDFGenExt.nmsdf_ft_font_load_glyph(font, cp, coordinateScaling, MemoryUtil.memAddress((CustomBuffer)shape));
    }

    public static native int nmsdf_ft_font_load_glyph_by_index(long var0, int var2, int var3, long var4);

    public static int msdf_ft_font_load_glyph_by_index(@NativeType(value="msdf_ft_font_handle") long font, @NativeType(value="unsigned") int index, int coordinateScaling, @NativeType(value="msdf_shape_handle *") PointerBuffer shape) {
        if (Checks.CHECKS) {
            Checks.check((long)font);
            Checks.check((CustomBuffer)shape, (int)1);
        }
        return MSDFGenExt.nmsdf_ft_font_load_glyph_by_index(font, index, coordinateScaling, MemoryUtil.memAddress((CustomBuffer)shape));
    }

    public static native int nmsdf_ft_font_get_glyph_index(long var0, int var2, long var3);

    public static int msdf_ft_font_get_glyph_index(@NativeType(value="msdf_ft_font_handle") long font, @NativeType(value="unsigned") int cp, @NativeType(value="unsigned *") IntBuffer index) {
        if (Checks.CHECKS) {
            Checks.check((long)font);
            Checks.check((Buffer)index, (int)1);
        }
        return MSDFGenExt.nmsdf_ft_font_get_glyph_index(font, cp, MemoryUtil.memAddress((IntBuffer)index));
    }

    public static native int nmsdf_ft_font_get_kerning(long var0, int var2, int var3, long var4);

    public static int msdf_ft_font_get_kerning(@NativeType(value="msdf_ft_font_handle") long font, @NativeType(value="unsigned") int cp1, @NativeType(value="unsigned") int cp2, @NativeType(value="double *") DoubleBuffer kerning) {
        if (Checks.CHECKS) {
            Checks.check((long)font);
            Checks.check((Buffer)kerning, (int)1);
        }
        return MSDFGenExt.nmsdf_ft_font_get_kerning(font, cp1, cp2, MemoryUtil.memAddress((DoubleBuffer)kerning));
    }

    public static native int nmsdf_ft_font_get_kerning_by_index(long var0, int var2, int var3, long var4);

    public static int msdf_ft_font_get_kerning_by_index(@NativeType(value="msdf_ft_font_handle") long font, @NativeType(value="unsigned") int index1, @NativeType(value="unsigned") int index2, @NativeType(value="double *") DoubleBuffer kerning) {
        if (Checks.CHECKS) {
            Checks.check((long)font);
            Checks.check((Buffer)kerning, (int)1);
        }
        return MSDFGenExt.nmsdf_ft_font_get_kerning_by_index(font, index1, index2, MemoryUtil.memAddress((DoubleBuffer)kerning));
    }

    public static native void nmsdf_ft_font_destroy(long var0);

    public static void msdf_ft_font_destroy(@NativeType(value="msdf_ft_font_handle") long font) {
        if (Checks.CHECKS) {
            Checks.check((long)font);
        }
        MSDFGenExt.nmsdf_ft_font_destroy(font);
    }

    public static native void nmsdf_ft_deinit(long var0);

    public static void msdf_ft_deinit(@NativeType(value="msdf_ft_handle") long handle) {
        if (Checks.CHECKS) {
            Checks.check((long)handle);
        }
        MSDFGenExt.nmsdf_ft_deinit(handle);
    }

    static {
        LibMsdfGen.initialize();
    }
}

