/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.nfd;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.nfd.NFDFilterItem;
import org.lwjgl.util.nfd.NFDWindowHandle;

@NativeType(value="struct nfdopendialogu8args_t")
public class NFDOpenDialogArgs
extends Struct<NFDOpenDialogArgs>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FILTERLIST;
    public static final int FILTERCOUNT;
    public static final int DEFAULTPATH;
    public static final int PARENTWINDOW;

    protected NFDOpenDialogArgs(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected NFDOpenDialogArgs create(long address, @Nullable ByteBuffer container) {
        return new NFDOpenDialogArgs(address, container);
    }

    public NFDOpenDialogArgs(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NFDOpenDialogArgs.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="nfdfilteritem_t const *")
    public @Nullable NFDFilterItem.Buffer filterList() {
        return NFDOpenDialogArgs.nfilterList(this.address());
    }

    @NativeType(value="nfdfiltersize_t")
    public int filterCount() {
        return NFDOpenDialogArgs.nfilterCount(this.address());
    }

    @NativeType(value="nfdchar_t const *")
    public @Nullable ByteBuffer defaultPath() {
        return NFDOpenDialogArgs.ndefaultPath(this.address());
    }

    @NativeType(value="nfdchar_t const *")
    public @Nullable String defaultPathString() {
        return NFDOpenDialogArgs.ndefaultPathString(this.address());
    }

    @NativeType(value="nfdwindowhandle_t")
    public NFDWindowHandle parentWindow() {
        return NFDOpenDialogArgs.nparentWindow(this.address());
    }

    public NFDOpenDialogArgs filterList(@NativeType(value="nfdfilteritem_t const *") @Nullable NFDFilterItem.Buffer value) {
        NFDOpenDialogArgs.nfilterList(this.address(), value);
        return this;
    }

    public NFDOpenDialogArgs defaultPath(@NativeType(value="nfdchar_t const *") @Nullable ByteBuffer value) {
        NFDOpenDialogArgs.ndefaultPath(this.address(), value);
        return this;
    }

    public NFDOpenDialogArgs parentWindow(@NativeType(value="nfdwindowhandle_t") NFDWindowHandle value) {
        NFDOpenDialogArgs.nparentWindow(this.address(), value);
        return this;
    }

    public NFDOpenDialogArgs parentWindow(Consumer<NFDWindowHandle> consumer) {
        consumer.accept(this.parentWindow());
        return this;
    }

    public NFDOpenDialogArgs set(@Nullable NFDFilterItem.Buffer filterList, @Nullable ByteBuffer defaultPath, NFDWindowHandle parentWindow) {
        this.filterList(filterList);
        this.defaultPath(defaultPath);
        this.parentWindow(parentWindow);
        return this;
    }

    public NFDOpenDialogArgs set(NFDOpenDialogArgs src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NFDOpenDialogArgs malloc() {
        return new NFDOpenDialogArgs(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static NFDOpenDialogArgs calloc() {
        return new NFDOpenDialogArgs(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static NFDOpenDialogArgs create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new NFDOpenDialogArgs(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static NFDOpenDialogArgs create(long address) {
        return new NFDOpenDialogArgs(address, null);
    }

    public static @Nullable NFDOpenDialogArgs createSafe(long address) {
        return address == 0L ? null : new NFDOpenDialogArgs(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)NFDOpenDialogArgs.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NFDOpenDialogArgs.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static NFDOpenDialogArgs malloc(MemoryStack stack) {
        return new NFDOpenDialogArgs(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NFDOpenDialogArgs calloc(MemoryStack stack) {
        return new NFDOpenDialogArgs(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static @Nullable NFDFilterItem.Buffer nfilterList(long struct) {
        return NFDFilterItem.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)FILTERLIST)), NFDOpenDialogArgs.nfilterCount(struct));
    }

    public static int nfilterCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FILTERCOUNT));
    }

    public static @Nullable ByteBuffer ndefaultPath(long struct) {
        return MemoryUtil.memByteBufferNT1Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)DEFAULTPATH)));
    }

    public static @Nullable String ndefaultPathString(long struct) {
        return MemoryUtil.memUTF8Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)DEFAULTPATH)));
    }

    public static NFDWindowHandle nparentWindow(long struct) {
        return NFDWindowHandle.create(struct + (long)PARENTWINDOW);
    }

    public static void nfilterList(long struct, @Nullable NFDFilterItem.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)FILTERLIST), (long)MemoryUtil.memAddressSafe((Pointer)value));
        NFDOpenDialogArgs.nfilterCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nfilterCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FILTERCOUNT), (int)value);
    }

    public static void ndefaultPath(long struct, @Nullable ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)DEFAULTPATH), (long)MemoryUtil.memAddressSafe((ByteBuffer)value));
    }

    public static void nparentWindow(long struct, NFDWindowHandle value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PARENTWINDOW), (long)NFDWindowHandle.SIZEOF);
    }

    public static void validate(long struct) {
        int filterCount = NFDOpenDialogArgs.nfilterCount(struct);
        if (filterCount != 0) {
            long filterList = MemoryUtil.memGetAddress((long)(struct + (long)FILTERLIST));
            Checks.check((long)filterList);
            NFDOpenDialogArgs.validate((long)filterList, (int)filterCount, (int)NFDFilterItem.SIZEOF, NFDFilterItem::validate);
        }
    }

    static {
        Struct.Layout layout = NFDOpenDialogArgs.__struct((Struct.Member[])new Struct.Member[]{NFDOpenDialogArgs.__member((int)POINTER_SIZE), NFDOpenDialogArgs.__member((int)4), NFDOpenDialogArgs.__member((int)POINTER_SIZE), NFDOpenDialogArgs.__member((int)NFDWindowHandle.SIZEOF, (int)NFDWindowHandle.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FILTERLIST = layout.offsetof(0);
        FILTERCOUNT = layout.offsetof(1);
        DEFAULTPATH = layout.offsetof(2);
        PARENTWINDOW = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<NFDOpenDialogArgs, Buffer>
    implements NativeResource {
        private static final NFDOpenDialogArgs ELEMENT_FACTORY = NFDOpenDialogArgs.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected NFDOpenDialogArgs getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="nfdfilteritem_t const *")
        public @Nullable NFDFilterItem.Buffer filterList() {
            return NFDOpenDialogArgs.nfilterList(this.address());
        }

        @NativeType(value="nfdfiltersize_t")
        public int filterCount() {
            return NFDOpenDialogArgs.nfilterCount(this.address());
        }

        @NativeType(value="nfdchar_t const *")
        public @Nullable ByteBuffer defaultPath() {
            return NFDOpenDialogArgs.ndefaultPath(this.address());
        }

        @NativeType(value="nfdchar_t const *")
        public @Nullable String defaultPathString() {
            return NFDOpenDialogArgs.ndefaultPathString(this.address());
        }

        @NativeType(value="nfdwindowhandle_t")
        public NFDWindowHandle parentWindow() {
            return NFDOpenDialogArgs.nparentWindow(this.address());
        }

        public Buffer filterList(@NativeType(value="nfdfilteritem_t const *") @Nullable NFDFilterItem.Buffer value) {
            NFDOpenDialogArgs.nfilterList(this.address(), value);
            return this;
        }

        public Buffer defaultPath(@NativeType(value="nfdchar_t const *") @Nullable ByteBuffer value) {
            NFDOpenDialogArgs.ndefaultPath(this.address(), value);
            return this;
        }

        public Buffer parentWindow(@NativeType(value="nfdwindowhandle_t") NFDWindowHandle value) {
            NFDOpenDialogArgs.nparentWindow(this.address(), value);
            return this;
        }

        public Buffer parentWindow(Consumer<NFDWindowHandle> consumer) {
            consumer.accept(this.parentWindow());
            return this;
        }
    }
}

