/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.nuklear.NkPluginCopy;
import org.lwjgl.nuklear.NkPluginCopyI;
import org.lwjgl.nuklear.NkPluginPaste;
import org.lwjgl.nuklear.NkPluginPasteI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_clipboard")
public class NkClipboard
extends Struct<NkClipboard>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int USERDATA;
    public static final int PASTE;
    public static final int COPY;

    protected NkClipboard(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected NkClipboard create(long address, @Nullable ByteBuffer container) {
        return new NkClipboard(address, container);
    }

    public NkClipboard(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkClipboard.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="nk_handle")
    public NkHandle userdata() {
        return NkClipboard.nuserdata(this.address());
    }

    @NativeType(value="nk_plugin_paste")
    public @Nullable NkPluginPaste paste() {
        return NkClipboard.npaste(this.address());
    }

    @NativeType(value="nk_plugin_copy")
    public @Nullable NkPluginCopy copy() {
        return NkClipboard.ncopy(this.address());
    }

    public NkClipboard userdata(@NativeType(value="nk_handle") NkHandle value) {
        NkClipboard.nuserdata(this.address(), value);
        return this;
    }

    public NkClipboard userdata(Consumer<NkHandle> consumer) {
        consumer.accept(this.userdata());
        return this;
    }

    public NkClipboard paste(@NativeType(value="nk_plugin_paste") @Nullable NkPluginPasteI value) {
        NkClipboard.npaste(this.address(), value);
        return this;
    }

    public NkClipboard copy(@NativeType(value="nk_plugin_copy") @Nullable NkPluginCopyI value) {
        NkClipboard.ncopy(this.address(), value);
        return this;
    }

    public NkClipboard set(NkHandle userdata, NkPluginPasteI paste, NkPluginCopyI copy) {
        this.userdata(userdata);
        this.paste(paste);
        this.copy(copy);
        return this;
    }

    public NkClipboard set(NkClipboard src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NkClipboard malloc() {
        return new NkClipboard(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static NkClipboard calloc() {
        return new NkClipboard(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static NkClipboard create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new NkClipboard(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static NkClipboard create(long address) {
        return new NkClipboard(address, null);
    }

    public static @Nullable NkClipboard createSafe(long address) {
        return address == 0L ? null : new NkClipboard(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)NkClipboard.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkClipboard.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static NkClipboard mallocStack() {
        return NkClipboard.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkClipboard callocStack() {
        return NkClipboard.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkClipboard mallocStack(MemoryStack stack) {
        return NkClipboard.malloc(stack);
    }

    @Deprecated
    public static NkClipboard callocStack(MemoryStack stack) {
        return NkClipboard.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkClipboard.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkClipboard.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkClipboard.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkClipboard.calloc(capacity, stack);
    }

    public static NkClipboard malloc(MemoryStack stack) {
        return new NkClipboard(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NkClipboard calloc(MemoryStack stack) {
        return new NkClipboard(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkHandle nuserdata(long struct) {
        return NkHandle.create(struct + (long)USERDATA);
    }

    public static @Nullable NkPluginPaste npaste(long struct) {
        return NkPluginPaste.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PASTE)));
    }

    public static @Nullable NkPluginCopy ncopy(long struct) {
        return NkPluginCopy.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)COPY)));
    }

    public static void nuserdata(long struct, NkHandle value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)USERDATA), (long)NkHandle.SIZEOF);
    }

    public static void npaste(long struct, @Nullable NkPluginPasteI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PASTE), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void ncopy(long struct, @Nullable NkPluginCopyI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)COPY), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    static {
        Struct.Layout layout = NkClipboard.__struct((Struct.Member[])new Struct.Member[]{NkClipboard.__member((int)NkHandle.SIZEOF, (int)NkHandle.ALIGNOF), NkClipboard.__member((int)POINTER_SIZE), NkClipboard.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        USERDATA = layout.offsetof(0);
        PASTE = layout.offsetof(1);
        COPY = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<NkClipboard, Buffer>
    implements NativeResource {
        private static final NkClipboard ELEMENT_FACTORY = NkClipboard.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected NkClipboard getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="nk_handle")
        public NkHandle userdata() {
            return NkClipboard.nuserdata(this.address());
        }

        @NativeType(value="nk_plugin_paste")
        public @Nullable NkPluginPaste paste() {
            return NkClipboard.npaste(this.address());
        }

        @NativeType(value="nk_plugin_copy")
        public @Nullable NkPluginCopy copy() {
            return NkClipboard.ncopy(this.address());
        }

        public Buffer userdata(@NativeType(value="nk_handle") NkHandle value) {
            NkClipboard.nuserdata(this.address(), value);
            return this;
        }

        public Buffer userdata(Consumer<NkHandle> consumer) {
            consumer.accept(this.userdata());
            return this;
        }

        public Buffer paste(@NativeType(value="nk_plugin_paste") @Nullable NkPluginPasteI value) {
            NkClipboard.npaste(this.address(), value);
            return this;
        }

        public Buffer copy(@NativeType(value="nk_plugin_copy") @Nullable NkPluginCopyI value) {
            NkClipboard.ncopy(this.address(), value);
            return this;
        }
    }
}

