/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.nuklear.NkBuffer;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.nuklear.NkRect;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_command_buffer")
public class NkCommandBuffer
extends Struct<NkCommandBuffer> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BASE;
    public static final int CLIP;
    public static final int USE_CLIPPING;
    public static final int USERDATA;
    public static final int BEGIN;
    public static final int END;
    public static final int LAST;

    protected NkCommandBuffer(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected NkCommandBuffer create(long address, @Nullable ByteBuffer container) {
        return new NkCommandBuffer(address, container);
    }

    public NkCommandBuffer(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkCommandBuffer.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_buffer *")
    public @Nullable NkBuffer base() {
        return NkCommandBuffer.nbase(this.address());
    }

    @NativeType(value="struct nk_rect")
    public NkRect clip() {
        return NkCommandBuffer.nclip(this.address());
    }

    public int use_clipping() {
        return NkCommandBuffer.nuse_clipping(this.address());
    }

    @NativeType(value="nk_handle")
    public NkHandle userdata() {
        return NkCommandBuffer.nuserdata(this.address());
    }

    @NativeType(value="nk_size")
    public long begin() {
        return NkCommandBuffer.nbegin(this.address());
    }

    @NativeType(value="nk_size")
    public long end() {
        return NkCommandBuffer.nend(this.address());
    }

    @NativeType(value="nk_size")
    public long last() {
        return NkCommandBuffer.nlast(this.address());
    }

    public static NkCommandBuffer create(long address) {
        return new NkCommandBuffer(address, null);
    }

    public static @Nullable NkCommandBuffer createSafe(long address) {
        return address == 0L ? null : new NkCommandBuffer(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static @Nullable NkBuffer nbase(long struct) {
        return NkBuffer.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)BASE)));
    }

    public static NkRect nclip(long struct) {
        return NkRect.create(struct + (long)CLIP);
    }

    public static int nuse_clipping(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)USE_CLIPPING));
    }

    public static NkHandle nuserdata(long struct) {
        return NkHandle.create(struct + (long)USERDATA);
    }

    public static long nbegin(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)BEGIN));
    }

    public static long nend(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)END));
    }

    public static long nlast(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)LAST));
    }

    static {
        Struct.Layout layout = NkCommandBuffer.__struct((Struct.Member[])new Struct.Member[]{NkCommandBuffer.__member((int)POINTER_SIZE), NkCommandBuffer.__member((int)NkRect.SIZEOF, (int)NkRect.ALIGNOF), NkCommandBuffer.__member((int)4), NkCommandBuffer.__member((int)NkHandle.SIZEOF, (int)NkHandle.ALIGNOF), NkCommandBuffer.__member((int)POINTER_SIZE), NkCommandBuffer.__member((int)POINTER_SIZE), NkCommandBuffer.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BASE = layout.offsetof(0);
        CLIP = layout.offsetof(1);
        USE_CLIPPING = layout.offsetof(2);
        USERDATA = layout.offsetof(3);
        BEGIN = layout.offsetof(4);
        END = layout.offsetof(5);
        LAST = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<NkCommandBuffer, Buffer> {
        private static final NkCommandBuffer ELEMENT_FACTORY = NkCommandBuffer.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected NkCommandBuffer getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_buffer *")
        public @Nullable NkBuffer base() {
            return NkCommandBuffer.nbase(this.address());
        }

        @NativeType(value="struct nk_rect")
        public NkRect clip() {
            return NkCommandBuffer.nclip(this.address());
        }

        public int use_clipping() {
            return NkCommandBuffer.nuse_clipping(this.address());
        }

        @NativeType(value="nk_handle")
        public NkHandle userdata() {
            return NkCommandBuffer.nuserdata(this.address());
        }

        @NativeType(value="nk_size")
        public long begin() {
            return NkCommandBuffer.nbegin(this.address());
        }

        @NativeType(value="nk_size")
        public long end() {
            return NkCommandBuffer.nend(this.address());
        }

        @NativeType(value="nk_size")
        public long last() {
            return NkCommandBuffer.nlast(this.address());
        }
    }
}

