/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.nuklear.NkRect;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_draw_command")
public class NkDrawCommand
extends Struct<NkDrawCommand> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ELEM_COUNT;
    public static final int CLIP_RECT;
    public static final int TEXTURE;
    public static final int USERDATA;

    protected NkDrawCommand(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected NkDrawCommand create(long address, @Nullable ByteBuffer container) {
        return new NkDrawCommand(address, container);
    }

    public NkDrawCommand(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkDrawCommand.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int elem_count() {
        return NkDrawCommand.nelem_count(this.address());
    }

    @NativeType(value="struct nk_rect")
    public NkRect clip_rect() {
        return NkDrawCommand.nclip_rect(this.address());
    }

    @NativeType(value="nk_handle")
    public NkHandle texture() {
        return NkDrawCommand.ntexture(this.address());
    }

    @NativeType(value="nk_handle")
    public NkHandle userdata() {
        return NkDrawCommand.nuserdata(this.address());
    }

    public static NkDrawCommand create(long address) {
        return new NkDrawCommand(address, null);
    }

    public static @Nullable NkDrawCommand createSafe(long address) {
        return address == 0L ? null : new NkDrawCommand(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static int nelem_count(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)ELEM_COUNT));
    }

    public static NkRect nclip_rect(long struct) {
        return NkRect.create(struct + (long)CLIP_RECT);
    }

    public static NkHandle ntexture(long struct) {
        return NkHandle.create(struct + (long)TEXTURE);
    }

    public static NkHandle nuserdata(long struct) {
        return NkHandle.create(struct + (long)USERDATA);
    }

    static {
        Struct.Layout layout = NkDrawCommand.__struct((Struct.Member[])new Struct.Member[]{NkDrawCommand.__member((int)4), NkDrawCommand.__member((int)NkRect.SIZEOF, (int)NkRect.ALIGNOF), NkDrawCommand.__member((int)NkHandle.SIZEOF, (int)NkHandle.ALIGNOF), NkDrawCommand.__member((int)NkHandle.SIZEOF, (int)NkHandle.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ELEM_COUNT = layout.offsetof(0);
        CLIP_RECT = layout.offsetof(1);
        TEXTURE = layout.offsetof(2);
        USERDATA = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<NkDrawCommand, Buffer> {
        private static final NkDrawCommand ELEMENT_FACTORY = NkDrawCommand.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected NkDrawCommand getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int elem_count() {
            return NkDrawCommand.nelem_count(this.address());
        }

        @NativeType(value="struct nk_rect")
        public NkRect clip_rect() {
            return NkDrawCommand.nclip_rect(this.address());
        }

        @NativeType(value="nk_handle")
        public NkHandle texture() {
            return NkDrawCommand.ntexture(this.address());
        }

        @NativeType(value="nk_handle")
        public NkHandle userdata() {
            return NkDrawCommand.nuserdata(this.address());
        }
    }
}

