/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkBakedFont;
import org.lwjgl.nuklear.NkFontConfig;
import org.lwjgl.nuklear.NkFontGlyph;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.nuklear.NkUserFont;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_font")
public class NkFont
extends Struct<NkFont>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NEXT;
    public static final int HANDLE;
    public static final int INFO;
    public static final int SCALE;
    public static final int GLYPHS;
    public static final int FALLBACK;
    public static final int FALLBACK_CODEPOINT;
    public static final int TEXTURE;
    public static final int CONFIG;

    protected NkFont(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected NkFont create(long address, @Nullable ByteBuffer container) {
        return new NkFont(address, container);
    }

    public NkFont(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkFont.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_font *")
    public @Nullable NkFont next() {
        return NkFont.nnext(this.address());
    }

    @NativeType(value="struct nk_user_font")
    public NkUserFont handle() {
        return NkFont.nhandle(this.address());
    }

    @NativeType(value="struct nk_baked_font")
    public NkBakedFont info() {
        return NkFont.ninfo(this.address());
    }

    public float scale() {
        return NkFont.nscale(this.address());
    }

    @NativeType(value="struct nk_font_glyph *")
    public @Nullable NkFontGlyph glyphs() {
        return NkFont.nglyphs(this.address());
    }

    @NativeType(value="struct nk_font_glyph const *")
    public @Nullable NkFontGlyph fallback() {
        return NkFont.nfallback(this.address());
    }

    @NativeType(value="nk_rune")
    public int fallback_codepoint() {
        return NkFont.nfallback_codepoint(this.address());
    }

    @NativeType(value="nk_handle")
    public NkHandle texture() {
        return NkFont.ntexture(this.address());
    }

    @NativeType(value="struct nk_font_config *")
    public @Nullable NkFontConfig config() {
        return NkFont.nconfig(this.address());
    }

    public NkFont next(@NativeType(value="struct nk_font *") @Nullable NkFont value) {
        NkFont.nnext(this.address(), value);
        return this;
    }

    public NkFont handle(@NativeType(value="struct nk_user_font") NkUserFont value) {
        NkFont.nhandle(this.address(), value);
        return this;
    }

    public NkFont handle(Consumer<NkUserFont> consumer) {
        consumer.accept(this.handle());
        return this;
    }

    public NkFont info(@NativeType(value="struct nk_baked_font") NkBakedFont value) {
        NkFont.ninfo(this.address(), value);
        return this;
    }

    public NkFont info(Consumer<NkBakedFont> consumer) {
        consumer.accept(this.info());
        return this;
    }

    public NkFont scale(float value) {
        NkFont.nscale(this.address(), value);
        return this;
    }

    public NkFont glyphs(@NativeType(value="struct nk_font_glyph *") @Nullable NkFontGlyph value) {
        NkFont.nglyphs(this.address(), value);
        return this;
    }

    public NkFont fallback(@NativeType(value="struct nk_font_glyph const *") @Nullable NkFontGlyph value) {
        NkFont.nfallback(this.address(), value);
        return this;
    }

    public NkFont fallback_codepoint(@NativeType(value="nk_rune") int value) {
        NkFont.nfallback_codepoint(this.address(), value);
        return this;
    }

    public NkFont texture(@NativeType(value="nk_handle") NkHandle value) {
        NkFont.ntexture(this.address(), value);
        return this;
    }

    public NkFont texture(Consumer<NkHandle> consumer) {
        consumer.accept(this.texture());
        return this;
    }

    public NkFont config(@NativeType(value="struct nk_font_config *") @Nullable NkFontConfig value) {
        NkFont.nconfig(this.address(), value);
        return this;
    }

    public NkFont set(@Nullable NkFont next, NkUserFont handle, NkBakedFont info, float scale, @Nullable NkFontGlyph glyphs, @Nullable NkFontGlyph fallback, int fallback_codepoint, NkHandle texture, @Nullable NkFontConfig config) {
        this.next(next);
        this.handle(handle);
        this.info(info);
        this.scale(scale);
        this.glyphs(glyphs);
        this.fallback(fallback);
        this.fallback_codepoint(fallback_codepoint);
        this.texture(texture);
        this.config(config);
        return this;
    }

    public NkFont set(NkFont src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NkFont malloc() {
        return new NkFont(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static NkFont calloc() {
        return new NkFont(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static NkFont create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new NkFont(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static NkFont create(long address) {
        return new NkFont(address, null);
    }

    public static @Nullable NkFont createSafe(long address) {
        return address == 0L ? null : new NkFont(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)NkFont.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkFont.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static NkFont malloc(MemoryStack stack) {
        return new NkFont(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NkFont calloc(MemoryStack stack) {
        return new NkFont(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static @Nullable NkFont nnext(long struct) {
        return NkFont.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)NEXT)));
    }

    public static NkUserFont nhandle(long struct) {
        return NkUserFont.create(struct + (long)HANDLE);
    }

    public static NkBakedFont ninfo(long struct) {
        return NkBakedFont.create(struct + (long)INFO);
    }

    public static float nscale(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)SCALE));
    }

    public static @Nullable NkFontGlyph nglyphs(long struct) {
        return NkFontGlyph.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)GLYPHS)));
    }

    public static @Nullable NkFontGlyph nfallback(long struct) {
        return NkFontGlyph.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)FALLBACK)));
    }

    public static int nfallback_codepoint(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FALLBACK_CODEPOINT));
    }

    public static NkHandle ntexture(long struct) {
        return NkHandle.create(struct + (long)TEXTURE);
    }

    public static @Nullable NkFontConfig nconfig(long struct) {
        return NkFontConfig.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)CONFIG)));
    }

    public static void nnext(long struct, @Nullable NkFont value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nhandle(long struct, NkUserFont value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)HANDLE), (long)NkUserFont.SIZEOF);
    }

    public static void ninfo(long struct, NkBakedFont value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)INFO), (long)NkBakedFont.SIZEOF);
    }

    public static void nscale(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)SCALE), (float)value);
    }

    public static void nglyphs(long struct, @Nullable NkFontGlyph value) {
        MemoryUtil.memPutAddress((long)(struct + (long)GLYPHS), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nfallback(long struct, @Nullable NkFontGlyph value) {
        MemoryUtil.memPutAddress((long)(struct + (long)FALLBACK), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nfallback_codepoint(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FALLBACK_CODEPOINT), (int)value);
    }

    public static void ntexture(long struct, NkHandle value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)TEXTURE), (long)NkHandle.SIZEOF);
    }

    public static void nconfig(long struct, @Nullable NkFontConfig value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CONFIG), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    static {
        Struct.Layout layout = NkFont.__struct((Struct.Member[])new Struct.Member[]{NkFont.__member((int)POINTER_SIZE), NkFont.__member((int)NkUserFont.SIZEOF, (int)NkUserFont.ALIGNOF), NkFont.__member((int)NkBakedFont.SIZEOF, (int)NkBakedFont.ALIGNOF), NkFont.__member((int)4), NkFont.__member((int)POINTER_SIZE), NkFont.__member((int)POINTER_SIZE), NkFont.__member((int)4), NkFont.__member((int)NkHandle.SIZEOF, (int)NkHandle.ALIGNOF), NkFont.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NEXT = layout.offsetof(0);
        HANDLE = layout.offsetof(1);
        INFO = layout.offsetof(2);
        SCALE = layout.offsetof(3);
        GLYPHS = layout.offsetof(4);
        FALLBACK = layout.offsetof(5);
        FALLBACK_CODEPOINT = layout.offsetof(6);
        TEXTURE = layout.offsetof(7);
        CONFIG = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<NkFont, Buffer>
    implements NativeResource {
        private static final NkFont ELEMENT_FACTORY = NkFont.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected NkFont getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_font *")
        public @Nullable NkFont next() {
            return NkFont.nnext(this.address());
        }

        @NativeType(value="struct nk_user_font")
        public NkUserFont handle() {
            return NkFont.nhandle(this.address());
        }

        @NativeType(value="struct nk_baked_font")
        public NkBakedFont info() {
            return NkFont.ninfo(this.address());
        }

        public float scale() {
            return NkFont.nscale(this.address());
        }

        @NativeType(value="struct nk_font_glyph *")
        public @Nullable NkFontGlyph glyphs() {
            return NkFont.nglyphs(this.address());
        }

        @NativeType(value="struct nk_font_glyph const *")
        public @Nullable NkFontGlyph fallback() {
            return NkFont.nfallback(this.address());
        }

        @NativeType(value="nk_rune")
        public int fallback_codepoint() {
            return NkFont.nfallback_codepoint(this.address());
        }

        @NativeType(value="nk_handle")
        public NkHandle texture() {
            return NkFont.ntexture(this.address());
        }

        @NativeType(value="struct nk_font_config *")
        public @Nullable NkFontConfig config() {
            return NkFont.nconfig(this.address());
        }

        public Buffer next(@NativeType(value="struct nk_font *") @Nullable NkFont value) {
            NkFont.nnext(this.address(), value);
            return this;
        }

        public Buffer handle(@NativeType(value="struct nk_user_font") NkUserFont value) {
            NkFont.nhandle(this.address(), value);
            return this;
        }

        public Buffer handle(Consumer<NkUserFont> consumer) {
            consumer.accept(this.handle());
            return this;
        }

        public Buffer info(@NativeType(value="struct nk_baked_font") NkBakedFont value) {
            NkFont.ninfo(this.address(), value);
            return this;
        }

        public Buffer info(Consumer<NkBakedFont> consumer) {
            consumer.accept(this.info());
            return this;
        }

        public Buffer scale(float value) {
            NkFont.nscale(this.address(), value);
            return this;
        }

        public Buffer glyphs(@NativeType(value="struct nk_font_glyph *") @Nullable NkFontGlyph value) {
            NkFont.nglyphs(this.address(), value);
            return this;
        }

        public Buffer fallback(@NativeType(value="struct nk_font_glyph const *") @Nullable NkFontGlyph value) {
            NkFont.nfallback(this.address(), value);
            return this;
        }

        public Buffer fallback_codepoint(@NativeType(value="nk_rune") int value) {
            NkFont.nfallback_codepoint(this.address(), value);
            return this;
        }

        public Buffer texture(@NativeType(value="nk_handle") NkHandle value) {
            NkFont.ntexture(this.address(), value);
            return this;
        }

        public Buffer texture(Consumer<NkHandle> consumer) {
            consumer.accept(this.texture());
            return this;
        }

        public Buffer config(@NativeType(value="struct nk_font_config *") @Nullable NkFontConfig value) {
            NkFont.nconfig(this.address(), value);
            return this;
        }
    }
}

