/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkBakedFont;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_font_config")
public class NkFontConfig
extends Struct<NkFontConfig>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NEXT;
    public static final int TTF_BLOB;
    public static final int TTF_SIZE;
    public static final int TTF_DATA_OWNED_BY_ATLAS;
    public static final int MERGE_MODE;
    public static final int PIXEL_SNAP;
    public static final int OVERSAMPLE_V;
    public static final int OVERSAMPLE_H;
    public static final int PADDING;
    public static final int SIZE;
    public static final int COORD_TYPE;
    public static final int SPACING;
    public static final int RANGE;
    public static final int FONT;
    public static final int FALLBACK_GLYPH;
    public static final int N;
    public static final int P;

    protected NkFontConfig(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected NkFontConfig create(long address, @Nullable ByteBuffer container) {
        return new NkFontConfig(address, container);
    }

    public NkFontConfig(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkFontConfig.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_font_config *")
    public @Nullable NkFontConfig next() {
        return NkFontConfig.nnext(this.address());
    }

    @NativeType(value="void *")
    public @Nullable ByteBuffer ttf_blob() {
        return NkFontConfig.nttf_blob(this.address());
    }

    @NativeType(value="nk_size")
    public long ttf_size() {
        return NkFontConfig.nttf_size(this.address());
    }

    @NativeType(value="unsigned char")
    public boolean ttf_data_owned_by_atlas() {
        return NkFontConfig.nttf_data_owned_by_atlas(this.address());
    }

    @NativeType(value="unsigned char")
    public boolean merge_mode() {
        return NkFontConfig.nmerge_mode(this.address());
    }

    @NativeType(value="unsigned char")
    public boolean pixel_snap() {
        return NkFontConfig.npixel_snap(this.address());
    }

    @NativeType(value="unsigned char")
    public boolean oversample_v() {
        return NkFontConfig.noversample_v(this.address());
    }

    @NativeType(value="unsigned char")
    public boolean oversample_h() {
        return NkFontConfig.noversample_h(this.address());
    }

    @NativeType(value="unsigned char[3]")
    public ByteBuffer padding() {
        return NkFontConfig.npadding(this.address());
    }

    @NativeType(value="unsigned char")
    public byte padding(int index) {
        return NkFontConfig.npadding(this.address(), index);
    }

    public float size() {
        return NkFontConfig.nsize(this.address());
    }

    @NativeType(value="enum nk_font_coord_type")
    public int coord_type() {
        return NkFontConfig.ncoord_type(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 spacing() {
        return NkFontConfig.nspacing(this.address());
    }

    @NativeType(value="nk_rune const *")
    public @Nullable IntBuffer range(int capacity) {
        return NkFontConfig.nrange(this.address(), capacity);
    }

    @NativeType(value="struct nk_baked_font *")
    public @Nullable NkBakedFont font() {
        return NkFontConfig.nfont(this.address());
    }

    @NativeType(value="nk_rune")
    public int fallback_glyph() {
        return NkFontConfig.nfallback_glyph(this.address());
    }

    @NativeType(value="struct nk_font_config *")
    public @Nullable NkFontConfig n() {
        return NkFontConfig.nn(this.address());
    }

    @NativeType(value="struct nk_font_config *")
    public @Nullable NkFontConfig p() {
        return NkFontConfig.np(this.address());
    }

    public NkFontConfig next(@NativeType(value="struct nk_font_config *") @Nullable NkFontConfig value) {
        NkFontConfig.nnext(this.address(), value);
        return this;
    }

    public NkFontConfig ttf_blob(@NativeType(value="void *") @Nullable ByteBuffer value) {
        NkFontConfig.nttf_blob(this.address(), value);
        return this;
    }

    public NkFontConfig ttf_size(@NativeType(value="nk_size") long value) {
        NkFontConfig.nttf_size(this.address(), value);
        return this;
    }

    public NkFontConfig ttf_data_owned_by_atlas(@NativeType(value="unsigned char") boolean value) {
        NkFontConfig.nttf_data_owned_by_atlas(this.address(), value);
        return this;
    }

    public NkFontConfig merge_mode(@NativeType(value="unsigned char") boolean value) {
        NkFontConfig.nmerge_mode(this.address(), value);
        return this;
    }

    public NkFontConfig pixel_snap(@NativeType(value="unsigned char") boolean value) {
        NkFontConfig.npixel_snap(this.address(), value);
        return this;
    }

    public NkFontConfig oversample_v(@NativeType(value="unsigned char") boolean value) {
        NkFontConfig.noversample_v(this.address(), value);
        return this;
    }

    public NkFontConfig oversample_h(@NativeType(value="unsigned char") boolean value) {
        NkFontConfig.noversample_h(this.address(), value);
        return this;
    }

    public NkFontConfig padding(@NativeType(value="unsigned char[3]") ByteBuffer value) {
        NkFontConfig.npadding(this.address(), value);
        return this;
    }

    public NkFontConfig padding(int index, @NativeType(value="unsigned char") byte value) {
        NkFontConfig.npadding(this.address(), index, value);
        return this;
    }

    public NkFontConfig size(float value) {
        NkFontConfig.nsize(this.address(), value);
        return this;
    }

    public NkFontConfig coord_type(@NativeType(value="enum nk_font_coord_type") int value) {
        NkFontConfig.ncoord_type(this.address(), value);
        return this;
    }

    public NkFontConfig spacing(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkFontConfig.nspacing(this.address(), value);
        return this;
    }

    public NkFontConfig spacing(Consumer<NkVec2> consumer) {
        consumer.accept(this.spacing());
        return this;
    }

    public NkFontConfig range(@NativeType(value="nk_rune const *") @Nullable IntBuffer value) {
        NkFontConfig.nrange(this.address(), value);
        return this;
    }

    public NkFontConfig font(@NativeType(value="struct nk_baked_font *") @Nullable NkBakedFont value) {
        NkFontConfig.nfont(this.address(), value);
        return this;
    }

    public NkFontConfig fallback_glyph(@NativeType(value="nk_rune") int value) {
        NkFontConfig.nfallback_glyph(this.address(), value);
        return this;
    }

    public NkFontConfig n(@NativeType(value="struct nk_font_config *") @Nullable NkFontConfig value) {
        NkFontConfig.nn(this.address(), value);
        return this;
    }

    public NkFontConfig p(@NativeType(value="struct nk_font_config *") @Nullable NkFontConfig value) {
        NkFontConfig.np(this.address(), value);
        return this;
    }

    public NkFontConfig set(@Nullable NkFontConfig next, @Nullable ByteBuffer ttf_blob, long ttf_size, boolean ttf_data_owned_by_atlas, boolean merge_mode, boolean pixel_snap, boolean oversample_v, boolean oversample_h, ByteBuffer padding, float size, int coord_type, NkVec2 spacing, @Nullable IntBuffer range, @Nullable NkBakedFont font, int fallback_glyph, @Nullable NkFontConfig n, @Nullable NkFontConfig p) {
        this.next(next);
        this.ttf_blob(ttf_blob);
        this.ttf_size(ttf_size);
        this.ttf_data_owned_by_atlas(ttf_data_owned_by_atlas);
        this.merge_mode(merge_mode);
        this.pixel_snap(pixel_snap);
        this.oversample_v(oversample_v);
        this.oversample_h(oversample_h);
        this.padding(padding);
        this.size(size);
        this.coord_type(coord_type);
        this.spacing(spacing);
        this.range(range);
        this.font(font);
        this.fallback_glyph(fallback_glyph);
        this.n(n);
        this.p(p);
        return this;
    }

    public NkFontConfig set(NkFontConfig src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NkFontConfig malloc() {
        return new NkFontConfig(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static NkFontConfig calloc() {
        return new NkFontConfig(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static NkFontConfig create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new NkFontConfig(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static NkFontConfig create(long address) {
        return new NkFontConfig(address, null);
    }

    public static @Nullable NkFontConfig createSafe(long address) {
        return address == 0L ? null : new NkFontConfig(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)NkFontConfig.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkFontConfig.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static NkFontConfig malloc(MemoryStack stack) {
        return new NkFontConfig(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NkFontConfig calloc(MemoryStack stack) {
        return new NkFontConfig(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static @Nullable NkFontConfig nnext(long struct) {
        return NkFontConfig.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)NEXT)));
    }

    public static @Nullable ByteBuffer nttf_blob(long struct) {
        return MemoryUtil.memByteBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)TTF_BLOB)), (int)((int)NkFontConfig.nttf_size(struct)));
    }

    public static long nttf_size(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)TTF_SIZE));
    }

    public static boolean nttf_data_owned_by_atlas(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)TTF_DATA_OWNED_BY_ATLAS)) != 0;
    }

    public static boolean nmerge_mode(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)MERGE_MODE)) != 0;
    }

    public static boolean npixel_snap(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)PIXEL_SNAP)) != 0;
    }

    public static boolean noversample_v(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)OVERSAMPLE_V)) != 0;
    }

    public static boolean noversample_h(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)OVERSAMPLE_H)) != 0;
    }

    public static ByteBuffer npadding(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)PADDING), (int)3);
    }

    public static byte npadding(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)PADDING + Checks.check((int)index, (int)3) * 1L));
    }

    public static float nsize(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)SIZE));
    }

    public static int ncoord_type(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)COORD_TYPE));
    }

    public static NkVec2 nspacing(long struct) {
        return NkVec2.create(struct + (long)SPACING);
    }

    public static @Nullable IntBuffer nrange(long struct, int capacity) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)RANGE)), (int)capacity);
    }

    public static @Nullable NkBakedFont nfont(long struct) {
        return NkBakedFont.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)FONT)));
    }

    public static int nfallback_glyph(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FALLBACK_GLYPH));
    }

    public static @Nullable NkFontConfig nn(long struct) {
        return NkFontConfig.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)N)));
    }

    public static @Nullable NkFontConfig np(long struct) {
        return NkFontConfig.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)P)));
    }

    public static void nnext(long struct, @Nullable NkFontConfig value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nttf_blob(long struct, @Nullable ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)TTF_BLOB), (long)MemoryUtil.memAddressSafe((ByteBuffer)value));
        NkFontConfig.nttf_size(struct, value == null ? 0L : (long)value.remaining());
    }

    public static void nttf_size(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)TTF_SIZE), (long)value);
    }

    public static void nttf_data_owned_by_atlas(long struct, boolean value) {
        MemoryUtil.memPutByte((long)(struct + (long)TTF_DATA_OWNED_BY_ATLAS), (byte)(value ? (byte)1 : 0));
    }

    public static void nmerge_mode(long struct, boolean value) {
        MemoryUtil.memPutByte((long)(struct + (long)MERGE_MODE), (byte)(value ? (byte)1 : 0));
    }

    public static void npixel_snap(long struct, boolean value) {
        MemoryUtil.memPutByte((long)(struct + (long)PIXEL_SNAP), (byte)(value ? (byte)1 : 0));
    }

    public static void noversample_v(long struct, boolean value) {
        MemoryUtil.memPutByte((long)(struct + (long)OVERSAMPLE_V), (byte)(value ? (byte)1 : 0));
    }

    public static void noversample_h(long struct, boolean value) {
        MemoryUtil.memPutByte((long)(struct + (long)OVERSAMPLE_H), (byte)(value ? (byte)1 : 0));
    }

    public static void npadding(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)3);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)PADDING), (long)(value.remaining() * 1));
    }

    public static void npadding(long struct, int index, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)PADDING + Checks.check((int)index, (int)3) * 1L), (byte)value);
    }

    public static void nsize(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)SIZE), (float)value);
    }

    public static void ncoord_type(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)COORD_TYPE), (int)value);
    }

    public static void nspacing(long struct, NkVec2 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SPACING), (long)NkVec2.SIZEOF);
    }

    public static void nrange(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)RANGE), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
    }

    public static void nfont(long struct, @Nullable NkBakedFont value) {
        MemoryUtil.memPutAddress((long)(struct + (long)FONT), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nfallback_glyph(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FALLBACK_GLYPH), (int)value);
    }

    public static void nn(long struct, @Nullable NkFontConfig value) {
        MemoryUtil.memPutAddress((long)(struct + (long)N), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void np(long struct, @Nullable NkFontConfig value) {
        MemoryUtil.memPutAddress((long)(struct + (long)P), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    static {
        Struct.Layout layout = NkFontConfig.__struct((Struct.Member[])new Struct.Member[]{NkFontConfig.__member((int)POINTER_SIZE), NkFontConfig.__member((int)POINTER_SIZE), NkFontConfig.__member((int)POINTER_SIZE), NkFontConfig.__member((int)1), NkFontConfig.__member((int)1), NkFontConfig.__member((int)1), NkFontConfig.__member((int)1), NkFontConfig.__member((int)1), NkFontConfig.__array((int)1, (int)3), NkFontConfig.__member((int)4), NkFontConfig.__member((int)4), NkFontConfig.__member((int)NkVec2.SIZEOF, (int)NkVec2.ALIGNOF), NkFontConfig.__member((int)POINTER_SIZE), NkFontConfig.__member((int)POINTER_SIZE), NkFontConfig.__member((int)4), NkFontConfig.__member((int)POINTER_SIZE), NkFontConfig.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NEXT = layout.offsetof(0);
        TTF_BLOB = layout.offsetof(1);
        TTF_SIZE = layout.offsetof(2);
        TTF_DATA_OWNED_BY_ATLAS = layout.offsetof(3);
        MERGE_MODE = layout.offsetof(4);
        PIXEL_SNAP = layout.offsetof(5);
        OVERSAMPLE_V = layout.offsetof(6);
        OVERSAMPLE_H = layout.offsetof(7);
        PADDING = layout.offsetof(8);
        SIZE = layout.offsetof(9);
        COORD_TYPE = layout.offsetof(10);
        SPACING = layout.offsetof(11);
        RANGE = layout.offsetof(12);
        FONT = layout.offsetof(13);
        FALLBACK_GLYPH = layout.offsetof(14);
        N = layout.offsetof(15);
        P = layout.offsetof(16);
    }

    public static class Buffer
    extends StructBuffer<NkFontConfig, Buffer>
    implements NativeResource {
        private static final NkFontConfig ELEMENT_FACTORY = NkFontConfig.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected NkFontConfig getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_font_config *")
        public @Nullable NkFontConfig next() {
            return NkFontConfig.nnext(this.address());
        }

        @NativeType(value="void *")
        public @Nullable ByteBuffer ttf_blob() {
            return NkFontConfig.nttf_blob(this.address());
        }

        @NativeType(value="nk_size")
        public long ttf_size() {
            return NkFontConfig.nttf_size(this.address());
        }

        @NativeType(value="unsigned char")
        public boolean ttf_data_owned_by_atlas() {
            return NkFontConfig.nttf_data_owned_by_atlas(this.address());
        }

        @NativeType(value="unsigned char")
        public boolean merge_mode() {
            return NkFontConfig.nmerge_mode(this.address());
        }

        @NativeType(value="unsigned char")
        public boolean pixel_snap() {
            return NkFontConfig.npixel_snap(this.address());
        }

        @NativeType(value="unsigned char")
        public boolean oversample_v() {
            return NkFontConfig.noversample_v(this.address());
        }

        @NativeType(value="unsigned char")
        public boolean oversample_h() {
            return NkFontConfig.noversample_h(this.address());
        }

        @NativeType(value="unsigned char[3]")
        public ByteBuffer padding() {
            return NkFontConfig.npadding(this.address());
        }

        @NativeType(value="unsigned char")
        public byte padding(int index) {
            return NkFontConfig.npadding(this.address(), index);
        }

        public float size() {
            return NkFontConfig.nsize(this.address());
        }

        @NativeType(value="enum nk_font_coord_type")
        public int coord_type() {
            return NkFontConfig.ncoord_type(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 spacing() {
            return NkFontConfig.nspacing(this.address());
        }

        @NativeType(value="nk_rune const *")
        public @Nullable IntBuffer range(int capacity) {
            return NkFontConfig.nrange(this.address(), capacity);
        }

        @NativeType(value="struct nk_baked_font *")
        public @Nullable NkBakedFont font() {
            return NkFontConfig.nfont(this.address());
        }

        @NativeType(value="nk_rune")
        public int fallback_glyph() {
            return NkFontConfig.nfallback_glyph(this.address());
        }

        @NativeType(value="struct nk_font_config *")
        public @Nullable NkFontConfig n() {
            return NkFontConfig.nn(this.address());
        }

        @NativeType(value="struct nk_font_config *")
        public @Nullable NkFontConfig p() {
            return NkFontConfig.np(this.address());
        }

        public Buffer next(@NativeType(value="struct nk_font_config *") @Nullable NkFontConfig value) {
            NkFontConfig.nnext(this.address(), value);
            return this;
        }

        public Buffer ttf_blob(@NativeType(value="void *") @Nullable ByteBuffer value) {
            NkFontConfig.nttf_blob(this.address(), value);
            return this;
        }

        public Buffer ttf_size(@NativeType(value="nk_size") long value) {
            NkFontConfig.nttf_size(this.address(), value);
            return this;
        }

        public Buffer ttf_data_owned_by_atlas(@NativeType(value="unsigned char") boolean value) {
            NkFontConfig.nttf_data_owned_by_atlas(this.address(), value);
            return this;
        }

        public Buffer merge_mode(@NativeType(value="unsigned char") boolean value) {
            NkFontConfig.nmerge_mode(this.address(), value);
            return this;
        }

        public Buffer pixel_snap(@NativeType(value="unsigned char") boolean value) {
            NkFontConfig.npixel_snap(this.address(), value);
            return this;
        }

        public Buffer oversample_v(@NativeType(value="unsigned char") boolean value) {
            NkFontConfig.noversample_v(this.address(), value);
            return this;
        }

        public Buffer oversample_h(@NativeType(value="unsigned char") boolean value) {
            NkFontConfig.noversample_h(this.address(), value);
            return this;
        }

        public Buffer padding(@NativeType(value="unsigned char[3]") ByteBuffer value) {
            NkFontConfig.npadding(this.address(), value);
            return this;
        }

        public Buffer padding(int index, @NativeType(value="unsigned char") byte value) {
            NkFontConfig.npadding(this.address(), index, value);
            return this;
        }

        public Buffer size(float value) {
            NkFontConfig.nsize(this.address(), value);
            return this;
        }

        public Buffer coord_type(@NativeType(value="enum nk_font_coord_type") int value) {
            NkFontConfig.ncoord_type(this.address(), value);
            return this;
        }

        public Buffer spacing(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkFontConfig.nspacing(this.address(), value);
            return this;
        }

        public Buffer spacing(Consumer<NkVec2> consumer) {
            consumer.accept(this.spacing());
            return this;
        }

        public Buffer range(@NativeType(value="nk_rune const *") @Nullable IntBuffer value) {
            NkFontConfig.nrange(this.address(), value);
            return this;
        }

        public Buffer font(@NativeType(value="struct nk_baked_font *") @Nullable NkBakedFont value) {
            NkFontConfig.nfont(this.address(), value);
            return this;
        }

        public Buffer fallback_glyph(@NativeType(value="nk_rune") int value) {
            NkFontConfig.nfallback_glyph(this.address(), value);
            return this;
        }

        public Buffer n(@NativeType(value="struct nk_font_config *") @Nullable NkFontConfig value) {
            NkFontConfig.nn(this.address(), value);
            return this;
        }

        public Buffer p(@NativeType(value="struct nk_font_config *") @Nullable NkFontConfig value) {
            NkFontConfig.np(this.address(), value);
            return this;
        }
    }
}

