/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkColor;
import org.lwjgl.nuklear.NkDrawBeginCallback;
import org.lwjgl.nuklear.NkDrawBeginCallbackI;
import org.lwjgl.nuklear.NkDrawEndCallback;
import org.lwjgl.nuklear.NkDrawEndCallbackI;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.nuklear.NkStyleButton;
import org.lwjgl.nuklear.NkStyleItem;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_style_scrollbar")
public class NkStyleScrollbar
extends Struct<NkStyleScrollbar>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NORMAL;
    public static final int HOVER;
    public static final int ACTIVE;
    public static final int BORDER_COLOR;
    public static final int CURSOR_NORMAL;
    public static final int CURSOR_HOVER;
    public static final int CURSOR_ACTIVE;
    public static final int CURSOR_BORDER_COLOR;
    public static final int BORDER;
    public static final int ROUNDING;
    public static final int BORDER_CURSOR;
    public static final int ROUNDING_CURSOR;
    public static final int PADDING;
    public static final int COLOR_FACTOR;
    public static final int DISABLED_FACTOR;
    public static final int SHOW_BUTTONS;
    public static final int INC_BUTTON;
    public static final int DEC_BUTTON;
    public static final int INC_SYMBOL;
    public static final int DEC_SYMBOL;
    public static final int USERDATA;
    public static final int DRAW_BEGIN;
    public static final int DRAW_END;

    protected NkStyleScrollbar(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected NkStyleScrollbar create(long address, @Nullable ByteBuffer container) {
        return new NkStyleScrollbar(address, container);
    }

    public NkStyleScrollbar(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkStyleScrollbar.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem normal() {
        return NkStyleScrollbar.nnormal(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem hover() {
        return NkStyleScrollbar.nhover(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem active() {
        return NkStyleScrollbar.nactive(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor border_color() {
        return NkStyleScrollbar.nborder_color(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem cursor_normal() {
        return NkStyleScrollbar.ncursor_normal(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem cursor_hover() {
        return NkStyleScrollbar.ncursor_hover(this.address());
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem cursor_active() {
        return NkStyleScrollbar.ncursor_active(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor cursor_border_color() {
        return NkStyleScrollbar.ncursor_border_color(this.address());
    }

    public float border() {
        return NkStyleScrollbar.nborder(this.address());
    }

    public float rounding() {
        return NkStyleScrollbar.nrounding(this.address());
    }

    public float border_cursor() {
        return NkStyleScrollbar.nborder_cursor(this.address());
    }

    public float rounding_cursor() {
        return NkStyleScrollbar.nrounding_cursor(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 padding() {
        return NkStyleScrollbar.npadding(this.address());
    }

    public float color_factor() {
        return NkStyleScrollbar.ncolor_factor(this.address());
    }

    public float disabled_factor() {
        return NkStyleScrollbar.ndisabled_factor(this.address());
    }

    public int show_buttons() {
        return NkStyleScrollbar.nshow_buttons(this.address());
    }

    @NativeType(value="struct nk_style_button")
    public NkStyleButton inc_button() {
        return NkStyleScrollbar.ninc_button(this.address());
    }

    @NativeType(value="struct nk_style_button")
    public NkStyleButton dec_button() {
        return NkStyleScrollbar.ndec_button(this.address());
    }

    @NativeType(value="enum nk_symbol_type")
    public int inc_symbol() {
        return NkStyleScrollbar.ninc_symbol(this.address());
    }

    @NativeType(value="enum nk_symbol_type")
    public int dec_symbol() {
        return NkStyleScrollbar.ndec_symbol(this.address());
    }

    @NativeType(value="nk_handle")
    public NkHandle userdata() {
        return NkStyleScrollbar.nuserdata(this.address());
    }

    @NativeType(value="nk_draw_begin")
    public @Nullable NkDrawBeginCallback draw_begin() {
        return NkStyleScrollbar.ndraw_begin(this.address());
    }

    @NativeType(value="nk_draw_end")
    public @Nullable NkDrawEndCallback draw_end() {
        return NkStyleScrollbar.ndraw_end(this.address());
    }

    public NkStyleScrollbar normal(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleScrollbar.nnormal(this.address(), value);
        return this;
    }

    public NkStyleScrollbar normal(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.normal());
        return this;
    }

    public NkStyleScrollbar hover(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleScrollbar.nhover(this.address(), value);
        return this;
    }

    public NkStyleScrollbar hover(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.hover());
        return this;
    }

    public NkStyleScrollbar active(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleScrollbar.nactive(this.address(), value);
        return this;
    }

    public NkStyleScrollbar active(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.active());
        return this;
    }

    public NkStyleScrollbar border_color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleScrollbar.nborder_color(this.address(), value);
        return this;
    }

    public NkStyleScrollbar border_color(Consumer<NkColor> consumer) {
        consumer.accept(this.border_color());
        return this;
    }

    public NkStyleScrollbar cursor_normal(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleScrollbar.ncursor_normal(this.address(), value);
        return this;
    }

    public NkStyleScrollbar cursor_normal(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.cursor_normal());
        return this;
    }

    public NkStyleScrollbar cursor_hover(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleScrollbar.ncursor_hover(this.address(), value);
        return this;
    }

    public NkStyleScrollbar cursor_hover(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.cursor_hover());
        return this;
    }

    public NkStyleScrollbar cursor_active(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleScrollbar.ncursor_active(this.address(), value);
        return this;
    }

    public NkStyleScrollbar cursor_active(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.cursor_active());
        return this;
    }

    public NkStyleScrollbar cursor_border_color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleScrollbar.ncursor_border_color(this.address(), value);
        return this;
    }

    public NkStyleScrollbar cursor_border_color(Consumer<NkColor> consumer) {
        consumer.accept(this.cursor_border_color());
        return this;
    }

    public NkStyleScrollbar border(float value) {
        NkStyleScrollbar.nborder(this.address(), value);
        return this;
    }

    public NkStyleScrollbar rounding(float value) {
        NkStyleScrollbar.nrounding(this.address(), value);
        return this;
    }

    public NkStyleScrollbar border_cursor(float value) {
        NkStyleScrollbar.nborder_cursor(this.address(), value);
        return this;
    }

    public NkStyleScrollbar rounding_cursor(float value) {
        NkStyleScrollbar.nrounding_cursor(this.address(), value);
        return this;
    }

    public NkStyleScrollbar padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleScrollbar.npadding(this.address(), value);
        return this;
    }

    public NkStyleScrollbar padding(Consumer<NkVec2> consumer) {
        consumer.accept(this.padding());
        return this;
    }

    public NkStyleScrollbar color_factor(float value) {
        NkStyleScrollbar.ncolor_factor(this.address(), value);
        return this;
    }

    public NkStyleScrollbar disabled_factor(float value) {
        NkStyleScrollbar.ndisabled_factor(this.address(), value);
        return this;
    }

    public NkStyleScrollbar show_buttons(int value) {
        NkStyleScrollbar.nshow_buttons(this.address(), value);
        return this;
    }

    public NkStyleScrollbar inc_button(@NativeType(value="struct nk_style_button") NkStyleButton value) {
        NkStyleScrollbar.ninc_button(this.address(), value);
        return this;
    }

    public NkStyleScrollbar inc_button(Consumer<NkStyleButton> consumer) {
        consumer.accept(this.inc_button());
        return this;
    }

    public NkStyleScrollbar dec_button(@NativeType(value="struct nk_style_button") NkStyleButton value) {
        NkStyleScrollbar.ndec_button(this.address(), value);
        return this;
    }

    public NkStyleScrollbar dec_button(Consumer<NkStyleButton> consumer) {
        consumer.accept(this.dec_button());
        return this;
    }

    public NkStyleScrollbar inc_symbol(@NativeType(value="enum nk_symbol_type") int value) {
        NkStyleScrollbar.ninc_symbol(this.address(), value);
        return this;
    }

    public NkStyleScrollbar dec_symbol(@NativeType(value="enum nk_symbol_type") int value) {
        NkStyleScrollbar.ndec_symbol(this.address(), value);
        return this;
    }

    public NkStyleScrollbar userdata(@NativeType(value="nk_handle") NkHandle value) {
        NkStyleScrollbar.nuserdata(this.address(), value);
        return this;
    }

    public NkStyleScrollbar userdata(Consumer<NkHandle> consumer) {
        consumer.accept(this.userdata());
        return this;
    }

    public NkStyleScrollbar draw_begin(@NativeType(value="nk_draw_begin") @Nullable NkDrawBeginCallbackI value) {
        NkStyleScrollbar.ndraw_begin(this.address(), value);
        return this;
    }

    public NkStyleScrollbar draw_end(@NativeType(value="nk_draw_end") @Nullable NkDrawEndCallbackI value) {
        NkStyleScrollbar.ndraw_end(this.address(), value);
        return this;
    }

    public NkStyleScrollbar set(NkStyleItem normal, NkStyleItem hover, NkStyleItem active, NkColor border_color, NkStyleItem cursor_normal, NkStyleItem cursor_hover, NkStyleItem cursor_active, NkColor cursor_border_color, float border, float rounding, float border_cursor, float rounding_cursor, NkVec2 padding, float color_factor, float disabled_factor, int show_buttons, NkStyleButton inc_button, NkStyleButton dec_button, int inc_symbol, int dec_symbol, NkHandle userdata, NkDrawBeginCallbackI draw_begin, NkDrawEndCallbackI draw_end) {
        this.normal(normal);
        this.hover(hover);
        this.active(active);
        this.border_color(border_color);
        this.cursor_normal(cursor_normal);
        this.cursor_hover(cursor_hover);
        this.cursor_active(cursor_active);
        this.cursor_border_color(cursor_border_color);
        this.border(border);
        this.rounding(rounding);
        this.border_cursor(border_cursor);
        this.rounding_cursor(rounding_cursor);
        this.padding(padding);
        this.color_factor(color_factor);
        this.disabled_factor(disabled_factor);
        this.show_buttons(show_buttons);
        this.inc_button(inc_button);
        this.dec_button(dec_button);
        this.inc_symbol(inc_symbol);
        this.dec_symbol(dec_symbol);
        this.userdata(userdata);
        this.draw_begin(draw_begin);
        this.draw_end(draw_end);
        return this;
    }

    public NkStyleScrollbar set(NkStyleScrollbar src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NkStyleScrollbar malloc() {
        return new NkStyleScrollbar(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static NkStyleScrollbar calloc() {
        return new NkStyleScrollbar(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static NkStyleScrollbar create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new NkStyleScrollbar(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static NkStyleScrollbar create(long address) {
        return new NkStyleScrollbar(address, null);
    }

    public static @Nullable NkStyleScrollbar createSafe(long address) {
        return address == 0L ? null : new NkStyleScrollbar(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)NkStyleScrollbar.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkStyleScrollbar.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static NkStyleScrollbar mallocStack() {
        return NkStyleScrollbar.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStyleScrollbar callocStack() {
        return NkStyleScrollbar.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStyleScrollbar mallocStack(MemoryStack stack) {
        return NkStyleScrollbar.malloc(stack);
    }

    @Deprecated
    public static NkStyleScrollbar callocStack(MemoryStack stack) {
        return NkStyleScrollbar.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkStyleScrollbar.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkStyleScrollbar.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkStyleScrollbar.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkStyleScrollbar.calloc(capacity, stack);
    }

    public static NkStyleScrollbar malloc(MemoryStack stack) {
        return new NkStyleScrollbar(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NkStyleScrollbar calloc(MemoryStack stack) {
        return new NkStyleScrollbar(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkStyleItem nnormal(long struct) {
        return NkStyleItem.create(struct + (long)NORMAL);
    }

    public static NkStyleItem nhover(long struct) {
        return NkStyleItem.create(struct + (long)HOVER);
    }

    public static NkStyleItem nactive(long struct) {
        return NkStyleItem.create(struct + (long)ACTIVE);
    }

    public static NkColor nborder_color(long struct) {
        return NkColor.create(struct + (long)BORDER_COLOR);
    }

    public static NkStyleItem ncursor_normal(long struct) {
        return NkStyleItem.create(struct + (long)CURSOR_NORMAL);
    }

    public static NkStyleItem ncursor_hover(long struct) {
        return NkStyleItem.create(struct + (long)CURSOR_HOVER);
    }

    public static NkStyleItem ncursor_active(long struct) {
        return NkStyleItem.create(struct + (long)CURSOR_ACTIVE);
    }

    public static NkColor ncursor_border_color(long struct) {
        return NkColor.create(struct + (long)CURSOR_BORDER_COLOR);
    }

    public static float nborder(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)BORDER));
    }

    public static float nrounding(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)ROUNDING));
    }

    public static float nborder_cursor(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)BORDER_CURSOR));
    }

    public static float nrounding_cursor(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)ROUNDING_CURSOR));
    }

    public static NkVec2 npadding(long struct) {
        return NkVec2.create(struct + (long)PADDING);
    }

    public static float ncolor_factor(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)COLOR_FACTOR));
    }

    public static float ndisabled_factor(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)DISABLED_FACTOR));
    }

    public static int nshow_buttons(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SHOW_BUTTONS));
    }

    public static NkStyleButton ninc_button(long struct) {
        return NkStyleButton.create(struct + (long)INC_BUTTON);
    }

    public static NkStyleButton ndec_button(long struct) {
        return NkStyleButton.create(struct + (long)DEC_BUTTON);
    }

    public static int ninc_symbol(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)INC_SYMBOL));
    }

    public static int ndec_symbol(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DEC_SYMBOL));
    }

    public static NkHandle nuserdata(long struct) {
        return NkHandle.create(struct + (long)USERDATA);
    }

    public static @Nullable NkDrawBeginCallback ndraw_begin(long struct) {
        return NkDrawBeginCallback.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)DRAW_BEGIN)));
    }

    public static @Nullable NkDrawEndCallback ndraw_end(long struct) {
        return NkDrawEndCallback.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)DRAW_END)));
    }

    public static void nnormal(long struct, NkStyleItem value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)NORMAL), (long)NkStyleItem.SIZEOF);
    }

    public static void nhover(long struct, NkStyleItem value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)HOVER), (long)NkStyleItem.SIZEOF);
    }

    public static void nactive(long struct, NkStyleItem value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)ACTIVE), (long)NkStyleItem.SIZEOF);
    }

    public static void nborder_color(long struct, NkColor value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)BORDER_COLOR), (long)NkColor.SIZEOF);
    }

    public static void ncursor_normal(long struct, NkStyleItem value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CURSOR_NORMAL), (long)NkStyleItem.SIZEOF);
    }

    public static void ncursor_hover(long struct, NkStyleItem value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CURSOR_HOVER), (long)NkStyleItem.SIZEOF);
    }

    public static void ncursor_active(long struct, NkStyleItem value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CURSOR_ACTIVE), (long)NkStyleItem.SIZEOF);
    }

    public static void ncursor_border_color(long struct, NkColor value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CURSOR_BORDER_COLOR), (long)NkColor.SIZEOF);
    }

    public static void nborder(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)BORDER), (float)value);
    }

    public static void nrounding(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)ROUNDING), (float)value);
    }

    public static void nborder_cursor(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)BORDER_CURSOR), (float)value);
    }

    public static void nrounding_cursor(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)ROUNDING_CURSOR), (float)value);
    }

    public static void npadding(long struct, NkVec2 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PADDING), (long)NkVec2.SIZEOF);
    }

    public static void ncolor_factor(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)COLOR_FACTOR), (float)value);
    }

    public static void ndisabled_factor(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)DISABLED_FACTOR), (float)value);
    }

    public static void nshow_buttons(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SHOW_BUTTONS), (int)value);
    }

    public static void ninc_button(long struct, NkStyleButton value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)INC_BUTTON), (long)NkStyleButton.SIZEOF);
    }

    public static void ndec_button(long struct, NkStyleButton value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)DEC_BUTTON), (long)NkStyleButton.SIZEOF);
    }

    public static void ninc_symbol(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)INC_SYMBOL), (int)value);
    }

    public static void ndec_symbol(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DEC_SYMBOL), (int)value);
    }

    public static void nuserdata(long struct, NkHandle value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)USERDATA), (long)NkHandle.SIZEOF);
    }

    public static void ndraw_begin(long struct, @Nullable NkDrawBeginCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DRAW_BEGIN), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void ndraw_end(long struct, @Nullable NkDrawEndCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DRAW_END), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    static {
        Struct.Layout layout = NkStyleScrollbar.__struct((Struct.Member[])new Struct.Member[]{NkStyleScrollbar.__member((int)NkStyleItem.SIZEOF, (int)NkStyleItem.ALIGNOF), NkStyleScrollbar.__member((int)NkStyleItem.SIZEOF, (int)NkStyleItem.ALIGNOF), NkStyleScrollbar.__member((int)NkStyleItem.SIZEOF, (int)NkStyleItem.ALIGNOF), NkStyleScrollbar.__member((int)NkColor.SIZEOF, (int)NkColor.ALIGNOF), NkStyleScrollbar.__member((int)NkStyleItem.SIZEOF, (int)NkStyleItem.ALIGNOF), NkStyleScrollbar.__member((int)NkStyleItem.SIZEOF, (int)NkStyleItem.ALIGNOF), NkStyleScrollbar.__member((int)NkStyleItem.SIZEOF, (int)NkStyleItem.ALIGNOF), NkStyleScrollbar.__member((int)NkColor.SIZEOF, (int)NkColor.ALIGNOF), NkStyleScrollbar.__member((int)4), NkStyleScrollbar.__member((int)4), NkStyleScrollbar.__member((int)4), NkStyleScrollbar.__member((int)4), NkStyleScrollbar.__member((int)NkVec2.SIZEOF, (int)NkVec2.ALIGNOF), NkStyleScrollbar.__member((int)4), NkStyleScrollbar.__member((int)4), NkStyleScrollbar.__member((int)4), NkStyleScrollbar.__member((int)NkStyleButton.SIZEOF, (int)NkStyleButton.ALIGNOF), NkStyleScrollbar.__member((int)NkStyleButton.SIZEOF, (int)NkStyleButton.ALIGNOF), NkStyleScrollbar.__member((int)4), NkStyleScrollbar.__member((int)4), NkStyleScrollbar.__member((int)NkHandle.SIZEOF, (int)NkHandle.ALIGNOF), NkStyleScrollbar.__member((int)POINTER_SIZE), NkStyleScrollbar.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NORMAL = layout.offsetof(0);
        HOVER = layout.offsetof(1);
        ACTIVE = layout.offsetof(2);
        BORDER_COLOR = layout.offsetof(3);
        CURSOR_NORMAL = layout.offsetof(4);
        CURSOR_HOVER = layout.offsetof(5);
        CURSOR_ACTIVE = layout.offsetof(6);
        CURSOR_BORDER_COLOR = layout.offsetof(7);
        BORDER = layout.offsetof(8);
        ROUNDING = layout.offsetof(9);
        BORDER_CURSOR = layout.offsetof(10);
        ROUNDING_CURSOR = layout.offsetof(11);
        PADDING = layout.offsetof(12);
        COLOR_FACTOR = layout.offsetof(13);
        DISABLED_FACTOR = layout.offsetof(14);
        SHOW_BUTTONS = layout.offsetof(15);
        INC_BUTTON = layout.offsetof(16);
        DEC_BUTTON = layout.offsetof(17);
        INC_SYMBOL = layout.offsetof(18);
        DEC_SYMBOL = layout.offsetof(19);
        USERDATA = layout.offsetof(20);
        DRAW_BEGIN = layout.offsetof(21);
        DRAW_END = layout.offsetof(22);
    }

    public static class Buffer
    extends StructBuffer<NkStyleScrollbar, Buffer>
    implements NativeResource {
        private static final NkStyleScrollbar ELEMENT_FACTORY = NkStyleScrollbar.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected NkStyleScrollbar getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem normal() {
            return NkStyleScrollbar.nnormal(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem hover() {
            return NkStyleScrollbar.nhover(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem active() {
            return NkStyleScrollbar.nactive(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor border_color() {
            return NkStyleScrollbar.nborder_color(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem cursor_normal() {
            return NkStyleScrollbar.ncursor_normal(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem cursor_hover() {
            return NkStyleScrollbar.ncursor_hover(this.address());
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem cursor_active() {
            return NkStyleScrollbar.ncursor_active(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor cursor_border_color() {
            return NkStyleScrollbar.ncursor_border_color(this.address());
        }

        public float border() {
            return NkStyleScrollbar.nborder(this.address());
        }

        public float rounding() {
            return NkStyleScrollbar.nrounding(this.address());
        }

        public float border_cursor() {
            return NkStyleScrollbar.nborder_cursor(this.address());
        }

        public float rounding_cursor() {
            return NkStyleScrollbar.nrounding_cursor(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 padding() {
            return NkStyleScrollbar.npadding(this.address());
        }

        public float color_factor() {
            return NkStyleScrollbar.ncolor_factor(this.address());
        }

        public float disabled_factor() {
            return NkStyleScrollbar.ndisabled_factor(this.address());
        }

        public int show_buttons() {
            return NkStyleScrollbar.nshow_buttons(this.address());
        }

        @NativeType(value="struct nk_style_button")
        public NkStyleButton inc_button() {
            return NkStyleScrollbar.ninc_button(this.address());
        }

        @NativeType(value="struct nk_style_button")
        public NkStyleButton dec_button() {
            return NkStyleScrollbar.ndec_button(this.address());
        }

        @NativeType(value="enum nk_symbol_type")
        public int inc_symbol() {
            return NkStyleScrollbar.ninc_symbol(this.address());
        }

        @NativeType(value="enum nk_symbol_type")
        public int dec_symbol() {
            return NkStyleScrollbar.ndec_symbol(this.address());
        }

        @NativeType(value="nk_handle")
        public NkHandle userdata() {
            return NkStyleScrollbar.nuserdata(this.address());
        }

        @NativeType(value="nk_draw_begin")
        public @Nullable NkDrawBeginCallback draw_begin() {
            return NkStyleScrollbar.ndraw_begin(this.address());
        }

        @NativeType(value="nk_draw_end")
        public @Nullable NkDrawEndCallback draw_end() {
            return NkStyleScrollbar.ndraw_end(this.address());
        }

        public Buffer normal(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleScrollbar.nnormal(this.address(), value);
            return this;
        }

        public Buffer normal(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.normal());
            return this;
        }

        public Buffer hover(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleScrollbar.nhover(this.address(), value);
            return this;
        }

        public Buffer hover(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.hover());
            return this;
        }

        public Buffer active(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleScrollbar.nactive(this.address(), value);
            return this;
        }

        public Buffer active(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.active());
            return this;
        }

        public Buffer border_color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleScrollbar.nborder_color(this.address(), value);
            return this;
        }

        public Buffer border_color(Consumer<NkColor> consumer) {
            consumer.accept(this.border_color());
            return this;
        }

        public Buffer cursor_normal(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleScrollbar.ncursor_normal(this.address(), value);
            return this;
        }

        public Buffer cursor_normal(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.cursor_normal());
            return this;
        }

        public Buffer cursor_hover(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleScrollbar.ncursor_hover(this.address(), value);
            return this;
        }

        public Buffer cursor_hover(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.cursor_hover());
            return this;
        }

        public Buffer cursor_active(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleScrollbar.ncursor_active(this.address(), value);
            return this;
        }

        public Buffer cursor_active(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.cursor_active());
            return this;
        }

        public Buffer cursor_border_color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleScrollbar.ncursor_border_color(this.address(), value);
            return this;
        }

        public Buffer cursor_border_color(Consumer<NkColor> consumer) {
            consumer.accept(this.cursor_border_color());
            return this;
        }

        public Buffer border(float value) {
            NkStyleScrollbar.nborder(this.address(), value);
            return this;
        }

        public Buffer rounding(float value) {
            NkStyleScrollbar.nrounding(this.address(), value);
            return this;
        }

        public Buffer border_cursor(float value) {
            NkStyleScrollbar.nborder_cursor(this.address(), value);
            return this;
        }

        public Buffer rounding_cursor(float value) {
            NkStyleScrollbar.nrounding_cursor(this.address(), value);
            return this;
        }

        public Buffer padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleScrollbar.npadding(this.address(), value);
            return this;
        }

        public Buffer padding(Consumer<NkVec2> consumer) {
            consumer.accept(this.padding());
            return this;
        }

        public Buffer color_factor(float value) {
            NkStyleScrollbar.ncolor_factor(this.address(), value);
            return this;
        }

        public Buffer disabled_factor(float value) {
            NkStyleScrollbar.ndisabled_factor(this.address(), value);
            return this;
        }

        public Buffer show_buttons(int value) {
            NkStyleScrollbar.nshow_buttons(this.address(), value);
            return this;
        }

        public Buffer inc_button(@NativeType(value="struct nk_style_button") NkStyleButton value) {
            NkStyleScrollbar.ninc_button(this.address(), value);
            return this;
        }

        public Buffer inc_button(Consumer<NkStyleButton> consumer) {
            consumer.accept(this.inc_button());
            return this;
        }

        public Buffer dec_button(@NativeType(value="struct nk_style_button") NkStyleButton value) {
            NkStyleScrollbar.ndec_button(this.address(), value);
            return this;
        }

        public Buffer dec_button(Consumer<NkStyleButton> consumer) {
            consumer.accept(this.dec_button());
            return this;
        }

        public Buffer inc_symbol(@NativeType(value="enum nk_symbol_type") int value) {
            NkStyleScrollbar.ninc_symbol(this.address(), value);
            return this;
        }

        public Buffer dec_symbol(@NativeType(value="enum nk_symbol_type") int value) {
            NkStyleScrollbar.ndec_symbol(this.address(), value);
            return this;
        }

        public Buffer userdata(@NativeType(value="nk_handle") NkHandle value) {
            NkStyleScrollbar.nuserdata(this.address(), value);
            return this;
        }

        public Buffer userdata(Consumer<NkHandle> consumer) {
            consumer.accept(this.userdata());
            return this;
        }

        public Buffer draw_begin(@NativeType(value="nk_draw_begin") @Nullable NkDrawBeginCallbackI value) {
            NkStyleScrollbar.ndraw_begin(this.address(), value);
            return this;
        }

        public Buffer draw_end(@NativeType(value="nk_draw_end") @Nullable NkDrawEndCallbackI value) {
            NkStyleScrollbar.ndraw_end(this.address(), value);
            return this;
        }
    }
}

