/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.util.Set;
import java.util.function.IntFunction;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProviderLocal;
import org.lwjgl.system.ThreadLocalUtil;

public final class ALCCapabilities {
    public final long alcOpenDevice;
    public final long alcCloseDevice;
    public final long alcCreateContext;
    public final long alcMakeContextCurrent;
    public final long alcProcessContext;
    public final long alcSuspendContext;
    public final long alcDestroyContext;
    public final long alcGetCurrentContext;
    public final long alcGetContextsDevice;
    public final long alcIsExtensionPresent;
    public final long alcGetProcAddress;
    public final long alcGetEnumValue;
    public final long alcGetError;
    public final long alcGetString;
    public final long alcGetIntegerv;
    public final long alcCaptureOpenDevice;
    public final long alcCaptureCloseDevice;
    public final long alcCaptureStart;
    public final long alcCaptureStop;
    public final long alcCaptureSamples;
    public final long alcGetProcAddress2;
    public final long alcSetThreadContext;
    public final long alcGetThreadContext;
    public final long alcGetInteger64vSOFT;
    public final long alcGetStringiSOFT;
    public final long alcResetDeviceSOFT;
    public final long alcLoopbackOpenDeviceSOFT;
    public final long alcIsRenderFormatSupportedSOFT;
    public final long alcRenderSamplesSOFT;
    public final long alcDevicePauseSOFT;
    public final long alcDeviceResumeSOFT;
    public final long alcReopenDeviceSOFT;
    public final long alcEventIsSupportedSOFT;
    public final long alcEventControlSOFT;
    public final long alcEventCallbackSOFT;
    public final boolean OpenALC10;
    public final boolean OpenALC11;
    public final boolean OpenALC_SOFT_loopback_bformat;
    public final boolean ALC_ENUMERATE_ALL_EXT;
    public final boolean ALC_ENUMERATION_EXT;
    public final boolean ALC_EXT_CAPTURE;
    public final boolean ALC_EXT_debug;
    public final boolean ALC_EXT_DEDICATED;
    public final boolean ALC_EXT_DEFAULT_FILTER_ORDER;
    public final boolean ALC_EXT_direct_context;
    public final boolean ALC_EXT_disconnect;
    public final boolean ALC_EXT_EFX;
    public final boolean ALC_EXT_thread_local_context;
    public final boolean ALC_LOKI_audio_channel;
    public final boolean ALC_SOFT_device_clock;
    public final boolean ALC_SOFT_HRTF;
    public final boolean ALC_SOFT_loopback;
    public final boolean ALC_SOFT_output_limiter;
    public final boolean ALC_SOFT_output_mode;
    public final boolean ALC_SOFT_pause_device;
    public final boolean ALC_SOFT_reopen_device;
    public final boolean ALC_SOFT_system_events;
    final long device;
    final PointerBuffer addresses;

    ALCCapabilities(FunctionProviderLocal provider, long device, Set<String> ext, IntFunction<PointerBuffer> bufferFactory) {
        this.device = device;
        PointerBuffer caps = bufferFactory.apply(35);
        this.OpenALC10 = ALCCapabilities.check_ALC10(provider, device, caps, ext);
        this.OpenALC11 = ALCCapabilities.check_ALC11(provider, device, caps, ext);
        this.OpenALC_SOFT_loopback_bformat = ext.contains("OpenALC_SOFT_loopback_bformat");
        this.ALC_ENUMERATE_ALL_EXT = ext.contains("ALC_ENUMERATE_ALL_EXT");
        this.ALC_ENUMERATION_EXT = ext.contains("ALC_ENUMERATION_EXT");
        this.ALC_EXT_CAPTURE = ALCCapabilities.check_EXT_CAPTURE(provider, device, caps, ext);
        this.ALC_EXT_debug = ext.contains("ALC_EXT_debug");
        this.ALC_EXT_DEDICATED = ext.contains("ALC_EXT_DEDICATED");
        this.ALC_EXT_DEFAULT_FILTER_ORDER = ext.contains("ALC_EXT_DEFAULT_FILTER_ORDER");
        this.ALC_EXT_direct_context = ALCCapabilities.check_EXT_direct_context(provider, device, caps, ext);
        this.ALC_EXT_disconnect = ext.contains("ALC_EXT_disconnect");
        this.ALC_EXT_EFX = ext.contains("ALC_EXT_EFX");
        this.ALC_EXT_thread_local_context = ALCCapabilities.check_EXT_thread_local_context(provider, device, caps, ext);
        this.ALC_LOKI_audio_channel = ext.contains("ALC_LOKI_audio_channel");
        this.ALC_SOFT_device_clock = ALCCapabilities.check_SOFT_device_clock(provider, device, caps, ext);
        this.ALC_SOFT_HRTF = ALCCapabilities.check_SOFT_HRTF(provider, device, caps, ext);
        this.ALC_SOFT_loopback = ALCCapabilities.check_SOFT_loopback(provider, device, caps, ext);
        this.ALC_SOFT_output_limiter = ext.contains("ALC_SOFT_output_limiter");
        this.ALC_SOFT_output_mode = ext.contains("ALC_SOFT_output_mode");
        this.ALC_SOFT_pause_device = ALCCapabilities.check_SOFT_pause_device(provider, device, caps, ext);
        this.ALC_SOFT_reopen_device = ALCCapabilities.check_SOFT_reopen_device(provider, device, caps, ext);
        this.ALC_SOFT_system_events = ALCCapabilities.check_SOFT_system_events(provider, device, caps, ext);
        this.alcOpenDevice = caps.get(0);
        this.alcCloseDevice = caps.get(1);
        this.alcCreateContext = caps.get(2);
        this.alcMakeContextCurrent = caps.get(3);
        this.alcProcessContext = caps.get(4);
        this.alcSuspendContext = caps.get(5);
        this.alcDestroyContext = caps.get(6);
        this.alcGetCurrentContext = caps.get(7);
        this.alcGetContextsDevice = caps.get(8);
        this.alcIsExtensionPresent = caps.get(9);
        this.alcGetProcAddress = caps.get(10);
        this.alcGetEnumValue = caps.get(11);
        this.alcGetError = caps.get(12);
        this.alcGetString = caps.get(13);
        this.alcGetIntegerv = caps.get(14);
        this.alcCaptureOpenDevice = caps.get(15);
        this.alcCaptureCloseDevice = caps.get(16);
        this.alcCaptureStart = caps.get(17);
        this.alcCaptureStop = caps.get(18);
        this.alcCaptureSamples = caps.get(19);
        this.alcGetProcAddress2 = caps.get(20);
        this.alcSetThreadContext = caps.get(21);
        this.alcGetThreadContext = caps.get(22);
        this.alcGetInteger64vSOFT = caps.get(23);
        this.alcGetStringiSOFT = caps.get(24);
        this.alcResetDeviceSOFT = caps.get(25);
        this.alcLoopbackOpenDeviceSOFT = caps.get(26);
        this.alcIsRenderFormatSupportedSOFT = caps.get(27);
        this.alcRenderSamplesSOFT = caps.get(28);
        this.alcDevicePauseSOFT = caps.get(29);
        this.alcDeviceResumeSOFT = caps.get(30);
        this.alcReopenDeviceSOFT = caps.get(31);
        this.alcEventIsSupportedSOFT = caps.get(32);
        this.alcEventControlSOFT = caps.get(33);
        this.alcEventCallbackSOFT = caps.get(34);
        this.addresses = ThreadLocalUtil.setupAddressBuffer((PointerBuffer)caps);
    }

    public PointerBuffer getAddressBuffer() {
        return this.addresses;
    }

    private static boolean check_ALC10(FunctionProviderLocal provider, long device, PointerBuffer caps, Set<String> ext) {
        if (!ext.contains("OpenALC10")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProviderLocal)provider, (long)device, (PointerBuffer)caps, (int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14}, (String[])new String[]{"alcOpenDevice", "alcCloseDevice", "alcCreateContext", "alcMakeContextCurrent", "alcProcessContext", "alcSuspendContext", "alcDestroyContext", "alcGetCurrentContext", "alcGetContextsDevice", "alcIsExtensionPresent", "alcGetProcAddress", "alcGetEnumValue", "alcGetError", "alcGetString", "alcGetIntegerv"}) || Checks.reportMissing((String)"ALC", (String)"OpenALC10");
    }

    private static boolean check_ALC11(FunctionProviderLocal provider, long device, PointerBuffer caps, Set<String> ext) {
        if (!ext.contains("OpenALC11")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProviderLocal)provider, (long)device, (PointerBuffer)caps, (int[])new int[]{15, 16, 17, 18, 19}, (String[])new String[]{"alcCaptureOpenDevice", "alcCaptureCloseDevice", "alcCaptureStart", "alcCaptureStop", "alcCaptureSamples"}) || Checks.reportMissing((String)"ALC", (String)"OpenALC11");
    }

    private static boolean check_EXT_CAPTURE(FunctionProviderLocal provider, long device, PointerBuffer caps, Set<String> ext) {
        if (!ext.contains("ALC_EXT_CAPTURE")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProviderLocal)provider, (long)device, (PointerBuffer)caps, (int[])new int[]{15, 16, 17, 18, 19}, (String[])new String[]{"alcCaptureOpenDevice", "alcCaptureCloseDevice", "alcCaptureStart", "alcCaptureStop", "alcCaptureSamples"}) || Checks.reportMissing((String)"ALC", (String)"ALC_EXT_CAPTURE");
    }

    private static boolean check_EXT_direct_context(FunctionProviderLocal provider, long device, PointerBuffer caps, Set<String> ext) {
        if (!ext.contains("ALC_EXT_direct_context")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProviderLocal)provider, (long)device, (PointerBuffer)caps, (int[])new int[]{20}, (String[])new String[]{"alcGetProcAddress2"}) || Checks.reportMissing((String)"ALC", (String)"ALC_EXT_direct_context");
    }

    private static boolean check_EXT_thread_local_context(FunctionProviderLocal provider, long device, PointerBuffer caps, Set<String> ext) {
        if (!ext.contains("ALC_EXT_thread_local_context")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProviderLocal)provider, (long)device, (PointerBuffer)caps, (int[])new int[]{21, 22}, (String[])new String[]{"alcSetThreadContext", "alcGetThreadContext"}) || Checks.reportMissing((String)"ALC", (String)"ALC_EXT_thread_local_context");
    }

    private static boolean check_SOFT_device_clock(FunctionProviderLocal provider, long device, PointerBuffer caps, Set<String> ext) {
        if (!ext.contains("ALC_SOFT_device_clock")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProviderLocal)provider, (long)device, (PointerBuffer)caps, (int[])new int[]{23}, (String[])new String[]{"alcGetInteger64vSOFT"}) || Checks.reportMissing((String)"ALC", (String)"ALC_SOFT_device_clock");
    }

    private static boolean check_SOFT_HRTF(FunctionProviderLocal provider, long device, PointerBuffer caps, Set<String> ext) {
        if (!ext.contains("ALC_SOFT_HRTF")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProviderLocal)provider, (long)device, (PointerBuffer)caps, (int[])new int[]{24, 25}, (String[])new String[]{"alcGetStringiSOFT", "alcResetDeviceSOFT"}) || Checks.reportMissing((String)"ALC", (String)"ALC_SOFT_HRTF");
    }

    private static boolean check_SOFT_loopback(FunctionProviderLocal provider, long device, PointerBuffer caps, Set<String> ext) {
        if (!ext.contains("ALC_SOFT_loopback")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProviderLocal)provider, (long)device, (PointerBuffer)caps, (int[])new int[]{26, 27, 28}, (String[])new String[]{"alcLoopbackOpenDeviceSOFT", "alcIsRenderFormatSupportedSOFT", "alcRenderSamplesSOFT"}) || Checks.reportMissing((String)"ALC", (String)"ALC_SOFT_loopback");
    }

    private static boolean check_SOFT_pause_device(FunctionProviderLocal provider, long device, PointerBuffer caps, Set<String> ext) {
        if (!ext.contains("ALC_SOFT_pause_device")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProviderLocal)provider, (long)device, (PointerBuffer)caps, (int[])new int[]{29, 30}, (String[])new String[]{"alcDevicePauseSOFT", "alcDeviceResumeSOFT"}) || Checks.reportMissing((String)"ALC", (String)"ALC_SOFT_pause_device");
    }

    private static boolean check_SOFT_reopen_device(FunctionProviderLocal provider, long device, PointerBuffer caps, Set<String> ext) {
        if (!ext.contains("ALC_SOFT_reopen_device")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProviderLocal)provider, (long)device, (PointerBuffer)caps, (int[])new int[]{31}, (String[])new String[]{"alcReopenDeviceSOFT"}) || Checks.reportMissing((String)"ALC", (String)"ALC_SOFT_reopen_device");
    }

    private static boolean check_SOFT_system_events(FunctionProviderLocal provider, long device, PointerBuffer caps, Set<String> ext) {
        if (!ext.contains("ALC_SOFT_system_events")) {
            return false;
        }
        return Checks.checkFunctions((FunctionProviderLocal)provider, (long)device, (PointerBuffer)caps, (int[])new int[]{32, 33, 34}, (String[])new String[]{"alcEventIsSupportedSOFT", "alcEventControlSOFT", "alcEventCallbackSOFT"}) || Checks.reportMissing((String)"ALC", (String)"ALC_SOFT_system_events");
    }
}

