/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct cl_mem_ext_host_ptr")
public class CLMemEXTHostPtr
extends Struct<CLMemEXTHostPtr>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ALLOCATION_TYPE;
    public static final int HOST_CACHE_POLICY;

    protected CLMemEXTHostPtr(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CLMemEXTHostPtr create(long address, @Nullable ByteBuffer container) {
        return new CLMemEXTHostPtr(address, container);
    }

    public CLMemEXTHostPtr(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CLMemEXTHostPtr.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="cl_uint")
    public int allocation_type() {
        return CLMemEXTHostPtr.nallocation_type(this.address());
    }

    @NativeType(value="cl_uint")
    public int host_cache_policy() {
        return CLMemEXTHostPtr.nhost_cache_policy(this.address());
    }

    public CLMemEXTHostPtr allocation_type(@NativeType(value="cl_uint") int value) {
        CLMemEXTHostPtr.nallocation_type(this.address(), value);
        return this;
    }

    public CLMemEXTHostPtr host_cache_policy(@NativeType(value="cl_uint") int value) {
        CLMemEXTHostPtr.nhost_cache_policy(this.address(), value);
        return this;
    }

    public CLMemEXTHostPtr set(int allocation_type, int host_cache_policy) {
        this.allocation_type(allocation_type);
        this.host_cache_policy(host_cache_policy);
        return this;
    }

    public CLMemEXTHostPtr set(CLMemEXTHostPtr src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CLMemEXTHostPtr malloc() {
        return new CLMemEXTHostPtr(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CLMemEXTHostPtr calloc() {
        return new CLMemEXTHostPtr(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CLMemEXTHostPtr create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CLMemEXTHostPtr(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CLMemEXTHostPtr create(long address) {
        return new CLMemEXTHostPtr(address, null);
    }

    public static @Nullable CLMemEXTHostPtr createSafe(long address) {
        return address == 0L ? null : new CLMemEXTHostPtr(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CLMemEXTHostPtr.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CLMemEXTHostPtr.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static CLMemEXTHostPtr mallocStack() {
        return CLMemEXTHostPtr.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CLMemEXTHostPtr callocStack() {
        return CLMemEXTHostPtr.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CLMemEXTHostPtr mallocStack(MemoryStack stack) {
        return CLMemEXTHostPtr.malloc(stack);
    }

    @Deprecated
    public static CLMemEXTHostPtr callocStack(MemoryStack stack) {
        return CLMemEXTHostPtr.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CLMemEXTHostPtr.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CLMemEXTHostPtr.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CLMemEXTHostPtr.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CLMemEXTHostPtr.calloc(capacity, stack);
    }

    public static CLMemEXTHostPtr malloc(MemoryStack stack) {
        return new CLMemEXTHostPtr(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CLMemEXTHostPtr calloc(MemoryStack stack) {
        return new CLMemEXTHostPtr(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nallocation_type(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)ALLOCATION_TYPE));
    }

    public static int nhost_cache_policy(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)HOST_CACHE_POLICY));
    }

    public static void nallocation_type(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)ALLOCATION_TYPE), (int)value);
    }

    public static void nhost_cache_policy(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)HOST_CACHE_POLICY), (int)value);
    }

    static {
        Struct.Layout layout = CLMemEXTHostPtr.__struct((Struct.Member[])new Struct.Member[]{CLMemEXTHostPtr.__member((int)4), CLMemEXTHostPtr.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ALLOCATION_TYPE = layout.offsetof(0);
        HOST_CACHE_POLICY = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CLMemEXTHostPtr, Buffer>
    implements NativeResource {
        private static final CLMemEXTHostPtr ELEMENT_FACTORY = CLMemEXTHostPtr.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected CLMemEXTHostPtr getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="cl_uint")
        public int allocation_type() {
            return CLMemEXTHostPtr.nallocation_type(this.address());
        }

        @NativeType(value="cl_uint")
        public int host_cache_policy() {
            return CLMemEXTHostPtr.nhost_cache_policy(this.address());
        }

        public Buffer allocation_type(@NativeType(value="cl_uint") int value) {
            CLMemEXTHostPtr.nallocation_type(this.address(), value);
            return this;
        }

        public Buffer host_cache_policy(@NativeType(value="cl_uint") int value) {
            CLMemEXTHostPtr.nhost_cache_policy(this.address(), value);
            return this;
        }
    }
}

