/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.TrackedDevicePose;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct CameraVideoStreamFrameHeader_t")
public class CameraVideoStreamFrameHeader
extends Struct<CameraVideoStreamFrameHeader>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int EFRAMETYPE;
    public static final int NWIDTH;
    public static final int NHEIGHT;
    public static final int NBYTESPERPIXEL;
    public static final int NFRAMESEQUENCE;
    public static final int TRACKEDDEVICEPOSE;
    public static final int ULFRAMEEXPOSURETIME;

    protected CameraVideoStreamFrameHeader(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CameraVideoStreamFrameHeader create(long address, @Nullable ByteBuffer container) {
        return new CameraVideoStreamFrameHeader(address, container);
    }

    public CameraVideoStreamFrameHeader(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CameraVideoStreamFrameHeader.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="EVRTrackedCameraFrameType")
    public int eFrameType() {
        return CameraVideoStreamFrameHeader.neFrameType(this.address());
    }

    @NativeType(value="uint32_t")
    public int nWidth() {
        return CameraVideoStreamFrameHeader.nnWidth(this.address());
    }

    @NativeType(value="uint32_t")
    public int nHeight() {
        return CameraVideoStreamFrameHeader.nnHeight(this.address());
    }

    @NativeType(value="uint32_t")
    public int nBytesPerPixel() {
        return CameraVideoStreamFrameHeader.nnBytesPerPixel(this.address());
    }

    @NativeType(value="uint32_t")
    public int nFrameSequence() {
        return CameraVideoStreamFrameHeader.nnFrameSequence(this.address());
    }

    @NativeType(value="TrackedDevicePose_t")
    public TrackedDevicePose trackedDevicePose() {
        return CameraVideoStreamFrameHeader.ntrackedDevicePose(this.address());
    }

    @NativeType(value="uint64_t")
    public long ulFrameExposureTime() {
        return CameraVideoStreamFrameHeader.nulFrameExposureTime(this.address());
    }

    public static CameraVideoStreamFrameHeader malloc() {
        return new CameraVideoStreamFrameHeader(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CameraVideoStreamFrameHeader calloc() {
        return new CameraVideoStreamFrameHeader(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CameraVideoStreamFrameHeader create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CameraVideoStreamFrameHeader(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CameraVideoStreamFrameHeader create(long address) {
        return new CameraVideoStreamFrameHeader(address, null);
    }

    public static @Nullable CameraVideoStreamFrameHeader createSafe(long address) {
        return address == 0L ? null : new CameraVideoStreamFrameHeader(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CameraVideoStreamFrameHeader.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CameraVideoStreamFrameHeader.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static CameraVideoStreamFrameHeader mallocStack() {
        return CameraVideoStreamFrameHeader.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CameraVideoStreamFrameHeader callocStack() {
        return CameraVideoStreamFrameHeader.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CameraVideoStreamFrameHeader mallocStack(MemoryStack stack) {
        return CameraVideoStreamFrameHeader.malloc(stack);
    }

    @Deprecated
    public static CameraVideoStreamFrameHeader callocStack(MemoryStack stack) {
        return CameraVideoStreamFrameHeader.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CameraVideoStreamFrameHeader.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CameraVideoStreamFrameHeader.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CameraVideoStreamFrameHeader.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CameraVideoStreamFrameHeader.calloc(capacity, stack);
    }

    public static CameraVideoStreamFrameHeader malloc(MemoryStack stack) {
        return new CameraVideoStreamFrameHeader(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CameraVideoStreamFrameHeader calloc(MemoryStack stack) {
        return new CameraVideoStreamFrameHeader(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int neFrameType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)EFRAMETYPE));
    }

    public static int nnWidth(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)NWIDTH));
    }

    public static int nnHeight(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)NHEIGHT));
    }

    public static int nnBytesPerPixel(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)NBYTESPERPIXEL));
    }

    public static int nnFrameSequence(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)NFRAMESEQUENCE));
    }

    public static TrackedDevicePose ntrackedDevicePose(long struct) {
        return TrackedDevicePose.create(struct + (long)TRACKEDDEVICEPOSE);
    }

    public static long nulFrameExposureTime(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)ULFRAMEEXPOSURETIME));
    }

    static {
        Struct.Layout layout = CameraVideoStreamFrameHeader.__struct((Struct.Member[])new Struct.Member[]{CameraVideoStreamFrameHeader.__member((int)4), CameraVideoStreamFrameHeader.__member((int)4), CameraVideoStreamFrameHeader.__member((int)4), CameraVideoStreamFrameHeader.__member((int)4), CameraVideoStreamFrameHeader.__member((int)4), CameraVideoStreamFrameHeader.__member((int)TrackedDevicePose.SIZEOF, (int)TrackedDevicePose.ALIGNOF), CameraVideoStreamFrameHeader.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        EFRAMETYPE = layout.offsetof(0);
        NWIDTH = layout.offsetof(1);
        NHEIGHT = layout.offsetof(2);
        NBYTESPERPIXEL = layout.offsetof(3);
        NFRAMESEQUENCE = layout.offsetof(4);
        TRACKEDDEVICEPOSE = layout.offsetof(5);
        ULFRAMEEXPOSURETIME = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<CameraVideoStreamFrameHeader, Buffer>
    implements NativeResource {
        private static final CameraVideoStreamFrameHeader ELEMENT_FACTORY = CameraVideoStreamFrameHeader.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected CameraVideoStreamFrameHeader getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="EVRTrackedCameraFrameType")
        public int eFrameType() {
            return CameraVideoStreamFrameHeader.neFrameType(this.address());
        }

        @NativeType(value="uint32_t")
        public int nWidth() {
            return CameraVideoStreamFrameHeader.nnWidth(this.address());
        }

        @NativeType(value="uint32_t")
        public int nHeight() {
            return CameraVideoStreamFrameHeader.nnHeight(this.address());
        }

        @NativeType(value="uint32_t")
        public int nBytesPerPixel() {
            return CameraVideoStreamFrameHeader.nnBytesPerPixel(this.address());
        }

        @NativeType(value="uint32_t")
        public int nFrameSequence() {
            return CameraVideoStreamFrameHeader.nnFrameSequence(this.address());
        }

        @NativeType(value="TrackedDevicePose_t")
        public TrackedDevicePose trackedDevicePose() {
            return CameraVideoStreamFrameHeader.ntrackedDevicePose(this.address());
        }

        @NativeType(value="uint64_t")
        public long ulFrameExposureTime() {
            return CameraVideoStreamFrameHeader.nulFrameExposureTime(this.address());
        }
    }
}

