/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.TrackedDevicePose;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct Compositor_FrameTiming")
public class CompositorFrameTiming
extends Struct<CompositorFrameTiming>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M_NSIZE;
    public static final int M_NFRAMEINDEX;
    public static final int M_NNUMFRAMEPRESENTS;
    public static final int M_NNUMMISPRESENTED;
    public static final int M_NNUMDROPPEDFRAMES;
    public static final int M_NREPROJECTIONFLAGS;
    public static final int M_FLSYSTEMTIMEINSECONDS;
    public static final int M_FLPRESUBMITGPUMS;
    public static final int M_FLPOSTSUBMITGPUMS;
    public static final int M_FLTOTALRENDERGPUMS;
    public static final int M_FLCOMPOSITORRENDERGPUMS;
    public static final int M_FLCOMPOSITORRENDERCPUMS;
    public static final int M_FLCOMPOSITORIDLECPUMS;
    public static final int M_FLCLIENTFRAMEINTERVALMS;
    public static final int M_FLPRESENTCALLCPUMS;
    public static final int M_FLWAITFORPRESENTCPUMS;
    public static final int M_FLSUBMITFRAMEMS;
    public static final int M_FLWAITGETPOSESCALLEDMS;
    public static final int M_FLNEWPOSESREADYMS;
    public static final int M_FLNEWFRAMEREADYMS;
    public static final int M_FLCOMPOSITORUPDATESTARTMS;
    public static final int M_FLCOMPOSITORUPDATEENDMS;
    public static final int M_FLCOMPOSITORRENDERSTARTMS;
    public static final int M_HMDPOSE;
    public static final int M_NNUMVSYNCSREADYFORUSE;
    public static final int M_NNUMVSYNCSTOFIRSTVIEW;
    public static final int M_FLTRANSFERLATENCYMS;

    protected CompositorFrameTiming(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CompositorFrameTiming create(long address, @Nullable ByteBuffer container) {
        return new CompositorFrameTiming(address, container);
    }

    public CompositorFrameTiming(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CompositorFrameTiming.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int m_nSize() {
        return CompositorFrameTiming.nm_nSize(this.address());
    }

    @NativeType(value="uint32_t")
    public int m_nFrameIndex() {
        return CompositorFrameTiming.nm_nFrameIndex(this.address());
    }

    @NativeType(value="uint32_t")
    public int m_nNumFramePresents() {
        return CompositorFrameTiming.nm_nNumFramePresents(this.address());
    }

    @NativeType(value="uint32_t")
    public int m_nNumMisPresented() {
        return CompositorFrameTiming.nm_nNumMisPresented(this.address());
    }

    @NativeType(value="uint32_t")
    public int m_nNumDroppedFrames() {
        return CompositorFrameTiming.nm_nNumDroppedFrames(this.address());
    }

    @NativeType(value="uint32_t")
    public int m_nReprojectionFlags() {
        return CompositorFrameTiming.nm_nReprojectionFlags(this.address());
    }

    public double m_flSystemTimeInSeconds() {
        return CompositorFrameTiming.nm_flSystemTimeInSeconds(this.address());
    }

    public float m_flPreSubmitGpuMs() {
        return CompositorFrameTiming.nm_flPreSubmitGpuMs(this.address());
    }

    public float m_flPostSubmitGpuMs() {
        return CompositorFrameTiming.nm_flPostSubmitGpuMs(this.address());
    }

    public float m_flTotalRenderGpuMs() {
        return CompositorFrameTiming.nm_flTotalRenderGpuMs(this.address());
    }

    public float m_flCompositorRenderGpuMs() {
        return CompositorFrameTiming.nm_flCompositorRenderGpuMs(this.address());
    }

    public float m_flCompositorRenderCpuMs() {
        return CompositorFrameTiming.nm_flCompositorRenderCpuMs(this.address());
    }

    public float m_flCompositorIdleCpuMs() {
        return CompositorFrameTiming.nm_flCompositorIdleCpuMs(this.address());
    }

    public float m_flClientFrameIntervalMs() {
        return CompositorFrameTiming.nm_flClientFrameIntervalMs(this.address());
    }

    public float m_flPresentCallCpuMs() {
        return CompositorFrameTiming.nm_flPresentCallCpuMs(this.address());
    }

    public float m_flWaitForPresentCpuMs() {
        return CompositorFrameTiming.nm_flWaitForPresentCpuMs(this.address());
    }

    public float m_flSubmitFrameMs() {
        return CompositorFrameTiming.nm_flSubmitFrameMs(this.address());
    }

    public float m_flWaitGetPosesCalledMs() {
        return CompositorFrameTiming.nm_flWaitGetPosesCalledMs(this.address());
    }

    public float m_flNewPosesReadyMs() {
        return CompositorFrameTiming.nm_flNewPosesReadyMs(this.address());
    }

    public float m_flNewFrameReadyMs() {
        return CompositorFrameTiming.nm_flNewFrameReadyMs(this.address());
    }

    public float m_flCompositorUpdateStartMs() {
        return CompositorFrameTiming.nm_flCompositorUpdateStartMs(this.address());
    }

    public float m_flCompositorUpdateEndMs() {
        return CompositorFrameTiming.nm_flCompositorUpdateEndMs(this.address());
    }

    public float m_flCompositorRenderStartMs() {
        return CompositorFrameTiming.nm_flCompositorRenderStartMs(this.address());
    }

    @NativeType(value="TrackedDevicePose_t")
    public TrackedDevicePose m_HmdPose() {
        return CompositorFrameTiming.nm_HmdPose(this.address());
    }

    @NativeType(value="uint32_t")
    public int m_nNumVSyncsReadyForUse() {
        return CompositorFrameTiming.nm_nNumVSyncsReadyForUse(this.address());
    }

    @NativeType(value="uint32_t")
    public int m_nNumVSyncsToFirstView() {
        return CompositorFrameTiming.nm_nNumVSyncsToFirstView(this.address());
    }

    public float m_flTransferLatencyMs() {
        return CompositorFrameTiming.nm_flTransferLatencyMs(this.address());
    }

    public static CompositorFrameTiming malloc() {
        return new CompositorFrameTiming(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CompositorFrameTiming calloc() {
        return new CompositorFrameTiming(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CompositorFrameTiming create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CompositorFrameTiming(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CompositorFrameTiming create(long address) {
        return new CompositorFrameTiming(address, null);
    }

    public static @Nullable CompositorFrameTiming createSafe(long address) {
        return address == 0L ? null : new CompositorFrameTiming(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CompositorFrameTiming.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CompositorFrameTiming.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static CompositorFrameTiming mallocStack() {
        return CompositorFrameTiming.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CompositorFrameTiming callocStack() {
        return CompositorFrameTiming.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CompositorFrameTiming mallocStack(MemoryStack stack) {
        return CompositorFrameTiming.malloc(stack);
    }

    @Deprecated
    public static CompositorFrameTiming callocStack(MemoryStack stack) {
        return CompositorFrameTiming.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CompositorFrameTiming.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CompositorFrameTiming.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CompositorFrameTiming.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CompositorFrameTiming.calloc(capacity, stack);
    }

    public static CompositorFrameTiming malloc(MemoryStack stack) {
        return new CompositorFrameTiming(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CompositorFrameTiming calloc(MemoryStack stack) {
        return new CompositorFrameTiming(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nm_nSize(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)M_NSIZE));
    }

    public static int nm_nFrameIndex(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)M_NFRAMEINDEX));
    }

    public static int nm_nNumFramePresents(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)M_NNUMFRAMEPRESENTS));
    }

    public static int nm_nNumMisPresented(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)M_NNUMMISPRESENTED));
    }

    public static int nm_nNumDroppedFrames(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)M_NNUMDROPPEDFRAMES));
    }

    public static int nm_nReprojectionFlags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)M_NREPROJECTIONFLAGS));
    }

    public static double nm_flSystemTimeInSeconds(long struct) {
        return MemoryUtil.memGetDouble((long)(struct + (long)M_FLSYSTEMTIMEINSECONDS));
    }

    public static float nm_flPreSubmitGpuMs(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)M_FLPRESUBMITGPUMS));
    }

    public static float nm_flPostSubmitGpuMs(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)M_FLPOSTSUBMITGPUMS));
    }

    public static float nm_flTotalRenderGpuMs(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)M_FLTOTALRENDERGPUMS));
    }

    public static float nm_flCompositorRenderGpuMs(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)M_FLCOMPOSITORRENDERGPUMS));
    }

    public static float nm_flCompositorRenderCpuMs(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)M_FLCOMPOSITORRENDERCPUMS));
    }

    public static float nm_flCompositorIdleCpuMs(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)M_FLCOMPOSITORIDLECPUMS));
    }

    public static float nm_flClientFrameIntervalMs(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)M_FLCLIENTFRAMEINTERVALMS));
    }

    public static float nm_flPresentCallCpuMs(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)M_FLPRESENTCALLCPUMS));
    }

    public static float nm_flWaitForPresentCpuMs(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)M_FLWAITFORPRESENTCPUMS));
    }

    public static float nm_flSubmitFrameMs(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)M_FLSUBMITFRAMEMS));
    }

    public static float nm_flWaitGetPosesCalledMs(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)M_FLWAITGETPOSESCALLEDMS));
    }

    public static float nm_flNewPosesReadyMs(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)M_FLNEWPOSESREADYMS));
    }

    public static float nm_flNewFrameReadyMs(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)M_FLNEWFRAMEREADYMS));
    }

    public static float nm_flCompositorUpdateStartMs(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)M_FLCOMPOSITORUPDATESTARTMS));
    }

    public static float nm_flCompositorUpdateEndMs(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)M_FLCOMPOSITORUPDATEENDMS));
    }

    public static float nm_flCompositorRenderStartMs(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)M_FLCOMPOSITORRENDERSTARTMS));
    }

    public static TrackedDevicePose nm_HmdPose(long struct) {
        return TrackedDevicePose.create(struct + (long)M_HMDPOSE);
    }

    public static int nm_nNumVSyncsReadyForUse(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)M_NNUMVSYNCSREADYFORUSE));
    }

    public static int nm_nNumVSyncsToFirstView(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)M_NNUMVSYNCSTOFIRSTVIEW));
    }

    public static float nm_flTransferLatencyMs(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)M_FLTRANSFERLATENCYMS));
    }

    static {
        Struct.Layout layout = CompositorFrameTiming.__struct((Struct.Member[])new Struct.Member[]{CompositorFrameTiming.__member((int)4), CompositorFrameTiming.__member((int)4), CompositorFrameTiming.__member((int)4), CompositorFrameTiming.__member((int)4), CompositorFrameTiming.__member((int)4), CompositorFrameTiming.__member((int)4), CompositorFrameTiming.__member((int)8), CompositorFrameTiming.__member((int)4), CompositorFrameTiming.__member((int)4), CompositorFrameTiming.__member((int)4), CompositorFrameTiming.__member((int)4), CompositorFrameTiming.__member((int)4), CompositorFrameTiming.__member((int)4), CompositorFrameTiming.__member((int)4), CompositorFrameTiming.__member((int)4), CompositorFrameTiming.__member((int)4), CompositorFrameTiming.__member((int)4), CompositorFrameTiming.__member((int)4), CompositorFrameTiming.__member((int)4), CompositorFrameTiming.__member((int)4), CompositorFrameTiming.__member((int)4), CompositorFrameTiming.__member((int)4), CompositorFrameTiming.__member((int)4), CompositorFrameTiming.__member((int)TrackedDevicePose.SIZEOF, (int)TrackedDevicePose.ALIGNOF), CompositorFrameTiming.__member((int)4), CompositorFrameTiming.__member((int)4), CompositorFrameTiming.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M_NSIZE = layout.offsetof(0);
        M_NFRAMEINDEX = layout.offsetof(1);
        M_NNUMFRAMEPRESENTS = layout.offsetof(2);
        M_NNUMMISPRESENTED = layout.offsetof(3);
        M_NNUMDROPPEDFRAMES = layout.offsetof(4);
        M_NREPROJECTIONFLAGS = layout.offsetof(5);
        M_FLSYSTEMTIMEINSECONDS = layout.offsetof(6);
        M_FLPRESUBMITGPUMS = layout.offsetof(7);
        M_FLPOSTSUBMITGPUMS = layout.offsetof(8);
        M_FLTOTALRENDERGPUMS = layout.offsetof(9);
        M_FLCOMPOSITORRENDERGPUMS = layout.offsetof(10);
        M_FLCOMPOSITORRENDERCPUMS = layout.offsetof(11);
        M_FLCOMPOSITORIDLECPUMS = layout.offsetof(12);
        M_FLCLIENTFRAMEINTERVALMS = layout.offsetof(13);
        M_FLPRESENTCALLCPUMS = layout.offsetof(14);
        M_FLWAITFORPRESENTCPUMS = layout.offsetof(15);
        M_FLSUBMITFRAMEMS = layout.offsetof(16);
        M_FLWAITGETPOSESCALLEDMS = layout.offsetof(17);
        M_FLNEWPOSESREADYMS = layout.offsetof(18);
        M_FLNEWFRAMEREADYMS = layout.offsetof(19);
        M_FLCOMPOSITORUPDATESTARTMS = layout.offsetof(20);
        M_FLCOMPOSITORUPDATEENDMS = layout.offsetof(21);
        M_FLCOMPOSITORRENDERSTARTMS = layout.offsetof(22);
        M_HMDPOSE = layout.offsetof(23);
        M_NNUMVSYNCSREADYFORUSE = layout.offsetof(24);
        M_NNUMVSYNCSTOFIRSTVIEW = layout.offsetof(25);
        M_FLTRANSFERLATENCYMS = layout.offsetof(26);
    }

    public static class Buffer
    extends StructBuffer<CompositorFrameTiming, Buffer>
    implements NativeResource {
        private static final CompositorFrameTiming ELEMENT_FACTORY = CompositorFrameTiming.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected CompositorFrameTiming getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int m_nSize() {
            return CompositorFrameTiming.nm_nSize(this.address());
        }

        @NativeType(value="uint32_t")
        public int m_nFrameIndex() {
            return CompositorFrameTiming.nm_nFrameIndex(this.address());
        }

        @NativeType(value="uint32_t")
        public int m_nNumFramePresents() {
            return CompositorFrameTiming.nm_nNumFramePresents(this.address());
        }

        @NativeType(value="uint32_t")
        public int m_nNumMisPresented() {
            return CompositorFrameTiming.nm_nNumMisPresented(this.address());
        }

        @NativeType(value="uint32_t")
        public int m_nNumDroppedFrames() {
            return CompositorFrameTiming.nm_nNumDroppedFrames(this.address());
        }

        @NativeType(value="uint32_t")
        public int m_nReprojectionFlags() {
            return CompositorFrameTiming.nm_nReprojectionFlags(this.address());
        }

        public double m_flSystemTimeInSeconds() {
            return CompositorFrameTiming.nm_flSystemTimeInSeconds(this.address());
        }

        public float m_flPreSubmitGpuMs() {
            return CompositorFrameTiming.nm_flPreSubmitGpuMs(this.address());
        }

        public float m_flPostSubmitGpuMs() {
            return CompositorFrameTiming.nm_flPostSubmitGpuMs(this.address());
        }

        public float m_flTotalRenderGpuMs() {
            return CompositorFrameTiming.nm_flTotalRenderGpuMs(this.address());
        }

        public float m_flCompositorRenderGpuMs() {
            return CompositorFrameTiming.nm_flCompositorRenderGpuMs(this.address());
        }

        public float m_flCompositorRenderCpuMs() {
            return CompositorFrameTiming.nm_flCompositorRenderCpuMs(this.address());
        }

        public float m_flCompositorIdleCpuMs() {
            return CompositorFrameTiming.nm_flCompositorIdleCpuMs(this.address());
        }

        public float m_flClientFrameIntervalMs() {
            return CompositorFrameTiming.nm_flClientFrameIntervalMs(this.address());
        }

        public float m_flPresentCallCpuMs() {
            return CompositorFrameTiming.nm_flPresentCallCpuMs(this.address());
        }

        public float m_flWaitForPresentCpuMs() {
            return CompositorFrameTiming.nm_flWaitForPresentCpuMs(this.address());
        }

        public float m_flSubmitFrameMs() {
            return CompositorFrameTiming.nm_flSubmitFrameMs(this.address());
        }

        public float m_flWaitGetPosesCalledMs() {
            return CompositorFrameTiming.nm_flWaitGetPosesCalledMs(this.address());
        }

        public float m_flNewPosesReadyMs() {
            return CompositorFrameTiming.nm_flNewPosesReadyMs(this.address());
        }

        public float m_flNewFrameReadyMs() {
            return CompositorFrameTiming.nm_flNewFrameReadyMs(this.address());
        }

        public float m_flCompositorUpdateStartMs() {
            return CompositorFrameTiming.nm_flCompositorUpdateStartMs(this.address());
        }

        public float m_flCompositorUpdateEndMs() {
            return CompositorFrameTiming.nm_flCompositorUpdateEndMs(this.address());
        }

        public float m_flCompositorRenderStartMs() {
            return CompositorFrameTiming.nm_flCompositorRenderStartMs(this.address());
        }

        @NativeType(value="TrackedDevicePose_t")
        public TrackedDevicePose m_HmdPose() {
            return CompositorFrameTiming.nm_HmdPose(this.address());
        }

        @NativeType(value="uint32_t")
        public int m_nNumVSyncsReadyForUse() {
            return CompositorFrameTiming.nm_nNumVSyncsReadyForUse(this.address());
        }

        @NativeType(value="uint32_t")
        public int m_nNumVSyncsToFirstView() {
            return CompositorFrameTiming.nm_nNumVSyncsToFirstView(this.address());
        }

        public float m_flTransferLatencyMs() {
            return CompositorFrameTiming.nm_flTransferLatencyMs(this.address());
        }
    }
}

