/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct HmdVector3_t")
public class HmdVector3
extends Struct<HmdVector3>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int V;

    protected HmdVector3(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected HmdVector3 create(long address, @Nullable ByteBuffer container) {
        return new HmdVector3(address, container);
    }

    public HmdVector3(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), HmdVector3.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float[3]")
    public FloatBuffer v() {
        return HmdVector3.nv(this.address());
    }

    public float v(int index) {
        return HmdVector3.nv(this.address(), index);
    }

    public HmdVector3 v(@NativeType(value="float[3]") FloatBuffer value) {
        HmdVector3.nv(this.address(), value);
        return this;
    }

    public HmdVector3 v(int index, float value) {
        HmdVector3.nv(this.address(), index, value);
        return this;
    }

    public HmdVector3 set(HmdVector3 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static HmdVector3 malloc() {
        return new HmdVector3(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static HmdVector3 calloc() {
        return new HmdVector3(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static HmdVector3 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new HmdVector3(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static HmdVector3 create(long address) {
        return new HmdVector3(address, null);
    }

    public static @Nullable HmdVector3 createSafe(long address) {
        return address == 0L ? null : new HmdVector3(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)HmdVector3.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = HmdVector3.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static HmdVector3 mallocStack() {
        return HmdVector3.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HmdVector3 callocStack() {
        return HmdVector3.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HmdVector3 mallocStack(MemoryStack stack) {
        return HmdVector3.malloc(stack);
    }

    @Deprecated
    public static HmdVector3 callocStack(MemoryStack stack) {
        return HmdVector3.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return HmdVector3.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return HmdVector3.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return HmdVector3.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return HmdVector3.calloc(capacity, stack);
    }

    public static HmdVector3 malloc(MemoryStack stack) {
        return new HmdVector3(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static HmdVector3 calloc(MemoryStack stack) {
        return new HmdVector3(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static FloatBuffer nv(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)V), (int)3);
    }

    public static float nv(long struct, int index) {
        return MemoryUtil.memGetFloat((long)(struct + (long)V + Checks.check((int)index, (int)3) * 4L));
    }

    public static void nv(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)3);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((FloatBuffer)value), (long)(struct + (long)V), (long)(value.remaining() * 4));
    }

    public static void nv(long struct, int index, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)V + Checks.check((int)index, (int)3) * 4L), (float)value);
    }

    static {
        Struct.Layout layout = HmdVector3.__struct((Struct.Member[])new Struct.Member[]{HmdVector3.__array((int)4, (int)3)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        V = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<HmdVector3, Buffer>
    implements NativeResource {
        private static final HmdVector3 ELEMENT_FACTORY = HmdVector3.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected HmdVector3 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="float[3]")
        public FloatBuffer v() {
            return HmdVector3.nv(this.address());
        }

        public float v(int index) {
            return HmdVector3.nv(this.address(), index);
        }

        public Buffer v(@NativeType(value="float[3]") FloatBuffer value) {
            HmdVector3.nv(this.address(), value);
            return this;
        }

        public Buffer v(int index, float value) {
            HmdVector3.nv(this.address(), index, value);
            return this;
        }
    }
}

