/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct InputDigitalActionData_t")
public class InputDigitalActionData
extends Struct<InputDigitalActionData>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BACTIVE;
    public static final int ACTIVEORIGIN;
    public static final int BSTATE;
    public static final int BCHANGED;
    public static final int FUPDATETIME;

    protected InputDigitalActionData(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected InputDigitalActionData create(long address, @Nullable ByteBuffer container) {
        return new InputDigitalActionData(address, container);
    }

    public InputDigitalActionData(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), InputDigitalActionData.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="bool")
    public boolean bActive() {
        return InputDigitalActionData.nbActive(this.address());
    }

    @NativeType(value="VRInputValueHandle_t")
    public long activeOrigin() {
        return InputDigitalActionData.nactiveOrigin(this.address());
    }

    @NativeType(value="bool")
    public boolean bState() {
        return InputDigitalActionData.nbState(this.address());
    }

    @NativeType(value="bool")
    public boolean bChanged() {
        return InputDigitalActionData.nbChanged(this.address());
    }

    public float fUpdateTime() {
        return InputDigitalActionData.nfUpdateTime(this.address());
    }

    public static InputDigitalActionData malloc() {
        return new InputDigitalActionData(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static InputDigitalActionData calloc() {
        return new InputDigitalActionData(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static InputDigitalActionData create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new InputDigitalActionData(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static InputDigitalActionData create(long address) {
        return new InputDigitalActionData(address, null);
    }

    public static @Nullable InputDigitalActionData createSafe(long address) {
        return address == 0L ? null : new InputDigitalActionData(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)InputDigitalActionData.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = InputDigitalActionData.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static InputDigitalActionData mallocStack() {
        return InputDigitalActionData.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static InputDigitalActionData callocStack() {
        return InputDigitalActionData.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static InputDigitalActionData mallocStack(MemoryStack stack) {
        return InputDigitalActionData.malloc(stack);
    }

    @Deprecated
    public static InputDigitalActionData callocStack(MemoryStack stack) {
        return InputDigitalActionData.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return InputDigitalActionData.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return InputDigitalActionData.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return InputDigitalActionData.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return InputDigitalActionData.calloc(capacity, stack);
    }

    public static InputDigitalActionData malloc(MemoryStack stack) {
        return new InputDigitalActionData(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static InputDigitalActionData calloc(MemoryStack stack) {
        return new InputDigitalActionData(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static boolean nbActive(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)BACTIVE)) != 0;
    }

    public static long nactiveOrigin(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)ACTIVEORIGIN));
    }

    public static boolean nbState(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)BSTATE)) != 0;
    }

    public static boolean nbChanged(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)BCHANGED)) != 0;
    }

    public static float nfUpdateTime(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)FUPDATETIME));
    }

    static {
        Struct.Layout layout = InputDigitalActionData.__struct((Struct.Member[])new Struct.Member[]{InputDigitalActionData.__member((int)1), InputDigitalActionData.__member((int)8), InputDigitalActionData.__member((int)1), InputDigitalActionData.__member((int)1), InputDigitalActionData.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BACTIVE = layout.offsetof(0);
        ACTIVEORIGIN = layout.offsetof(1);
        BSTATE = layout.offsetof(2);
        BCHANGED = layout.offsetof(3);
        FUPDATETIME = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<InputDigitalActionData, Buffer>
    implements NativeResource {
        private static final InputDigitalActionData ELEMENT_FACTORY = InputDigitalActionData.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected InputDigitalActionData getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="bool")
        public boolean bActive() {
            return InputDigitalActionData.nbActive(this.address());
        }

        @NativeType(value="VRInputValueHandle_t")
        public long activeOrigin() {
            return InputDigitalActionData.nactiveOrigin(this.address());
        }

        @NativeType(value="bool")
        public boolean bState() {
            return InputDigitalActionData.nbState(this.address());
        }

        @NativeType(value="bool")
        public boolean bChanged() {
            return InputDigitalActionData.nbChanged(this.address());
        }

        public float fUpdateTime() {
            return InputDigitalActionData.nfUpdateTime(this.address());
        }
    }
}

