/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct InputOriginInfo_t")
public class InputOriginInfo
extends Struct<InputOriginInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DEVICEPATH;
    public static final int TRACKEDDEVICEINDEX;
    public static final int RCHRENDERMODELCOMPONENTNAME;

    protected InputOriginInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected InputOriginInfo create(long address, @Nullable ByteBuffer container) {
        return new InputOriginInfo(address, container);
    }

    public InputOriginInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), InputOriginInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VRInputValueHandle_t")
    public long devicePath() {
        return InputOriginInfo.ndevicePath(this.address());
    }

    @NativeType(value="TrackedDeviceIndex_t")
    public int trackedDeviceIndex() {
        return InputOriginInfo.ntrackedDeviceIndex(this.address());
    }

    @NativeType(value="char[128]")
    public ByteBuffer rchRenderModelComponentName() {
        return InputOriginInfo.nrchRenderModelComponentName(this.address());
    }

    @NativeType(value="char[128]")
    public String rchRenderModelComponentNameString() {
        return InputOriginInfo.nrchRenderModelComponentNameString(this.address());
    }

    public static InputOriginInfo malloc() {
        return new InputOriginInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static InputOriginInfo calloc() {
        return new InputOriginInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static InputOriginInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new InputOriginInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static InputOriginInfo create(long address) {
        return new InputOriginInfo(address, null);
    }

    public static @Nullable InputOriginInfo createSafe(long address) {
        return address == 0L ? null : new InputOriginInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)InputOriginInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = InputOriginInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static InputOriginInfo mallocStack() {
        return InputOriginInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static InputOriginInfo callocStack() {
        return InputOriginInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static InputOriginInfo mallocStack(MemoryStack stack) {
        return InputOriginInfo.malloc(stack);
    }

    @Deprecated
    public static InputOriginInfo callocStack(MemoryStack stack) {
        return InputOriginInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return InputOriginInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return InputOriginInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return InputOriginInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return InputOriginInfo.calloc(capacity, stack);
    }

    public static InputOriginInfo malloc(MemoryStack stack) {
        return new InputOriginInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static InputOriginInfo calloc(MemoryStack stack) {
        return new InputOriginInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ndevicePath(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)DEVICEPATH));
    }

    public static int ntrackedDeviceIndex(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TRACKEDDEVICEINDEX));
    }

    public static ByteBuffer nrchRenderModelComponentName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)RCHRENDERMODELCOMPONENTNAME), (int)128);
    }

    public static String nrchRenderModelComponentNameString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)RCHRENDERMODELCOMPONENTNAME));
    }

    static {
        Struct.Layout layout = InputOriginInfo.__struct((Struct.Member[])new Struct.Member[]{InputOriginInfo.__member((int)8), InputOriginInfo.__member((int)4), InputOriginInfo.__array((int)1, (int)128)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DEVICEPATH = layout.offsetof(0);
        TRACKEDDEVICEINDEX = layout.offsetof(1);
        RCHRENDERMODELCOMPONENTNAME = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<InputOriginInfo, Buffer>
    implements NativeResource {
        private static final InputOriginInfo ELEMENT_FACTORY = InputOriginInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected InputOriginInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VRInputValueHandle_t")
        public long devicePath() {
            return InputOriginInfo.ndevicePath(this.address());
        }

        @NativeType(value="TrackedDeviceIndex_t")
        public int trackedDeviceIndex() {
            return InputOriginInfo.ntrackedDeviceIndex(this.address());
        }

        @NativeType(value="char[128]")
        public ByteBuffer rchRenderModelComponentName() {
            return InputOriginInfo.nrchRenderModelComponentName(this.address());
        }

        @NativeType(value="char[128]")
        public String rchRenderModelComponentNameString() {
            return InputOriginInfo.nrchRenderModelComponentNameString(this.address());
        }
    }
}

