/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct InputSkeletalActionData_t")
public class InputSkeletalActionData
extends Struct<InputSkeletalActionData>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BACTIVE;
    public static final int ACTIVEORIGIN;

    protected InputSkeletalActionData(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected InputSkeletalActionData create(long address, @Nullable ByteBuffer container) {
        return new InputSkeletalActionData(address, container);
    }

    public InputSkeletalActionData(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), InputSkeletalActionData.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="bool")
    public boolean bActive() {
        return InputSkeletalActionData.nbActive(this.address());
    }

    @NativeType(value="VRInputValueHandle_t")
    public long activeOrigin() {
        return InputSkeletalActionData.nactiveOrigin(this.address());
    }

    public static InputSkeletalActionData malloc() {
        return new InputSkeletalActionData(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static InputSkeletalActionData calloc() {
        return new InputSkeletalActionData(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static InputSkeletalActionData create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new InputSkeletalActionData(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static InputSkeletalActionData create(long address) {
        return new InputSkeletalActionData(address, null);
    }

    public static @Nullable InputSkeletalActionData createSafe(long address) {
        return address == 0L ? null : new InputSkeletalActionData(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)InputSkeletalActionData.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = InputSkeletalActionData.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static InputSkeletalActionData mallocStack() {
        return InputSkeletalActionData.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static InputSkeletalActionData callocStack() {
        return InputSkeletalActionData.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static InputSkeletalActionData mallocStack(MemoryStack stack) {
        return InputSkeletalActionData.malloc(stack);
    }

    @Deprecated
    public static InputSkeletalActionData callocStack(MemoryStack stack) {
        return InputSkeletalActionData.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return InputSkeletalActionData.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return InputSkeletalActionData.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return InputSkeletalActionData.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return InputSkeletalActionData.calloc(capacity, stack);
    }

    public static InputSkeletalActionData malloc(MemoryStack stack) {
        return new InputSkeletalActionData(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static InputSkeletalActionData calloc(MemoryStack stack) {
        return new InputSkeletalActionData(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static boolean nbActive(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)BACTIVE)) != 0;
    }

    public static long nactiveOrigin(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)ACTIVEORIGIN));
    }

    static {
        Struct.Layout layout = InputSkeletalActionData.__struct((Struct.Member[])new Struct.Member[]{InputSkeletalActionData.__member((int)1), InputSkeletalActionData.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BACTIVE = layout.offsetof(0);
        ACTIVEORIGIN = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<InputSkeletalActionData, Buffer>
    implements NativeResource {
        private static final InputSkeletalActionData ELEMENT_FACTORY = InputSkeletalActionData.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected InputSkeletalActionData getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="bool")
        public boolean bActive() {
            return InputSkeletalActionData.nbActive(this.address());
        }

        @NativeType(value="VRInputValueHandle_t")
        public long activeOrigin() {
            return InputSkeletalActionData.nactiveOrigin(this.address());
        }
    }
}

