/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.openvr.RenderModelVertex;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Platform;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct RenderModel_t")
public class RenderModel
extends Struct<RenderModel> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RVERTEXDATA;
    public static final int UNVERTEXCOUNT;
    public static final int INDEXDATA;
    public static final int UNTRIANGLECOUNT;
    public static final int DIFFUSETEXTUREID;

    protected RenderModel(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected RenderModel create(long address, @Nullable ByteBuffer container) {
        return new RenderModel(address, container);
    }

    public RenderModel(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), RenderModel.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="RenderModel_Vertex_t const *")
    public RenderModelVertex.Buffer rVertexData() {
        return RenderModel.nrVertexData(this.address());
    }

    @NativeType(value="uint32_t")
    public int unVertexCount() {
        return RenderModel.nunVertexCount(this.address());
    }

    @NativeType(value="uint16_t const *")
    public ShortBuffer IndexData() {
        return RenderModel.nIndexData(this.address());
    }

    @NativeType(value="uint32_t")
    public int unTriangleCount() {
        return RenderModel.nunTriangleCount(this.address());
    }

    @NativeType(value="TextureID_t")
    public int diffuseTextureId() {
        return RenderModel.ndiffuseTextureId(this.address());
    }

    public static RenderModel create(long address) {
        return new RenderModel(address, null);
    }

    public static @Nullable RenderModel createSafe(long address) {
        return address == 0L ? null : new RenderModel(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static RenderModelVertex.Buffer nrVertexData(long struct) {
        return RenderModelVertex.create(MemoryUtil.memGetAddress((long)(struct + (long)RVERTEXDATA)), RenderModel.nunVertexCount(struct));
    }

    public static int nunVertexCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)UNVERTEXCOUNT));
    }

    public static ShortBuffer nIndexData(long struct) {
        return MemoryUtil.memShortBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)INDEXDATA)), (int)(RenderModel.nunTriangleCount(struct) * 3));
    }

    public static int nunTriangleCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)UNTRIANGLECOUNT));
    }

    public static int ndiffuseTextureId(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DIFFUSETEXTUREID));
    }

    static {
        Struct.Layout layout = RenderModel.__struct((int)(Platform.get() == Platform.LINUX || Platform.get() == Platform.MACOSX ? 4 : DEFAULT_PACK_ALIGNMENT), (int)0, (Struct.Member[])new Struct.Member[]{RenderModel.__member((int)POINTER_SIZE), RenderModel.__member((int)4), RenderModel.__member((int)POINTER_SIZE), RenderModel.__member((int)4), RenderModel.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RVERTEXDATA = layout.offsetof(0);
        UNVERTEXCOUNT = layout.offsetof(1);
        INDEXDATA = layout.offsetof(2);
        UNTRIANGLECOUNT = layout.offsetof(3);
        DIFFUSETEXTUREID = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<RenderModel, Buffer> {
        private static final RenderModel ELEMENT_FACTORY = RenderModel.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected RenderModel getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="RenderModel_Vertex_t const *")
        public RenderModelVertex.Buffer rVertexData() {
            return RenderModel.nrVertexData(this.address());
        }

        @NativeType(value="uint32_t")
        public int unVertexCount() {
            return RenderModel.nunVertexCount(this.address());
        }

        @NativeType(value="uint16_t const *")
        public ShortBuffer IndexData() {
            return RenderModel.nIndexData(this.address());
        }

        @NativeType(value="uint32_t")
        public int unTriangleCount() {
            return RenderModel.nunTriangleCount(this.address());
        }

        @NativeType(value="TextureID_t")
        public int diffuseTextureId() {
            return RenderModel.ndiffuseTextureId(this.address());
        }
    }
}

